[View]
# the views will be tried in this order, if one fails to import, the next
# is tried
View=DistUpgradeViewGtk3,DistUpgradeViewKDE,DistUpgradeViewText
#View=DistUpgradeViewNonInteractive
#Depends= apt (>= 1.0.10.2ubuntu2)
# the views below support upgrades over ssh connection
SupportSSH=DistUpgradeViewText,DistUpgradeViewNonInteractive

# Distro contains global information about the upgrade
[Distro]
# the meta-pkgs we support
MetaPkgs=ubuntu-desktop, kubuntu-desktop, xubuntu-core,
   xubuntu-desktop, ubuntustudio-desktop, mythbuntu-desktop,
   kubuntu-netbook, lubuntu-desktop, ubuntu-gnome-desktop,
   ubuntu-mate-core, ubuntu-mate-desktop,
   ubuntukylin-desktop, ubuntu-budgie-desktop
BaseMetaPkgs=ubuntu-minimal, ubuntu-standard
# minimal & standard, are handed via BaseMetaPkgs rule
# ubuntu-core is left-over task we forgot to remove
IgnoredTasks=minimal, standard, ubuntu-core
Demotions=demoted.cfg.groovy
#RemoveEssentialOk=sysvinit, sysvutils, belocs-locales-bin
RemovalBlacklistFile=removal_blacklist.cfg
# if those packages were installed, make sure to keep them installed
KeepInstalledPkgs=xserver-xorg-video-all
KeepInstalledSection=translations
RemoveObsoletes=yes
PurgeObsoletes=yes
#ForcedObsoletes=ksplash-engine-moodin, powernowd, laptop-mode-tools
# hints for for stuff that should be done right after the cache calculated
# the dist-upgrade (not to be confused with the PostUpgrade hooks in the
# quirks handling)
#PostUpgradePurge=linux-restricted-modules-common
#PostUpgradeRemove=xsettings-kde
#PostUpgradeUpgrade=brasero,edubuntu-desktop
#PostUpgradeInstall=apt
PostInstallScripts=./xorg_fix_proprietary.py
EnableApport=yes
# this supported blacklisting certain versions to ensure we do not upgrade
#  - blcr-dkms fails to build on kernel 2.6.35
#BadVersions=blcr-dkms_0.8.2-13
# ubiquity slideshow
#SlideshowUrl=http://people.canonical.com/~mvo/ubiquity-slideshow-upgrade/slides/

# information about the individual meta-pkgs
[ubuntu-desktop]
KeyDependencies=lightdm, unity, ubuntu-artwork, ubuntu-sounds
# those pkgs will be marked remove right after the distUpgrade in the cache
PostUpgradeRemove=gnome-cups-manager, powermanagement-interface, deskbar-applet, nautilus-cd-burner
ForcedObsoletes=desktop-effects, gnome-app-install, policykit-gnome, gnome-mount

[kubuntu-desktop]
KeyDependencies=plasma-desktop, kubuntu-settings-desktop
PostUpgradeRemove=powermanagement-interface, guidance-power-manager, kde-guidance-powermanager, kmix
# those packages are marked as obsolete right after the upgrade
ForcedObsoletes=ivman, gtk-qt-engine
# help the resolver a bit: LP: #1426132
PostUpgradeInstall=baloo-kf5

[kubuntu-netbook]
KeyDependencies=plasma-netbook, kubuntu-settings-netbook

[ubuntu-netbook]
KeyDependencies=gdm, ubuntu-netbook-default-settings

[xubuntu-core]
KeyDependencies=xubuntu-artwork, xubuntu-default-settings, xfwm4
PostUpgradeRemove=notification-daemon

[xubuntu-desktop]
KeyDependencies=xubuntu-artwork, xubuntu-default-settings, xfwm4
PostUpgradeRemove=notification-daemon

[ubuntustudio-desktop]
KeyDependencies=ubuntustudio-default-settings, ubuntustudio-look

[ichthux-desktop]
KeyDependencies=ichthux-artwork, ichthux-default-settings

[mythbuntu-desktop]
KeyDependencies=mythbuntu-artwork, mythbuntu-default-settings

[lubuntu-desktop]
KeyDependencies=lubuntu-artwork, lubuntu-default-settings

[ubuntu-gnome-desktop]
KeyDependencies=ubuntu-gnome-default-settings, ubuntu-gnome-wallpapers

[ubuntu-mate-core]
KeyDependencies=mate-desktop-environment-core, ubuntu-mate-default-settings, marco
PostUpgradeRemove=ibus,lightdm-gtk-greeter,lightdm-gtk-greeter-settings

[ubuntu-mate-desktop]
KeyDependencies=ubuntu-mate-core, deja-dup-caja
PostUpgradeRemove=ibus,lightdm-gtk-greeter,lightdm-gtk-greeter-settings

[ubuntukylin-desktop]
KeyDependencies=ubuntukylin-keyring, ubuntukylin-wallpapers, ubuntu-kylin-docs

[ubuntu-budgie-desktop]
KeyDependencies=budgie-desktop-environment, budgie-welcome, ubuntu-budgie-themes

[Files]
BackupExt=distUpgrade
LogDir=/var/log/dist-upgrade/

[Sources]
From=groovy
To=impish
ValidOrigin=Ubuntu
ValidMirrors = mirrors.cfg
Components=main,restricted,universe,multiverse
Pockets=security,updates,proposed,backports
;AllowThirdParty=False

;[PreRequists]
;Packages=release-upgrader-apt,release-upgrader-dpkg
;SourcesList=prerequists-sources.list
;SourcesList-ia64=prerequists-sources.ports.list
;SourcesList-hppa=prerequists-sources.ports.list

[Network]
MaxRetries=3

[NonInteractive]
ForceOverwrite=yes
RealReboot=no
DebugBrokenScripts=no
DpkgProgressLog=no
;TerminalTimeout=2400
