/*
 * AbiCollab - Code to enable the modification of remote documents.
 * Copyright (C) 2005 by Martin Sevior
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef ABI_COLLAB_H
#define ABI_COLLAB_H

#include "ut_types.h"
#include "pt_Types.h"
#include "ut_stack.h"
#include "xav_Listener.h"
#include "pl_Listener.h"
#include "ut_string_class.h"

class FL_DocLayout;
class PD_Document;
class UT_Stack;
class PX_ChangeRecord;
/*!
	The fl_DocListener class handles notifications from a PD_Document 
	to its associated FL_DocLayout. 
*/

class ABI_EXPORT ABI_Collab_Export : public PL_Listener
{
public:
	ABI_Collab_Export(PD_Document* doc);
	virtual ~ABI_Collab_Export();

	virtual bool		populate(PL_StruxFmtHandle sfh,
								 const PX_ChangeRecord * pcr);

	virtual bool		populateStrux(PL_StruxDocHandle sdh,
									  const PX_ChangeRecord * pcr,
									  PL_StruxFmtHandle * psfh);

	virtual bool		change(PL_StruxFmtHandle sfh,
							   const PX_ChangeRecord * pcr);


	virtual void		deferNotifications(void);
	virtual void		processDeferredNotifications(void);

	virtual bool		insertStrux(PL_StruxFmtHandle sfh,
									const PX_ChangeRecord * pcr,
									PL_StruxDocHandle sdh,
									PL_ListenerId lid,
									void (* pfnBindHandles)(PL_StruxDocHandle sdhNew,
															PL_ListenerId lid,
															PL_StruxFmtHandle sfhNew));

	virtual bool		signal(UT_uint32 iSignal);

	virtual PLListenerType getType() const {return PTL_DocLayout;}
	bool                    buildPacket( const PX_ChangeRecord * pcr,
					     PL_StruxDocHandle sdh,
					     UT_UTF8String & sPacket);
        void                    setLID(UT_uint32 lid);
	bool                    mapChangeRecordToString(const PX_ChangeRecord * pcr,UT_UTF8String & sType);
private:

	//! Document which is client of this DocListener
	PD_Document*		   m_pDoc;

	//! Counter used to keep track of when to update the Layout. In
	//! case of multi-step changes, updating is suspended.
	UT_uint32			   m_iGlobCounter;
	UT_Stack               m_sLastContainerLayout;

	bool                   m_bEndFootnoteProcessedInBlock;
	AV_ChangeMask          m_chgMaskCached;
	bool                   m_bCacheChanges;
	UT_uint32              m_lid;
};



#endif /* ABI_COLLAB_H */

