/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
 
// Class definition include
#include "OO_PicturesWriter.h"

// Internal includes
#include "OO_Common.h"

// Abiword includes
#include <ut_bytebuf.h>
#include <pd_Document.h>

// External includes
#include <gsf/gsf-output-stdio.h>
#include <gsf/gsf-outfile.h>


bool OO_PicturesWriter::writePictures(PD_Document * pDoc,
                                             GsfOutfile * oo)
{
    const char * szName;
    const char * szMimeType;
    const UT_ByteBuf * pByteBuf;

    // create Pictures directory
    GsfOutput * pictures = gsf_outfile_new_child(oo, "Pictures", TRUE);
    
    for (UT_uint32 k=0;
         (pDoc->enumDataItems(k,
                              NULL,
                              &szName,
                              &pByteBuf,
                              reinterpret_cast<const void **>
                                  (const_cast<const char **>(&szMimeType))));
         k++)
    {
        // create individual pictures
        UT_String name = UT_String_sprintf("IMG-%d.png", k);
        GsfOutput * img = gsf_outfile_new_child(GSF_OUTFILE(pictures), name.c_str(), FALSE);    
        oo_gsf_output_write(img, pByteBuf->getLength(),  pByteBuf->getPointer(0));

        oo_gsf_output_close(img);
    }

    oo_gsf_output_close(pictures);

    return true;
}
