/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

// Class definition include 
#include "OO_StylesContainer.h"



void OO_StylesContainer::addSpanStyle(UT_String &key)
{
    const void *temp;
    //if (!m_spanStylesHash.contains(key.utf8_str(), temp))
    if (!m_spanStylesHash.pick(key.c_str())) {
        UT_DEBUGMSG(("OO_AccumulatorImpl: props of this type: %s not yet found, adding style at num: %i\n", key.c_str(), (m_spanStylesHash.size()+1)));
        int *val = new int;
        char *keyCopy = new char[strlen(key.c_str())+1];
        keyCopy = strcpy(keyCopy, key.c_str());
        *val = (int)m_spanStylesHash.size()+1;
        m_spanStylesHash.insert(keyCopy, val);
    }
    else {
        UT_DEBUGMSG(("OO_AccumulatorImpl: props of this type: %s already there, forget it\n", key.c_str()));
    }
}


void OO_StylesContainer::addBlockStyle(UT_String & styleAtts, UT_String & styleProps)
{
    if (!m_blockAttsHash.pick(styleProps.c_str())) {
        UT_DEBUGMSG(("OO_AccumulatorImpl: block atts of this type: '%s' not yet found, adding style at pos: '%s'\n", styleAtts.c_str(), (styleProps.c_str())));
        UT_String *val = new UT_String(styleAtts);
        const char *key = strdup(styleProps.c_str());
        m_blockAttsHash.insert(key, val);
    }
    else {
        UT_DEBUGMSG(("OO_AccumulatorImpl: block atts of this type: '%s' already there, forget it\n", styleAtts.c_str()));
    }
}


void OO_StylesContainer::addFont(UT_String & font)
{
    if (!m_fontsHash.pick(font.c_str())) {
        UT_DEBUGMSG(("OO_AccumulatorImpl: font '%s' not yet found, adding \n", font.c_str()));
        int *val = new int;
        char *keyCopy = new char[strlen(font.c_str())+1];
        keyCopy = strcpy(keyCopy, font.c_str());
        *val = (int)m_fontsHash.size()+1;
        m_fontsHash.insert(keyCopy, val);
    }
    else {
        UT_DEBUGMSG(("OO_AccumulatorImpl: font '%s' already there, forget it\n", font.c_str()));
    }
}


const int OO_StylesContainer::getSpanStyleNum(UT_String &key) const
{
    if (int *val = m_spanStylesHash.pick(key.c_str())) {
        return *val;
    }
    else
        return 0;
}


const int OO_StylesContainer::getBlockStyleNum(UT_String & styleAtts, UT_String & styleProps) const
{
    UT_GenericVector<const UT_String*> *keys = m_blockAttsHash.keys();
    int num = keys->findItem(&styleProps);

    for (int i = 0; i < keys->size(); i++) {
        const UT_String * key = keys->getNthItem(i);
        if (key && (*key == styleProps))
            return i;
    }

    UT_ASSERT_NOT_REACHED();
    return -1;
}


UT_GenericVector<int*> * OO_StylesContainer::enumerateSpanStyles() const
{
    return m_spanStylesHash.enumerate();
}


UT_String * OO_StylesContainer::pickBlockAtts(const UT_String *key)
{
    return m_blockAttsHash.pick(key->c_str());
}


UT_GenericVector<const UT_String*> * OO_StylesContainer::getSpanStylesKeys() const
{
    return m_spanStylesHash.keys();
}


UT_GenericVector<const UT_String*> * OO_StylesContainer::getBlockStylesKeys() const
{
    return m_blockAttsHash.keys();
}


UT_GenericVector<const UT_String*> * OO_StylesContainer::getFontsKeys() const
{
    return m_fontsHash.keys();
}
