#!/bin/bash

. /etc/default/acpi-support
. /usr/share/acpi-support/power-funcs

getXuser;

if [ x$ACPI_SLEEP != xtrue ]; then
  exit;
fi

# Generic preparation code
. /etc/acpi/prepare.sh

if [ x$LOCK_SCREEN = xtrue ]; then
  . /usr/share/acpi-support/screenblank
fi

if [ x$DISABLE_DMA = xtrue ]; then
  hdparm -d 0 /dev/hda
fi

echo -n $ACPI_SLEEP_MODE >/sys/power/state

if [ x$DISABLE_DMA = xtrue ]; then
  hdparm -d 1 /dev/hda
fi

# Generic wakeup code
. /etc/acpi/resume.sh
