#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <kdebug.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include "easytagfilter.h"

using namespace aptFront;
using namespace adept;
using namespace Tagcoll;

static void fillCombo( QComboBox *c, const std::string f ) {
    Cache &cache = cache::Global::get(); // FIXME?
    OpSet< entity::Tag > t;
    t = cache.tags().tags( f );
    for (OpSet< entity::Tag >::iterator i = t.begin(); i != t.end(); ++ i) {
        c->insertItem( i->name() );
    }
}

EasyTagFilterWidget::EasyTagFilterWidget( QWidget *parent, const char *name )
    : EasyTagFilterUi( parent, name )
{
    fillCombo( m_use, "use" );
    fillCombo( m_interface, "interface" );
    fillCombo( m_worksWith, "works-with" );
    fillCombo( m_role, "role" );
    connect( m_use, SIGNAL( activated( int ) ),
             this, SLOT( widgetsChanged() ) );
    connect( m_interface, SIGNAL( activated( int ) ),
             this, SLOT( widgetsChanged() ) );
    connect( m_worksWith, SIGNAL( activated( int ) ),
             this, SLOT( widgetsChanged() ) );
    connect( m_role, SIGNAL( activated( int ) ),
             this, SLOT( widgetsChanged() ) );
    connect( m_reset, SIGNAL( clicked() ),
             this, SLOT( reset() ) );
}

static void setFacet( QComboBox *c, const std::string fac,
                      EasyTagFilter< entity::Package > &f )
{
    if (c->currentItem())
        f.set( fac, c->currentText() );
}

EasyTagFilterWidget::Predicate EasyTagFilterWidget::predicate()
{
    EasyTagFilter< entity::Package > f;
    setFacet( m_use, "use", f );
    setFacet( m_interface, "interface", f );
    setFacet( m_worksWith, "works-with", f );
    setFacet( m_role, "role", f );
    return predicate::adapt< entity::Entity >( f );
}

static void setCombo( QComboBox *c, const std::string &t ) {
    c->blockSignals( true );
    if (t == "")
        c->setCurrentItem( 0 );
    else
        c->setCurrentText( t );
    c->blockSignals( false );
}

void EasyTagFilterWidget::predicateChanged() {
    typedef EasyTagFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    setCombo( m_use, f.get( "use" ) );
    setCombo( m_interface, f.get( "interface" ) );
    setCombo( m_role, f.get( "role" ) );
    setCombo( m_worksWith, f.get( "works-with" ) );
}

void EasyTagFilterWidget::reset() {
    setCombo( m_use, "" );
    setCombo( m_interface, "" );
    setCombo( m_role, "" );
    setCombo( m_worksWith, "" );
    emit widgetsChanged();
}
