#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <qobjectlist.h>
#include <klocale.h>
#include <kdebug.h>
#include <klineedit.h>
#include <qcheckbox.h>

#include "quickfilter.h"

using namespace aptFront;
using namespace adept;

QuickFilterWidget::QuickFilterWidget( QWidget *parent, const char *name )
    : QuickFilterUi( parent, name )
{
    setFocusProxy( m_match );
    connect( m_match, SIGNAL( textChanged( const QString & ) ),
             this, SLOT( textChanged( const QString & ) ) );
    /* connect( m_reset, SIGNAL( clicked() ),
       this, SLOT( reset() ) ); */
    connect( m_match, SIGNAL( returnPressed() ),
             this, SLOT( widgetsChanged() ) );
    connect( &timer, SIGNAL( timeout() ),
             this, SLOT( widgetsChanged() ) );

    QObjectList *chld = queryList( "QCheckBox" );
    QObjectListIt it( *chld );
    while( it.current() != 0 ) {
        connect( it.current(), SIGNAL( toggled( bool )  ),
                 this, SLOT( widgetsChanged() ) );
        ++it;
    }
}

void QuickFilterWidget::mouseReleaseEvent( QMouseEvent *e ) {
    m_match->setFocus();
    QuickFilterUi::mouseReleaseEvent( e );
}

void QuickFilterWidget::textChanged( const QString & )
{
    kdDebug() << "QuickFilterWidget::textChanged" << endl;
    timer.start( 1000, true );
}

QuickFilterWidget::Predicate QuickFilterWidget::predicate()
{
    typedef QuickFilter< entity::Package > F;
    F f; int w = 0;
    if ( m_name->isChecked() ) w |= F::Name;
    if ( m_description->isChecked() ) w |= F::Description;
    if ( m_maintainer->isChecked() ) w |= F::Maintainer;

    f.setMatch( u8( m_match->text() ) );
    f.setWhat( w );

    return predicate::adapt< entity::Entity >( f );
}

static void blockedSet( QCheckBox *b, bool v ) {
    b->blockSignals( true );
    b->setChecked( v );
    b->blockSignals( false );
}

void QuickFilterWidget::predicateChanged() {
    typedef QuickFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    m_match->blockSignals( true );
    m_match->setText( f.match() );
    m_match->blockSignals( false );
    int w = f.what();

    blockedSet( m_name, w & F::Name );
    blockedSet( m_description, w & F::Description );
    blockedSet( m_maintainer, w & F::Maintainer );
}

