// -*- C++ -*- (c) 2007, 2008 Petr Rockai <me@mornfall.net>

#include <adept/packagedata.h>
#include <adept/tokenmodel.h>
#include <adept/packagelist.h>

#include <QtGui/QStackedWidget>
#include <QtGui/QPushButton>
#include <KVBox>

#ifndef ADEPT_PREVIEWWIDGET_H
#define ADEPT_PREVIEWWIDGET_H

namespace adept {

class PreviewWidget : public KVBox
{
    Q_OBJECT
protected:
    PackageData &d;
    QLabel *m_empty;
    QStackedWidget *m_stack;
    KHBox *m_buttons;
    TokenModel *m_model;
    QPushButton *m_applyButton, *m_revertButton, *m_upgradeButton;
    PackageListView *m_list;

public:
    PreviewWidget( PackageData &_d, QWidget *p = 0 )
        : KVBox( p ), d( _d )
    {
        m_stack = new QStackedWidget( this );
        m_empty = new QLabel();
        m_empty->setWordWrap( true );
        m_empty->setAlignment( Qt::AlignCenter );

        m_model = new TokenModel();
        m_list = setupList( this, m_stack, m_model, d );
        m_buttons = new KHBox( this );

        m_stack->addWidget( m_empty );
        m_stack->addWidget( m_list );

        new QWidget( m_buttons ); // spacer
        m_upgradeButton = new QPushButton( m_buttons );
        m_revertButton = new QPushButton( m_buttons );
        m_applyButton = new QPushButton( m_buttons );
        m_upgradeButton->setText( i18n( "Upgrade" ) );
        m_upgradeButton->setIcon( KIcon( "system-software-update" ) );
        m_revertButton->setText( i18n( "Revert changes" ) );
        m_revertButton->setIcon( KIcon( "edit-undo" ) );
        m_applyButton->setText( i18n( "Apply changes" ) );
        m_applyButton->setIcon( KIcon( "dialog-ok-apply" ) );

        connect( m_applyButton, SIGNAL( clicked() ),
                 this, SIGNAL( apply() ) );
        connect( m_revertButton, SIGNAL( clicked() ),
                 this, SIGNAL( revert() ) );
        connect( m_upgradeButton, SIGNAL( clicked() ),
                 this, SIGNAL( upgrade() ) );
    }

    void setEmptyText( QString s ) {
        m_empty->setText( s );
    }

    template< typename L >
    void fill( L l ) {
        QWidget *empty = m_empty, *list = m_list;
        m_stack->setCurrentWidget( l.empty() ? empty : list );
        m_list->closeAllEditors();
        m_model->fillFrom( l, Validator( d ) );
    }

    QPushButton *applyButton() {
        return m_applyButton;
    }

    QPushButton *upgradeButton() {
        return m_upgradeButton;
    }

    QPushButton *revertButton() {
        return m_revertButton;
    }

    PackageListView *list() {
        return m_list;
    }

public Q_SLOTS:
    void refresh() {
        m_list->viewport()->repaint();
    }

Q_SIGNALS:
    void upgrade();
    void apply();
    void revert();
};

}

#endif
