// -*- C++ -*- (c) 2008 Petr Rockai <me@mornfall.net>

#include <KVBox>
#include <QPushButton>
#include <QStackedWidget>
#include <QProgressBar>
#include <QLabel>

#include <adept/guidpkgpm.h>
#include <adept/debconfgui.h>

#ifndef ADEPT_COMMITWIDGET_H
#define ADEPT_COMMITWIDGET_H

namespace adept {

class CommitWidget : public KVBox
{
    Q_OBJECT
    QStackedWidget *m_stack;
    QLabel *m_action;
    DebconfGui *m_debconf;
    QProgressBar *m_progBar;
    QLabel *m_conffileName;
    QPushButton *m_conffileNew, *m_conffileOld;
    KVBox *m_conffile;
    DpkgGui *m_dpkg;
public:
    CommitWidget( QWidget *p = 0 ) : KVBox( p )
    {
        setMargin( 10 );

        m_stack = new QStackedWidget( this );

        try {
            m_debconf = new DebconfGui( m_stack );
            m_stack->addWidget( m_debconf );
            connect( m_debconf, SIGNAL( activated() ),
                     this, SLOT( raiseDebconf() ) );
            connect( m_debconf, SIGNAL( deactivated() ),
                     this, SLOT( raiseAction() ) );
            connect( m_debconf, SIGNAL( activated() ),
                     this, SIGNAL( activated() ) );
        } catch (...) {
            m_debconf = 0;
        }

        m_action = new QLabel( m_stack );
        m_stack->addWidget( m_action );

        m_conffile = new KVBox( m_stack );
        m_stack->addWidget( m_conffile );

        new QWidget( m_conffile ); // spacer

        m_conffileName = new QLabel( m_conffile );

        m_conffileOld = new QPushButton( m_conffile );
        m_conffileOld->setText( i18n( "Keep my version" ) );
        connect( m_conffileOld, SIGNAL( clicked() ),
                 this, SLOT( keepCurrentVersion() ) );

        m_conffileNew = new QPushButton( m_conffile );
        m_conffileNew->setText( i18n( "Install new version" ) );
        connect( m_conffileNew, SIGNAL( clicked() ),
                 this, SLOT( takeNewVersion() ) );

        new QWidget( m_conffile ); // spacer

        m_progBar = new QProgressBar( this );
        m_progBar->setMaximum( 100 );
    }

    void setPM( DpkgGui *dpkg ) {
        connect( dpkg, SIGNAL( statusChanged( int, QString ) ),
                 this, SLOT( setStatus( int, QString ) ) );
        connect( dpkg, SIGNAL(
                     conffilePrompt( std::string, std::string, std::string ) ),
                 this, SLOT(
                     handleConffile( std::string, std::string, std::string ) ) );
        m_dpkg = dpkg;
    }

    DebconfGui *debconf() {
        return m_debconf;
    }

public Q_SLOTS:
    void raiseDebconf() {
        if ( m_debconf )
            m_stack->setCurrentWidget( m_debconf );
    }

    void raiseAction() {
        m_stack->setCurrentWidget( m_action );
    }

    void setStatus( int p, QString m ) {
        m_action->setText( m );
        m_progBar->setValue( p );
        emit activated();
    }

    void handleConffile( std::string /* file */, std::string u, std::string s ) {
        m_stack->setCurrentWidget( m_conffile );
        m_conffileName->setWordWrap( true );
        m_conffileName->setText(
            i18n( "There is a conflict between your version of a configuration"
                  " file, and a new version provided by the package maintainer."
                  " You may inspect both files (you will for now need to use"
                  " a text editor or such). Your current version is <b>%1</b>."
                  " The new version provided by package maintainer"
                  " is <b>%2</b>.<br>"
                  " Which action do you wish to take?",
                  u8( u ), u8( s ) ) );
    }

    void takeNewVersion() {
        raiseAction();
        m_dpkg->tellDpkg( "Y\n" );
    }

    void keepCurrentVersion() {
        raiseAction();
        m_dpkg->tellDpkg( "N\n" );
    }

Q_SIGNALS:
    void activated();
};

}

#endif
