dnl ALSA soundcard configuration
dnl Find out which cards to compile driver for
dnl Copyright (c) by Jaroslav Kysela <perex@suse.cz>,
dnl                  Anders Semb Hermansen <ahermans@vf.telia.no>

AC_DEFUN([ALSA_TOPLEVEL_INIT], [
	CONFIG_SOUND=""
	CONFIG_SND=""
	CONFIG_SND_TIMER=""
	CONFIG_SND_PCM=""
	CONFIG_SND_HWDEP=""
	CONFIG_SND_RAWMIDI=""
	CONFIG_SND_SEQUENCER=""
	CONFIG_SND_SEQ_DUMMY=""
	CONFIG_SND_OSSEMUL=""
	CONFIG_SND_MIXER_OSS=""
	CONFIG_SND_PCM_OSS=""
	CONFIG_SND_SEQUENCER_OSS=""
	CONFIG_SND_BIT32_EMUL=""
	CONFIG_MIPS64=""
	CONFIG_SPARC64=""
	CONFIG_PPC64=""
	CONFIG_X86_64=""
	CONFIG_IA32_EMULATION=""
	CONFIG_SND_RTCTIMER=""
	CONFIG_RTC=""
	CONFIG_SND_VERBOSE_PRINTK=""
	CONFIG_SND_DEBUG=""
	CONFIG_SND_DEBUG_MEMORY=""
	CONFIG_SND_DEBUG_DETECT=""
	CONFIG_SND_MPU401_UART=""
	CONFIG_SND_OPL3_LIB=""
	CONFIG_SND_OPL4_LIB=""
	CONFIG_SND_VX_LIB=""
	CONFIG_SND_DUMMY=""
	CONFIG_SND_VIRMIDI=""
	CONFIG_SND_MTPAV=""
	CONFIG_SND_SERIAL_U16550=""
	CONFIG_SND_MPU401=""
	CONFIG_SND_SERIALMIDI=""
	CONFIG_ISA=""
	CONFIG_SND_AD1816A=""
	CONFIG_ISAPNP=""
	CONFIG_SND_AD1848=""
	CONFIG_SND_CS4231=""
	CONFIG_SND_CS4232=""
	CONFIG_SND_CS4236=""
	CONFIG_SND_PC98_CS4232=""
	CONFIG_X86_PC9800=""
	CONFIG_SND_ES968=""
	CONFIG_SND_ES1688=""
	CONFIG_SND_ES18XX=""
	CONFIG_SND_GUSCLASSIC=""
	CONFIG_SND_GUSEXTREME=""
	CONFIG_SND_GUSMAX=""
	CONFIG_SND_INTERWAVE=""
	CONFIG_SND_INTERWAVE_STB=""
	CONFIG_SND_OPTI92X_AD1848=""
	CONFIG_SND_OPTI92X_CS4231=""
	CONFIG_SND_OPTI93X=""
	CONFIG_SND_SB8=""
	CONFIG_SND_SB16=""
	CONFIG_SND_SBAWE=""
	CONFIG_SND_SB16_CSP=""
	CONFIG_SND_WAVEFRONT=""
	CONFIG_SND_ALS100=""
	CONFIG_SND_AZT2320=""
	CONFIG_SND_CMI8330=""
	CONFIG_SND_DT019X=""
	CONFIG_SND_OPL3SA2=""
	CONFIG_SND_SGALAXY=""
	CONFIG_SND_SSCAPE=""
	CONFIG_SND_MSND_PINNACLE=""
	CONFIG_X86=""
	CONFIG_PCI=""
	CONFIG_SND_AC97_CODEC=""
	CONFIG_SND_ALI5451=""
	CONFIG_SND_ATIIXP=""
	CONFIG_SND_AU8810=""
	CONFIG_SND_AU8820=""
	CONFIG_SND_AU8830=""
	CONFIG_SND_AZT3328=""
	CONFIG_EXPERIMENTAL=""
	CONFIG_SND_BT87X=""
	CONFIG_SND_CS46XX=""
	CONFIG_SND_CS46XX_NEW_DSP=""
	CONFIG_SND_CS4281=""
	CONFIG_SND_EMU10K1=""
	CONFIG_SND_KORG1212=""
	CONFIG_SND_MIXART=""
	CONFIG_SND_NM256=""
	CONFIG_SND_RME32=""
	CONFIG_SND_RME96=""
	CONFIG_SND_RME9652=""
	CONFIG_SND_HDSP=""
	CONFIG_SND_TRIDENT=""
	CONFIG_SND_YMFPCI=""
	CONFIG_SND_ALS4000=""
	CONFIG_SND_CMIPCI=""
	CONFIG_SND_ENS1370=""
	CONFIG_SND_ENS1371=""
	CONFIG_SND_ES1938=""
	CONFIG_SND_ES1968=""
	CONFIG_SND_MAESTRO3=""
	CONFIG_SND_FM801=""
	CONFIG_SND_FM801_TEA575X=""
	CONFIG_VIDEO_DEV=""
	CONFIG_SND_ICE1712=""
	CONFIG_SND_ICE1724=""
	CONFIG_SND_INTEL8X0=""
	CONFIG_SND_INTEL8X0M=""
	CONFIG_SND_SONICVIBES=""
	CONFIG_SND_VIA82XX=""
	CONFIG_SND_VX222=""
	CONFIG_SND_PDPLUS=""
	CONFIG_SND_HDSPM=""
	CONFIG_SND_EMU10K1X=""
	CONFIG_SND_ATIIXP_MODEM=""
	CONFIG_PPC=""
	CONFIG_SND_POWERMAC=""
	CONFIG_ARM=""
	CONFIG_SND_SA11XX_UDA1341=""
	CONFIG_ARCH_SA1100=""
	CONFIG_L3=""
	CONFIG_USB=""
	CONFIG_SND_USB_AUDIO=""
	CONFIG_SND_USB_USX2Y=""
	CONFIG_PCMCIA=""
	CONFIG_SND_VXPOCKET=""
	CONFIG_SND_VXP440=""
	CONFIG_SND_PDAUDIOCF=""
	CONFIG_SPARC32=""
	CONFIG_SND_SUN_AMD7930=""
	CONFIG_SBUS=""
	CONFIG_SND_SUN_CS4231=""
	CONFIG_PARISC=""
	CONFIG_SND_HARMONY=""
	CONFIG_SOUND_PRIME=""
])

AC_DEFUN([ALSA_TOPLEVEL_ALL], [
	CONFIG_SND="m"
	AC_DEFINE(CONFIG_SND_MODULE)
	CONFIG_SND_TIMER="m"
	AC_DEFINE(CONFIG_SND_TIMER_MODULE)
	CONFIG_SND_PCM="m"
	AC_DEFINE(CONFIG_SND_PCM_MODULE)
	CONFIG_SND_HWDEP="m"
	AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
	CONFIG_SND_RAWMIDI="m"
	AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
	CONFIG_SND_MPU401_UART="m"
	AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
	CONFIG_SND_OPL3_LIB="m"
	AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
	CONFIG_SND_OPL4_LIB="m"
	AC_DEFINE(CONFIG_SND_OPL4_LIB_MODULE)
	CONFIG_SND_VX_LIB="m"
	AC_DEFINE(CONFIG_SND_VX_LIB_MODULE)
	if ( test "$CONFIG_SND_SEQUENCER" == "y" -o "$CONFIG_SND_SEQUENCER" == "m" ); then
	  CONFIG_SND_SEQ_DUMMY="m"
	  AC_DEFINE(CONFIG_SND_SEQ_DUMMY_MODULE)
	fi
	CONFIG_MIPS64="m"
	AC_DEFINE(CONFIG_MIPS64_MODULE)
	CONFIG_SND_DUMMY="m"
	AC_DEFINE(CONFIG_SND_DUMMY_MODULE)
	if ( test "$CONFIG_SND_SEQUENCER" == "y" -o "$CONFIG_SND_SEQUENCER" == "m" ); then
	  CONFIG_SND_VIRMIDI="m"
	  AC_DEFINE(CONFIG_SND_VIRMIDI_MODULE)
	fi
	CONFIG_SND_MTPAV="m"
	AC_DEFINE(CONFIG_SND_MTPAV_MODULE)
	CONFIG_SND_SERIAL_U16550="m"
	AC_DEFINE(CONFIG_SND_SERIAL_U16550_MODULE)
	CONFIG_SND_MPU401="m"
	AC_DEFINE(CONFIG_SND_MPU401_MODULE)
	CONFIG_SND_SERIALMIDI="m"
	AC_DEFINE(CONFIG_SND_SERIALMIDI_MODULE)
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_ISAPNP" == "y" -o "$CONFIG_ISAPNP" == "m" ); then
	  CONFIG_SND_AD1816A="m"
	  AC_DEFINE(CONFIG_SND_AD1816A_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_AD1848="m"
	  AC_DEFINE(CONFIG_SND_AD1848_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_CS4231="m"
	  AC_DEFINE(CONFIG_SND_CS4231_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_CS4232="m"
	  AC_DEFINE(CONFIG_SND_CS4232_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_CS4236="m"
	  AC_DEFINE(CONFIG_SND_CS4236_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_X86_PC9800" == "y" -o "$CONFIG_X86_PC9800" == "m" ); then
	  CONFIG_SND_PC98_CS4232="m"
	  AC_DEFINE(CONFIG_SND_PC98_CS4232_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_ISAPNP" == "y" -o "$CONFIG_ISAPNP" == "m" ); then
	  CONFIG_SND_ES968="m"
	  AC_DEFINE(CONFIG_SND_ES968_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_ES1688="m"
	  AC_DEFINE(CONFIG_SND_ES1688_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_ES18XX="m"
	  AC_DEFINE(CONFIG_SND_ES18XX_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_GUSCLASSIC="m"
	  AC_DEFINE(CONFIG_SND_GUSCLASSIC_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_GUSEXTREME="m"
	  AC_DEFINE(CONFIG_SND_GUSEXTREME_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_GUSMAX="m"
	  AC_DEFINE(CONFIG_SND_GUSMAX_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_INTERWAVE="m"
	  AC_DEFINE(CONFIG_SND_INTERWAVE_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_INTERWAVE_STB="m"
	  AC_DEFINE(CONFIG_SND_INTERWAVE_STB_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_OPTI92X_AD1848="m"
	  AC_DEFINE(CONFIG_SND_OPTI92X_AD1848_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_OPTI92X_CS4231="m"
	  AC_DEFINE(CONFIG_SND_OPTI92X_CS4231_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_OPTI93X="m"
	  AC_DEFINE(CONFIG_SND_OPTI93X_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_SB8="m"
	  AC_DEFINE(CONFIG_SND_SB8_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_SB16="m"
	  AC_DEFINE(CONFIG_SND_SB16_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_SBAWE="m"
	  AC_DEFINE(CONFIG_SND_SBAWE_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_SND_SB16" == "y" -o "$CONFIG_SND_SB16" == "m" ) ||
	   ( test "$CONFIG_SND_SBAWE" == "y" -o "$CONFIG_SND_SBAWE" == "m" ); then
	  CONFIG_SND_SB16_CSP="y"
	  AC_DEFINE(CONFIG_SND_SB16_CSP)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_WAVEFRONT="m"
	  AC_DEFINE(CONFIG_SND_WAVEFRONT_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_ISAPNP" == "y" -o "$CONFIG_ISAPNP" == "m" ); then
	  CONFIG_SND_ALS100="m"
	  AC_DEFINE(CONFIG_SND_ALS100_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_ISAPNP" == "y" -o "$CONFIG_ISAPNP" == "m" ); then
	  CONFIG_SND_AZT2320="m"
	  AC_DEFINE(CONFIG_SND_AZT2320_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_CMI8330="m"
	  AC_DEFINE(CONFIG_SND_CMI8330_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_ISAPNP" == "y" -o "$CONFIG_ISAPNP" == "m" ); then
	  CONFIG_SND_DT019X="m"
	  AC_DEFINE(CONFIG_SND_DT019X_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_OPL3SA2="m"
	  AC_DEFINE(CONFIG_SND_OPL3SA2_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_SGALAXY="m"
	  AC_DEFINE(CONFIG_SND_SGALAXY_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_SSCAPE="m"
	  AC_DEFINE(CONFIG_SND_SSCAPE_MODULE)
	fi
	if ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ) &&
	   ( test "$CONFIG_X86" == "y" -o "$CONFIG_X86" == "m" ); then
	  CONFIG_SND_MSND_PINNACLE="m"
	  AC_DEFINE(CONFIG_SND_MSND_PINNACLE_MODULE)
	fi
	CONFIG_SND_AC97_CODEC="m"
	AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ALI5451="m"
	  AC_DEFINE(CONFIG_SND_ALI5451_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ATIIXP="m"
	  AC_DEFINE(CONFIG_SND_ATIIXP_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_AU8810="m"
	  AC_DEFINE(CONFIG_SND_AU8810_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_AU8820="m"
	  AC_DEFINE(CONFIG_SND_AU8820_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_AU8830="m"
	  AC_DEFINE(CONFIG_SND_AU8830_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ) &&
	   ( test "$CONFIG_EXPERIMENTAL" == "y" -o "$CONFIG_EXPERIMENTAL" == "m" ); then
	  CONFIG_SND_AZT3328="m"
	  AC_DEFINE(CONFIG_SND_AZT3328_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_BT87X="m"
	  AC_DEFINE(CONFIG_SND_BT87X_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_CS46XX="m"
	  AC_DEFINE(CONFIG_SND_CS46XX_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ) &&
	   ( test "$CONFIG_SND_CS46XX" == "y" -o "$CONFIG_SND_CS46XX" == "m" ) &&
	   ( test "$CONFIG_EXPERIMENTAL" == "y" -o "$CONFIG_EXPERIMENTAL" == "m" ); then
	  CONFIG_SND_CS46XX_NEW_DSP="y"
	  AC_DEFINE(CONFIG_SND_CS46XX_NEW_DSP)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_CS4281="m"
	  AC_DEFINE(CONFIG_SND_CS4281_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_EMU10K1="m"
	  AC_DEFINE(CONFIG_SND_EMU10K1_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_KORG1212="m"
	  AC_DEFINE(CONFIG_SND_KORG1212_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_MIXART="m"
	  AC_DEFINE(CONFIG_SND_MIXART_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_NM256="m"
	  AC_DEFINE(CONFIG_SND_NM256_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_RME32="m"
	  AC_DEFINE(CONFIG_SND_RME32_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_RME96="m"
	  AC_DEFINE(CONFIG_SND_RME96_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_RME9652="m"
	  AC_DEFINE(CONFIG_SND_RME9652_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_HDSP="m"
	  AC_DEFINE(CONFIG_SND_HDSP_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_TRIDENT="m"
	  AC_DEFINE(CONFIG_SND_TRIDENT_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_YMFPCI="m"
	  AC_DEFINE(CONFIG_SND_YMFPCI_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ALS4000="m"
	  AC_DEFINE(CONFIG_SND_ALS4000_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_CMIPCI="m"
	  AC_DEFINE(CONFIG_SND_CMIPCI_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ENS1370="m"
	  AC_DEFINE(CONFIG_SND_ENS1370_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ENS1371="m"
	  AC_DEFINE(CONFIG_SND_ENS1371_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ES1938="m"
	  AC_DEFINE(CONFIG_SND_ES1938_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ES1968="m"
	  AC_DEFINE(CONFIG_SND_ES1968_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_MAESTRO3="m"
	  AC_DEFINE(CONFIG_SND_MAESTRO3_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_FM801="m"
	  AC_DEFINE(CONFIG_SND_FM801_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ) &&
	   ( test "$CONFIG_VIDEO_DEV" == "y" -o "$CONFIG_VIDEO_DEV" == "m" ); then
	  CONFIG_SND_FM801_TEA575X="m"
	  AC_DEFINE(CONFIG_SND_FM801_TEA575X_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ICE1712="m"
	  AC_DEFINE(CONFIG_SND_ICE1712_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ICE1724="m"
	  AC_DEFINE(CONFIG_SND_ICE1724_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_INTEL8X0="m"
	  AC_DEFINE(CONFIG_SND_INTEL8X0_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ) &&
	   ( test "$CONFIG_EXPERIMENTAL" == "y" -o "$CONFIG_EXPERIMENTAL" == "m" ); then
	  CONFIG_SND_INTEL8X0M="m"
	  AC_DEFINE(CONFIG_SND_INTEL8X0M_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_SONICVIBES="m"
	  AC_DEFINE(CONFIG_SND_SONICVIBES_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_VIA82XX="m"
	  AC_DEFINE(CONFIG_SND_VIA82XX_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_VX222="m"
	  AC_DEFINE(CONFIG_SND_VX222_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_PDPLUS="m"
	  AC_DEFINE(CONFIG_SND_PDPLUS_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_HDSPM="m"
	  AC_DEFINE(CONFIG_SND_HDSPM_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_EMU10K1X="m"
	  AC_DEFINE(CONFIG_SND_EMU10K1X_MODULE)
	fi
	if ( test "$CONFIG_PCI" == "y" -o "$CONFIG_PCI" == "m" ); then
	  CONFIG_SND_ATIIXP_MODEM="m"
	  AC_DEFINE(CONFIG_SND_ATIIXP_MODEM_MODULE)
	fi
	if ( test "$CONFIG_PPC" == "y" -o "$CONFIG_PPC" == "m" ); then
	  CONFIG_SND_POWERMAC="m"
	  AC_DEFINE(CONFIG_SND_POWERMAC_MODULE)
	fi
	if ( test "$CONFIG_ARM" == "y" -o "$CONFIG_ARM" == "m" ) &&
	   ( test "$CONFIG_ARCH_SA1100" == "y" -o "$CONFIG_ARCH_SA1100" == "m" ) &&
	   ( test "$CONFIG_L3" == "y" -o "$CONFIG_L3" == "m" ); then
	  CONFIG_SND_SA11XX_UDA1341="m"
	  AC_DEFINE(CONFIG_SND_SA11XX_UDA1341_MODULE)
	fi
	if ( test "$CONFIG_USB" == "y" -o "$CONFIG_USB" == "m" ); then
	  CONFIG_SND_USB_AUDIO="m"
	  AC_DEFINE(CONFIG_SND_USB_AUDIO_MODULE)
	fi
	if ( test "$CONFIG_USB" == "y" -o "$CONFIG_USB" == "m" ); then
	  CONFIG_SND_USB_USX2Y="m"
	  AC_DEFINE(CONFIG_SND_USB_USX2Y_MODULE)
	fi
	if ( test "$CONFIG_PCMCIA" == "y" -o "$CONFIG_PCMCIA" == "m" ) &&
	   ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_VXPOCKET="m"
	  AC_DEFINE(CONFIG_SND_VXPOCKET_MODULE)
	fi
	if ( test "$CONFIG_PCMCIA" == "y" -o "$CONFIG_PCMCIA" == "m" ) &&
	   ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_VXP440="m"
	  AC_DEFINE(CONFIG_SND_VXP440_MODULE)
	fi
	if ( test "$CONFIG_PCMCIA" == "y" -o "$CONFIG_PCMCIA" == "m" ) &&
	   ( test "$CONFIG_ISA" == "y" -o "$CONFIG_ISA" == "m" ); then
	  CONFIG_SND_PDAUDIOCF="m"
	  AC_DEFINE(CONFIG_SND_PDAUDIOCF_MODULE)
	fi
	if ((( test "$CONFIG_SPARC32" == "y" -o "$CONFIG_SPARC32" == "m" ) ||
	   ( test "$CONFIG_SPARC64" == "y" -o "$CONFIG_SPARC64" == "m" ))) &&
	   ( test "$CONFIG_SBUS" == "y" -o "$CONFIG_SBUS" == "m" ); then
	  CONFIG_SND_SUN_AMD7930="m"
	  AC_DEFINE(CONFIG_SND_SUN_AMD7930_MODULE)
	fi
	if ((( test "$CONFIG_SPARC32" == "y" -o "$CONFIG_SPARC32" == "m" ) ||
	   ( test "$CONFIG_SPARC64" == "y" -o "$CONFIG_SPARC64" == "m" ))); then
	  CONFIG_SND_SUN_CS4231="m"
	  AC_DEFINE(CONFIG_SND_SUN_CS4231_MODULE)
	fi
	if ( test "$CONFIG_PARISC" == "y" -o "$CONFIG_PARISC" == "m" ); then
	  CONFIG_SND_HARMONY="m"
	  AC_DEFINE(CONFIG_SND_HARMONY_MODULE)
	fi
])

AC_DEFUN([ALSA_TOPLEVEL_SELECT], [
dnl Check for which cards to compile driver for...
AC_MSG_CHECKING(for which soundcards to compile driver for)
AC_ARG_WITH(cards,
  [  --with-cards=<list>     compile driver for cards in <list>; ]
  [                        cards may be separated with commas; ]
  [                        'all' compiles all drivers; ]
  [                        Possible cards are: ]
  [                        seq-dummy, dummy, virmidi, mtpav, serial-u16550, ]
  [                        mpu401, serialmidi, ad1816a, ad1848, cs4231, ]
  [                        cs4232, cs4236, pc98-cs4232, es968, es1688, ]
  [                        es18xx, gusclassic, gusextreme, gusmax, ]
  [                        interwave, interwave-stb, opti92x-ad1848, ]
  [                        opti92x-cs4231, opti93x, sb8, sb16, sbawe, ]
  [                        wavefront, als100, azt2320, cmi8330, dt019x, ]
  [                        opl3sa2, sgalaxy, sscape, msnd-pinnacle, ]
  [                        ac97-codec, ali5451, atiixp, au8810, au8820, ]
  [                        au8830, azt3328, bt87x, cs46xx, cs4281, emu10k1, ]
  [                        korg1212, mixart, nm256, rme32, rme96, rme9652, ]
  [                        hdsp, trident, ymfpci, als4000, cmipci, ens1370, ]
  [                        ens1371, es1938, es1968, maestro3, fm801, ]
  [                        fm801-tea575x, ice1712, ice1724, intel8x0, ]
  [                        intel8x0m, sonicvibes, via82xx, vx222, pdplus, ]
  [                        hdspm, emu10k1x, atiixp-modem, powermac, ]
  [                        sa11xx-uda1341, usb-audio, usb-usx2y, vxpocket, ]
  [                        vxp440, pdaudiocf, sun-amd7930, sun-cs4231, ]
  [                        harmony ],
  cards="$withval", cards="all")
if test "$cards" = "all"; then
  ALSA_TOPLEVEL_ALL
  AC_MSG_RESULT(all)
else
  cards=`echo $cards | sed 's/,/ /g'`
  for card in $cards
  do
    case "$card" in
	seq-dummy)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_SEQ_DUMMY="m"
		AC_DEFINE(CONFIG_SND_SEQ_DUMMY_MODULE)
		;;
	dummy)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_DUMMY="m"
		AC_DEFINE(CONFIG_SND_DUMMY_MODULE)
		;;
	virmidi)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_VIRMIDI="m"
		AC_DEFINE(CONFIG_SND_VIRMIDI_MODULE)
		;;
	mtpav)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_MTPAV="m"
		AC_DEFINE(CONFIG_SND_MTPAV_MODULE)
		;;
	serial-u16550)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_SERIAL_U16550="m"
		AC_DEFINE(CONFIG_SND_SERIAL_U16550_MODULE)
		;;
	mpu401)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_MPU401="m"
		AC_DEFINE(CONFIG_SND_MPU401_MODULE)
		;;
	serialmidi)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_SERIALMIDI="m"
		AC_DEFINE(CONFIG_SND_SERIALMIDI_MODULE)
		;;
	ad1816a)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AD1816A="m"
		AC_DEFINE(CONFIG_SND_AD1816A_MODULE)
		;;
	ad1848)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AD1848="m"
		AC_DEFINE(CONFIG_SND_AD1848_MODULE)
		;;
	cs4231)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_CS4231="m"
		AC_DEFINE(CONFIG_SND_CS4231_MODULE)
		;;
	cs4232)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_CS4232="m"
		AC_DEFINE(CONFIG_SND_CS4232_MODULE)
		;;
	cs4236)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_CS4236="m"
		AC_DEFINE(CONFIG_SND_CS4236_MODULE)
		;;
	pc98-cs4232)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_PC98_CS4232="m"
		AC_DEFINE(CONFIG_SND_PC98_CS4232_MODULE)
		;;
	es968)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_ES968="m"
		AC_DEFINE(CONFIG_SND_ES968_MODULE)
		;;
	es1688)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_ES1688="m"
		AC_DEFINE(CONFIG_SND_ES1688_MODULE)
		;;
	es18xx)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_ES18XX="m"
		AC_DEFINE(CONFIG_SND_ES18XX_MODULE)
		;;
	gusclassic)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_GUSCLASSIC="m"
		AC_DEFINE(CONFIG_SND_GUSCLASSIC_MODULE)
		;;
	gusextreme)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_GUSEXTREME="m"
		AC_DEFINE(CONFIG_SND_GUSEXTREME_MODULE)
		;;
	gusmax)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_GUSMAX="m"
		AC_DEFINE(CONFIG_SND_GUSMAX_MODULE)
		;;
	interwave)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_INTERWAVE="m"
		AC_DEFINE(CONFIG_SND_INTERWAVE_MODULE)
		;;
	interwave-stb)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_INTERWAVE_STB="m"
		AC_DEFINE(CONFIG_SND_INTERWAVE_STB_MODULE)
		;;
	opti92x-ad1848)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_OPL4_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL4_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPTI92X_AD1848="m"
		AC_DEFINE(CONFIG_SND_OPTI92X_AD1848_MODULE)
		;;
	opti92x-cs4231)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_OPL4_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL4_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPTI92X_CS4231="m"
		AC_DEFINE(CONFIG_SND_OPTI92X_CS4231_MODULE)
		;;
	opti93x)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPTI93X="m"
		AC_DEFINE(CONFIG_SND_OPTI93X_MODULE)
		;;
	sb8)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SB8="m"
		AC_DEFINE(CONFIG_SND_SB8_MODULE)
		;;
	sb16)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SB16="m"
		AC_DEFINE(CONFIG_SND_SB16_MODULE)
		;;
	sbawe)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SBAWE="m"
		AC_DEFINE(CONFIG_SND_SBAWE_MODULE)
		;;
	sb16-csp)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_SB16_CSP="y"
		AC_DEFINE(CONFIG_SND_SB16_CSP)
		;;
	wavefront)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_WAVEFRONT="m"
		AC_DEFINE(CONFIG_SND_WAVEFRONT_MODULE)
		;;
	als100)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_ALS100="m"
		AC_DEFINE(CONFIG_SND_ALS100_MODULE)
		;;
	azt2320)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AZT2320="m"
		AC_DEFINE(CONFIG_SND_AZT2320_MODULE)
		;;
	cmi8330)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_CMI8330="m"
		AC_DEFINE(CONFIG_SND_CMI8330_MODULE)
		;;
	dt019x)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_DT019X="m"
		AC_DEFINE(CONFIG_SND_DT019X_MODULE)
		;;
	opl3sa2)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPL3SA2="m"
		AC_DEFINE(CONFIG_SND_OPL3SA2_MODULE)
		;;
	sgalaxy)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SGALAXY="m"
		AC_DEFINE(CONFIG_SND_SGALAXY_MODULE)
		;;
	sscape)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SSCAPE="m"
		AC_DEFINE(CONFIG_SND_SSCAPE_MODULE)
		;;
	msnd-pinnacle)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MSND_PINNACLE="m"
		AC_DEFINE(CONFIG_SND_MSND_PINNACLE_MODULE)
		;;
	ac97-codec)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		;;
	ali5451)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ALI5451="m"
		AC_DEFINE(CONFIG_SND_ALI5451_MODULE)
		;;
	atiixp)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ATIIXP="m"
		AC_DEFINE(CONFIG_SND_ATIIXP_MODULE)
		;;
	au8810)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_AU8810="m"
		AC_DEFINE(CONFIG_SND_AU8810_MODULE)
		;;
	au8820)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_AU8820="m"
		AC_DEFINE(CONFIG_SND_AU8820_MODULE)
		;;
	au8830)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_AU8830="m"
		AC_DEFINE(CONFIG_SND_AU8830_MODULE)
		;;
	azt3328)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AZT3328="m"
		AC_DEFINE(CONFIG_SND_AZT3328_MODULE)
		;;
	bt87x)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_BT87X="m"
		AC_DEFINE(CONFIG_SND_BT87X_MODULE)
		;;
	cs46xx)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_CS46XX="m"
		AC_DEFINE(CONFIG_SND_CS46XX_MODULE)
		;;
	cs46xx-new-dsp)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_CS46XX_NEW_DSP="y"
		AC_DEFINE(CONFIG_SND_CS46XX_NEW_DSP)
		;;
	cs4281)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_CS4281="m"
		AC_DEFINE(CONFIG_SND_CS4281_MODULE)
		;;
	emu10k1)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_EMU10K1="m"
		AC_DEFINE(CONFIG_SND_EMU10K1_MODULE)
		;;
	korg1212)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_KORG1212="m"
		AC_DEFINE(CONFIG_SND_KORG1212_MODULE)
		;;
	mixart)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MIXART="m"
		AC_DEFINE(CONFIG_SND_MIXART_MODULE)
		;;
	nm256)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_NM256="m"
		AC_DEFINE(CONFIG_SND_NM256_MODULE)
		;;
	rme32)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_RME32="m"
		AC_DEFINE(CONFIG_SND_RME32_MODULE)
		;;
	rme96)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_RME96="m"
		AC_DEFINE(CONFIG_SND_RME96_MODULE)
		;;
	rme9652)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_RME9652="m"
		AC_DEFINE(CONFIG_SND_RME9652_MODULE)
		;;
	hdsp)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_HDSP="m"
		AC_DEFINE(CONFIG_SND_HDSP_MODULE)
		;;
	trident)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_TRIDENT="m"
		AC_DEFINE(CONFIG_SND_TRIDENT_MODULE)
		;;
	ymfpci)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_YMFPCI="m"
		AC_DEFINE(CONFIG_SND_YMFPCI_MODULE)
		;;
	als4000)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_ALS4000="m"
		AC_DEFINE(CONFIG_SND_ALS4000_MODULE)
		;;
	cmipci)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_CMIPCI="m"
		AC_DEFINE(CONFIG_SND_CMIPCI_MODULE)
		;;
	ens1370)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_ENS1370="m"
		AC_DEFINE(CONFIG_SND_ENS1370_MODULE)
		;;
	ens1371)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ENS1371="m"
		AC_DEFINE(CONFIG_SND_ENS1371_MODULE)
		;;
	es1938)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ES1938="m"
		AC_DEFINE(CONFIG_SND_ES1938_MODULE)
		;;
	es1968)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ES1968="m"
		AC_DEFINE(CONFIG_SND_ES1968_MODULE)
		;;
	maestro3)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_MAESTRO3="m"
		AC_DEFINE(CONFIG_SND_MAESTRO3_MODULE)
		;;
	fm801)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_FM801="m"
		AC_DEFINE(CONFIG_SND_FM801_MODULE)
		;;
	fm801-tea575x)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_FM801_TEA575X="m"
		AC_DEFINE(CONFIG_SND_FM801_TEA575X_MODULE)
		;;
	ice1712)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ICE1712="m"
		AC_DEFINE(CONFIG_SND_ICE1712_MODULE)
		;;
	ice1724)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ICE1724="m"
		AC_DEFINE(CONFIG_SND_ICE1724_MODULE)
		;;
	intel8x0)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_INTEL8X0="m"
		AC_DEFINE(CONFIG_SND_INTEL8X0_MODULE)
		;;
	intel8x0m)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_INTEL8X0M="m"
		AC_DEFINE(CONFIG_SND_INTEL8X0M_MODULE)
		;;
	sonicvibes)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_OPL3_LIB="m"
		AC_DEFINE(CONFIG_SND_OPL3_LIB_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_SONICVIBES="m"
		AC_DEFINE(CONFIG_SND_SONICVIBES_MODULE)
		;;
	via82xx)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_MPU401_UART="m"
		AC_DEFINE(CONFIG_SND_MPU401_UART_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_VIA82XX="m"
		AC_DEFINE(CONFIG_SND_VIA82XX_MODULE)
		;;
	vx222)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_VX_LIB="m"
		AC_DEFINE(CONFIG_SND_VX_LIB_MODULE)
		CONFIG_SND_VX222="m"
		AC_DEFINE(CONFIG_SND_VX222_MODULE)
		;;
	pdplus)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_PDPLUS="m"
		AC_DEFINE(CONFIG_SND_PDPLUS_MODULE)
		;;
	hdspm)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_HDSPM="m"
		AC_DEFINE(CONFIG_SND_HDSPM_MODULE)
		;;
	emu10k1x)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_EMU10K1X="m"
		AC_DEFINE(CONFIG_SND_EMU10K1X_MODULE)
		;;
	atiixp-modem)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_AC97_CODEC="m"
		AC_DEFINE(CONFIG_SND_AC97_CODEC_MODULE)
		CONFIG_SND_ATIIXP_MODEM="m"
		AC_DEFINE(CONFIG_SND_ATIIXP_MODEM_MODULE)
		;;
	powermac)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_POWERMAC="m"
		AC_DEFINE(CONFIG_SND_POWERMAC_MODULE)
		;;
	sa11xx-uda1341)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SA11XX_UDA1341="m"
		AC_DEFINE(CONFIG_SND_SA11XX_UDA1341_MODULE)
		;;
	usb-audio)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_USB_AUDIO="m"
		AC_DEFINE(CONFIG_SND_USB_AUDIO_MODULE)
		;;
	usb-usx2y)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_RAWMIDI="m"
		AC_DEFINE(CONFIG_SND_RAWMIDI_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_USB_AUDIO="m"
		AC_DEFINE(CONFIG_SND_USB_AUDIO_MODULE)
		CONFIG_SND_USB_USX2Y="m"
		AC_DEFINE(CONFIG_SND_USB_USX2Y_MODULE)
		;;
	vxpocket)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_VX_LIB="m"
		AC_DEFINE(CONFIG_SND_VX_LIB_MODULE)
		CONFIG_SND_VXPOCKET="m"
		AC_DEFINE(CONFIG_SND_VXPOCKET_MODULE)
		;;
	vxp440)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_HWDEP="m"
		AC_DEFINE(CONFIG_SND_HWDEP_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_VX_LIB="m"
		AC_DEFINE(CONFIG_SND_VX_LIB_MODULE)
		CONFIG_SND_VXP440="m"
		AC_DEFINE(CONFIG_SND_VXP440_MODULE)
		;;
	pdaudiocf)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_PDAUDIOCF="m"
		AC_DEFINE(CONFIG_SND_PDAUDIOCF_MODULE)
		;;
	sun-amd7930)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SUN_AMD7930="m"
		AC_DEFINE(CONFIG_SND_SUN_AMD7930_MODULE)
		;;
	sun-cs4231)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_SUN_CS4231="m"
		AC_DEFINE(CONFIG_SND_SUN_CS4231_MODULE)
		;;
	harmony)
		CONFIG_SND="m"
		AC_DEFINE(CONFIG_SND_MODULE)
		CONFIG_SND_TIMER="m"
		AC_DEFINE(CONFIG_SND_TIMER_MODULE)
		CONFIG_SND_PCM="m"
		AC_DEFINE(CONFIG_SND_PCM_MODULE)
		CONFIG_SND_HARMONY="m"
		AC_DEFINE(CONFIG_SND_HARMONY_MODULE)
		;;
	*)
		echo "Unknown soundcard $card, exiting!"
		exit 1
		;;
    esac
  done
  AC_MSG_RESULT($cards)
fi
])

AC_DEFUN([ALSA_TOPLEVEL_OUTPUT], [
dnl output all subst
AC_SUBST(CONFIG_SOUND)
AC_SUBST(CONFIG_SND)
AC_SUBST(CONFIG_SND_TIMER)
AC_SUBST(CONFIG_SND_PCM)
AC_SUBST(CONFIG_SND_HWDEP)
AC_SUBST(CONFIG_SND_RAWMIDI)
AC_SUBST(CONFIG_SND_SEQUENCER)
AC_SUBST(CONFIG_SND_SEQ_DUMMY)
AC_SUBST(CONFIG_SND_OSSEMUL)
AC_SUBST(CONFIG_SND_MIXER_OSS)
AC_SUBST(CONFIG_SND_PCM_OSS)
AC_SUBST(CONFIG_SND_SEQUENCER_OSS)
AC_SUBST(CONFIG_SND_BIT32_EMUL)
AC_SUBST(CONFIG_MIPS64)
AC_SUBST(CONFIG_SPARC64)
AC_SUBST(CONFIG_PPC64)
AC_SUBST(CONFIG_X86_64)
AC_SUBST(CONFIG_IA32_EMULATION)
AC_SUBST(CONFIG_SND_RTCTIMER)
AC_SUBST(CONFIG_RTC)
AC_SUBST(CONFIG_SND_VERBOSE_PRINTK)
AC_SUBST(CONFIG_SND_DEBUG)
AC_SUBST(CONFIG_SND_DEBUG_MEMORY)
AC_SUBST(CONFIG_SND_DEBUG_DETECT)
AC_SUBST(CONFIG_SND_MPU401_UART)
AC_SUBST(CONFIG_SND_OPL3_LIB)
AC_SUBST(CONFIG_SND_OPL4_LIB)
AC_SUBST(CONFIG_SND_VX_LIB)
AC_SUBST(CONFIG_SND_DUMMY)
AC_SUBST(CONFIG_SND_VIRMIDI)
AC_SUBST(CONFIG_SND_MTPAV)
AC_SUBST(CONFIG_SND_SERIAL_U16550)
AC_SUBST(CONFIG_SND_MPU401)
AC_SUBST(CONFIG_SND_SERIALMIDI)
AC_SUBST(CONFIG_ISA)
AC_SUBST(CONFIG_SND_AD1816A)
AC_SUBST(CONFIG_ISAPNP)
AC_SUBST(CONFIG_SND_AD1848)
AC_SUBST(CONFIG_SND_CS4231)
AC_SUBST(CONFIG_SND_CS4232)
AC_SUBST(CONFIG_SND_CS4236)
AC_SUBST(CONFIG_SND_PC98_CS4232)
AC_SUBST(CONFIG_X86_PC9800)
AC_SUBST(CONFIG_SND_ES968)
AC_SUBST(CONFIG_SND_ES1688)
AC_SUBST(CONFIG_SND_ES18XX)
AC_SUBST(CONFIG_SND_GUSCLASSIC)
AC_SUBST(CONFIG_SND_GUSEXTREME)
AC_SUBST(CONFIG_SND_GUSMAX)
AC_SUBST(CONFIG_SND_INTERWAVE)
AC_SUBST(CONFIG_SND_INTERWAVE_STB)
AC_SUBST(CONFIG_SND_OPTI92X_AD1848)
AC_SUBST(CONFIG_SND_OPTI92X_CS4231)
AC_SUBST(CONFIG_SND_OPTI93X)
AC_SUBST(CONFIG_SND_SB8)
AC_SUBST(CONFIG_SND_SB16)
AC_SUBST(CONFIG_SND_SBAWE)
AC_SUBST(CONFIG_SND_SB16_CSP)
AC_SUBST(CONFIG_SND_WAVEFRONT)
AC_SUBST(CONFIG_SND_ALS100)
AC_SUBST(CONFIG_SND_AZT2320)
AC_SUBST(CONFIG_SND_CMI8330)
AC_SUBST(CONFIG_SND_DT019X)
AC_SUBST(CONFIG_SND_OPL3SA2)
AC_SUBST(CONFIG_SND_SGALAXY)
AC_SUBST(CONFIG_SND_SSCAPE)
AC_SUBST(CONFIG_SND_MSND_PINNACLE)
AC_SUBST(CONFIG_X86)
AC_SUBST(CONFIG_PCI)
AC_SUBST(CONFIG_SND_AC97_CODEC)
AC_SUBST(CONFIG_SND_ALI5451)
AC_SUBST(CONFIG_SND_ATIIXP)
AC_SUBST(CONFIG_SND_AU8810)
AC_SUBST(CONFIG_SND_AU8820)
AC_SUBST(CONFIG_SND_AU8830)
AC_SUBST(CONFIG_SND_AZT3328)
AC_SUBST(CONFIG_EXPERIMENTAL)
AC_SUBST(CONFIG_SND_BT87X)
AC_SUBST(CONFIG_SND_CS46XX)
AC_SUBST(CONFIG_SND_CS46XX_NEW_DSP)
AC_SUBST(CONFIG_SND_CS4281)
AC_SUBST(CONFIG_SND_EMU10K1)
AC_SUBST(CONFIG_SND_KORG1212)
AC_SUBST(CONFIG_SND_MIXART)
AC_SUBST(CONFIG_SND_NM256)
AC_SUBST(CONFIG_SND_RME32)
AC_SUBST(CONFIG_SND_RME96)
AC_SUBST(CONFIG_SND_RME9652)
AC_SUBST(CONFIG_SND_HDSP)
AC_SUBST(CONFIG_SND_TRIDENT)
AC_SUBST(CONFIG_SND_YMFPCI)
AC_SUBST(CONFIG_SND_ALS4000)
AC_SUBST(CONFIG_SND_CMIPCI)
AC_SUBST(CONFIG_SND_ENS1370)
AC_SUBST(CONFIG_SND_ENS1371)
AC_SUBST(CONFIG_SND_ES1938)
AC_SUBST(CONFIG_SND_ES1968)
AC_SUBST(CONFIG_SND_MAESTRO3)
AC_SUBST(CONFIG_SND_FM801)
AC_SUBST(CONFIG_SND_FM801_TEA575X)
AC_SUBST(CONFIG_VIDEO_DEV)
AC_SUBST(CONFIG_SND_ICE1712)
AC_SUBST(CONFIG_SND_ICE1724)
AC_SUBST(CONFIG_SND_INTEL8X0)
AC_SUBST(CONFIG_SND_INTEL8X0M)
AC_SUBST(CONFIG_SND_SONICVIBES)
AC_SUBST(CONFIG_SND_VIA82XX)
AC_SUBST(CONFIG_SND_VX222)
AC_SUBST(CONFIG_SND_PDPLUS)
AC_SUBST(CONFIG_SND_HDSPM)
AC_SUBST(CONFIG_SND_EMU10K1X)
AC_SUBST(CONFIG_SND_ATIIXP_MODEM)
AC_SUBST(CONFIG_PPC)
AC_SUBST(CONFIG_SND_POWERMAC)
AC_SUBST(CONFIG_ARM)
AC_SUBST(CONFIG_SND_SA11XX_UDA1341)
AC_SUBST(CONFIG_ARCH_SA1100)
AC_SUBST(CONFIG_L3)
AC_SUBST(CONFIG_USB)
AC_SUBST(CONFIG_SND_USB_AUDIO)
AC_SUBST(CONFIG_SND_USB_USX2Y)
AC_SUBST(CONFIG_PCMCIA)
AC_SUBST(CONFIG_SND_VXPOCKET)
AC_SUBST(CONFIG_SND_VXP440)
AC_SUBST(CONFIG_SND_PDAUDIOCF)
AC_SUBST(CONFIG_SPARC32)
AC_SUBST(CONFIG_SND_SUN_AMD7930)
AC_SUBST(CONFIG_SBUS)
AC_SUBST(CONFIG_SND_SUN_CS4231)
AC_SUBST(CONFIG_PARISC)
AC_SUBST(CONFIG_SND_HARMONY)
AC_SUBST(CONFIG_SOUND_PRIME)
])

