/* inode-sig.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__INODE_SIG_H
#define INCLUDE__LIBARCH__INODE_SIG_H


#include "hackerlab/os/time.h"
#include "libawk/relational.h"
#include "libawk/associative.h"
#include "libarch/project-tree.h"

struct inode_sig_val {
    rel_table ids;
    rel_table paths;
    time_t start_time;
};

typedef struct inode_sig_val inode_sig;


/* automatically generated __STDC__ prototypes */
extern t_uchar * arch_statb_inode_sig (struct stat * statb);
extern inode_sig arch_tree_inode_sig (arch_project_tree_t * tree);
extern void arch_snap_inode_sig (arch_project_tree_t * tree, arch_patch_id * patch_id);
extern void arch_snap_inode_sig_files (arch_project_tree_t * tree, t_uchar * archive, t_uchar * prev_revision, t_uchar * revision, rel_table file_list);
extern void arch_snap_inode_sig_not_reference (arch_project_tree_t * tree, t_uchar const * const archive, t_uchar const * const revision);
extern void arch_snap_inode_sig_not_reference_files (arch_project_tree_t * tree, t_uchar * archive, t_uchar * prev_revision, t_uchar * revision, rel_table file_list);
extern int arch_valid_inode_sig (arch_project_tree_t * tree, t_uchar const * const archive, t_uchar const * const revision);
extern void arch_read_inode_sig_ids (rel_table * as_table, assoc_table * as_assoc,
                                     t_uchar const * const tree_root, t_uchar const * const archive, t_uchar const * const revision);
extern void arch_read_id_shortcut (assoc_table * tags_shortcut, t_uchar * tree_root);
extern void arch_inode_sig_free (inode_sig);
extern void arch_clear_inode_sigs (t_uchar const * const tree_root);
#endif  /* INCLUDE__LIBARCH__INODE_SIG_H */


/* tag: Tom Lord Fri Sep 12 10:33:59 2003 (inode-sig.h)
 */
