# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import email
import os

def read_config(configfile):
    realpath = os.path.expanduser(configfile)
    if not os.path.exists(os.path.dirname(realpath)):
        os.makedirs(os.path.dirname(realpath))
    if not os.path.exists(realpath):
        # write default configuration
        f = open(os.path.expanduser(configfile), "w")
        default_configuration = """Packages-Dir: ~/.bughelper/packages
Local-Packages-Dir: 
Update-Interval: 24
Attachments-Cache: ~/.bughelper/attachments-cache"""
        m = email.message_from_string(default_configuration)
        f.write(m.as_string())
        f.close()
    return email.message_from_file(open(realpath))

class Config(object):
    def __init__(self, configfile):
        m = read_config(configfile)
        self.packages_dir = os.path.expanduser(m.get("Packages-Dir")).strip()
        if m.get("Local-Packages-Dir"):
            self.local_packages_dir = \
                os.path.expanduser(m.get("Local-Packages-Dir")).strip()
        else:
            self.local_packages_dir = None
        self.update_interval = m.get("Update-Interval").strip()
        self.attachments_cache = \
            os.path.expanduser(m.get("Attachments-Cache")).strip()
