'''Temporarily store a blob in Launchpad and get a ticket for it.

Copyright (C) 2007 Canonical Ltd.
Author: Martin Pitt <martin.pitt@ubuntu.com>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.  See http://www.gnu.org/copyleft/gpl.html for
the full text of the license.
'''

import MultipartPostHandler, urllib2

def upload(blob):
    '''Upload given blob (file-like object) to Malone and return the ticket for
    it.

    Return None on error.'''

    ticket = None

    opener = urllib2.build_opener(MultipartPostHandler.MultipartPostHandler)
    result = opener.open('https://launchpad.net/+storeblob', 
        { 'FORM_SUBMIT': '1', 'field.blob': blob })
    ticket = result.info().get('X-Launchpad-Blob-Token')

    return ticket
