# Copyright (C) 2005 by Aaron Bentley

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
from bzrlib.branch import Branch
from bzrlib.errors import NoSuchRevision, InstallFailed, BzrCommandError
def fetch_ghosts(branch, no_fix):
    """Install ghosts from copies in another branch."""
    this_branch = Branch.open_containing('.')[0]
    if branch is None:
        branch = this_branch.get_parent()
        if branch is None:
            raise BzrCommandError('No branch specified and no location saved.')
        else:
            print "Using saved location %s" % branch

    other_branch = Branch.open_containing(branch)[0]
    installed = []
    failed = []
    lock_other = this_branch.base != other_branch.base
    
    this_branch.lock_write()
    try:
        if lock_other:
            other_branch.lock_read()
        try:
            # Because iter_ghosts tests for existence after our last fetch
            # is complete, it won't falsely report an ancestor as a ghost.
            # Yay iterators!
            ghosts = iter_ghosts(this_branch)
            for revision in ghosts:
                try:
                    this_branch.fetch(other_branch, revision)
                    installed.append(revision)
                except InstallFailed:
                    failed.append(revision)
            else:
                if this_branch.last_revision() is None:
                    print "No revisions in branch."
            if len(installed) > 0:
                print "Installed:"
                for rev in installed:
                    print rev
            if len(failed) > 0:
                print "Still missing:"
                for rev in failed:
                    print rev
        finally:
            if lock_other:
                other_branch.unlock()
    finally:
        this_branch.unlock()

    if not no_fix and len(installed) > 0:
        from bzrlib.builtins import cmd_reconcile
        cmd_reconcile().run(".")
        
def iter_ghosts(branch):
    """Find all ancestors that aren't stored in this branch."""
    seen = set()
    lines = [branch.last_revision()]
    if lines[0] is None:
        return
    while len(lines) > 0:
        new_lines = []
        for line in lines:
            if line in seen:
                continue
            seen.add(line)
            try:
                revision = branch.repository.get_revision(line)
                new_lines.extend(revision.parent_ids)
            except NoSuchRevision:
                yield line
        lines = new_lines
