/* Generated from posix.scm by the CHICKEN compiler
   Version 1, Build 21 - linux-unix-gnu-x86
   command line: posix.scm -quiet -debug-level 0 -optimize-level 2 -include-path . -output-file posix.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <grp.h>
#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANONYMOUS
# define MAP_ANONYMOUS    0
#endif

#ifndef C_MACOSX
extern char **environ;
#endif

static char *C_exec_args[ ARG_MAX ];
static struct utsname C_utsname;
static struct flock C_flock;
static DIR *temphandle;
static struct passwd *C_user;
static struct group *C_group;
static int C_pipefds[ 2 ];
static time_t C_secs;
static struct tm C_tm;
static fd_set C_fd_sets[ 2 ];
static struct timeval C_timeval;
static char C_hostbuf[ 256 ];
static struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_fileno(p)         C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_alarm             alarm
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_close(fd)         C_fix(close(C_unfix(fd)))

#ifdef C_MACOSX
# define C_getenventry(i)   NULL
#else
# define C_getenventry(i)   environ[ i ]
#endif

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_exec_arg(int i, char *a, int len);
void C_fcall C_set_exec_arg(int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  C_exec_args[ i ] = ptr;
}

static void C_fcall C_free_exec_args();
void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__)
static int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open((char *)C_data_pointer(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if !defined(C_GNU_ENV)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
#endif

C_externimport void C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_script_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_word lf[326];


/* from k1157 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub656(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub656(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from k3904 */
static C_word C_fcall stub623(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub623(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)sleep(t0));
return C_r;}

/* from parent-process-id in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall stub620(C_word C_buf) C_regparm;
static C_word C_fcall stub620(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall stub618(C_word C_buf) C_regparm;
static C_word C_fcall stub618(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeargs */
static C_word C_fcall stub580(C_word C_buf) C_regparm;
static C_word C_fcall stub580(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k1345 */
static C_word C_fcall stub573(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
static C_word C_fcall stub573(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k3717 */
static C_word C_fcall stub562(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub562(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub557(C_word C_buf) C_regparm;
static C_word C_fcall stub557(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub521(C_word C_buf) C_regparm;
static C_word C_fcall stub521(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
            else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from k1206 */
static C_word C_fcall stub513(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub513(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k3459 */
static C_word C_fcall stub496(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub496(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k1103 */
static C_word C_fcall stub490(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub490(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from asctime */
static C_word C_fcall stub479(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub479(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k1051 */
static C_word C_fcall stub470(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub470(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k1181 */
static C_word C_fcall stub451(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub451(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k1386 */
static C_word C_fcall stub425(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
static C_word C_fcall stub425(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k1359 */
static C_word C_fcall stub407(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub407(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from current-effective-group-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall stub276(C_word C_buf) C_regparm;
static C_word C_fcall stub276(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall stub274(C_word C_buf) C_regparm;
static C_word C_fcall stub274(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall stub272(C_word C_buf) C_regparm;
static C_word C_fcall stub272(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall stub270(C_word C_buf) C_regparm;
static C_word C_fcall stub270(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2657 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub247(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub247(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from k1217 */
static C_word C_fcall stub57(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub57(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k1195 */
static C_word C_fcall stub51(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub51(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k1164 */
static C_word C_fcall stub46(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub46(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k1570 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub1(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub1(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

C_externexport void C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
static void f1553(C_word c,C_word t0,C_word t1) C_noret;
static void f1556(C_word c,C_word t0,C_word t1) C_noret;
static void f1559(C_word c,C_word t0,C_word t1) C_noret;
static void f1562(C_word c,C_word t0,C_word t1) C_noret;
static void f1565(C_word c,C_word t0,C_word t1) C_noret;
static void f2507(C_word c,C_word t0,C_word t1) C_noret;
static void f4296(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2568(C_word c,C_word t0,C_word t1) C_noret;
static void f2869(C_word c,C_word t0,C_word t1) C_noret;
static void f4232(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f4232r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1328(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3982(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3994(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f4006(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f4196(C_word c,C_word t0,C_word t1) C_noret;
static void f4200(C_word c,C_word t0,C_word t1) C_noret;
static void f4203(C_word c,C_word t0,C_word t1) C_noret;
static void f4227(C_word c,C_word t0,C_word t1) C_noret;
static void f4206(C_word c,C_word t0,C_word t1) C_noret;
static void f4218(C_word c,C_word t0,C_word t1) C_noret;
static void f4209(C_word c,C_word t0,C_word t1) C_noret;
static void f4010(C_word c,C_word t0,C_word t1) C_noret;
static void f4013(C_word c,C_word t0,C_word t1) C_noret;
static void f4016(C_word c,C_word t0,C_word t1) C_noret;
static void f4029(C_word c,C_word t0,C_word t1) C_noret;
static void f4183(C_word c,C_word t0,C_word t1) C_noret;
static void f4187(C_word c,C_word t0,C_word t1) C_noret;
static void f4167(C_word c,C_word t0,C_word t1) C_noret;
static void f4148(C_word c,C_word t0,C_word t1) C_noret;
static void f4152(C_word c,C_word t0,C_word t1) C_noret;
static void f4076(C_word c,C_word t0,C_word t1) C_noret;
static void f4135(C_word c,C_word t0,C_word t1) C_noret;
static void f4139(C_word c,C_word t0,C_word t1) C_noret;
static void f4082(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f4091(C_word t0,C_word t1) C_c_regparm C_noret;
static void f4126(C_word c,C_word t0,C_word t1) C_noret;
static void f4113(C_word c,C_word t0,C_word t1) C_noret;
static void f4107(C_word c,C_word t0,C_word t1) C_noret;
static void f4080(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f4031(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f4045(C_word t0,C_word t1) C_c_regparm C_noret;
static void f4070(C_word c,C_word t0,C_word t1) C_noret;
static void f4061(C_word c,C_word t0,C_word t1) C_noret;
static void f4064(C_word c,C_word t0,C_word t1) C_noret;
static void f4041(C_word c,C_word t0,C_word t1) C_noret;
static void f4000(C_word c,C_word t0,C_word t1) C_noret;
static void f3988(C_word c,C_word t0,C_word t1) C_noret;
static void f3938(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3938r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3945(C_word c,C_word t0,C_word t1) C_noret;
static void f3960(C_word c,C_word t0,C_word t1) C_noret;
static void f3908(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3908r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3921(C_word c,C_word t0,C_word t1) C_noret;
static void f3901(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3898(C_word c,C_word t0,C_word t1) C_noret;
static void f3895(C_word c,C_word t0,C_word t1) C_noret;
static void f3816(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3816r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3847(C_word c,C_word t0,C_word t1) C_noret;
static void f3730(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3730r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3743(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3751(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f3765(C_word c,C_word t0,C_word t1) C_noret;
static void f3768(C_word c,C_word t0,C_word t1) C_noret;
static void f3685(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3685r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3692(C_word c,C_word t0,C_word t1) C_noret;
static void f3710(C_word c,C_word t0,C_word t1) C_noret;
static void f3714(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3581(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3581r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f3587(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3608(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f3679(C_word c,C_word t0,C_word t1) C_noret;
static void f3612(C_word c,C_word t0,C_word t1) C_noret;
static void f3619(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3621(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3638(C_word c,C_word t0,C_word t1) C_noret;
static void f3648(C_word c,C_word t0,C_word t1) C_noret;
static void f3652(C_word c,C_word t0,C_word t1) C_noret;
static void f3602(C_word c,C_word t0,C_word t1) C_noret;
static void f3566(C_word c,C_word t0,C_word t1) C_noret;
static void f3570(C_word c,C_word t0,C_word t1) C_noret;
static void f3576(C_word c,C_word t0,C_word t1) C_noret;
static void f3573(C_word c,C_word t0,C_word t1) C_noret;
static void f3541(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3545(C_word c,C_word t0,C_word t1) C_noret;
static void f3548(C_word c,C_word t0,C_word t1) C_noret;
static void f3522(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3526(C_word c,C_word t0,C_word t1) C_noret;
static void f3529(C_word c,C_word t0,C_word t1) C_noret;
static void f3463(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f3463r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f3467(C_word c,C_word t0,C_word t1) C_noret;
static void f3473(C_word c,C_word t0,C_word t1) C_noret;
static void f3456(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3437(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3437r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3441(C_word c,C_word t0,C_word t1) C_noret;
static void f3409(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3416(C_word c,C_word t0,C_word t1) C_noret;
static void f3419(C_word c,C_word t0,C_word t1) C_noret;
static void f3422(C_word c,C_word t0,C_word t1) C_noret;
static void f3397(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3401(C_word c,C_word t0,C_word t1) C_noret;
static void f3404(C_word c,C_word t0,C_word t1) C_noret;
static void f3388(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3379(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3370(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3332(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3332r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3348(C_word c,C_word t0,C_word t1) C_noret;
static void f3280(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f3280r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f3284(C_word c,C_word t0,C_word t1) C_noret;
static void f3290(C_word c,C_word t0,C_word t1) C_noret;
static void f3312(C_word c,C_word t0,C_word t1) C_noret;
static void f3305(C_word c,C_word t0,C_word t1) C_noret;
static void f3296(C_word c,C_word t0,C_word t1) C_noret;
static void f3206(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3212(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3216(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3224(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f3250(C_word c,C_word t0,C_word t1) C_noret;
static void f3254(C_word c,C_word t0,C_word t1) C_noret;
static void f3242(C_word c,C_word t0,C_word t1) C_noret;
static void f3196(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3204(C_word c,C_word t0,C_word t1) C_noret;
static void f3179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3190(C_word c,C_word t0,C_word t1) C_noret;
static void f3194(C_word c,C_word t0,C_word t1) C_noret;
static void f3154(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3161(C_word c,C_word t0,C_word t1) C_noret;
static void f3164(C_word c,C_word t0,C_word t1) C_noret;
static void f3112(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3112r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f3119(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3139(C_word c,C_word t0,C_word t1) C_noret;
static void f3131(C_word c,C_word t0,C_word t1) C_noret;
static void f3081(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3102(C_word c,C_word t0,C_word t1) C_noret;
static void f3059(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3059r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3063(C_word c,C_word t0,C_word t1) C_noret;
static void f3044(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3044r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3048(C_word c,C_word t0,C_word t1) C_noret;
static void f3029(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3029r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3033(C_word c,C_word t0,C_word t1) C_noret;
static void f2991(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3018(C_word c,C_word t0,C_word t1) C_noret;
static void f3011(C_word c,C_word t0,C_word t1) C_noret;
static void f3004(C_word c,C_word t0,C_word t1) C_noret;
static void f2961(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2961r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f2968(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2977(C_word c,C_word t0,C_word t1) C_noret;
static void f2971(C_word c,C_word t0,C_word t1) C_noret;
static void f2926(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2930(C_word c,C_word t0,C_word t1) C_noret;
static void f2959(C_word c,C_word t0,C_word t1) C_noret;
static void f2945(C_word c,C_word t0,C_word t1) C_noret;
static void f2939(C_word c,C_word t0,C_word t1) C_noret;
static void f2912(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2912r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2924(C_word c,C_word t0,C_word t1) C_noret;
static void f2898(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2898r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2910(C_word c,C_word t0,C_word t1) C_noret;
static void f2870(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2878(C_word c,C_word t0,C_word t1) C_noret;
static void f2890(C_word c,C_word t0,C_word t1) C_noret;
static void f2881(C_word c,C_word t0,C_word t1) C_noret;
static void f2837(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2861(C_word c,C_word t0,C_word t1) C_noret;
static void f2865(C_word c,C_word t0,C_word t1) C_noret;
static void f2853(C_word c,C_word t0,C_word t1) C_noret;
static void f2831(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2825(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2819(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2804(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2814(C_word c,C_word t0,C_word t1) C_noret;
static void f2801(C_word c,C_word t0,C_word t1) C_noret;
static void f2798(C_word c,C_word t0,C_word t1) C_noret;
static void f2795(C_word c,C_word t0,C_word t1) C_noret;
static void f2792(C_word c,C_word t0,C_word t1) C_noret;
static void f2763(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2790(C_word c,C_word t0,C_word t1) C_noret;
static void f2782(C_word c,C_word t0,C_word t1) C_noret;
static void f2737(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2761(C_word c,C_word t0,C_word t1) C_noret;
static void f2753(C_word c,C_word t0,C_word t1) C_noret;
static void f2661(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2713(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f2665(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2675(C_word c,C_word t0,C_word t1) C_noret;
static void f2679(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f2685(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f2689(C_word c,C_word t0,C_word t1) C_noret;
static void f2699(C_word c,C_word t0,C_word t1) C_noret;
static void f2683(C_word c,C_word t0,C_word t1) C_noret;
static void f2608(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2648(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f2612(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2622(C_word c,C_word t0,C_word t1) C_noret;
static void f2626(C_word c,C_word t0,C_word t1) C_noret;
static void f2630(C_word c,C_word t0,C_word t1) C_noret;
static void f2634(C_word c,C_word t0,C_word t1) C_noret;
static void f2638(C_word c,C_word t0,C_word t1) C_noret;
static void f2570(C_word c,C_word t0,C_word t1) C_noret;
static void f2603(C_word c,C_word t0,C_word t1) C_noret;
static void f2574(C_word c,C_word t0,C_word t1) C_noret;
static void f2581(C_word c,C_word t0,C_word t1) C_noret;
static void f2585(C_word c,C_word t0,C_word t1) C_noret;
static void f2589(C_word c,C_word t0,C_word t1) C_noret;
static void f2593(C_word c,C_word t0,C_word t1) C_noret;
static void f2597(C_word c,C_word t0,C_word t1) C_noret;
static void f2540(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2561(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2547(C_word c,C_word t0,C_word t1) C_noret;
static void f2556(C_word c,C_word t0,C_word t1) C_noret;
static void f2522(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2532(C_word c,C_word t0,C_word t1) C_noret;
static void f2509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2463(C_word c,C_word t0,C_word t1) C_noret;
static void f2476(C_word c,C_word t0,C_word t1) C_noret;
static void f2467(C_word c,C_word t0,C_word t1) C_noret;
static void f2443(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2443r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2447(C_word c,C_word t0,C_word t1) C_noret;
static void f2453(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2453r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2457(C_word c,C_word t0,C_word t1) C_noret;
static void f2423(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2423r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2427(C_word c,C_word t0,C_word t1) C_noret;
static void f2433(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2433r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2437(C_word c,C_word t0,C_word t1) C_noret;
static void f2399(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2399r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2403(C_word c,C_word t0,C_word t1) C_noret;
static void f2414(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2414r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2418(C_word c,C_word t0,C_word t1) C_noret;
static void f2408(C_word c,C_word t0,C_word t1) C_noret;
static void f2375(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2375r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2379(C_word c,C_word t0,C_word t1) C_noret;
static void f2390(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2390r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2394(C_word c,C_word t0,C_word t1) C_noret;
static void f2384(C_word c,C_word t0,C_word t1) C_noret;
static void f2356(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2360(C_word c,C_word t0,C_word t1) C_noret;
static void f2363(C_word c,C_word t0,C_word t1) C_noret;
static void f2320(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2320r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2351(C_word c,C_word t0,C_word t1) C_noret;
static void f2341(C_word c,C_word t0,C_word t1) C_noret;
static void f2334(C_word c,C_word t0,C_word t1) C_noret;
static void f2284(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2284r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2315(C_word c,C_word t0,C_word t1) C_noret;
static void f2305(C_word c,C_word t0,C_word t1) C_noret;
static void f2298(C_word c,C_word t0,C_word t1) C_noret;
static void f2266(C_word c,C_word t0,C_word t1) C_noret;
static void f2270(C_word c,C_word t0,C_word t1) C_noret;
static void f2273(C_word c,C_word t0,C_word t1) C_noret;
static void f2247(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2254(C_word c,C_word t0,C_word t1) C_noret;
static void f2194(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2201(C_word c,C_word t0,C_word t1) C_noret;
static void f2204(C_word c,C_word t0,C_word t1) C_noret;
static void f2207(C_word c,C_word t0,C_word t1) C_noret;
static void f2211(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f2228(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2238(C_word c,C_word t0,C_word t1) C_noret;
static void f2245(C_word c,C_word t0,C_word t1) C_noret;
static void f2220(C_word c,C_word t0,C_word t1) C_noret;
static void f2171(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2192(C_word c,C_word t0,C_word t1) C_noret;
static void f2184(C_word c,C_word t0,C_word t1) C_noret;
static void f2148(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2169(C_word c,C_word t0,C_word t1) C_noret;
static void f2161(C_word c,C_word t0,C_word t1) C_noret;
static void f2125(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2146(C_word c,C_word t0,C_word t1) C_noret;
static void f2138(C_word c,C_word t0,C_word t1) C_noret;
static void f2064(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2064r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2077(C_word c,C_word t0,C_word t1) C_noret;
static void f2092(C_word c,C_word t0,C_word t1) C_noret;
static void f2083(C_word c,C_word t0,C_word t1) C_noret;
static void f2086(C_word c,C_word t0,C_word t1) C_noret;
static void f2024(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2043(C_word c,C_word t0,C_word t1) C_noret;
static void f2028(C_word c,C_word t0,C_word t1) C_noret;
static void f2037(C_word c,C_word t0,C_word t1) C_noret;
static void f2031(C_word c,C_word t0,C_word t1) C_noret;
static void f2018(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2022(C_word c,C_word t0,C_word t1) C_noret;
static void f2012(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2016(C_word c,C_word t0,C_word t1) C_noret;
static void f2006(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2010(C_word c,C_word t0,C_word t1) C_noret;
static void f2000(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2004(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1966(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1995(C_word c,C_word t0,C_word t1) C_noret;
static void f1970(C_word c,C_word t0,C_word t1) C_noret;
static void f1979(C_word c,C_word t0,C_word t1) C_noret;
static void f1771(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1771r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1947(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1787(C_word c,C_word t0,C_word t1) C_noret;
static void f1921(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1793(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1796(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1881(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1879(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1838(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1856(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1854(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1842(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1805(C_word c,C_word t0,C_word t1) C_noret;
static void f1729(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1729r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1736(C_word c,C_word t0,C_word t1) C_noret;
static void f1751(C_word c,C_word t0,C_word t1) C_noret;
static void f1745(C_word c,C_word t0,C_word t1) C_noret;
static void f1684(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1684r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1694(C_word c,C_word t0,C_word t1) C_noret;
static void f1697(C_word c,C_word t0,C_word t1) C_noret;
static void f1709(C_word c,C_word t0,C_word t1) C_noret;
static void f1700(C_word c,C_word t0,C_word t1) C_noret;
static void f1666(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1679(C_word c,C_word t0,C_word t1) C_noret;
static void f1629(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1629r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1646(C_word c,C_word t0,C_word t1) C_noret;
static void f1655(C_word c,C_word t0,C_word t1) C_noret;
static void f1649(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1574(C_word t0) C_c_regparm C_noret;
static void f1580(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1589(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f1567(C_word t0) C_c_regparm;
static void C_fcall f1411(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9) C_c_regparm C_noret;
static void f1537(C_word c,C_word t0,C_word t1,...) C_noret;
static void f1545(C_word c,C_word t0,C_word t1,...) C_noret;
static void C_fcall f1418(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1525(C_word c,C_word t0,C_word t1) C_noret;
static void f1428(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1430(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1449(C_word c,C_word t0,C_word t1) C_noret;
static void f1511(C_word c,C_word t0,C_word t1) C_noret;
static void f1518(C_word c,C_word t0,C_word t1) C_noret;
static void f1505(C_word c,C_word t0,C_word t1) C_noret;
static void f1464(C_word c,C_word t0,C_word t1) C_noret;
static void f1495(C_word c,C_word t0,C_word t1) C_noret;
static void f1481(C_word c,C_word t0,C_word t1) C_noret;
static void f1493(C_word c,C_word t0,C_word t1) C_noret;
static void f1489(C_word c,C_word t0,C_word t1) C_noret;
static void f1476(C_word c,C_word t0,C_word t1) C_noret;
static void f1474(C_word c,C_word t0,C_word t1) C_noret;
static void f1529(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f1405(C_word t0,C_word t1) C_c_regparm C_noret;
static C_word C_fcall f1393(C_word t0) C_c_regparm;
static C_word C_fcall f1334(C_word t0,C_word t1,C_word t2) C_c_regparm;
static void C_fcall f1316(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_c_regparm C_noret;
static void C_fcall f1242(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1264(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1270(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1221(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1233(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1227(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f1210(C_word t0,C_word t1) C_c_regparm;
static C_word C_fcall f1188(C_word t0,C_word t1) C_c_regparm;
static void C_fcall f1168(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_c_regparm C_noret;
static C_word C_fcall f1161(C_word t0) C_c_regparm;
static void C_fcall f1136(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1140(C_word c,C_word t0,C_word t1) C_noret;
static void f1152(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1107(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1125(C_word c,C_word t0,C_word t1) C_noret;
static void f1117(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1082(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1086(C_word c,C_word t0,C_word t1) C_noret;
static void f1098(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1061(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1065(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1007(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1015(C_word c,C_word t0,C_word t1) C_noret;

static void C_fcall trf4091(void *dummy) C_regparm C_noret;
static void C_fcall trf4091(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f4091(t0,t1);}

static void C_fcall trf4031(void *dummy) C_regparm C_noret;
static void C_fcall trf4031(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f4031(t0,t1);}

static void C_fcall trf4045(void *dummy) C_regparm C_noret;
static void C_fcall trf4045(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f4045(t0,t1);}

static void C_fcall trf3751(void *dummy) C_regparm C_noret;
static void C_fcall trf3751(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f3751(t0,t1,t2,t3);}

static void C_fcall trf3587(void *dummy) C_regparm C_noret;
static void C_fcall trf3587(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3587(t0,t1,t2);}

static void C_fcall trf3621(void *dummy) C_regparm C_noret;
static void C_fcall trf3621(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3621(t0,t1,t2);}

static void C_fcall trf3212(void *dummy) C_regparm C_noret;
static void C_fcall trf3212(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3212(t0,t1,t2);}

static void C_fcall trf3224(void *dummy) C_regparm C_noret;
static void C_fcall trf3224(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f3224(t0,t1,t2);}

static void C_fcall trf3119(void *dummy) C_regparm C_noret;
static void C_fcall trf3119(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3119(t0,t1);}

static void C_fcall trf2968(void *dummy) C_regparm C_noret;
static void C_fcall trf2968(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2968(t0,t1);}

static void C_fcall trf2665(void *dummy) C_regparm C_noret;
static void C_fcall trf2665(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2665(t0,t1);}

static void C_fcall trf2685(void *dummy) C_regparm C_noret;
static void C_fcall trf2685(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f2685(t0,t1,t2);}

static void C_fcall trf2612(void *dummy) C_regparm C_noret;
static void C_fcall trf2612(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2612(t0,t1);}

static void C_fcall trf2228(void *dummy) C_regparm C_noret;
static void C_fcall trf2228(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2228(t0,t1);}

static void C_fcall trf1966(void *dummy) C_regparm C_noret;
static void C_fcall trf1966(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1966(t0,t1);}

static void C_fcall trf1796(void *dummy) C_regparm C_noret;
static void C_fcall trf1796(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1796(t0,t1);}

static void C_fcall trf1838(void *dummy) C_regparm C_noret;
static void C_fcall trf1838(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1838(t0,t1);}

static void C_fcall trf1842(void *dummy) C_regparm C_noret;
static void C_fcall trf1842(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1842(t0,t1);}

static void C_fcall trf1574(void *dummy) C_regparm C_noret;
static void C_fcall trf1574(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f1574(t0);}

static void C_fcall trf1411(void *dummy) C_regparm C_noret;
static void C_fcall trf1411(void *dummy){
C_word t9=C_pick(0);
C_word t8=C_pick(1);
C_word t7=C_pick(2);
C_word t6=C_pick(3);
C_word t5=C_pick(4);
C_word t4=C_pick(5);
C_word t3=C_pick(6);
C_word t2=C_pick(7);
C_word t1=C_pick(8);
C_word t0=C_pick(9);
C_adjust_stack(-10);
f1411(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

static void C_fcall trf1418(void *dummy) C_regparm C_noret;
static void C_fcall trf1418(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1418(t0,t1);}

static void C_fcall trf1430(void *dummy) C_regparm C_noret;
static void C_fcall trf1430(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1430(t0,t1,t2,t3);}

static void C_fcall trf1405(void *dummy) C_regparm C_noret;
static void C_fcall trf1405(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1405(t0,t1);}

static void C_fcall trf1316(void *dummy) C_regparm C_noret;
static void C_fcall trf1316(void *dummy){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
f1316(t0,t1,t2,t3,t4,t5,t6,t7,t8);}

static void C_fcall trf1242(void *dummy) C_regparm C_noret;
static void C_fcall trf1242(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1242(t0,t1,t2,t3);}

static void C_fcall trf1270(void *dummy) C_regparm C_noret;
static void C_fcall trf1270(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1270(t0,t1);}

static void C_fcall trf1221(void *dummy) C_regparm C_noret;
static void C_fcall trf1221(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1221(t0,t1,t2);}

static void C_fcall trf1168(void *dummy) C_regparm C_noret;
static void C_fcall trf1168(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f1168(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall trf1136(void *dummy) C_regparm C_noret;
static void C_fcall trf1136(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1136(t0,t1,t2,t3);}

static void C_fcall trf1107(void *dummy) C_regparm C_noret;
static void C_fcall trf1107(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1107(t0,t1,t2,t3);}

static void C_fcall trf1082(void *dummy) C_regparm C_noret;
static void C_fcall trf1082(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1082(t0,t1,t2,t3);}

static void C_fcall trf1061(void *dummy) C_regparm C_noret;
static void C_fcall trf1061(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1061(t0,t1,t2,t3);}

static void C_fcall trf1007(void *dummy) C_regparm C_noret;
static void C_fcall trf1007(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1007(t0,t1,t2);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(35);
if(!C_demand(35)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3938)){
C_save(t1);
C_rereclaim(-3938*sizeof(C_word));
t1=C_restore;}
a=C_alloc(35);
C_initialize_lf(lf,326);
lf[1]=C_h_intern(&lf[1],17,"\003sysmake-c-string");
lf[2]=C_h_intern(&lf[2],7,"\000append");
lf[3]=C_h_intern(&lf[3],9,"\003syserror");
lf[4]=C_string(C_heaptop,27,"invalid mode for input file");
lf[5]=C_string(C_heaptop,1,"a");
lf[6]=C_string(C_heaptop,21,"invalid mode argument");
lf[7]=C_string(C_heaptop,1,"r");
lf[8]=C_string(C_heaptop,1,"w");
lf[10]=C_h_intern(&lf[10],16,"\003sysupdate-errno");
lf[12]=C_h_intern(&lf[12],15,"\003syssignal-hook");
lf[13]=C_h_intern(&lf[13],11,"\000file-error");
lf[14]=C_string(C_heaptop,17,"can not open pipe");
lf[15]=C_h_intern(&lf[15],13,"\003sysmake-port");
lf[16]=C_h_intern(&lf[16],21,"\003sysstream-port-class");
lf[17]=C_string(C_heaptop,6,"(pipe)");
lf[18]=C_h_intern(&lf[18],6,"stream");
lf[21]=C_string(C_heaptop,17,"can not open file");
lf[22]=C_string(C_heaptop,8,"(fdport)");
lf[29]=C_h_intern(&lf[29],7,"process");
lf[30]=C_string(C_heaptop,25,"process exited abnormally");
lf[32]=C_h_intern(&lf[32],4,"lock");
lf[33]=C_h_intern(&lf[33],14,"\003syscheck-port");
lf[38]=C_h_intern(&lf[38],5,"\000text");
lf[40]=C_string(C_heaptop,35,"illegal input/output mode specifier");
lf[41]=C_h_intern(&lf[41],10,"find-files");
lf[42]=C_string(C_heaptop,1,".");
lf[43]=C_string(C_heaptop,2,"..");
lf[44]=C_string(C_heaptop,1,"*");
lf[45]=C_h_intern(&lf[45],16,"\003sysdynamic-wind");
lf[46]=C_h_intern(&lf[46],13,"pathname-file");
lf[47]=C_string(C_heaptop,1,"*");
lf[48]=C_string(C_heaptop,27,"too many optional arguments");
lf[51]=C_h_intern(&lf[51],18,"\003syscurrent-thread");
lf[52]=C_h_intern(&lf[52],12,"\003sysschedule");
lf[53]=C_h_intern(&lf[53],8,"pipe/buf");
lf[54]=C_h_intern(&lf[54],11,"open/rdonly");
lf[55]=C_h_intern(&lf[55],11,"open/wronly");
lf[56]=C_h_intern(&lf[56],9,"open/rdwr");
lf[57]=C_h_intern(&lf[57],9,"open/read");
lf[58]=C_h_intern(&lf[58],10,"open/write");
lf[59]=C_h_intern(&lf[59],10,"open/creat");
lf[60]=C_h_intern(&lf[60],11,"open/append");
lf[61]=C_h_intern(&lf[61],9,"open/excl");
lf[62]=C_h_intern(&lf[62],11,"open/noctty");
lf[63]=C_h_intern(&lf[63],13,"open/nonblock");
lf[64]=C_h_intern(&lf[64],10,"open/trunc");
lf[65]=C_h_intern(&lf[65],9,"open/sync");
lf[66]=C_h_intern(&lf[66],10,"open/fsync");
lf[67]=C_h_intern(&lf[67],11,"open/binary");
lf[68]=C_h_intern(&lf[68],9,"open/text");
lf[69]=C_h_intern(&lf[69],10,"perm/irusr");
lf[70]=C_h_intern(&lf[70],10,"perm/iwusr");
lf[71]=C_h_intern(&lf[71],10,"perm/ixusr");
lf[72]=C_h_intern(&lf[72],10,"perm/irgrp");
lf[73]=C_h_intern(&lf[73],10,"perm/iwgrp");
lf[74]=C_h_intern(&lf[74],10,"perm/ixgrp");
lf[75]=C_h_intern(&lf[75],10,"perm/iroth");
lf[76]=C_h_intern(&lf[76],10,"perm/iwoth");
lf[77]=C_h_intern(&lf[77],10,"perm/ixoth");
lf[78]=C_h_intern(&lf[78],10,"perm/irwxu");
lf[79]=C_h_intern(&lf[79],10,"perm/irwxg");
lf[80]=C_h_intern(&lf[80],10,"perm/irwxo");
lf[81]=C_h_intern(&lf[81],10,"perm/isvtx");
lf[82]=C_h_intern(&lf[82],10,"perm/isuid");
lf[83]=C_h_intern(&lf[83],10,"perm/isgid");
lf[84]=C_h_intern(&lf[84],9,"file-open");
lf[85]=C_string(C_heaptop,17,"can not open file");
lf[86]=C_h_intern(&lf[86],10,"file-close");
lf[87]=C_string(C_heaptop,18,"can not close file");
lf[88]=C_h_intern(&lf[88],11,"make-string");
lf[89]=C_h_intern(&lf[89],9,"file-read");
lf[90]=C_string(C_heaptop,22,"can not read from file");
lf[91]=C_h_intern(&lf[91],11,"\000type-error");
lf[92]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[93]=C_h_intern(&lf[93],10,"file-write");
lf[94]=C_string(C_heaptop,21,"can not write to file");
lf[95]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[96]=C_h_intern(&lf[96],11,"file-select");
lf[97]=C_string(C_heaptop,6,"failed");
lf[98]=C_h_intern(&lf[98],12,"\003sysfor-each");
lf[99]=C_h_intern(&lf[99],8,"seek/set");
lf[100]=C_h_intern(&lf[100],8,"seek/end");
lf[101]=C_h_intern(&lf[101],8,"seek/cur");
lf[103]=C_string(C_heaptop,19,"can not access file");
lf[104]=C_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[105]=C_h_intern(&lf[105],9,"file-size");
lf[106]=C_h_intern(&lf[106],22,"file-modification-time");
lf[107]=C_h_intern(&lf[107],10,"file-owner");
lf[108]=C_h_intern(&lf[108],16,"file-permissions");
lf[109]=C_h_intern(&lf[109],13,"file-position");
lf[110]=C_string(C_heaptop,38,"can not retrieve file position of port");
lf[111]=C_string(C_heaptop,12,"invalid file");
lf[112]=C_h_intern(&lf[112],5,"port\077");
lf[113]=C_h_intern(&lf[113],18,"set-file-position!");
lf[114]=C_string(C_heaptop,25,"can not set file position");
lf[115]=C_string(C_heaptop,12,"invalid file");
lf[116]=C_string(C_heaptop,30,"invalid negative port position");
lf[117]=C_h_intern(&lf[117],16,"create-directory");
lf[118]=C_string(C_heaptop,24,"can not create directory");
lf[119]=C_h_intern(&lf[119],16,"change-directory");
lf[120]=C_string(C_heaptop,32,"can not change current directory");
lf[121]=C_h_intern(&lf[121],16,"delete-directory");
lf[122]=C_string(C_heaptop,24,"can not delete directory");
lf[123]=C_h_intern(&lf[123],13,"string-append");
lf[124]=C_h_intern(&lf[124],6,"string");
lf[125]=C_h_intern(&lf[125],9,"substring");
lf[126]=C_h_intern(&lf[126],9,"directory");
lf[127]=C_string(C_heaptop,22,"can not open directory");
lf[128]=C_h_intern(&lf[128],16,"\003sysmake-pointer");
lf[129]=C_h_intern(&lf[129],10,"directory\077");
lf[130]=C_h_intern(&lf[130],13,"\003sysfile-info");
lf[131]=C_h_intern(&lf[131],17,"current-directory");
lf[132]=C_string(C_heaptop,34,"can not retrieve current directory");
lf[133]=C_h_intern(&lf[133],15,"open-input-pipe");
lf[134]=C_h_intern(&lf[134],7,"\000binary");
lf[135]=C_h_intern(&lf[135],16,"open-output-pipe");
lf[136]=C_h_intern(&lf[136],16,"close-input-pipe");
lf[137]=C_string(C_heaptop,24,"error while closing pipe");
lf[138]=C_h_intern(&lf[138],17,"close-output-pipe");
lf[139]=C_h_intern(&lf[139],20,"call-with-input-pipe");
lf[140]=C_h_intern(&lf[140],6,"values");
lf[141]=C_h_intern(&lf[141],21,"call-with-output-pipe");
lf[142]=C_h_intern(&lf[142],20,"with-input-from-pipe");
lf[143]=C_h_intern(&lf[143],18,"\003sysstandard-input");
lf[144]=C_h_intern(&lf[144],19,"with-output-to-pipe");
lf[145]=C_h_intern(&lf[145],19,"\003sysstandard-output");
lf[146]=C_h_intern(&lf[146],11,"create-pipe");
lf[147]=C_string(C_heaptop,19,"can not create pipe");
lf[148]=C_h_intern(&lf[148],11,"signal/term");
lf[149]=C_h_intern(&lf[149],11,"signal/kill");
lf[150]=C_h_intern(&lf[150],10,"signal/int");
lf[151]=C_h_intern(&lf[151],10,"signal/hup");
lf[152]=C_h_intern(&lf[152],10,"signal/fpe");
lf[153]=C_h_intern(&lf[153],10,"signal/ill");
lf[154]=C_h_intern(&lf[154],11,"signal/segv");
lf[155]=C_h_intern(&lf[155],11,"signal/abrt");
lf[156]=C_h_intern(&lf[156],11,"signal/trap");
lf[157]=C_h_intern(&lf[157],11,"signal/quit");
lf[158]=C_h_intern(&lf[158],11,"signal/alrm");
lf[159]=C_h_intern(&lf[159],13,"signal/vtalrm");
lf[160]=C_h_intern(&lf[160],11,"signal/prof");
lf[161]=C_h_intern(&lf[161],9,"signal/io");
lf[162]=C_h_intern(&lf[162],10,"signal/urg");
lf[163]=C_h_intern(&lf[163],11,"signal/chld");
lf[164]=C_h_intern(&lf[164],11,"signal/cont");
lf[165]=C_h_intern(&lf[165],11,"signal/stop");
lf[166]=C_h_intern(&lf[166],11,"signal/tstp");
lf[167]=C_h_intern(&lf[167],11,"signal/pipe");
lf[168]=C_h_intern(&lf[168],11,"signal/xcpu");
lf[169]=C_h_intern(&lf[169],11,"signal/xfsz");
lf[170]=C_h_intern(&lf[170],11,"signal/usr1");
lf[171]=C_h_intern(&lf[171],11,"signal/usr2");
lf[172]=C_h_intern(&lf[172],12,"signal/winch");
lf[173]=C_h_intern(&lf[173],18,"\003sysinterrupt-hook");
lf[174]=C_h_intern(&lf[174],19,"set-signal-handler!");
lf[175]=C_h_intern(&lf[175],18,"\003syscontext-switch");
lf[176]=C_h_intern(&lf[176],16,"set-signal-mask!");
lf[177]=C_string(C_heaptop,23,"can not set signal mask");
lf[178]=C_h_intern(&lf[178],18,"system-information");
lf[179]=C_h_intern(&lf[179],25,"\003syspeek-nonnull-c-string");
lf[180]=C_string(C_heaptop,35,"can not retrieve system information");
lf[181]=C_h_intern(&lf[181],16,"user-information");
lf[182]=C_h_intern(&lf[182],17,"\003syspeek-c-string");
lf[183]=C_h_intern(&lf[183],17,"group-information");
lf[184]=C_h_intern(&lf[184],10,"errno/perm");
lf[185]=C_h_intern(&lf[185],11,"errno/noent");
lf[186]=C_h_intern(&lf[186],10,"errno/srch");
lf[187]=C_h_intern(&lf[187],10,"errno/intr");
lf[188]=C_h_intern(&lf[188],8,"errno/io");
lf[189]=C_h_intern(&lf[189],12,"errno/noexec");
lf[190]=C_h_intern(&lf[190],10,"errno/badf");
lf[191]=C_h_intern(&lf[191],11,"errno/child");
lf[192]=C_h_intern(&lf[192],11,"errno/nomem");
lf[193]=C_h_intern(&lf[193],11,"errno/acces");
lf[194]=C_h_intern(&lf[194],11,"errno/fault");
lf[195]=C_h_intern(&lf[195],10,"errno/busy");
lf[196]=C_h_intern(&lf[196],12,"errno/notdir");
lf[197]=C_h_intern(&lf[197],11,"errno/isdir");
lf[198]=C_h_intern(&lf[198],11,"errno/inval");
lf[199]=C_h_intern(&lf[199],11,"errno/mfile");
lf[200]=C_h_intern(&lf[200],11,"errno/nospc");
lf[201]=C_h_intern(&lf[201],11,"errno/spipe");
lf[202]=C_h_intern(&lf[202],10,"errno/pipe");
lf[203]=C_h_intern(&lf[203],11,"errno/again");
lf[204]=C_h_intern(&lf[204],10,"errno/rofs");
lf[205]=C_h_intern(&lf[205],16,"errno/wouldblock");
lf[206]=C_h_intern(&lf[206],16,"change-file-mode");
lf[207]=C_string(C_heaptop,24,"can not change file mode");
lf[208]=C_h_intern(&lf[208],17,"change-file-owner");
lf[209]=C_string(C_heaptop,25,"can not change file owner");
lf[210]=C_h_intern(&lf[210],15,"current-user-id");
lf[211]=C_h_intern(&lf[211],16,"current-group-id");
lf[212]=C_h_intern(&lf[212],25,"current-effective-user-id");
lf[213]=C_h_intern(&lf[213],26,"current-effective-group-id");
lf[214]=C_h_intern(&lf[214],12,"set-user-id!");
lf[215]=C_string(C_heaptop,19,"can not set user id");
lf[216]=C_h_intern(&lf[216],17,"file-read-access\077");
lf[217]=C_h_intern(&lf[217],18,"file-write-access\077");
lf[218]=C_h_intern(&lf[218],20,"file-execute-access\077");
lf[219]=C_h_intern(&lf[219],20,"create-symbolic-link");
lf[220]=C_h_intern(&lf[220],18,"create-symbol-link");
lf[221]=C_string(C_heaptop,28,"can not create symbolic link");
lf[222]=C_h_intern(&lf[222],18,"read-symbolic-link");
lf[223]=C_string(C_heaptop,26,"can not read symbolic link");
lf[224]=C_h_intern(&lf[224],12,"fileno/stdin");
lf[225]=C_h_intern(&lf[225],13,"fileno/stdout");
lf[226]=C_h_intern(&lf[226],13,"fileno/stderr");
lf[227]=C_h_intern(&lf[227],16,"open-input-file*");
lf[228]=C_h_intern(&lf[228],17,"open-output-file*");
lf[229]=C_h_intern(&lf[229],12,"port->fileno");
lf[230]=C_string(C_heaptop,25,"port has no attached file");
lf[231]=C_string(C_heaptop,38,"can not access file-descriptor of port");
lf[232]=C_h_intern(&lf[232],25,"\003syspeek-unsigned-integer");
lf[233]=C_h_intern(&lf[233],16,"duplicate-fileno");
lf[234]=C_string(C_heaptop,33,"can not duplicate file descriptor");
lf[235]=C_h_intern(&lf[235],13,"file-truncate");
lf[236]=C_string(C_heaptop,21,"can not truncate file");
lf[237]=C_string(C_heaptop,12,"invalid file");
lf[238]=C_h_intern(&lf[238],9,"file-lock");
lf[239]=C_string(C_heaptop,17,"can not lock file");
lf[240]=C_h_intern(&lf[240],18,"file-lock/blocking");
lf[241]=C_string(C_heaptop,17,"can not lock file");
lf[242]=C_h_intern(&lf[242],14,"file-test-lock");
lf[243]=C_string(C_heaptop,19,"can not unlock file");
lf[244]=C_h_intern(&lf[244],11,"file-unlock");
lf[245]=C_string(C_heaptop,19,"can not unlock file");
lf[246]=C_h_intern(&lf[246],11,"create-fifo");
lf[247]=C_string(C_heaptop,19,"can not create FIFO");
lf[248]=C_h_intern(&lf[248],5,"fifo\077");
lf[249]=C_string(C_heaptop,19,"file does not exist");
lf[250]=C_h_intern(&lf[250],6,"setenv");
lf[251]=C_h_intern(&lf[251],8,"unsetenv");
lf[252]=C_h_intern(&lf[252],19,"current-environment");
lf[253]=C_h_intern(&lf[253],9,"prot/read");
lf[254]=C_h_intern(&lf[254],10,"prot/write");
lf[255]=C_h_intern(&lf[255],9,"prot/exec");
lf[256]=C_h_intern(&lf[256],9,"prot/none");
lf[257]=C_h_intern(&lf[257],9,"map/fixed");
lf[258]=C_h_intern(&lf[258],10,"map/shared");
lf[259]=C_h_intern(&lf[259],11,"map/private");
lf[260]=C_h_intern(&lf[260],13,"map/anonymous");
lf[261]=C_h_intern(&lf[261],8,"map/file");
lf[262]=C_h_intern(&lf[262],18,"map-file-to-memory");
lf[263]=C_h_intern(&lf[263],4,"mmap");
lf[264]=C_string(C_heaptop,26,"can not map file to memory");
lf[265]=C_h_intern(&lf[265],20,"\003syspointer->address");
lf[266]=C_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[267]=C_h_intern(&lf[267],16,"\003sysnull-pointer");
lf[268]=C_h_intern(&lf[268],22,"unmap-file-from-memory");
lf[269]=C_string(C_heaptop,30,"can not unmap file from memory");
lf[270]=C_h_intern(&lf[270],26,"memory-mapped-file-pointer");
lf[271]=C_h_intern(&lf[271],19,"seconds->local-time");
lf[272]=C_h_intern(&lf[272],18,"\003sysdecode-seconds");
lf[273]=C_h_intern(&lf[273],17,"seconds->utc-time");
lf[274]=C_h_intern(&lf[274],15,"seconds->string");
lf[275]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[276]=C_h_intern(&lf[276],12,"time->string");
lf[277]=C_string(C_heaptop,29,"can not time vector to string");
lf[278]=C_string(C_heaptop,21,"time vector too short");
lf[279]=C_h_intern(&lf[279],5,"_exit");
lf[280]=C_h_intern(&lf[280],23,"\003syscleanup-before-exit");
lf[281]=C_h_intern(&lf[281],10,"set-alarm!");
lf[282]=C_h_intern(&lf[282],19,"set-buffering-mode!");
lf[283]=C_string(C_heaptop,26,"can not set buffering mode");
lf[284]=C_h_intern(&lf[284],5,"\000full");
lf[285]=C_h_intern(&lf[285],5,"\000line");
lf[286]=C_h_intern(&lf[286],5,"\000none");
lf[287]=C_string(C_heaptop,22,"invalid buffering-mode");
lf[288]=C_h_intern(&lf[288],14,"terminal-port\077");
lf[289]=C_h_intern(&lf[289],13,"terminal-name");
lf[290]=C_string(C_heaptop,35,"port is not connected to a terminal");
lf[291]=C_h_intern(&lf[291],13,"get-host-name");
lf[292]=C_string(C_heaptop,26,"can not retrieve host-name");
lf[293]=C_h_intern(&lf[293],15,"pattern->regexp");
lf[294]=C_h_intern(&lf[294],13,"make-pathname");
lf[295]=C_h_intern(&lf[295],18,"decompose-pathname");
lf[296]=C_h_intern(&lf[296],4,"glob");
lf[297]=C_h_intern(&lf[297],12,"string-match");
lf[298]=C_string(C_heaptop,1,".");
lf[299]=C_string(C_heaptop,1,"*");
lf[300]=C_h_intern(&lf[300],12,"process-fork");
lf[301]=C_string(C_heaptop,28,"can not create child process");
lf[302]=C_h_intern(&lf[302],24,"pathname-strip-directory");
lf[303]=C_h_intern(&lf[303],15,"process-execute");
lf[304]=C_string(C_heaptop,23,"can not execute process");
lf[305]=C_h_intern(&lf[305],12,"process-wait");
lf[306]=C_string(C_heaptop,32,"waiting for child process failed");
lf[307]=C_h_intern(&lf[307],18,"current-process-id");
lf[308]=C_h_intern(&lf[308],17,"parent-process-id");
lf[309]=C_h_intern(&lf[309],5,"sleep");
lf[310]=C_h_intern(&lf[310],14,"process-signal");
lf[311]=C_string(C_heaptop,32,"could not send signal to process");
lf[312]=C_h_intern(&lf[312],6,"getenv");
lf[313]=C_h_intern(&lf[313],11,"process-run");
lf[314]=C_string(C_heaptop,7,"/bin/sh");
lf[315]=C_string(C_heaptop,2,"-c");
lf[316]=C_string(C_heaptop,5,"SHELL");
lf[317]=C_h_intern(&lf[317],15,"make-input-port");
lf[318]=C_h_intern(&lf[318],16,"make-output-port");
lf[319]=C_h_intern(&lf[319],25,"\003systhread-block-for-i/o!");
lf[320]=C_string(C_heaptop,22,"can not read from pipe");
lf[321]=C_string(C_heaptop,21,"can not write to pipe");
lf[322]=C_h_intern(&lf[322],23,"\003sysuser-interrupt-hook");
lf[323]=C_h_intern(&lf[323],11,"make-vector");
lf[324]=C_h_intern(&lf[324],17,"register-feature!");
lf[325]=C_h_intern(&lf[325],5,"posix");
C_register_lf(lf,326);
t2=C_mutate(&lf[0],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1007,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate(&lf[9],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1061,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate(&lf[11],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1082,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate(&lf[19],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1107,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate(&lf[20],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1136,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate(&lf[23],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1161,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate(&lf[24],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1168,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate(&lf[26],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1188,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate(&lf[27],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1210,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate(&lf[28],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1221,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate(&lf[31],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1242,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate(&lf[25],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1316,tmp=(C_word)a,a+=2,tmp));
t14=C_mutate(&lf[36],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1334,tmp=(C_word)a,a+=2,tmp));
t15=C_mutate(&lf[37],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1393,tmp=(C_word)a,a+=2,tmp));
t16=C_mutate(&lf[39],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1405,tmp=(C_word)a,a+=2,tmp));
t17=C_mutate(&lf[35],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1411,tmp=(C_word)a,a+=2,tmp));
t18=C_mutate(&lf[34],lf[48]);
t19=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1553,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t19);}

/* k1551 */
static void f1553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1553,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1556,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1554 in k1551 */
static void f1556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1556,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1559,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1557 in k1554 in k1551 */
static void f1559(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1559,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1562,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_script_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1560 in k1557 in k1554 in k1551 */
static void f1562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1562,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1565,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[324]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[325]);}

/* k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1565(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word ab[74],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1565,2,t0,t1);}
t2=C_mutate(&lf[49],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1567,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate(&lf[50],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1574,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[53]+1,C_fix((C_word)PIPE_BUF));
t5=C_mutate((C_word*)lf[54]+1,C_fix((C_word)O_RDONLY));
t6=C_mutate((C_word*)lf[55]+1,C_fix((C_word)O_WRONLY));
t7=C_mutate((C_word*)lf[56]+1,C_fix((C_word)O_RDWR));
t8=C_mutate((C_word*)lf[57]+1,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[58]+1,C_fix((C_word)O_WRONLY));
t10=C_mutate((C_word*)lf[59]+1,C_fix((C_word)O_CREAT));
t11=C_mutate((C_word*)lf[60]+1,C_fix((C_word)O_APPEND));
t12=C_mutate((C_word*)lf[61]+1,C_fix((C_word)O_EXCL));
t13=C_mutate((C_word*)lf[62]+1,C_fix((C_word)O_NOCTTY));
t14=C_mutate((C_word*)lf[63]+1,C_fix((C_word)O_NONBLOCK));
t15=C_mutate((C_word*)lf[64]+1,C_fix((C_word)O_TRUNC));
t16=C_mutate((C_word*)lf[65]+1,C_fix((C_word)O_FSYNC));
t17=C_mutate((C_word*)lf[66]+1,C_fix((C_word)O_FSYNC));
t18=C_mutate((C_word*)lf[67]+1,C_fix((C_word)O_BINARY));
t19=C_mutate((C_word*)lf[68]+1,C_fix((C_word)O_TEXT));
t20=C_mutate((C_word*)lf[69]+1,C_fix((C_word)S_IRUSR));
t21=C_mutate((C_word*)lf[70]+1,C_fix((C_word)S_IWUSR));
t22=C_mutate((C_word*)lf[71]+1,C_fix((C_word)S_IXUSR));
t23=C_mutate((C_word*)lf[72]+1,C_fix((C_word)S_IRGRP));
t24=C_mutate((C_word*)lf[73]+1,C_fix((C_word)S_IWGRP));
t25=C_mutate((C_word*)lf[74]+1,C_fix((C_word)S_IXGRP));
t26=C_mutate((C_word*)lf[75]+1,C_fix((C_word)S_IROTH));
t27=C_mutate((C_word*)lf[76]+1,C_fix((C_word)S_IWOTH));
t28=C_mutate((C_word*)lf[77]+1,C_fix((C_word)S_IXOTH));
t29=C_mutate((C_word*)lf[78]+1,C_fix((C_word)S_IRWXU));
t30=C_mutate((C_word*)lf[79]+1,C_fix((C_word)S_IRWXG));
t31=C_mutate((C_word*)lf[80]+1,C_fix((C_word)S_IRWXO));
t32=C_mutate((C_word*)lf[81]+1,C_fix((C_word)S_ISVTX));
t33=C_mutate((C_word*)lf[82]+1,C_fix((C_word)S_ISUID));
t34=C_mutate((C_word*)lf[83]+1,C_fix((C_word)S_ISGID));
t35=(C_word)C_fixnum_or(C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t36=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t35);
t37=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1629,a[2]=t36,tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[86]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1666,tmp=(C_word)a,a+=2,tmp));
t39=*((C_word*)lf[88]+1);
t40=C_mutate((C_word*)lf[89]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1684,a[2]=t39,tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[93]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1729,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[96]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1771,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[99]+1,C_fix((C_word)SEEK_SET));
t44=C_mutate((C_word*)lf[100]+1,C_fix((C_word)SEEK_END));
t45=C_mutate((C_word*)lf[101]+1,C_fix((C_word)SEEK_CUR));
t46=C_mutate(&lf[102],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1966,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[105]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2000,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[106]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2006,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2012,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[108]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2018,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[109]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2024,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2064,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2125,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2148,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[121]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2171,tmp=(C_word)a,a+=2,tmp));
t56=*((C_word*)lf[123]+1);
t57=*((C_word*)lf[88]+1);
t58=*((C_word*)lf[124]+1);
t59=*((C_word*)lf[125]+1);
t60=C_mutate((C_word*)lf[126]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2194,a[2]=t57,a[3]=t59,tmp=(C_word)a,a+=4,tmp));
t61=C_mutate((C_word*)lf[129]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2247,tmp=(C_word)a,a+=2,tmp));
t62=*((C_word*)lf[88]+1);
t63=*((C_word*)lf[125]+1);
t64=C_mutate((C_word*)lf[131]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2266,a[2]=t62,a[3]=t63,tmp=(C_word)a,a+=4,tmp));
t65=C_mutate((C_word*)lf[133]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2284,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[135]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2320,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[136]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2356,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[138]+1,*((C_word*)lf[136]+1));
t69=*((C_word*)lf[133]+1);
t70=*((C_word*)lf[135]+1);
t71=*((C_word*)lf[136]+1);
t72=*((C_word*)lf[138]+1);
t73=C_mutate((C_word*)lf[139]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2375,a[2]=t69,a[3]=t71,tmp=(C_word)a,a+=4,tmp));
t74=C_mutate((C_word*)lf[141]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2399,a[2]=t70,a[3]=t72,tmp=(C_word)a,a+=4,tmp));
t75=C_mutate((C_word*)lf[142]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2423,a[2]=t69,a[3]=t71,tmp=(C_word)a,a+=4,tmp));
t76=C_mutate((C_word*)lf[144]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2443,a[2]=t70,a[3]=t72,tmp=(C_word)a,a+=4,tmp));
t77=C_mutate((C_word*)lf[146]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2463,tmp=(C_word)a,a+=2,tmp));
t78=C_mutate((C_word*)lf[148]+1,C_fix((C_word)SIGTERM));
t79=C_mutate((C_word*)lf[149]+1,C_fix((C_word)SIGKILL));
t80=C_mutate((C_word*)lf[150]+1,C_fix((C_word)SIGINT));
t81=C_mutate((C_word*)lf[151]+1,C_fix((C_word)SIGHUP));
t82=C_mutate((C_word*)lf[152]+1,C_fix((C_word)SIGFPE));
t83=C_mutate((C_word*)lf[153]+1,C_fix((C_word)SIGILL));
t84=C_mutate((C_word*)lf[154]+1,C_fix((C_word)SIGSEGV));
t85=C_mutate((C_word*)lf[155]+1,C_fix((C_word)SIGABRT));
t86=C_mutate((C_word*)lf[156]+1,C_fix((C_word)SIGTRAP));
t87=C_mutate((C_word*)lf[157]+1,C_fix((C_word)SIGQUIT));
t88=C_mutate((C_word*)lf[158]+1,C_fix((C_word)SIGALRM));
t89=C_mutate((C_word*)lf[159]+1,C_fix((C_word)SIGVTALRM));
t90=C_mutate((C_word*)lf[160]+1,C_fix((C_word)SIGPROF));
t91=C_mutate((C_word*)lf[161]+1,C_fix((C_word)SIGIO));
t92=C_mutate((C_word*)lf[162]+1,C_fix((C_word)SIGURG));
t93=C_mutate((C_word*)lf[163]+1,C_fix((C_word)SIGCHLD));
t94=C_mutate((C_word*)lf[164]+1,C_fix((C_word)SIGCONT));
t95=C_mutate((C_word*)lf[165]+1,C_fix((C_word)SIGSTOP));
t96=C_mutate((C_word*)lf[166]+1,C_fix((C_word)SIGTSTP));
t97=C_mutate((C_word*)lf[167]+1,C_fix((C_word)SIGPIPE));
t98=C_mutate((C_word*)lf[168]+1,C_fix((C_word)SIGXCPU));
t99=C_mutate((C_word*)lf[169]+1,C_fix((C_word)SIGXFSZ));
t100=C_mutate((C_word*)lf[170]+1,C_fix((C_word)SIGUSR1));
t101=C_mutate((C_word*)lf[171]+1,C_fix((C_word)SIGUSR2));
t102=C_mutate((C_word*)lf[172]+1,C_fix((C_word)SIGWINCH));
t103=*((C_word*)lf[173]+1);
t104=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2507,a[2]=((C_word*)t0)[2],a[3]=t103,tmp=(C_word)a,a+=4,tmp);
t105=*((C_word*)lf[323]+1);
((C_proc4)C_retrieve_proc(t105))(4,t105,t104,C_fix(256),C_SCHEME_FALSE);}

/* k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2507,2,t0,t1);}
t2=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2509,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[173]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2522,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2540,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2568,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f4296,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[174]+1);
((C_proc4)C_retrieve_proc(t7))(4,t7,t5,*((C_word*)lf[150]+1),t6);}

/* a4295 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4296(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f4296,3,t0,t1,t2);}
t3=*((C_word*)lf[322]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

/* k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2568(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word ab[32],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2568,2,t0,t1);}
t2=C_mutate((C_word*)lf[178]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2570,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[181]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2608,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[183]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2661,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[184]+1,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[185]+1,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[186]+1,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[187]+1,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[188]+1,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[189]+1,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[190]+1,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[191]+1,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[192]+1,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[193]+1,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[194]+1,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[195]+1,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[196]+1,C_fix((C_word)ENOTDIR));
t18=C_mutate((C_word*)lf[197]+1,C_fix((C_word)EISDIR));
t19=C_mutate((C_word*)lf[198]+1,C_fix((C_word)EINVAL));
t20=C_mutate((C_word*)lf[199]+1,C_fix((C_word)EMFILE));
t21=C_mutate((C_word*)lf[200]+1,C_fix((C_word)ENOSPC));
t22=C_mutate((C_word*)lf[201]+1,C_fix((C_word)ESPIPE));
t23=C_mutate((C_word*)lf[202]+1,C_fix((C_word)EPIPE));
t24=C_mutate((C_word*)lf[203]+1,C_fix((C_word)EAGAIN));
t25=C_mutate((C_word*)lf[204]+1,C_fix((C_word)EROFS));
t26=C_mutate((C_word*)lf[205]+1,C_fix((C_word)EWOULDBLOCK));
t27=C_mutate((C_word*)lf[206]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2737,tmp=(C_word)a,a+=2,tmp));
t28=C_mutate((C_word*)lf[208]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2763,tmp=(C_word)a,a+=2,tmp));
t29=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2792,tmp=(C_word)a,a+=2,tmp));
t30=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2795,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2798,tmp=(C_word)a,a+=2,tmp));
t32=C_mutate((C_word*)lf[213]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2801,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2804,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2819,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2825,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2831,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2837,tmp=(C_word)a,a+=2,tmp));
t38=*((C_word*)lf[125]+1);
t39=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2869,a[2]=((C_word*)t0)[2],a[3]=t38,tmp=(C_word)a,a+=4,tmp);
t40=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
t41=*((C_word*)lf[88]+1);
((C_proc3)C_retrieve_proc(t41))(3,t41,t39,t40);}

/* k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word ab[102],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2869,2,t0,t1);}
t2=C_mutate((C_word*)lf[222]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2870,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[224]+1,C_fix((C_word)STDIN_FILENO));
t4=C_mutate((C_word*)lf[225]+1,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate((C_word*)lf[226]+1,C_fix((C_word)STDERR_FILENO));
t6=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2898,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[228]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2912,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[229]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2926,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2961,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[235]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2991,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[238]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3029,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[240]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3044,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3059,tmp=(C_word)a,a+=2,tmp));
t14=C_mutate((C_word*)lf[244]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3081,tmp=(C_word)a,a+=2,tmp));
t15=C_mutate((C_word*)lf[246]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3112,tmp=(C_word)a,a+=2,tmp));
t16=C_mutate((C_word*)lf[248]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3154,tmp=(C_word)a,a+=2,tmp));
t17=C_mutate((C_word*)lf[250]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3179,tmp=(C_word)a,a+=2,tmp));
t18=C_mutate((C_word*)lf[251]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3196,tmp=(C_word)a,a+=2,tmp));
t19=*((C_word*)lf[125]+1);
t20=C_mutate((C_word*)lf[252]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3206,a[2]=t19,tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[253]+1,C_fix((C_word)PROT_READ));
t22=C_mutate((C_word*)lf[254]+1,C_fix((C_word)PROT_WRITE));
t23=C_mutate((C_word*)lf[255]+1,C_fix((C_word)PROT_EXEC));
t24=C_mutate((C_word*)lf[256]+1,C_fix((C_word)PROT_NONE));
t25=C_mutate((C_word*)lf[257]+1,C_fix((C_word)MAP_FIXED));
t26=C_mutate((C_word*)lf[258]+1,C_fix((C_word)MAP_SHARED));
t27=C_mutate((C_word*)lf[259]+1,C_fix((C_word)MAP_PRIVATE));
t28=C_mutate((C_word*)lf[260]+1,C_fix((C_word)MAP_ANONYMOUS));
t29=C_mutate((C_word*)lf[261]+1,C_fix((C_word)MAP_FILE));
t30=C_mutate((C_word*)lf[262]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3280,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[268]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3332,tmp=(C_word)a,a+=2,tmp));
t32=C_mutate((C_word*)lf[270]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3370,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[271]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3379,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[273]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3388,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[274]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3397,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[276]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3409,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3437,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3456,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[282]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3463,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3522,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[289]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3541,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[291]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3566,tmp=(C_word)a,a+=2,tmp));
t43=*((C_word*)lf[293]+1);
t44=*((C_word*)lf[126]+1);
t45=*((C_word*)lf[294]+1);
t46=*((C_word*)lf[295]+1);
t47=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3581,a[2]=t43,a[3]=t44,a[4]=t45,a[5]=t46,tmp=(C_word)a,a+=6,tmp));
t48=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3685,tmp=(C_word)a,a+=2,tmp));
t49=*((C_word*)lf[302]+1);
t50=C_mutate((C_word*)lf[303]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3730,a[2]=t49,tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3816,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[307]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3895,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[308]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3898,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[309]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3901,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[310]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3908,tmp=(C_word)a,a+=2,tmp));
t56=*((C_word*)lf[300]+1);
t57=*((C_word*)lf[303]+1);
t58=*((C_word*)lf[312]+1);
t59=C_mutate((C_word*)lf[313]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3938,a[2]=t56,a[3]=t58,a[4]=t57,tmp=(C_word)a,a+=5,tmp));
t60=*((C_word*)lf[146]+1);
t61=*((C_word*)lf[300]+1);
t62=*((C_word*)lf[233]+1);
t63=*((C_word*)lf[86]+1);
t64=*((C_word*)lf[313]+1);
t65=*((C_word*)lf[88]+1);
t66=*((C_word*)lf[89]+1);
t67=*((C_word*)lf[317]+1);
t68=*((C_word*)lf[318]+1);
t69=*((C_word*)lf[93]+1);
t70=*((C_word*)lf[305]+1);
t71=C_mutate((C_word*)lf[29]+1,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f3982,a[2]=t61,a[3]=t62,a[4]=t64,a[5]=t65,a[6]=t67,a[7]=t68,a[8]=t63,a[9]=t70,a[10]=t60,tmp=(C_word)a,a+=11,tmp));
t72=*((C_word*)lf[296]+1);
t73=*((C_word*)lf[297]+1);
t74=*((C_word*)lf[294]+1);
t75=*((C_word*)lf[129]+1);
t76=C_mutate((C_word*)lf[41]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f4232,a[2]=t73,a[3]=t75,a[4]=t72,a[5]=t74,tmp=(C_word)a,a+=6,tmp));
t77=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t77+1)))(2,t77,t76);}

/* find-files in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4232(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+2)){
C_save_and_reclaim((void*)tr4r,(void*)f4232r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f4232r(t0,t1,t2,t3,t4);}}

static void f4232r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t1;
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1328,tmp=(C_word)a,a+=2,tmp);
f1168(t5,t6,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t7,((C_word*)t0)[2],t8);}
else{
t5=(C_word)C_i_car(t4);
t6=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t6))){
f1168(t1,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t3,((C_word*)t0)[2],t5);}
else{
t7=(C_word)C_i_car(t6);
t8=(C_word)C_i_cdr(t6);
if(C_truep((C_word)C_i_nullp(t8))){
f1316(t1,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t3,((C_word*)t0)[2],t5,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
f1411(t1,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t3,((C_word*)t0)[2],t5,t7,t9);}
else{
t11=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[34],t10);}}}}}

/* a1327 in find-files in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1328(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f1328,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3982(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[15],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3982,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3988,a[2]=((C_word*)t0)[10],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f3994,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
C_call_with_values(4,0,t1,t3,t4);}

/* a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3994(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f3994,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f4000,a[2]=((C_word*)t0)[11],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f4006,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=t3,tmp=(C_word)a,a+=13,tmp);
C_call_with_values(4,0,t1,t4,t5);}

/* a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4006(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[23],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f4006,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f4010,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f4196,a[2]=((C_word*)t0)[12],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[9],a[7]=t3,a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[4],tmp=(C_word)a,a+=10,tmp);
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t4,t5);}

/* a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4196,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f4200,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t1,a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4198 in a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4200(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4200,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f4203,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4201 in k4198 in a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4203(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4203,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f4206,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[224]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f4206(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4227,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[224]+1));}}

/* k4225 in k4201 in k4198 in a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4204 in k4201 in k4198 in a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4206,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4209,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[225]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f4209(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4218,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[225]+1));}}

/* k4216 in k4204 in k4201 in k4198 in a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4218(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4207 in k4204 in k4201 in k4198 in a4195 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4209(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4010,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f4013,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
t7=((C_word*)t0)[7];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[2]);}

/* k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4013,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f4016,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4016,2,t0,t1);}
t2=f1567(((C_word*)t0)[13]);
t3=f1567(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f4029,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

/* k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[41],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4029,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f4031,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f4076,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f4148,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4167,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f4183,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t11=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t11))(5,t11,t7,t8,t9,t10);}

/* a4182 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4183,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f4187,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4185 in a4182 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4187(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
f1221(((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4166 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4167,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)C_i_foreign_fixnum_argumentp(t3);
t5=(C_word)stub656(C_SCHEME_UNDEFINED,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_eqp(C_fix(1),t5));}}

/* a4147 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4148,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f4152,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[2];
f4031(t3,t2);}

/* k4150 in a4147 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fudge(C_fix(1)));}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4076,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4080,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4082,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f4135,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,t3,t4);}

/* a4134 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4135,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f4139,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4137 in a4134 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
f1221(((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4081 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4082(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f4082,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f4091,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f4091(t10,t1);}

/* loop in a4081 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f4091(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf4091,NULL,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4107,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
f1574(t5);}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4113,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f4126,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=*((C_word*)lf[125]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4124 in loop in a4081 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
t5=((C_word*)((C_word*)t0)[3])[1];
f4091(t5,((C_word*)t0)[2]);}

/* k4111 in loop in a4081 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[13],lf[321],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4105 in loop in a4081 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4107(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
f4091(t2,((C_word*)t0)[2]);}

/* k4078 in k4074 in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f4031(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf4031,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4041,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f4045,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f4045(t6,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f4045(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf4045,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4061,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[319]+1);
((C_proc5)C_retrieve_proc(t6))(5,t6,t5,*((C_word*)lf[51]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f4070,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4068 in loop in fetch in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[29],lf[320],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4059 in loop in fetch in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4061,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f4064,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
f1574(t2);}

/* k4062 in k4059 in loop in fetch in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4064(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
f4045(t2,((C_word*)t0)[2]);}

/* k4039 in fetch in k4027 in k4014 in k4011 in k4008 in a4005 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a3999 in a3993 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f4000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f4000,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a3987 in process in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3988,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* process-run in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3938(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f3938r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3938r(t0,t1,t2,t3);}}

static void f3938r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3945,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k3943 in process-run in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3945,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
t3=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3960,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[316]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k3958 in k3943 in process-run in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3960,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[314]);
t3=(C_word)C_a_i_list(&a,2,lf[315],((C_word*)t0)[4]);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3908(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f3908r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3908r(t0,t1,t2,t3);}}

static void f3908r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[310]);
t7=(C_word)C_i_check_exact_2(t5,lf[310]);
t8=(C_word)C_kill(t2,t5);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3921,a[2]=t5,a[3]=t2,a[4]=t1,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
t10=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}

/* k3919 in process-signal in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[4],lf[310],lf[311],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* sleep in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3901(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3901,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub623(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3898(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3898,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub620(C_SCHEME_UNDEFINED));}

/* current-process-id in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3895(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3895,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub618(C_SCHEME_UNDEFINED));}

/* process-wait in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3816(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f3816r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f3816r(t0,t1,t2);}}

static void f3816r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(6);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_i_check_exact_2(t11,lf[305]);
t14=(C_word)C_waitpid(t11,t12);
t15=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3847,a[2]=t15,a[3]=t11,a[4]=t1,a[5]=t14,tmp=(C_word)a,a+=6,tmp);
t17=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t17+1)))(2,t17,t16);}
else{
t11=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[34],t10);}}

/* k3845 in process-wait in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[4],lf[305],lf[306],((C_word*)t0)[3]);}
else{
t3=(C_truep(((C_word*)t0)[2])?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[2],t3);}}

/* process-execute in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3730(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f3730r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3730r(t0,t1,t2,t3);}}

static void f3730r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_string_2(t2,lf[303]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_END_OF_LIST);
t7=(C_word)C_i_check_list_2(t6,lf[303]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3743,a[2]=t6,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t9))(3,t9,t8,t2);}

/* k3741 in process-execute in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3743(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3743,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f1334(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3751,a[2]=t5,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f3751(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do586 in k3741 in process-execute in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f3751(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf3751,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f1334(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3765,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[3]);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[303]);
t6=(C_word)C_block_size(t4);
t7=f1334(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t13=t1;
t14=t8;
t15=t9;
t1=t13;
t2=t14;
t3=t15;
goto loop;}}

/* k3763 in do586 in k3741 in process-execute in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3765,2,t0,t1);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3768,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3766 in k3763 in do586 in k3741 in process-execute in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=(C_word)stub580(C_SCHEME_UNDEFINED);
t4=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],lf[303],lf[304],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* process-fork in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3685(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2rv,(void*)f3685r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f3685r(t0,t1,t2);}}

static void f3685r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t3=(C_word)stub557(C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3692,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

/* k3690 in process-fork in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3692,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],lf[300],lf[301]);}
else{
t3=(C_word)C_notvemptyp(((C_word*)t0)[2]);
t4=(C_truep(t3)?(C_word)C_eqp(((C_word*)t0)[4],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3710,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_i_vector_ref(((C_word*)t0)[2],C_fix(0));
t7=t6;
((C_proc2)C_retrieve_proc(t7))(2,t7,t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[4]);}}}

/* k3708 in k3690 in process-fork in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3710,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3714,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f3714 in k3708 in k3690 in process-fork in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3714(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3714,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub562(C_SCHEME_UNDEFINED,t3));}

/* glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3581(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f3581r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f3581r(t0,t1,t2);}}

static void f3581r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3587,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f3587(t6,t1,t2);}

/* conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f3587(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf3587,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3602,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3608,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
C_call_with_values(4,0,t1,t4,t5);}}

/* a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3608(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f3608,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3612,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3679,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[299]);
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3677 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3610 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3612,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3619,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[298]);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t2,t3);}

/* k3617 in k3610 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3619,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3621,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f3621(t5,((C_word*)t0)[2],t1);}

/* loop in k3617 in k3610 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f3621(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf3621,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
t4=((C_word*)((C_word*)t0)[6])[1];
f3587(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3638,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
t5=*((C_word*)lf[297]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3636 in loop in k3617 in k3610 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3638,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3648,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
t3=((C_word*)((C_word*)t0)[4])[1];
f3621(t3,((C_word*)t0)[6],t2);}}

/* k3646 in k3636 in loop in k3617 in k3610 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3648,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3652,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
t4=((C_word*)((C_word*)t0)[2])[1];
f3621(t4,t2,t3);}

/* k3650 in k3646 in k3636 in loop in k3617 in k3610 in a3607 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3652(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3652,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3601 in conc in glob in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3602(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3602,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3566,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3570,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t4=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub521(t3),C_fix(0));}

/* k3568 in get-host-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3570,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3573,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3573(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3576,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3574 in k3568 in get-host-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3576(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[291],lf[292]);}

/* k3571 in k3568 in get-host-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3573(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3541(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3541,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3545,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[33]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[289]);}

/* k3543 in terminal-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3545(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3545,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3548,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[2],C_fix(7));
t4=(C_word)C_eqp(lf[18],t3);
t5=(C_truep(t4)?(C_word)C_tty_portp(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;
f3548(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t2,lf[289],lf[290],((C_word*)t0)[2]);}}

/* k3546 in k3543 in terminal-name in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3548,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub513(t4,t5);
t7=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* terminal-port? in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3522(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3522,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3526,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[33]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[288]);}

/* k3524 in terminal-port? in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3526,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3529,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[232]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k3527 in k3524 in terminal-port? in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3463(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f3463r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f3463r(t0,t1,t2,t3,t4);}}

static void f3463r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3467,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[33]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[282]);}

/* k3465 in set-buffering-mode! in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3467,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3473,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[284]);
if(C_truep(t6)){
t7=t5;
f3473(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[285]);
if(C_truep(t7)){
t8=t5;
f3473(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[286]);
if(C_truep(t8)){
t9=t5;
f3473(2,t9,C_fix((C_word)_IONBF));}
else{
t9=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[282],lf[287],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k3471 in k3465 in set-buffering-mode! in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[282]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[18],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
t6=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[282],lf[283],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3456(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3456,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub496(C_SCHEME_UNDEFINED,t3));}

/* _exit in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3437(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f3437r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f3437r(t0,t1,t2);}}

static void f3437r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3441,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[280]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k3439 in _exit in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub490(C_SCHEME_UNDEFINED,t5));}

/* time->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3409(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3409,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[276]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3416,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
t6=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[276],lf[278],t2);}
else{
t6=t4;
f3416(2,t6,C_SCHEME_UNDEFINED);}}

/* k3414 in time->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3416(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3416,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3419,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub479(t4,t3),C_fix(0));}

/* k3417 in k3414 in time->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3419(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3419,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3422,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3422(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[276],lf[277],((C_word*)t0)[2]);}}

/* k3420 in k3417 in k3414 in time->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3397(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3397,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3401,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub470(t5,t6);
t8=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3399 in seconds->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3401,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3404,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3404(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[274],lf[275],((C_word*)t0)[2]);}}

/* k3402 in k3399 in seconds->string in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3388(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3388,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[273]);
t4=*((C_word*)lf[272]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3379(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3379,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[271]);
t4=*((C_word*)lf[272]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file-pointer in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3370(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3370,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[263],lf[270]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3332(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f3332r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3332r(t0,t1,t2,t3);}}

static void f3332r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_structure_2(t2,lf[263],lf[268]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub451(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3348,a[2]=t6,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t13=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,t12);}}

/* k3346 in unmap-file-from-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[268],lf[269],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* map-file-to-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3280(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc(c,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f3280r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f3280r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f3280r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3284,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f3284(2,t10,t2);}
else{
t10=*((C_word*)lf[267]+1);
((C_proc2)C_retrieve_proc(t10))(2,t10,t8);}}

/* k3282 in map-file-to-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3284(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3284,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3290,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f3290(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[91],lf[262],lf[266],t1);}}

/* k3288 in k3282 in map-file-to-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3290,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub425(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3296,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3312,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
t17=*((C_word*)lf[265]+1);
((C_proc3)C_retrieve_proc(t17))(3,t17,t16,t14);}

/* k3310 in k3288 in k3282 in map-file-to-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3312(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3312,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3305,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[8];
f3296(2,t3,C_SCHEME_UNDEFINED);}}

/* k3303 in k3310 in k3288 in k3282 in map-file-to-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc11)(void*)(*((C_word*)t2+1)))(11,t2,((C_word*)t0)[8],lf[13],lf[262],lf[264],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3294 in k3288 in k3282 in map-file-to-memory in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3296,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[263],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3206,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3212,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f3212(t5,t1,C_fix(0));}

/* loop in current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f3212(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf3212,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3216,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub407(t5,t6);
t8=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3214 in loop in current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3216(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3216,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3224,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f3224(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3214 in loop in current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f3224(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf3224,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3250,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3248 in scan in k3214 in loop in current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3250,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3254,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k3252 in k3248 in scan in k3214 in loop in current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3254(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3254,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3242,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[2])[1];
f3212(t5,t3,t4);}

/* k3240 in k3252 in k3248 in scan in k3214 in loop in current-environment in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3242,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3196(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3196,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[251]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3204,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3202 in unsetenv in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3179(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f3179,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[250]);
t5=(C_word)C_i_check_string_2(t3,lf[250]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3190,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3188 in setenv in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3190,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3194,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3192 in k3188 in setenv in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3154(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3154,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[248]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3161,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[130]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3159 in fifo? in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3161,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3164,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3162 in k3159 in fifo? in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[248],lf[249],((C_word*)t0)[2]);}}

/* create-fifo in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3112(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f3112r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3112r(t0,t1,t2,t3);}}

static void f3112r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[246]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3119,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f3119(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f3119(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k3117 in create-fifo in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f3119(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf3119,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[246]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3139,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3137 in k3117 in create-fifo in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3139,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3131,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3129 in k3137 in k3117 in create-fifo in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3131(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[246],lf[247],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-unlock in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3081(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f3081,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[32],lf[244]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3102,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t10=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* k3100 in file-unlock in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[244],lf[245],((C_word*)t0)[2]);}

/* file-test-lock in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3059(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f3059r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3059r(t0,t1,t2,t3);}}

static void f3059r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3063,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1242(t4,t2,t3,lf[242]);}

/* k3061 in file-test-lock in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[3]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
f1061(((C_word*)t0)[2],lf[243],t1,lf[242]);}}

/* file-lock/blocking in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3044(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f3044r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3044r(t0,t1,t2,t3);}}

static void f3044r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3048,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1242(t4,t2,t3,lf[240]);}

/* k3046 in file-lock/blocking in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3048(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[3]),C_fix(0)))){
f1061(((C_word*)t0)[2],lf[241],t1,lf[240]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3029(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f3029r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f3029r(t0,t1,t2,t3);}}

static void f3029r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3033,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1242(t4,t2,t3,lf[238]);}

/* k3031 in file-lock in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[3]),C_fix(0)))){
f1061(((C_word*)t0)[2],lf[239],t1,lf[238]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-truncate in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2991(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f2991,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[235]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3011,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3018,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f3011(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
t6=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[235],lf[237],t2);}}}

/* k3016 in file-truncate in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f3011(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k3009 in file-truncate in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3011(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f3011,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3004,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k3002 in k3009 in file-truncate in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f3004(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[235],lf[236],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* duplicate-fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2961(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f2961r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2961r(t0,t1,t2,t3);}}

static void f2961r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[233]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2968,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f2968(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[233]);
t8=t5;
f2968(t8,(C_word)C_dup2(t2,t6));}}

/* k2966 in duplicate-fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f2968(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf2968,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2971,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2977,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2971(2,t3,C_SCHEME_UNDEFINED);}}

/* k2975 in k2966 in duplicate-fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2977(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[233],lf[234],((C_word*)t0)[2]);}

/* k2969 in k2966 in duplicate-fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2971(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2926(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2926,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2930,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[33]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[229]);}

/* k2928 in port->fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2930(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2930,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2959,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[232]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k2957 in k2928 in port->fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2959(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2959,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[91],lf[229],lf[230],((C_word*)t0)[2]);}
else{
t2=(C_word)C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2939,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2945,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f2939(2,t4,C_SCHEME_UNDEFINED);}}}

/* k2943 in k2957 in k2928 in port->fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[229],lf[231],((C_word*)t0)[2]);}

/* k2937 in k2957 in k2928 in port->fileno in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2939(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2912(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f2912r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2912r(t0,t1,t2,t3);}}

static void f2912r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,lf[228]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2924,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1007(t5,C_SCHEME_FALSE,t3);}

/* k2922 in open-output-file* in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2924(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2924,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[3],t1);
f1136(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2898(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3r,(void*)f2898r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2898r(t0,t1,t2,t3);}}

static void f2898r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,lf[227]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2910,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1007(t5,C_SCHEME_TRUE,t3);}

/* k2908 in open-input-file* in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2910(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2910,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[3],t1);
f1136(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE,t2);}

/* read-symbolic-link in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2870(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2870,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[222]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2878,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2876 in read-symbolic-link in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2878(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2878,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2881,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2890,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f2881(2,t4,C_SCHEME_UNDEFINED);}}

/* k2888 in k2876 in read-symbolic-link in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[222],lf[223],((C_word*)t0)[2]);}

/* k2879 in k2876 in read-symbolic-link in k2867 in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2837(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f2837,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[219]);
t5=(C_word)C_i_check_string_2(t3,lf[219]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2861,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k2859 in create-symbolic-link in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2861,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2865,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2863 in k2859 in create-symbolic-link in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2865(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2865,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2853,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2851 in k2863 in k2859 in create-symbolic-link in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2853(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[220],lf[221],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-execute-access? in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2831(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2831,3,t0,t1,t2);}
f1107(t1,t2,C_fix((C_word)X_OK),lf[218]);}

/* file-write-access? in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2825(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2825,3,t0,t1,t2);}
f1107(t1,t2,C_fix((C_word)W_OK),lf[217]);}

/* file-read-access? in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2819(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2819,3,t0,t1,t2);}
f1107(t1,t2,C_fix((C_word)R_OK),lf[216]);}

/* set-user-id! in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2804(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2804,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2814,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2812 in set-user-id! in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2814(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[3]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[214],lf[215],((C_word*)t0)[2]);}

/* current-effective-group-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2801,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub276(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2798(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2798,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub274(C_SCHEME_UNDEFINED));}

/* current-group-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2795,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub272(C_SCHEME_UNDEFINED));}

/* current-user-id in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2792,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub270(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2763(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f2763,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[208]);
t6=(C_word)C_i_check_exact_2(t3,lf[208]);
t7=(C_word)C_i_check_exact_2(t4,lf[208]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2790,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k2788 in change-file-owner in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2790(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2790,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2782,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2780 in k2788 in change-file-owner in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[13],lf[208],lf[209],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* change-file-mode in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2737(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f2737,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[206]);
t5=(C_word)C_i_check_exact_2(t3,lf[206]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2761,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k2759 in change-file-mode in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2761(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2761,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2753,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2751 in k2759 in change-file-mode in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2753(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[206],lf[207],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2661(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2661,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2665,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f2665(t4,(C_word)C_getgrgid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[183]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2713,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2711 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f2665(t2,(C_word)C_getgrnam(t1));}

/* k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f2665(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf2665,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2675,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2673 in k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2675,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2679,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2677 in k2673 in k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2679,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2683,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2685,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f2685(t6,t2,C_fix(0));}

/* rec in k2677 in k2673 in k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f2685(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf2685,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2689,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub247(t5,t6);
t8=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2687 in rec in k2677 in k2673 in k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2689,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2699,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=((C_word*)((C_word*)t0)[2])[1];
f2685(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2697 in k2687 in rec in k2677 in k2673 in k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2699,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2681 in k2677 in k2673 in k2663 in group-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(6,0,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2608(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2608,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2612,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f2612(t4,(C_word)C_getpwuid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[181]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2648,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2646 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f2612(t2,(C_word)C_getpwnam(t1));}

/* k2610 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f2612(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf2612,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2622,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2620 in k2610 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2622(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2622,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2626,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2624 in k2620 in k2610 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2626,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2630,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2628 in k2624 in k2620 in k2610 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2630,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2634,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2632 in k2628 in k2624 in k2620 in k2610 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2634,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2638,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2636 in k2632 in k2628 in k2624 in k2620 in k2610 in user-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(9,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2570,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2574,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2603,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2574(2,t3,C_SCHEME_UNDEFINED);}}

/* k2601 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[178],lf[180]);}

/* k2572 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2574,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2581,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2579 in k2572 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2581,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2585,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2583 in k2579 in k2572 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2585,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2589,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2587 in k2583 in k2579 in k2572 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2589,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2593,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2591 in k2587 in k2583 in k2579 in k2572 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2593(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2593,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2597,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2595 in k2591 in k2587 in k2583 in k2579 in k2572 in system-information in k2566 in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(7,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* set-signal-mask! in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2540(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2540,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[176]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2547,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2561,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a2560 in set-signal-mask! in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2561(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2561,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[176]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k2545 in set-signal-mask! in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2547,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2556,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2554 in k2545 in set-signal-mask! in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[176],lf[177]);}

/* ##sys#interrupt-hook in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2522(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f2522,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2532,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k2530 in ##sys#interrupt-hook in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2532(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[175]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2505 in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f2509,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[174]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2463,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2467,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2476,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2467(2,t3,C_SCHEME_UNDEFINED);}}

/* k2474 in create-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[13],lf[146],lf[147]);}

/* k2465 in create-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2467(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2443(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f2443r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2443r(t0,t1,t2,t3,t4);}}

static void f2443r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[145]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2447,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2445 in with-output-to-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2447(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2447,2,t0,t1);}
t2=C_mutate((C_word*)lf[145]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2453,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2452 in k2445 in with-output-to-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2453(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f2453r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2453r(t0,t1,t2);}}

static void f2453r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2457,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2455 in a2452 in k2445 in with-output-to-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[145]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* with-input-from-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2423(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f2423r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2423r(t0,t1,t2,t3,t4);}}

static void f2423r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[143]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2427,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2425 in with-input-from-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2427(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2427,2,t0,t1);}
t2=C_mutate((C_word*)lf[143]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2433,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2432 in k2425 in with-input-from-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2433(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f2433r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2433r(t0,t1,t2);}}

static void f2433r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2437,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2435 in a2432 in k2425 in with-input-from-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2437(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[143]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* call-with-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2399(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f2399r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2399r(t0,t1,t2,t3,t4);}}

static void f2399r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2403,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2401 in call-with-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2403,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2408,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2414,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2413 in k2401 in call-with-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2414(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f2414r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2414r(t0,t1,t2);}}

static void f2414r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2418,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2416 in a2413 in k2401 in call-with-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2418(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* a2407 in k2401 in call-with-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2408(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2408,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2375(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f2375r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2375r(t0,t1,t2,t3,t4);}}

static void f2375r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2379,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2377 in call-with-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2379(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2379,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2384,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2390,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2389 in k2377 in call-with-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2390(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f2390r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2390r(t0,t1,t2);}}

static void f2390r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2394,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2392 in a2389 in k2377 in call-with-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* a2383 in k2377 in call-with-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2384,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2356(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2356,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2360,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[33]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[136]);}

/* k2358 in close-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2360,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2363,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2361 in k2358 in close-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[13],lf[136],lf[137],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2320(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f2320r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2320r(t0,t1,t2,t3);}}

static void f2320r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(C_word)C_i_check_string_2(t2,lf[135]);
t5=f1393(t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2334,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(t5,lf[38]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2341,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[134]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2351,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
f1405(t6,t5);}}}

/* k2349 in open-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2351,2,t0,t1);}
t2=((C_word*)t0)[2];
f2334(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2339 in open-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2341,2,t0,t1);}
t2=((C_word*)t0)[2];
f2334(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2332 in open-output-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f1082(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2284(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f2284r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2284r(t0,t1,t2,t3);}}

static void f2284r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(C_word)C_i_check_string_2(t2,lf[133]);
t5=f1393(t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2298,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(t5,lf[38]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2305,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[134]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2315,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
f1405(t6,t5);}}}

/* k2313 in open-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2315(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2315,2,t0,t1);}
t2=((C_word*)t0)[2];
f2298(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2303 in open-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2305,2,t0,t1);}
t2=((C_word*)t0)[2];
f2298(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2296 in open-input-pipe in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f1082(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* current-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2266,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2270,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}

/* k2268 in current-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2270,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2273,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2271 in k2268 in current-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[5]);}
else{
t2=*((C_word*)lf[12]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[13],lf[131],lf[132]);}}

/* directory? in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2247(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2247,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[129]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2254,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[130]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2252 in directory? in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2254(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2194(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2194,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[126]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2201,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

/* k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2201(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2201,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2204,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[128]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2204(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2204,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2207,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[128]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k2205 in k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2207,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2211,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[4]);}

/* k2209 in k2205 in k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2211,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2220,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2228,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f2228(t6,((C_word*)t0)[6]);}}

/* loop in k2209 in k2205 in k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f2228(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf2228,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2238,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k2236 in loop in k2209 in k2205 in k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2238(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2238,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2245,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)((C_word*)t0)[2])[1];
f2228(t3,t2);}

/* k2243 in k2236 in loop in k2209 in k2205 in k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2245(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2245,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2218 in k2209 in k2205 in k2202 in k2199 in directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[126],lf[127],((C_word*)t0)[2]);}

/* delete-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2171(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2171,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[121]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2192,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2190 in delete-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2192,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2184,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2182 in k2190 in delete-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[121],lf[122],((C_word*)t0)[2]);}

/* change-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2148(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2148,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[119]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2169,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2167 in change-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2169(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2169,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2161,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2159 in k2167 in change-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[119],lf[120],((C_word*)t0)[2]);}

/* create-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2125(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2125,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[117]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2146,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2144 in create-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2146,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2138,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2136 in k2144 in create-directory in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2138(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[117],lf[118],((C_word*)t0)[2]);}

/* set-file-position! in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2064(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f2064r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f2064r(t0,t1,t2,t3,t4);}}

static void f2064r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[113]);
t8=(C_word)C_i_check_exact_2(t6,lf[113]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2077,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t10=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t10+1)))(6,t10,t9,lf[113],lf[116],t3,t2);}
else{
t10=t9;
f2077(2,t10,C_SCHEME_UNDEFINED);}}

/* k2075 in set-file-position! in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2077,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2083,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2092,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[112]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k2090 in k2075 in set-file-position! in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[18]);
t4=((C_word*)t0)[4];
f2083(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f2083(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[91],lf[113],lf[115],((C_word*)t0)[5]);}}}

/* k2081 in k2075 in set-file-position! in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2083,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2086,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k2084 in k2081 in k2075 in set-file-position! in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[113],lf[114],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2024(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2024,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2028,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2043,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[112]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k2041 in file-position in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2043(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[18]);
t4=((C_word*)t0)[2];
f2028(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f2028(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[91],lf[109],lf[111],((C_word*)t0)[3]);}}}

/* k2026 in file-position in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f2028,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2031,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2037,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2031(2,t3,C_SCHEME_UNDEFINED);}}

/* k2035 in k2026 in file-position in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[109],lf[110],((C_word*)t0)[2]);}

/* k2029 in k2026 in file-position in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-permissions in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2018(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2018,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2022,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1966(t3,t2);}

/* k2020 in file-permissions in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2022(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_mode));}

/* file-owner in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2012(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2012,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2016,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1966(t3,t2);}

/* k2014 in file-owner in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2016(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_uid));}

/* file-modification-time in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2006(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2006,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2010,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1966(t3,t2);}

/* k2008 in file-modification-time in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_mtime));}

/* file-size in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2000(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f2000,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2004,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1966(t3,t2);}

/* k2002 in file-size in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f2004(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_size));}

/* ##sys#stat in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f1966(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1966,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1970,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f1970(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1995,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
t4=*((C_word*)lf[12]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[91],lf[104],t2);}}}

/* k1993 in ##sys#stat in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1995(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f1970(2,t2,(C_word)C_stat(t1));}

/* k1968 in ##sys#stat in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1970,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1979,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k1977 in k1968 in ##sys#stat in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1979(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[13],lf[103],((C_word*)t0)[2]);}

/* file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1771(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr4rv,(void*)f1771r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1771r(t0,t1,t2,t3,t4);}}

static void f1771r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(12);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f1161(C_fix(0));
t10=f1161(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1787,a[2]=t6,a[3]=t8,a[4]=t2,a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t11)){
t13=t12;
f1787(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
t14=t12;
f1787(2,t14,f1188(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[96]);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1947,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t15=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a1946 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1947(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1947,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[96]);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t2));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f1188(C_fix(0),t2));}

/* k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1787,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[6]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1793,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(t2)){
t4=t3;
f1793(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[6]);
t5=t3;
f1793(2,t5,f1188(C_fix(1),((C_word*)t0)[6]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[6],lf[96]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1921,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[6]);}}}

/* a1920 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1921(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1921,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[96]);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t2));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f1188(C_fix(1),t2));}

/* k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1793,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1796,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[96]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f1796(t5,(C_word)C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f1796(t4,(C_word)C_select(t3));}}

/* k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f1796(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1796,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1805,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[3]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[2]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
C_values(4,0,((C_word*)t0)[4],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1838,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t4=t3;
f1838(t4,f1210(C_fix(0),((C_word*)t0)[3]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1879,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1881,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[3]);}}
else{
t4=t3;
f1838(t4,C_SCHEME_FALSE);}}}}

/* a1880 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1881(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1881,3,t0,t1,t2);}
t3=f1210(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1877 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f1838(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1836 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f1838(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1838,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1842,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f1842(t3,f1210(C_fix(1),((C_word*)t0)[2]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1854,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1856,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t7=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[2]);}}
else{
t3=t2;
f1842(t3,C_SCHEME_FALSE);}}

/* a1855 in k1836 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1856(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1856,3,t0,t1,t2);}
t3=f1210(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1852 in k1836 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1854(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f1842(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1840 in k1836 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f1842(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k1803 in k1794 in k1791 in k1785 in file-select in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1805(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[96],lf[97],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-write in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1729(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f1729r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1729r(t0,t1,t2,t3,t4);}}

static void f1729r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[93]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1736,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f1736(2,t8,C_SCHEME_UNDEFINED);}
else{
t8=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[91],lf[93],lf[95],t3);}}

/* k1734 in file-write in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1736,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[93]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1745,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1751,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f1745(2,t8,C_SCHEME_UNDEFINED);}}

/* k1749 in k1734 in file-write in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[93],lf[94],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1743 in k1734 in file-write in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1684(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f1684r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1684r(t0,t1,t2,t3,t4);}}

static void f1684r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[89]);
t6=(C_word)C_i_check_exact_2(t3,lf[89]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1694,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f1694(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1692 in file-read in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1694,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1697,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f1697(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[91],lf[89],lf[92],t1);}}

/* k1695 in k1692 in file-read in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1697,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1700,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1709,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f1700(2,t5,C_SCHEME_UNDEFINED);}}

/* k1707 in k1695 in k1692 in file-read in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[13],lf[89],lf[90],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1698 in k1695 in k1692 in file-read in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1700,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1666(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1666,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[86]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1679,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1677 in file-close in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1679(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[13],lf[86],lf[87],((C_word*)t0)[2]);}

/* file-open in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1629(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f1629r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1629r(t0,t1,t2,t3,t4);}}

static void f1629r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[84]);
t8=(C_word)C_i_check_exact_2(t3,lf[84]);
t9=(C_word)C_i_check_exact_2(t6,lf[84]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1646,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t11+1)))(3,t11,t10,t2);}

/* k1644 in file-open in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1646,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1649,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1655,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f1649(2,t5,C_SCHEME_UNDEFINED);}}

/* k1653 in k1644 in file-open in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[13],lf[84],lf[85],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1647 in k1644 in file-open in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1649(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1563 in k1560 in k1557 in k1554 in k1551 */
static void C_fcall f1574(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1574,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1580,tmp=(C_word)a,a+=2,tmp);
C_call_cc(3,0,t1,t2);}

/* a1579 in yield in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1580(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1580,3,t0,t1,t2);}
t3=*((C_word*)lf[51]+1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1589,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
t6=*((C_word*)lf[52]+1);
((C_proc2)C_retrieve_proc(t6))(2,t6,t1);}

/* a1588 in a1579 in yield in k1563 in k1560 in k1557 in k1554 in k1551 */
static void f1589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1589,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* make-nonblocking in k1563 in k1560 in k1557 in k1554 in k1551 */
static C_word C_fcall f1567(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub1(C_SCHEME_UNDEFINED,t2));}

/* body731 */
static void C_fcall f1411(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9,C_word t10){
C_word tmp;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1411,NULL,10,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10);}
t11=(C_word)C_i_check_string_2(t2,lf[41]);
t12=C_fix(0);
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f1418,a[2]=t2,a[3]=t9,a[4]=t1,a[5]=t5,a[6]=t8,a[7]=t3,a[8]=t4,a[9]=t13,a[10]=t7,a[11]=t6,tmp=(C_word)a,a+=12,tmp);
t15=t10;
if(C_truep(t15)){
t16=(C_word)C_fixnump(t10);
t17=t14;
f1418(t17,(C_truep(t16)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1545,a[2]=t10,a[3]=t13,tmp=(C_word)a,a+=4,tmp):t10));}
else{
t16=t14;
f1418(t16,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1537,tmp=(C_word)a,a+=2,tmp));}}

/* f1537 in body731 */
static void f1537(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1537,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f1545 in body731 */
static void f1545(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1545,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k1416 in body731 */
static void C_fcall f1418(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1418,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1529,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f1428,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1525,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[47]);}

/* k1523 in k1416 in body731 */
static void f1525(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k1426 in k1416 in body731 */
static void f1428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1428,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f1430,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f1430(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k1426 in k1416 in body731 */
static void C_fcall f1430(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1430,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f1449,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k1447 in loop in k1426 in k1416 in body731 */
static void f1449(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1449,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f1505,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=*((C_word*)lf[46]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1511,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k1509 in k1447 in loop in k1426 in k1416 in body731 */
static void f1511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1511,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1518,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)((C_word*)t0)[7])[1];
f1430(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k1516 in k1509 in k1447 in loop in k1426 in k1416 in body731 */
static void f1518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
f1430(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1505,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[42]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[43]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
t2=((C_word*)((C_word*)t0)[10])[1];
f1430(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f1464,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1464(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1464,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1474,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1476,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1481,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1495,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t11=*((C_word*)lf[45]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=((C_word*)((C_word*)t0)[8])[1];
f1430(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a1494 in k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1495(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1495,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a1480 in k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1481(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1481,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1489,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1493,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[44]);}

/* k1491 in a1480 in k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1493(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k1487 in a1480 in k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1489(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
f1430(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a1475 in k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1476,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1472 in k1462 in k1503 in k1447 in loop in k1426 in k1416 in body731 */
static void f1474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
f1430(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f1529 in k1416 in body731 */
static void f1529(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f1529,3,t0,t1,t2);}
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* badmode */
static void C_fcall f1405(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1405,NULL,2,t1,t2);}
t3=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[40],t2);}

/* mode */
static C_word C_fcall f1393(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[38]));}

/* setarg */
static C_word C_fcall f1334(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub573(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* def-limit735 */
static void C_fcall f1316(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1316,NULL,9,t1,t2,t3,t4,t5,t6,t7,t8,t9);}
f1411(t1,t2,t3,t4,t5,t6,t7,t8,t9,C_SCHEME_FALSE);}

/* setup */
static void C_fcall f1242(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1242,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1264,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
t16=*((C_word*)lf[33]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
t15=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[34],t14);}}

/* k1262 in setup */
static void f1264(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1264,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1270,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f1270(t6,t5);}
else{
t5=t3;
f1270(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k1268 in k1262 in setup */
static void C_fcall f1270(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1270,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[32],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* wait */
static void C_fcall f1221(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1221,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1227,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1233,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
C_call_with_values(4,0,t1,t4,t5);}

/* a1232 in wait */
static void f1233(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f1233,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[3]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[29],lf[30],((C_word*)t0)[2],t4);}}

/* a1226 in wait */
static void f1227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1227,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* fd_test */
static C_word C_fcall f1210(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub57(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set */
static C_word C_fcall f1188(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub51(C_SCHEME_UNDEFINED,t3,t4));}

/* def-id734 */
static void C_fcall f1168(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1168,NULL,8,t1,t2,t3,t4,t5,t6,t7,t8);}
f1316(t1,t2,t3,t4,t5,t6,t7,t8,C_SCHEME_END_OF_LIST);}

/* fd_zero */
static C_word C_fcall f1161(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub46(C_SCHEME_UNDEFINED,t2));}

/* check */
static void C_fcall f1136(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1136,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1140,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1138 in check */
static void f1140(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1140,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[12]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[13],lf[21],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1152,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[15]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[16]+1),lf[22],lf[18]);}}

/* k1150 in k1138 in check */
static void f1152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* check */
static void C_fcall f1107(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1107,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1125,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k1123 in check */
static void f1125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1125,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1117,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f1117(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k1115 in k1123 in check */
static void f1117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* check */
static void C_fcall f1082(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1082,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1086,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1084 in check */
static void f1086(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f1086,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[12]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[13],lf[14],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1098,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[15]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[16]+1),lf[17],lf[18]);}}

/* k1096 in k1084 in check */
static void f1098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* err */
static void C_fcall f1061(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1061,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1065,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[10]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1063 in err */
static void f1065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(2));
t4=(C_word)C_slot(((C_word*)t0)[5],C_fix(3));
t5=*((C_word*)lf[3]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t2,t3,t4);}

/* mode */
static void C_fcall f1007(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf1007,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1015,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[2]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
t8=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[4],t5);}
else{
t8=t4;
f1015(2,t8,lf[5]);}}
else{
t7=*((C_word*)lf[3]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[6],t5);}}
else{
t5=t4;
f1015(2,t5,(C_truep(t2)?lf[7]:lf[8]));}}

/* k1013 in mode */
static void f1015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[1]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}
/* end of file */
