;;;; psyntax-bootstrap.scm - Generate expanded psyntax-chicken.pp - felix


(define eval
  (let ([eval eval])
    (lambda (x . env)
      (apply 
       eval 
       (if (and-let* ([(pair? x)] [a (car x)])
	     (string? a)
	     (string=? "noexpand" a) )
	   (cadr x) 
	   x)
       env) ) ) )

(define ##syncase#properties (make-vector 3001 '()))

(define (putprop s k x)
  (let ([props (##sys#hash-table-ref ##syncase#properties s)])
    (if props
	(let ([a (assq props k)])
	  (if a
	      (##sys#setslot a 1 x)
	      (##sys#hash-table-set! ##syncase#properties s (cons (cons k x) props)) ) )
	(##sys#hash-table-set! ##syncase#properties s (list (cons k x))) ) ) )

(define (getprop s k)
  (and-let* ([props (##sys#hash-table-ref ##syncase#properties s)]
	     [a (assq k props)] )
    (cdr a) ) )

(define (remprop s k)
  (and-let* ([props (##sys#hash-table-ref ##syncase#properties s)])
    (let loop ([ps props] [prev #f])
      (unless (null? ps)
	(let ([a (##sys#slot ps 0)]
	      [r (##sys#slot ps 1)] )
	  (if (eq? k (##sys#slot a 0))
	      (if prev
		  (##sys#setslot prev 1 r)
		  (##sys#hash-table-set! ##syncase#properties s r) )
	      (loop r ps) ) ) ) ) ) )

(print "bootstrapping psyntax.pp ...")
(load "psyntax.pp")

(define (expand-file file outfile)
  (with-input-from-file file
    (lambda ()
      (call-with-output-file outfile
	(lambda (out)
	  (for-each
	   (lambda (x)
	     (pretty-print (sc-expand x) out) 
	     (newline out) ) 
	   (read-file) ) ) ) ) ) )

(print "expanding psyntax.scm to psyntax-chicken.pp ...")
(expand-file "psyntax.scm" "psyntax-chicken.pp")
