/* Generated from posix.scm by the Chicken compiler
   2004-07-28 18:17
   Version 1, Build 63 - linux-unix-gnu-x86
   command line: posix.scm -quiet -debug-level 0 -optimize-level 2 -include-path . -output-file posix.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANONYMOUS
# define MAP_ANONYMOUS    0
#endif

#ifndef C_MACOSX
extern char **environ;
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_fileno(p)         C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_alarm             alarm
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_close(fd)         C_fix(close(C_unfix(fd)))

#ifdef C_MACOSX
# define C_getenventry(i)   NULL
#else
# define C_getenventry(i)   environ[ i ]
#endif

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_exec_arg(int i, char *a, int len);
void C_fcall C_set_exec_arg(int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  C_exec_args[ i ] = ptr;
}

static void C_fcall C_free_exec_args();
void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if !defined(C_GNU_ENV)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
#endif

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

C_externimport void C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[329];


/* from k4067 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub709(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub709(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from k3986 */
static C_word C_fcall stub676(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub676(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)sleep(t0));
return C_r;}

/* from parent-process-id in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall stub673(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub673(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall stub671(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub671(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeargs */
static C_word C_fcall stub633(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub633(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k3800 */
static C_word C_fcall stub626(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub626(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k3776 */
static C_word C_fcall stub615(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub615(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub610(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub610(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub574(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub574(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
            else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from k3590 */
static C_word C_fcall stub566(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub566(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k3501 */
static C_word C_fcall stub549(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub549(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k3476 */
static C_word C_fcall stub543(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub543(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from asctime */
static C_word C_fcall stub532(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub532(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k3425 */
static C_word C_fcall stub523(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub523(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k3347 */
static C_word C_fcall stub504(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub504(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k3282 */
static C_word C_fcall stub478(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub478(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k3182 */
static C_word C_fcall stub460(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub460(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from current-effective-group-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall stub329(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub329(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall stub327(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub327(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall stub325(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub325(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall stub323(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub323(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from k2443 */
static C_word C_fcall stub300(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub300(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from k2312 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub273(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub273(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_return:
#undef return

return C_r;}

/* from k2305 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub269(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub269(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_return:
#undef return

return C_r;}

/* from k2244 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub257(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub257(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from k1295 */
static C_word C_fcall stub67(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k1285 */
static C_word C_fcall stub61(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub61(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k1275 */
static C_word C_fcall stub56(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub56(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k1032 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

C_externexport void C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
static void f_1015(C_word c,C_word t0,C_word t1) C_noret;
static void f_1018(C_word c,C_word t0,C_word t1) C_noret;
static void f_1021(C_word c,C_word t0,C_word t1) C_noret;
static void f_1024(C_word c,C_word t0,C_word t1) C_noret;
static void f_1027(C_word c,C_word t0,C_word t1) C_noret;
static void f_2094(C_word c,C_word t0,C_word t1) C_noret;
static void f_4574(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2155(C_word c,C_word t0,C_word t1) C_noret;
static void f_2672(C_word c,C_word t0,C_word t1) C_noret;
static void f_4350(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_4350r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void C_fcall f_4501(C_word t0,C_word t1) C_noret;
static void f_4507(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_4496(C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4491(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void C_fcall f_4352(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_4478(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_4486(C_word c,C_word t0,C_word t1,...) C_noret;
static void C_fcall f_4359(C_word t0,C_word t1) C_noret;
static void f_4466(C_word c,C_word t0,C_word t1) C_noret;
static void f_4369(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4371(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4390(C_word c,C_word t0,C_word t1) C_noret;
static void f_4452(C_word c,C_word t0,C_word t1) C_noret;
static void f_4459(C_word c,C_word t0,C_word t1) C_noret;
static void f_4446(C_word c,C_word t0,C_word t1) C_noret;
static void f_4405(C_word c,C_word t0,C_word t1) C_noret;
static void f_4436(C_word c,C_word t0,C_word t1) C_noret;
static void f_4422(C_word c,C_word t0,C_word t1) C_noret;
static void f_4434(C_word c,C_word t0,C_word t1) C_noret;
static void f_4430(C_word c,C_word t0,C_word t1) C_noret;
static void f_4417(C_word c,C_word t0,C_word t1) C_noret;
static void f_4415(C_word c,C_word t0,C_word t1) C_noret;
static void f_4470(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4090(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_4102(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4114(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_4304(C_word c,C_word t0,C_word t1) C_noret;
static void f_4308(C_word c,C_word t0,C_word t1) C_noret;
static void f_4311(C_word c,C_word t0,C_word t1) C_noret;
static void f_4345(C_word c,C_word t0,C_word t1) C_noret;
static void f_4314(C_word c,C_word t0,C_word t1) C_noret;
static void f_4336(C_word c,C_word t0,C_word t1) C_noret;
static void f_4317(C_word c,C_word t0,C_word t1) C_noret;
static void f_4320(C_word c,C_word t0,C_word t1) C_noret;
static void f_4118(C_word c,C_word t0,C_word t1) C_noret;
static void f_4121(C_word c,C_word t0,C_word t1) C_noret;
static void f_4124(C_word c,C_word t0,C_word t1) C_noret;
static void f_4137(C_word c,C_word t0,C_word t1) C_noret;
static void f_4291(C_word c,C_word t0,C_word t1) C_noret;
static void f_4295(C_word c,C_word t0,C_word t1) C_noret;
static void f_4275(C_word c,C_word t0,C_word t1) C_noret;
static void f_4256(C_word c,C_word t0,C_word t1) C_noret;
static void f_4260(C_word c,C_word t0,C_word t1) C_noret;
static void f_4184(C_word c,C_word t0,C_word t1) C_noret;
static void f_4243(C_word c,C_word t0,C_word t1) C_noret;
static void f_4247(C_word c,C_word t0,C_word t1) C_noret;
static void f_4190(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_4199(C_word t0,C_word t1) C_noret;
static void f_4234(C_word c,C_word t0,C_word t1) C_noret;
static void f_4221(C_word c,C_word t0,C_word t1) C_noret;
static void f_4215(C_word c,C_word t0,C_word t1) C_noret;
static void f_4188(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4139(C_word t0,C_word t1) C_noret;
static void C_fcall f_4153(C_word t0,C_word t1) C_noret;
static void f_4178(C_word c,C_word t0,C_word t1) C_noret;
static void f_4169(C_word c,C_word t0,C_word t1) C_noret;
static void f_4172(C_word c,C_word t0,C_word t1) C_noret;
static void f_4149(C_word c,C_word t0,C_word t1) C_noret;
static void f_4108(C_word c,C_word t0,C_word t1) C_noret;
static void f_4096(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_4070(C_word t0,C_word t1,C_word t2) C_noret;
static void f_4082(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_4076(C_word c,C_word t0,C_word t1) C_noret;
static void f_4020(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_4020r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_4027(C_word c,C_word t0,C_word t1) C_noret;
static void f_4042(C_word c,C_word t0,C_word t1) C_noret;
static void f_3990(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3990r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_4003(C_word c,C_word t0,C_word t1) C_noret;
static void f_3983(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3980(C_word c,C_word t0,C_word t1) C_noret;
static void f_3977(C_word c,C_word t0,C_word t1) C_noret;
static void f_3898(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3898r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3929(C_word c,C_word t0,C_word t1) C_noret;
static void f_3808(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3808r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3821(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3829(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3862(C_word c,C_word t0,C_word t1) C_noret;
static void f_3843(C_word c,C_word t0,C_word t1) C_noret;
static void f_3846(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_3789(C_word t0,C_word t1,C_word t2);
static void f_3744(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3744r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3751(C_word c,C_word t0,C_word t1) C_noret;
static void f_3769(C_word c,C_word t0,C_word t1) C_noret;
static void f_3773(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3638(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3638r(C_word t0,C_word t1,C_word t3) C_noret;
static void C_fcall f_3644(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3665(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_3736(C_word c,C_word t0,C_word t1) C_noret;
static void f_3669(C_word c,C_word t0,C_word t1) C_noret;
static void f_3676(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3678(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3695(C_word c,C_word t0,C_word t1) C_noret;
static void f_3705(C_word c,C_word t0,C_word t1) C_noret;
static void f_3709(C_word c,C_word t0,C_word t1) C_noret;
static void f_3659(C_word c,C_word t0,C_word t1) C_noret;
static void f_3623(C_word c,C_word t0,C_word t1) C_noret;
static void f_3627(C_word c,C_word t0,C_word t1) C_noret;
static void f_3633(C_word c,C_word t0,C_word t1) C_noret;
static void f_3630(C_word c,C_word t0,C_word t1) C_noret;
static void f_3593(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3597(C_word c,C_word t0,C_word t1) C_noret;
static void f_3600(C_word c,C_word t0,C_word t1) C_noret;
static void f_3564(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3568(C_word c,C_word t0,C_word t1) C_noret;
static void f_3571(C_word c,C_word t0,C_word t1) C_noret;
static void f_3505(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_3505r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_3509(C_word c,C_word t0,C_word t1) C_noret;
static void f_3515(C_word c,C_word t0,C_word t1) C_noret;
static void f_3498(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3479(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_3479r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_3483(C_word c,C_word t0,C_word t1) C_noret;
static void f_3445(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3452(C_word c,C_word t0,C_word t1) C_noret;
static void f_3455(C_word c,C_word t0,C_word t1) C_noret;
static void f_3458(C_word c,C_word t0,C_word t1) C_noret;
static void f_3428(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3432(C_word c,C_word t0,C_word t1) C_noret;
static void f_3435(C_word c,C_word t0,C_word t1) C_noret;
static void f_3409(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3400(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3391(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3353(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3353r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3369(C_word c,C_word t0,C_word t1) C_noret;
static void f_3288(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f_3288r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f_3292(C_word c,C_word t0,C_word t1) C_noret;
static void f_3298(C_word c,C_word t0,C_word t1) C_noret;
static void f_3320(C_word c,C_word t0,C_word t1) C_noret;
static void f_3313(C_word c,C_word t0,C_word t1) C_noret;
static void f_3304(C_word c,C_word t0,C_word t1) C_noret;
static void f_3185(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3191(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3195(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_3203(C_word t0,C_word t1,C_word t2) C_noret;
static void f_3229(C_word c,C_word t0,C_word t1) C_noret;
static void f_3233(C_word c,C_word t0,C_word t1) C_noret;
static void f_3221(C_word c,C_word t0,C_word t1) C_noret;
static void f_3165(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3173(C_word c,C_word t0,C_word t1) C_noret;
static void f_3148(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_3159(C_word c,C_word t0,C_word t1) C_noret;
static void f_3163(C_word c,C_word t0,C_word t1) C_noret;
static void f_3119(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3146(C_word c,C_word t0,C_word t1) C_noret;
static void f_3126(C_word c,C_word t0,C_word t1) C_noret;
static void f_3129(C_word c,C_word t0,C_word t1) C_noret;
static void f_3073(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3073r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_3080(C_word t0,C_word t1) C_noret;
static void f_3104(C_word c,C_word t0,C_word t1) C_noret;
static void f_3100(C_word c,C_word t0,C_word t1) C_noret;
static void f_3092(C_word c,C_word t0,C_word t1) C_noret;
static void f_3042(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_3063(C_word c,C_word t0,C_word t1) C_noret;
static void f_3020(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3020r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3024(C_word c,C_word t0,C_word t1) C_noret;
static void f_3005(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_3005r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_3009(C_word c,C_word t0,C_word t1) C_noret;
static void f_2990(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2990r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2994(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2969(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2973(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2895(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2917(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2923(C_word t0,C_word t1) C_noret;
static void f_2853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2884(C_word c,C_word t0,C_word t1) C_noret;
static void f_2880(C_word c,C_word t0,C_word t1) C_noret;
static void f_2873(C_word c,C_word t0,C_word t1) C_noret;
static void f_2866(C_word c,C_word t0,C_word t1) C_noret;
static void f_2823(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2823r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f_2830(C_word t0,C_word t1) C_noret;
static void f_2839(C_word c,C_word t0,C_word t1) C_noret;
static void f_2833(C_word c,C_word t0,C_word t1) C_noret;
static void f_2788(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2792(C_word c,C_word t0,C_word t1) C_noret;
static void f_2821(C_word c,C_word t0,C_word t1) C_noret;
static void f_2807(C_word c,C_word t0,C_word t1) C_noret;
static void f_2801(C_word c,C_word t0,C_word t1) C_noret;
static void f_2774(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2774r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2786(C_word c,C_word t0,C_word t1) C_noret;
static void f_2760(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_2760r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_2772(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2742(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2746(C_word c,C_word t0,C_word t1) C_noret;
static void f_2758(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2705(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2713(C_word c,C_word t0,C_word t1) C_noret;
static void f_2673(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2700(C_word c,C_word t0,C_word t1) C_noret;
static void f_2681(C_word c,C_word t0,C_word t1) C_noret;
static void f_2693(C_word c,C_word t0,C_word t1) C_noret;
static void f_2684(C_word c,C_word t0,C_word t1) C_noret;
static void f_2632(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2668(C_word c,C_word t0,C_word t1) C_noret;
static void f_2656(C_word c,C_word t0,C_word t1) C_noret;
static void f_2664(C_word c,C_word t0,C_word t1) C_noret;
static void f_2660(C_word c,C_word t0,C_word t1) C_noret;
static void f_2648(C_word c,C_word t0,C_word t1) C_noret;
static void f_2626(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2620(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2614(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f_2590(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2612(C_word c,C_word t0,C_word t1) C_noret;
static void f_2608(C_word c,C_word t0,C_word t1) C_noret;
static void f_2600(C_word c,C_word t0,C_word t1) C_noret;
static void f_2575(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2585(C_word c,C_word t0,C_word t1) C_noret;
static void f_2572(C_word c,C_word t0,C_word t1) C_noret;
static void f_2569(C_word c,C_word t0,C_word t1) C_noret;
static void f_2566(C_word c,C_word t0,C_word t1) C_noret;
static void f_2563(C_word c,C_word t0,C_word t1) C_noret;
static void f_2530(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f_2561(C_word c,C_word t0,C_word t1) C_noret;
static void f_2557(C_word c,C_word t0,C_word t1) C_noret;
static void f_2549(C_word c,C_word t0,C_word t1) C_noret;
static void f_2500(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2528(C_word c,C_word t0,C_word t1) C_noret;
static void f_2524(C_word c,C_word t0,C_word t1) C_noret;
static void f_2516(C_word c,C_word t0,C_word t1) C_noret;
static void f_2453(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2441(C_word c,C_word t0,C_word t1) C_noret;
static void f_2469(C_word c,C_word t0,C_word t1) C_noret;
static void f_2379(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2383(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2388(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2404(C_word c,C_word t0,C_word t1) C_noret;
static void f_2316(C_word c,C_word t0,C_word t1) C_noret;
static void f_2374(C_word c,C_word t0,C_word t1) C_noret;
static void f_2320(C_word c,C_word t0,C_word t1) C_noret;
static void f_2323(C_word c,C_word t0,C_word t1) C_noret;
static void f_2355(C_word c,C_word t0,C_word t1) C_noret;
static void f_2326(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2331(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2345(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_2309(C_word t0);
static void f_2248(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2300(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2252(C_word t0,C_word t1) C_noret;
static void f_2262(C_word c,C_word t0,C_word t1) C_noret;
static void f_2266(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2272(C_word t0,C_word t1,C_word t2) C_noret;
static void f_2276(C_word c,C_word t0,C_word t1) C_noret;
static void f_2286(C_word c,C_word t0,C_word t1) C_noret;
static void f_2270(C_word c,C_word t0,C_word t1) C_noret;
static void f_2195(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2235(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_2199(C_word t0,C_word t1) C_noret;
static void f_2209(C_word c,C_word t0,C_word t1) C_noret;
static void f_2213(C_word c,C_word t0,C_word t1) C_noret;
static void f_2217(C_word c,C_word t0,C_word t1) C_noret;
static void f_2221(C_word c,C_word t0,C_word t1) C_noret;
static void f_2225(C_word c,C_word t0,C_word t1) C_noret;
static void f_2157(C_word c,C_word t0,C_word t1) C_noret;
static void f_2190(C_word c,C_word t0,C_word t1) C_noret;
static void f_2161(C_word c,C_word t0,C_word t1) C_noret;
static void f_2168(C_word c,C_word t0,C_word t1) C_noret;
static void f_2172(C_word c,C_word t0,C_word t1) C_noret;
static void f_2176(C_word c,C_word t0,C_word t1) C_noret;
static void f_2180(C_word c,C_word t0,C_word t1) C_noret;
static void f_2184(C_word c,C_word t0,C_word t1) C_noret;
static void f_2127(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2148(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_2134(C_word c,C_word t0,C_word t1) C_noret;
static void f_2143(C_word c,C_word t0,C_word t1) C_noret;
static void f_2109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2119(C_word c,C_word t0,C_word t1) C_noret;
static void f_2096(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_2050(C_word c,C_word t0,C_word t1) C_noret;
static void f_2063(C_word c,C_word t0,C_word t1) C_noret;
static void f_2054(C_word c,C_word t0,C_word t1) C_noret;
static void f_2030(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2030r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2034(C_word c,C_word t0,C_word t1) C_noret;
static void f_2040(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2040r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2044(C_word c,C_word t0,C_word t1) C_noret;
static void f_2010(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_2010r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_2014(C_word c,C_word t0,C_word t1) C_noret;
static void f_2020(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2020r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2024(C_word c,C_word t0,C_word t1) C_noret;
static void f_1986(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1986r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1990(C_word c,C_word t0,C_word t1) C_noret;
static void f_2001(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_2001r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_2005(C_word c,C_word t0,C_word t1) C_noret;
static void f_1995(C_word c,C_word t0,C_word t1) C_noret;
static void f_1962(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1962r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1966(C_word c,C_word t0,C_word t1) C_noret;
static void f_1977(C_word c,C_word t0,C_word t1,...) C_noret;
static void f_1977r(C_word t0,C_word t1,C_word t3) C_noret;
static void f_1981(C_word c,C_word t0,C_word t1) C_noret;
static void f_1971(C_word c,C_word t0,C_word t1) C_noret;
static void f_1943(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1947(C_word c,C_word t0,C_word t1) C_noret;
static void f_1950(C_word c,C_word t0,C_word t1) C_noret;
static void f_1907(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_1907r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_1938(C_word c,C_word t0,C_word t1) C_noret;
static void f_1928(C_word c,C_word t0,C_word t1) C_noret;
static void f_1921(C_word c,C_word t0,C_word t1) C_noret;
static void f_1871(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f_1871r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f_1902(C_word c,C_word t0,C_word t1) C_noret;
static void f_1892(C_word c,C_word t0,C_word t1) C_noret;
static void f_1885(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1853(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f_1857(C_word c,C_word t0,C_word t1) C_noret;
static void f_1869(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1847(C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1835(C_word t0);
static void f_1817(C_word c,C_word t0,C_word t1) C_noret;
static void f_1821(C_word c,C_word t0,C_word t1) C_noret;
static void f_1824(C_word c,C_word t0,C_word t1) C_noret;
static void f_1794(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1815(C_word c,C_word t0,C_word t1) C_noret;
static void f_1801(C_word c,C_word t0,C_word t1) C_noret;
static void f_1737(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1744(C_word c,C_word t0,C_word t1) C_noret;
static void f_1747(C_word c,C_word t0,C_word t1) C_noret;
static void f_1750(C_word c,C_word t0,C_word t1) C_noret;
static void f_1792(C_word c,C_word t0,C_word t1) C_noret;
static void f_1754(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1771(C_word t0,C_word t1) C_noret;
static void f_1781(C_word c,C_word t0,C_word t1) C_noret;
static void f_1788(C_word c,C_word t0,C_word t1) C_noret;
static void f_1763(C_word c,C_word t0,C_word t1) C_noret;
static void f_1710(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1735(C_word c,C_word t0,C_word t1) C_noret;
static void f_1731(C_word c,C_word t0,C_word t1) C_noret;
static void f_1723(C_word c,C_word t0,C_word t1) C_noret;
static void f_1683(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1708(C_word c,C_word t0,C_word t1) C_noret;
static void f_1704(C_word c,C_word t0,C_word t1) C_noret;
static void f_1696(C_word c,C_word t0,C_word t1) C_noret;
static void f_1656(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1681(C_word c,C_word t0,C_word t1) C_noret;
static void f_1677(C_word c,C_word t0,C_word t1) C_noret;
static void f_1669(C_word c,C_word t0,C_word t1) C_noret;
static void f_1595(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1595r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1608(C_word c,C_word t0,C_word t1) C_noret;
static void f_1623(C_word c,C_word t0,C_word t1) C_noret;
static void f_1614(C_word c,C_word t0,C_word t1) C_noret;
static void f_1617(C_word c,C_word t0,C_word t1) C_noret;
static void f_1555(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1574(C_word c,C_word t0,C_word t1) C_noret;
static void f_1559(C_word c,C_word t0,C_word t1) C_noret;
static void f_1568(C_word c,C_word t0,C_word t1) C_noret;
static void f_1562(C_word c,C_word t0,C_word t1) C_noret;
static void f_1549(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1553(C_word c,C_word t0,C_word t1) C_noret;
static void f_1543(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1547(C_word c,C_word t0,C_word t1) C_noret;
static void f_1537(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1541(C_word c,C_word t0,C_word t1) C_noret;
static void f_1531(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1535(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1493(C_word t0,C_word t1) C_noret;
static void f_1526(C_word c,C_word t0,C_word t1) C_noret;
static void f_1522(C_word c,C_word t0,C_word t1) C_noret;
static void f_1497(C_word c,C_word t0,C_word t1) C_noret;
static void f_1506(C_word c,C_word t0,C_word t1) C_noret;
static void f_1298(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1298r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1474(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1314(C_word c,C_word t0,C_word t1) C_noret;
static void f_1448(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1320(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1323(C_word t0,C_word t1) C_noret;
static void f_1408(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1406(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1365(C_word t0,C_word t1) C_noret;
static void f_1383(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1381(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1369(C_word t0,C_word t1) C_noret;
static void f_1332(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1288(C_word t0,C_word t1);
static C_word C_fcall f_1278(C_word t0,C_word t1);
static C_word C_fcall f_1272(C_word t0);
static void f_1237(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1244(C_word c,C_word t0,C_word t1) C_noret;
static void f_1247(C_word c,C_word t0,C_word t1) C_noret;
static void f_1267(C_word c,C_word t0,C_word t1) C_noret;
static void f_1250(C_word c,C_word t0,C_word t1) C_noret;
static void f_1257(C_word c,C_word t0,C_word t1) C_noret;
static void f_1195(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1195r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1202(C_word c,C_word t0,C_word t1) C_noret;
static void f_1217(C_word c,C_word t0,C_word t1) C_noret;
static void f_1211(C_word c,C_word t0,C_word t1) C_noret;
static void f_1150(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1150r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1160(C_word c,C_word t0,C_word t1) C_noret;
static void f_1163(C_word c,C_word t0,C_word t1) C_noret;
static void f_1175(C_word c,C_word t0,C_word t1) C_noret;
static void f_1166(C_word c,C_word t0,C_word t1) C_noret;
static void f_1132(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1145(C_word c,C_word t0,C_word t1) C_noret;
static void f_1091(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f_1091r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f_1124(C_word c,C_word t0,C_word t1) C_noret;
static void f_1108(C_word c,C_word t0,C_word t1) C_noret;
static void f_1117(C_word c,C_word t0,C_word t1) C_noret;
static void f_1111(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f_1036(C_word t0) C_noret;
static void f_1042(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f_1051(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f_1029(C_word t0);

static void C_fcall trf_4501(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4501(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4501(t0,t1);}

static void C_fcall trf_4496(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4496(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4496(t0,t1,t2);}

static void C_fcall trf_4491(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4491(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4491(t0,t1,t2,t3);}

static void C_fcall trf_4352(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4352(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4352(t0,t1,t2,t3,t4);}

static void C_fcall trf_4359(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4359(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4359(t0,t1);}

static void C_fcall trf_4371(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4371(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4371(t0,t1,t2,t3);}

static void C_fcall trf_4199(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4199(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4199(t0,t1);}

static void C_fcall trf_4139(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4139(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4139(t0,t1);}

static void C_fcall trf_4153(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4153(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4153(t0,t1);}

static void C_fcall trf_4070(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4070(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4070(t0,t1,t2);}

static void C_fcall trf_3829(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3829(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3829(t0,t1,t2,t3);}

static void C_fcall trf_3644(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3644(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3644(t0,t1,t2);}

static void C_fcall trf_3678(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3678(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3678(t0,t1,t2);}

static void C_fcall trf_3191(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3191(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3191(t0,t1,t2);}

static void C_fcall trf_3203(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3203(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3203(t0,t1,t2);}

static void C_fcall trf_3080(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3080(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3080(t0,t1);}

static void C_fcall trf_2969(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2969(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2969(t0,t1,t2,t3);}

static void C_fcall trf_2895(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2895(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2895(t0,t1,t2,t3);}

static void C_fcall trf_2923(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2923(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2923(t0,t1);}

static void C_fcall trf_2830(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2830(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2830(t0,t1);}

static void C_fcall trf_2742(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2742(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2742(t0,t1,t2,t3);}

static void C_fcall trf_2705(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2705(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2705(t0,t1,t2);}

static void C_fcall trf_2590(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2590(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2590(t0,t1,t2,t3);}

static void C_fcall trf_2388(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2388(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2388(t0,t1,t2,t3);}

static void C_fcall trf_2331(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2331(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2331(t0,t1,t2);}

static void C_fcall trf_2252(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2252(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2252(t0,t1);}

static void C_fcall trf_2272(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2272(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2272(t0,t1,t2);}

static void C_fcall trf_2199(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2199(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2199(t0,t1);}

static void C_fcall trf_1853(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1853(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1853(t0,t1,t2,t3);}

static void C_fcall trf_1847(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1847(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1847(t0,t1);}

static void C_fcall trf_1771(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1771(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1771(t0,t1);}

static void C_fcall trf_1493(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1493(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1493(t0,t1);}

static void C_fcall trf_1323(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1323(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1323(t0,t1);}

static void C_fcall trf_1365(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1365(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1365(t0,t1);}

static void C_fcall trf_1369(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1369(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1369(t0,t1);}

static void C_fcall trf_1036(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1036(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f_1036(t0);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(4138)){
C_save(t1);
C_rereclaim2(4138*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,329);
lf[1]=C_string(C_heaptop,27,"too many optional arguments");
lf[4]=C_h_intern(&lf[4],18,"\003syscurrent-thread");
lf[5]=C_h_intern(&lf[5],12,"\003sysschedule");
lf[6]=C_h_intern(&lf[6],8,"pipe/buf");
lf[7]=C_h_intern(&lf[7],11,"open/rdonly");
lf[8]=C_h_intern(&lf[8],11,"open/wronly");
lf[9]=C_h_intern(&lf[9],9,"open/rdwr");
lf[10]=C_h_intern(&lf[10],9,"open/read");
lf[11]=C_h_intern(&lf[11],10,"open/write");
lf[12]=C_h_intern(&lf[12],10,"open/creat");
lf[13]=C_h_intern(&lf[13],11,"open/append");
lf[14]=C_h_intern(&lf[14],9,"open/excl");
lf[15]=C_h_intern(&lf[15],11,"open/noctty");
lf[16]=C_h_intern(&lf[16],13,"open/nonblock");
lf[17]=C_h_intern(&lf[17],10,"open/trunc");
lf[18]=C_h_intern(&lf[18],9,"open/sync");
lf[19]=C_h_intern(&lf[19],10,"open/fsync");
lf[20]=C_h_intern(&lf[20],11,"open/binary");
lf[21]=C_h_intern(&lf[21],9,"open/text");
lf[22]=C_h_intern(&lf[22],10,"perm/irusr");
lf[23]=C_h_intern(&lf[23],10,"perm/iwusr");
lf[24]=C_h_intern(&lf[24],10,"perm/ixusr");
lf[25]=C_h_intern(&lf[25],10,"perm/irgrp");
lf[26]=C_h_intern(&lf[26],10,"perm/iwgrp");
lf[27]=C_h_intern(&lf[27],10,"perm/ixgrp");
lf[28]=C_h_intern(&lf[28],10,"perm/iroth");
lf[29]=C_h_intern(&lf[29],10,"perm/iwoth");
lf[30]=C_h_intern(&lf[30],10,"perm/ixoth");
lf[31]=C_h_intern(&lf[31],10,"perm/irwxu");
lf[32]=C_h_intern(&lf[32],10,"perm/irwxg");
lf[33]=C_h_intern(&lf[33],10,"perm/irwxo");
lf[34]=C_h_intern(&lf[34],10,"perm/isvtx");
lf[35]=C_h_intern(&lf[35],10,"perm/isuid");
lf[36]=C_h_intern(&lf[36],10,"perm/isgid");
lf[37]=C_h_intern(&lf[37],9,"file-open");
lf[38]=C_h_intern(&lf[38],15,"\003syssignal-hook");
lf[39]=C_h_intern(&lf[39],11,"\000file-error");
lf[40]=C_string(C_heaptop,17,"can not open file");
lf[41]=C_h_intern(&lf[41],16,"\003sysupdate-errno");
lf[42]=C_h_intern(&lf[42],17,"\003sysmake-c-string");
lf[43]=C_h_intern(&lf[43],20,"\003sysexpand-home-path");
lf[44]=C_h_intern(&lf[44],10,"file-close");
lf[45]=C_string(C_heaptop,18,"can not close file");
lf[46]=C_h_intern(&lf[46],11,"make-string");
lf[47]=C_h_intern(&lf[47],9,"file-read");
lf[48]=C_string(C_heaptop,22,"can not read from file");
lf[49]=C_h_intern(&lf[49],11,"\000type-error");
lf[50]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[51]=C_h_intern(&lf[51],10,"file-write");
lf[52]=C_string(C_heaptop,21,"can not write to file");
lf[53]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[54]=C_h_intern(&lf[54],13,"string-length");
lf[55]=C_h_intern(&lf[55],12,"file-mkstemp");
lf[56]=C_h_intern(&lf[56],13,"\003syssubstring");
lf[57]=C_string(C_heaptop,29,"can not create temporary file");
lf[58]=C_h_intern(&lf[58],11,"file-select");
lf[59]=C_string(C_heaptop,6,"failed");
lf[60]=C_h_intern(&lf[60],12,"\003sysfor-each");
lf[61]=C_h_intern(&lf[61],8,"seek/set");
lf[62]=C_h_intern(&lf[62],8,"seek/end");
lf[63]=C_h_intern(&lf[63],8,"seek/cur");
lf[65]=C_string(C_heaptop,19,"can not access file");
lf[66]=C_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[67]=C_h_intern(&lf[67],9,"file-size");
lf[68]=C_h_intern(&lf[68],22,"file-modification-time");
lf[69]=C_h_intern(&lf[69],10,"file-owner");
lf[70]=C_h_intern(&lf[70],16,"file-permissions");
lf[71]=C_h_intern(&lf[71],13,"file-position");
lf[72]=C_string(C_heaptop,38,"can not retrieve file position of port");
lf[73]=C_h_intern(&lf[73],6,"stream");
lf[74]=C_string(C_heaptop,12,"invalid file");
lf[75]=C_h_intern(&lf[75],5,"port\077");
lf[76]=C_h_intern(&lf[76],18,"set-file-position!");
lf[77]=C_string(C_heaptop,25,"can not set file position");
lf[78]=C_string(C_heaptop,12,"invalid file");
lf[79]=C_h_intern(&lf[79],13,"\000bounds-error");
lf[80]=C_string(C_heaptop,30,"invalid negative port position");
lf[81]=C_h_intern(&lf[81],16,"create-directory");
lf[82]=C_string(C_heaptop,24,"can not create directory");
lf[83]=C_h_intern(&lf[83],16,"change-directory");
lf[84]=C_string(C_heaptop,32,"can not change current directory");
lf[85]=C_h_intern(&lf[85],16,"delete-directory");
lf[86]=C_string(C_heaptop,24,"can not delete directory");
lf[87]=C_h_intern(&lf[87],13,"string-append");
lf[88]=C_h_intern(&lf[88],6,"string");
lf[89]=C_h_intern(&lf[89],9,"substring");
lf[90]=C_h_intern(&lf[90],9,"directory");
lf[91]=C_string(C_heaptop,22,"can not open directory");
lf[92]=C_h_intern(&lf[92],16,"\003sysmake-pointer");
lf[93]=C_h_intern(&lf[93],10,"directory\077");
lf[94]=C_h_intern(&lf[94],13,"\003sysfile-info");
lf[95]=C_h_intern(&lf[95],17,"current-directory");
lf[96]=C_string(C_heaptop,34,"can not retrieve current directory");
lf[97]=C_h_intern(&lf[97],5,"\000text");
lf[98]=C_h_intern(&lf[98],9,"\003syserror");
lf[99]=C_string(C_heaptop,35,"illegal input/output mode specifier");
lf[100]=C_string(C_heaptop,17,"can not open pipe");
lf[101]=C_h_intern(&lf[101],13,"\003sysmake-port");
lf[102]=C_h_intern(&lf[102],21,"\003sysstream-port-class");
lf[103]=C_string(C_heaptop,6,"(pipe)");
lf[104]=C_h_intern(&lf[104],15,"open-input-pipe");
lf[105]=C_h_intern(&lf[105],7,"\000binary");
lf[106]=C_h_intern(&lf[106],16,"open-output-pipe");
lf[107]=C_h_intern(&lf[107],16,"close-input-pipe");
lf[108]=C_string(C_heaptop,24,"error while closing pipe");
lf[109]=C_h_intern(&lf[109],14,"\003syscheck-port");
lf[110]=C_h_intern(&lf[110],17,"close-output-pipe");
lf[111]=C_h_intern(&lf[111],20,"call-with-input-pipe");
lf[112]=C_h_intern(&lf[112],6,"values");
lf[113]=C_h_intern(&lf[113],21,"call-with-output-pipe");
lf[114]=C_h_intern(&lf[114],20,"with-input-from-pipe");
lf[115]=C_h_intern(&lf[115],18,"\003sysstandard-input");
lf[116]=C_h_intern(&lf[116],19,"with-output-to-pipe");
lf[117]=C_h_intern(&lf[117],19,"\003sysstandard-output");
lf[118]=C_h_intern(&lf[118],11,"create-pipe");
lf[119]=C_string(C_heaptop,19,"can not create pipe");
lf[120]=C_h_intern(&lf[120],11,"signal/term");
lf[121]=C_h_intern(&lf[121],11,"signal/kill");
lf[122]=C_h_intern(&lf[122],10,"signal/int");
lf[123]=C_h_intern(&lf[123],10,"signal/hup");
lf[124]=C_h_intern(&lf[124],10,"signal/fpe");
lf[125]=C_h_intern(&lf[125],10,"signal/ill");
lf[126]=C_h_intern(&lf[126],11,"signal/segv");
lf[127]=C_h_intern(&lf[127],11,"signal/abrt");
lf[128]=C_h_intern(&lf[128],11,"signal/trap");
lf[129]=C_h_intern(&lf[129],11,"signal/quit");
lf[130]=C_h_intern(&lf[130],11,"signal/alrm");
lf[131]=C_h_intern(&lf[131],13,"signal/vtalrm");
lf[132]=C_h_intern(&lf[132],11,"signal/prof");
lf[133]=C_h_intern(&lf[133],9,"signal/io");
lf[134]=C_h_intern(&lf[134],10,"signal/urg");
lf[135]=C_h_intern(&lf[135],11,"signal/chld");
lf[136]=C_h_intern(&lf[136],11,"signal/cont");
lf[137]=C_h_intern(&lf[137],11,"signal/stop");
lf[138]=C_h_intern(&lf[138],11,"signal/tstp");
lf[139]=C_h_intern(&lf[139],11,"signal/pipe");
lf[140]=C_h_intern(&lf[140],11,"signal/xcpu");
lf[141]=C_h_intern(&lf[141],11,"signal/xfsz");
lf[142]=C_h_intern(&lf[142],11,"signal/usr1");
lf[143]=C_h_intern(&lf[143],11,"signal/usr2");
lf[144]=C_h_intern(&lf[144],12,"signal/winch");
lf[145]=C_h_intern(&lf[145],18,"\003sysinterrupt-hook");
lf[146]=C_h_intern(&lf[146],19,"set-signal-handler!");
lf[147]=C_h_intern(&lf[147],18,"\003syscontext-switch");
lf[148]=C_h_intern(&lf[148],16,"set-signal-mask!");
lf[149]=C_string(C_heaptop,23,"can not set signal mask");
lf[150]=C_h_intern(&lf[150],18,"system-information");
lf[151]=C_h_intern(&lf[151],25,"\003syspeek-nonnull-c-string");
lf[152]=C_string(C_heaptop,35,"can not retrieve system information");
lf[153]=C_h_intern(&lf[153],16,"user-information");
lf[154]=C_h_intern(&lf[154],17,"\003syspeek-c-string");
lf[155]=C_h_intern(&lf[155],17,"group-information");
lf[157]=C_h_intern(&lf[157],10,"get-groups");
lf[158]=C_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[159]=C_string(C_heaptop,13,"out of memory");
lf[160]=C_string(C_heaptop,40,"can not retrieve supplementary group ids");
lf[161]=C_h_intern(&lf[161],11,"set-groups!");
lf[162]=C_string(C_heaptop,35,"can not set supplementary group ids");
lf[163]=C_string(C_heaptop,13,"out of memory");
lf[164]=C_h_intern(&lf[164],17,"initialize-groups");
lf[165]=C_string(C_heaptop,43,"can not initialize supplementrary group ids");
lf[166]=C_h_intern(&lf[166],10,"errno/perm");
lf[167]=C_h_intern(&lf[167],11,"errno/noent");
lf[168]=C_h_intern(&lf[168],10,"errno/srch");
lf[169]=C_h_intern(&lf[169],10,"errno/intr");
lf[170]=C_h_intern(&lf[170],8,"errno/io");
lf[171]=C_h_intern(&lf[171],12,"errno/noexec");
lf[172]=C_h_intern(&lf[172],10,"errno/badf");
lf[173]=C_h_intern(&lf[173],11,"errno/child");
lf[174]=C_h_intern(&lf[174],11,"errno/nomem");
lf[175]=C_h_intern(&lf[175],11,"errno/acces");
lf[176]=C_h_intern(&lf[176],11,"errno/fault");
lf[177]=C_h_intern(&lf[177],10,"errno/busy");
lf[178]=C_h_intern(&lf[178],12,"errno/notdir");
lf[179]=C_h_intern(&lf[179],11,"errno/isdir");
lf[180]=C_h_intern(&lf[180],11,"errno/inval");
lf[181]=C_h_intern(&lf[181],11,"errno/mfile");
lf[182]=C_h_intern(&lf[182],11,"errno/nospc");
lf[183]=C_h_intern(&lf[183],11,"errno/spipe");
lf[184]=C_h_intern(&lf[184],10,"errno/pipe");
lf[185]=C_h_intern(&lf[185],11,"errno/again");
lf[186]=C_h_intern(&lf[186],10,"errno/rofs");
lf[187]=C_h_intern(&lf[187],16,"errno/wouldblock");
lf[188]=C_h_intern(&lf[188],16,"change-file-mode");
lf[189]=C_string(C_heaptop,24,"can not change file mode");
lf[190]=C_h_intern(&lf[190],17,"change-file-owner");
lf[191]=C_string(C_heaptop,25,"can not change file owner");
lf[192]=C_h_intern(&lf[192],15,"current-user-id");
lf[193]=C_h_intern(&lf[193],16,"current-group-id");
lf[194]=C_h_intern(&lf[194],25,"current-effective-user-id");
lf[195]=C_h_intern(&lf[195],26,"current-effective-group-id");
lf[196]=C_h_intern(&lf[196],12,"set-user-id!");
lf[197]=C_string(C_heaptop,19,"can not set user id");
lf[198]=C_h_intern(&lf[198],17,"file-read-access\077");
lf[199]=C_h_intern(&lf[199],18,"file-write-access\077");
lf[200]=C_h_intern(&lf[200],20,"file-execute-access\077");
lf[201]=C_h_intern(&lf[201],20,"create-symbolic-link");
lf[202]=C_h_intern(&lf[202],18,"create-symbol-link");
lf[203]=C_string(C_heaptop,28,"can not create symbolic link");
lf[204]=C_h_intern(&lf[204],18,"read-symbolic-link");
lf[205]=C_string(C_heaptop,26,"can not read symbolic link");
lf[206]=C_h_intern(&lf[206],12,"fileno/stdin");
lf[207]=C_h_intern(&lf[207],13,"fileno/stdout");
lf[208]=C_h_intern(&lf[208],13,"fileno/stderr");
lf[209]=C_h_intern(&lf[209],7,"\000append");
lf[210]=C_string(C_heaptop,27,"invalid mode for input file");
lf[211]=C_string(C_heaptop,1,"a");
lf[212]=C_string(C_heaptop,21,"invalid mode argument");
lf[213]=C_string(C_heaptop,1,"r");
lf[214]=C_string(C_heaptop,1,"w");
lf[215]=C_string(C_heaptop,17,"can not open file");
lf[216]=C_string(C_heaptop,8,"(fdport)");
lf[217]=C_h_intern(&lf[217],16,"open-input-file*");
lf[218]=C_h_intern(&lf[218],17,"open-output-file*");
lf[219]=C_h_intern(&lf[219],12,"port->fileno");
lf[220]=C_string(C_heaptop,25,"port has no attached file");
lf[221]=C_string(C_heaptop,38,"can not access file-descriptor of port");
lf[222]=C_h_intern(&lf[222],25,"\003syspeek-unsigned-integer");
lf[223]=C_h_intern(&lf[223],16,"duplicate-fileno");
lf[224]=C_string(C_heaptop,33,"can not duplicate file descriptor");
lf[225]=C_h_intern(&lf[225],13,"file-truncate");
lf[226]=C_string(C_heaptop,21,"can not truncate file");
lf[227]=C_string(C_heaptop,12,"invalid file");
lf[228]=C_h_intern(&lf[228],4,"lock");
lf[229]=C_h_intern(&lf[229],9,"file-lock");
lf[230]=C_string(C_heaptop,17,"can not lock file");
lf[231]=C_h_intern(&lf[231],18,"file-lock/blocking");
lf[232]=C_string(C_heaptop,17,"can not lock file");
lf[233]=C_h_intern(&lf[233],14,"file-test-lock");
lf[234]=C_string(C_heaptop,19,"can not unlock file");
lf[235]=C_h_intern(&lf[235],11,"file-unlock");
lf[236]=C_string(C_heaptop,19,"can not unlock file");
lf[237]=C_h_intern(&lf[237],11,"create-fifo");
lf[238]=C_string(C_heaptop,19,"can not create FIFO");
lf[239]=C_h_intern(&lf[239],5,"fifo\077");
lf[240]=C_string(C_heaptop,19,"file does not exist");
lf[241]=C_h_intern(&lf[241],6,"setenv");
lf[242]=C_h_intern(&lf[242],8,"unsetenv");
lf[243]=C_h_intern(&lf[243],19,"current-environment");
lf[244]=C_h_intern(&lf[244],9,"prot/read");
lf[245]=C_h_intern(&lf[245],10,"prot/write");
lf[246]=C_h_intern(&lf[246],9,"prot/exec");
lf[247]=C_h_intern(&lf[247],9,"prot/none");
lf[248]=C_h_intern(&lf[248],9,"map/fixed");
lf[249]=C_h_intern(&lf[249],10,"map/shared");
lf[250]=C_h_intern(&lf[250],11,"map/private");
lf[251]=C_h_intern(&lf[251],13,"map/anonymous");
lf[252]=C_h_intern(&lf[252],8,"map/file");
lf[253]=C_h_intern(&lf[253],18,"map-file-to-memory");
lf[254]=C_h_intern(&lf[254],4,"mmap");
lf[255]=C_string(C_heaptop,26,"can not map file to memory");
lf[256]=C_h_intern(&lf[256],20,"\003syspointer->address");
lf[257]=C_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[258]=C_h_intern(&lf[258],16,"\003sysnull-pointer");
lf[259]=C_h_intern(&lf[259],22,"unmap-file-from-memory");
lf[260]=C_string(C_heaptop,30,"can not unmap file from memory");
lf[261]=C_h_intern(&lf[261],26,"memory-mapped-file-pointer");
lf[262]=C_h_intern(&lf[262],19,"seconds->local-time");
lf[263]=C_h_intern(&lf[263],18,"\003sysdecode-seconds");
lf[264]=C_h_intern(&lf[264],17,"seconds->utc-time");
lf[265]=C_h_intern(&lf[265],15,"seconds->string");
lf[266]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[267]=C_h_intern(&lf[267],12,"time->string");
lf[268]=C_string(C_heaptop,29,"can not time vector to string");
lf[269]=C_string(C_heaptop,21,"time vector too short");
lf[270]=C_h_intern(&lf[270],5,"_exit");
lf[271]=C_h_intern(&lf[271],23,"\003syscleanup-before-exit");
lf[272]=C_h_intern(&lf[272],10,"set-alarm!");
lf[273]=C_h_intern(&lf[273],19,"set-buffering-mode!");
lf[274]=C_string(C_heaptop,26,"can not set buffering mode");
lf[275]=C_h_intern(&lf[275],5,"\000full");
lf[276]=C_h_intern(&lf[276],5,"\000line");
lf[277]=C_h_intern(&lf[277],5,"\000none");
lf[278]=C_string(C_heaptop,22,"invalid buffering-mode");
lf[279]=C_h_intern(&lf[279],14,"terminal-port\077");
lf[280]=C_h_intern(&lf[280],13,"terminal-name");
lf[281]=C_string(C_heaptop,35,"port is not connected to a terminal");
lf[282]=C_h_intern(&lf[282],13,"get-host-name");
lf[283]=C_string(C_heaptop,26,"can not retrieve host-name");
lf[284]=C_h_intern(&lf[284],15,"pattern->regexp");
lf[285]=C_h_intern(&lf[285],13,"make-pathname");
lf[286]=C_h_intern(&lf[286],18,"decompose-pathname");
lf[287]=C_h_intern(&lf[287],4,"glob");
lf[288]=C_h_intern(&lf[288],12,"string-match");
lf[289]=C_string(C_heaptop,1,".");
lf[290]=C_string(C_heaptop,1,"*");
lf[291]=C_h_intern(&lf[291],12,"process-fork");
lf[292]=C_string(C_heaptop,28,"can not create child process");
lf[293]=C_h_intern(&lf[293],24,"pathname-strip-directory");
lf[294]=C_h_intern(&lf[294],15,"process-execute");
lf[295]=C_string(C_heaptop,23,"can not execute process");
lf[296]=C_h_intern(&lf[296],12,"process-wait");
lf[297]=C_string(C_heaptop,32,"waiting for child process failed");
lf[298]=C_h_intern(&lf[298],18,"current-process-id");
lf[299]=C_h_intern(&lf[299],17,"parent-process-id");
lf[300]=C_h_intern(&lf[300],5,"sleep");
lf[301]=C_h_intern(&lf[301],14,"process-signal");
lf[302]=C_string(C_heaptop,32,"could not send signal to process");
lf[303]=C_h_intern(&lf[303],6,"getenv");
lf[304]=C_h_intern(&lf[304],11,"process-run");
lf[305]=C_string(C_heaptop,7,"/bin/sh");
lf[306]=C_string(C_heaptop,2,"-c");
lf[307]=C_string(C_heaptop,5,"SHELL");
lf[308]=C_h_intern(&lf[308],15,"make-input-port");
lf[309]=C_h_intern(&lf[309],16,"make-output-port");
lf[310]=C_h_intern(&lf[310],7,"process");
lf[311]=C_string(C_heaptop,25,"process exited abnormally");
lf[312]=C_h_intern(&lf[312],25,"\003systhread-block-for-i/o!");
lf[313]=C_string(C_heaptop,22,"can not read from pipe");
lf[314]=C_string(C_heaptop,21,"can not write to pipe");
lf[315]=C_string(C_heaptop,7,"/bin/sh");
lf[316]=C_string(C_heaptop,2,"-c");
lf[317]=C_string(C_heaptop,5,"SHELL");
lf[318]=C_h_intern(&lf[318],10,"find-files");
lf[319]=C_string(C_heaptop,1,".");
lf[320]=C_string(C_heaptop,2,"..");
lf[321]=C_string(C_heaptop,1,"*");
lf[322]=C_h_intern(&lf[322],16,"\003sysdynamic-wind");
lf[323]=C_h_intern(&lf[323],13,"pathname-file");
lf[324]=C_string(C_heaptop,1,"*");
lf[325]=C_h_intern(&lf[325],23,"\003sysuser-interrupt-hook");
lf[326]=C_h_intern(&lf[326],11,"make-vector");
lf[327]=C_h_intern(&lf[327],17,"register-feature!");
lf[328]=C_h_intern(&lf[328],5,"posix");
C_register_lf(lf,329);
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1015,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1013 */
static void f_1015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1015,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1018,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1016 in k1013 */
static void f_1018(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1018,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1021,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1019 in k1016 in k1013 */
static void f_1021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1021,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1024,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1022 in k1019 in k1016 in k1013 */
static void f_1024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1024,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1027,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[327]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[328]);}

/* k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word ab[98],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1027,2,t0,t1);}
t2=C_mutate(&lf[2],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1029,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate(&lf[3],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1036,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[6]+1,C_fix((C_word)PIPE_BUF));
t5=C_mutate((C_word*)lf[7]+1,C_fix((C_word)O_RDONLY));
t6=C_mutate((C_word*)lf[8]+1,C_fix((C_word)O_WRONLY));
t7=C_mutate((C_word*)lf[9]+1,C_fix((C_word)O_RDWR));
t8=C_mutate((C_word*)lf[10]+1,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[11]+1,C_fix((C_word)O_WRONLY));
t10=C_mutate((C_word*)lf[12]+1,C_fix((C_word)O_CREAT));
t11=C_mutate((C_word*)lf[13]+1,C_fix((C_word)O_APPEND));
t12=C_mutate((C_word*)lf[14]+1,C_fix((C_word)O_EXCL));
t13=C_mutate((C_word*)lf[15]+1,C_fix((C_word)O_NOCTTY));
t14=C_mutate((C_word*)lf[16]+1,C_fix((C_word)O_NONBLOCK));
t15=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_TRUNC));
t16=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_FSYNC));
t17=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_FSYNC));
t18=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_BINARY));
t19=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_TEXT));
t20=C_mutate((C_word*)lf[22]+1,C_fix((C_word)S_IRUSR));
t21=C_mutate((C_word*)lf[23]+1,C_fix((C_word)S_IWUSR));
t22=C_mutate((C_word*)lf[24]+1,C_fix((C_word)S_IXUSR));
t23=C_mutate((C_word*)lf[25]+1,C_fix((C_word)S_IRGRP));
t24=C_mutate((C_word*)lf[26]+1,C_fix((C_word)S_IWGRP));
t25=C_mutate((C_word*)lf[27]+1,C_fix((C_word)S_IXGRP));
t26=C_mutate((C_word*)lf[28]+1,C_fix((C_word)S_IROTH));
t27=C_mutate((C_word*)lf[29]+1,C_fix((C_word)S_IWOTH));
t28=C_mutate((C_word*)lf[30]+1,C_fix((C_word)S_IXOTH));
t29=C_mutate((C_word*)lf[31]+1,C_fix((C_word)S_IRWXU));
t30=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IRWXG));
t31=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IRWXO));
t32=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_ISVTX));
t33=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_ISUID));
t34=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_ISGID));
t35=(C_word)C_fixnum_or(C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t36=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t35);
t37=C_mutate((C_word*)lf[37]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1091,a[2]=t36,tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[44]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1132,tmp=(C_word)a,a+=2,tmp));
t39=*((C_word*)lf[46]+1);
t40=C_mutate((C_word*)lf[47]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1150,a[2]=t39,tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[51]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1195,tmp=(C_word)a,a+=2,tmp));
t42=*((C_word*)lf[54]+1);
t43=C_mutate((C_word*)lf[55]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1237,a[2]=t42,tmp=(C_word)a,a+=3,tmp));
t44=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1272,tmp=(C_word)a,a+=2,tmp);
t45=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1278,tmp=(C_word)a,a+=2,tmp);
t46=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1288,tmp=(C_word)a,a+=2,tmp);
t47=C_mutate((C_word*)lf[58]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1298,a[2]=t45,a[3]=t46,a[4]=t44,tmp=(C_word)a,a+=5,tmp));
t48=C_mutate((C_word*)lf[61]+1,C_fix((C_word)SEEK_SET));
t49=C_mutate((C_word*)lf[62]+1,C_fix((C_word)SEEK_END));
t50=C_mutate((C_word*)lf[63]+1,C_fix((C_word)SEEK_CUR));
t51=C_mutate(&lf[64],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1493,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[67]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1531,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[68]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1537,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[69]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1543,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[70]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1549,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate((C_word*)lf[71]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1555,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1595,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[81]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1656,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1683,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1710,tmp=(C_word)a,a+=2,tmp));
t61=*((C_word*)lf[87]+1);
t62=*((C_word*)lf[46]+1);
t63=*((C_word*)lf[88]+1);
t64=*((C_word*)lf[89]+1);
t65=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1737,a[2]=t62,a[3]=t64,tmp=(C_word)a,a+=4,tmp));
t66=C_mutate((C_word*)lf[93]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1794,tmp=(C_word)a,a+=2,tmp));
t67=*((C_word*)lf[46]+1);
t68=*((C_word*)lf[89]+1);
t69=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1817,a[2]=t67,a[3]=t68,tmp=(C_word)a,a+=4,tmp));
t70=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1835,tmp=(C_word)a,a+=2,tmp);
t71=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1847,tmp=(C_word)a,a+=2,tmp);
t72=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1853,tmp=(C_word)a,a+=2,tmp);
t73=C_mutate((C_word*)lf[104]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1871,a[2]=t71,a[3]=t72,a[4]=t70,tmp=(C_word)a,a+=5,tmp));
t74=C_mutate((C_word*)lf[106]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1907,a[2]=t71,a[3]=t72,a[4]=t70,tmp=(C_word)a,a+=5,tmp));
t75=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1943,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[110]+1,*((C_word*)lf[107]+1));
t77=*((C_word*)lf[104]+1);
t78=*((C_word*)lf[106]+1);
t79=*((C_word*)lf[107]+1);
t80=*((C_word*)lf[110]+1);
t81=C_mutate((C_word*)lf[111]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1962,a[2]=t77,a[3]=t79,tmp=(C_word)a,a+=4,tmp));
t82=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1986,a[2]=t78,a[3]=t80,tmp=(C_word)a,a+=4,tmp));
t83=C_mutate((C_word*)lf[114]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2010,a[2]=t77,a[3]=t79,tmp=(C_word)a,a+=4,tmp));
t84=C_mutate((C_word*)lf[116]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2030,a[2]=t78,a[3]=t80,tmp=(C_word)a,a+=4,tmp));
t85=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2050,tmp=(C_word)a,a+=2,tmp));
t86=C_mutate((C_word*)lf[120]+1,C_fix((C_word)SIGTERM));
t87=C_mutate((C_word*)lf[121]+1,C_fix((C_word)SIGKILL));
t88=C_mutate((C_word*)lf[122]+1,C_fix((C_word)SIGINT));
t89=C_mutate((C_word*)lf[123]+1,C_fix((C_word)SIGHUP));
t90=C_mutate((C_word*)lf[124]+1,C_fix((C_word)SIGFPE));
t91=C_mutate((C_word*)lf[125]+1,C_fix((C_word)SIGILL));
t92=C_mutate((C_word*)lf[126]+1,C_fix((C_word)SIGSEGV));
t93=C_mutate((C_word*)lf[127]+1,C_fix((C_word)SIGABRT));
t94=C_mutate((C_word*)lf[128]+1,C_fix((C_word)SIGTRAP));
t95=C_mutate((C_word*)lf[129]+1,C_fix((C_word)SIGQUIT));
t96=C_mutate((C_word*)lf[130]+1,C_fix((C_word)SIGALRM));
t97=C_mutate((C_word*)lf[131]+1,C_fix((C_word)SIGVTALRM));
t98=C_mutate((C_word*)lf[132]+1,C_fix((C_word)SIGPROF));
t99=C_mutate((C_word*)lf[133]+1,C_fix((C_word)SIGIO));
t100=C_mutate((C_word*)lf[134]+1,C_fix((C_word)SIGURG));
t101=C_mutate((C_word*)lf[135]+1,C_fix((C_word)SIGCHLD));
t102=C_mutate((C_word*)lf[136]+1,C_fix((C_word)SIGCONT));
t103=C_mutate((C_word*)lf[137]+1,C_fix((C_word)SIGSTOP));
t104=C_mutate((C_word*)lf[138]+1,C_fix((C_word)SIGTSTP));
t105=C_mutate((C_word*)lf[139]+1,C_fix((C_word)SIGPIPE));
t106=C_mutate((C_word*)lf[140]+1,C_fix((C_word)SIGXCPU));
t107=C_mutate((C_word*)lf[141]+1,C_fix((C_word)SIGXFSZ));
t108=C_mutate((C_word*)lf[142]+1,C_fix((C_word)SIGUSR1));
t109=C_mutate((C_word*)lf[143]+1,C_fix((C_word)SIGUSR2));
t110=C_mutate((C_word*)lf[144]+1,C_fix((C_word)SIGWINCH));
t111=*((C_word*)lf[145]+1);
t112=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2094,a[2]=((C_word*)t0)[2],a[3]=t111,tmp=(C_word)a,a+=4,tmp);
t113=*((C_word*)lf[326]+1);
((C_proc4)C_retrieve_proc(t113))(4,t113,t112,C_fix(256),C_SCHEME_FALSE);}

/* k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2094(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2094,2,t0,t1);}
t2=C_mutate((C_word*)lf[146]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2096,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[145]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2109,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[148]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2127,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2155,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4574,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[146]+1);
((C_proc4)C_retrieve_proc(t7))(4,t7,t5,*((C_word*)lf[122]+1),t6);}

/* a4573 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4574(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4574,3,t0,t1,t2);}
t3=*((C_word*)lf[325]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

/* k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word ab[45],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2155,2,t0,t1);}
t2=C_mutate((C_word*)lf[150]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2157,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[153]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2195,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[155]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2248,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate(&lf[156],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2309,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[157]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2316,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[161]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2379,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[164]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2453,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[166]+1,C_fix((C_word)EPERM));
t10=C_mutate((C_word*)lf[167]+1,C_fix((C_word)ENOENT));
t11=C_mutate((C_word*)lf[168]+1,C_fix((C_word)ESRCH));
t12=C_mutate((C_word*)lf[169]+1,C_fix((C_word)EINTR));
t13=C_mutate((C_word*)lf[170]+1,C_fix((C_word)EIO));
t14=C_mutate((C_word*)lf[171]+1,C_fix((C_word)ENOEXEC));
t15=C_mutate((C_word*)lf[172]+1,C_fix((C_word)EBADF));
t16=C_mutate((C_word*)lf[173]+1,C_fix((C_word)ECHILD));
t17=C_mutate((C_word*)lf[174]+1,C_fix((C_word)ENOMEM));
t18=C_mutate((C_word*)lf[175]+1,C_fix((C_word)EACCES));
t19=C_mutate((C_word*)lf[176]+1,C_fix((C_word)EFAULT));
t20=C_mutate((C_word*)lf[177]+1,C_fix((C_word)EBUSY));
t21=C_mutate((C_word*)lf[178]+1,C_fix((C_word)ENOTDIR));
t22=C_mutate((C_word*)lf[179]+1,C_fix((C_word)EISDIR));
t23=C_mutate((C_word*)lf[180]+1,C_fix((C_word)EINVAL));
t24=C_mutate((C_word*)lf[181]+1,C_fix((C_word)EMFILE));
t25=C_mutate((C_word*)lf[182]+1,C_fix((C_word)ENOSPC));
t26=C_mutate((C_word*)lf[183]+1,C_fix((C_word)ESPIPE));
t27=C_mutate((C_word*)lf[184]+1,C_fix((C_word)EPIPE));
t28=C_mutate((C_word*)lf[185]+1,C_fix((C_word)EAGAIN));
t29=C_mutate((C_word*)lf[186]+1,C_fix((C_word)EROFS));
t30=C_mutate((C_word*)lf[187]+1,C_fix((C_word)EWOULDBLOCK));
t31=C_mutate((C_word*)lf[188]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2500,tmp=(C_word)a,a+=2,tmp));
t32=C_mutate((C_word*)lf[190]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2530,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[192]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2563,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[193]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2566,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[194]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2569,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[195]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2572,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[196]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2575,tmp=(C_word)a,a+=2,tmp));
t38=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2590,tmp=(C_word)a,a+=2,tmp);
t39=C_mutate((C_word*)lf[198]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2614,a[2]=t38,tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[199]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2620,a[2]=t38,tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[200]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2626,a[2]=t38,tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[201]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2632,tmp=(C_word)a,a+=2,tmp));
t43=*((C_word*)lf[89]+1);
t44=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2672,a[2]=((C_word*)t0)[2],a[3]=t43,tmp=(C_word)a,a+=4,tmp);
t45=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
t46=*((C_word*)lf[46]+1);
((C_proc3)C_retrieve_proc(t46))(3,t46,t44,t45);}

/* k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word ab[125],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2672,2,t0,t1);}
t2=C_mutate((C_word*)lf[204]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2673,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[206]+1,C_fix((C_word)STDIN_FILENO));
t4=C_mutate((C_word*)lf[207]+1,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate((C_word*)lf[208]+1,C_fix((C_word)STDERR_FILENO));
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2705,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2742,tmp=(C_word)a,a+=2,tmp);
t8=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2760,a[2]=t6,a[3]=t7,tmp=(C_word)a,a+=4,tmp));
t9=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2774,a[2]=t6,a[3]=t7,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2788,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2823,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[225]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2853,tmp=(C_word)a,a+=2,tmp));
t13=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2895,tmp=(C_word)a,a+=2,tmp);
t14=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2969,tmp=(C_word)a,a+=2,tmp);
t15=C_mutate((C_word*)lf[229]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2990,a[2]=t13,a[3]=t14,tmp=(C_word)a,a+=4,tmp));
t16=C_mutate((C_word*)lf[231]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3005,a[2]=t13,a[3]=t14,tmp=(C_word)a,a+=4,tmp));
t17=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3020,a[2]=t13,a[3]=t14,tmp=(C_word)a,a+=4,tmp));
t18=C_mutate((C_word*)lf[235]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3042,tmp=(C_word)a,a+=2,tmp));
t19=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3073,tmp=(C_word)a,a+=2,tmp));
t20=C_mutate((C_word*)lf[239]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3119,tmp=(C_word)a,a+=2,tmp));
t21=C_mutate((C_word*)lf[241]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3148,tmp=(C_word)a,a+=2,tmp));
t22=C_mutate((C_word*)lf[242]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3165,tmp=(C_word)a,a+=2,tmp));
t23=*((C_word*)lf[89]+1);
t24=C_mutate((C_word*)lf[243]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3185,a[2]=t23,tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[244]+1,C_fix((C_word)PROT_READ));
t26=C_mutate((C_word*)lf[245]+1,C_fix((C_word)PROT_WRITE));
t27=C_mutate((C_word*)lf[246]+1,C_fix((C_word)PROT_EXEC));
t28=C_mutate((C_word*)lf[247]+1,C_fix((C_word)PROT_NONE));
t29=C_mutate((C_word*)lf[248]+1,C_fix((C_word)MAP_FIXED));
t30=C_mutate((C_word*)lf[249]+1,C_fix((C_word)MAP_SHARED));
t31=C_mutate((C_word*)lf[250]+1,C_fix((C_word)MAP_PRIVATE));
t32=C_mutate((C_word*)lf[251]+1,C_fix((C_word)MAP_ANONYMOUS));
t33=C_mutate((C_word*)lf[252]+1,C_fix((C_word)MAP_FILE));
t34=C_mutate((C_word*)lf[253]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3288,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[259]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3353,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[261]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3391,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[262]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3400,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[264]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3409,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[265]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3428,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[267]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3445,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[270]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3479,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[272]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3498,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[273]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3505,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3564,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[280]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3593,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[282]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3623,tmp=(C_word)a,a+=2,tmp));
t47=*((C_word*)lf[284]+1);
t48=*((C_word*)lf[90]+1);
t49=*((C_word*)lf[285]+1);
t50=*((C_word*)lf[286]+1);
t51=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3638,a[2]=t47,a[3]=t48,a[4]=t49,a[5]=t50,tmp=(C_word)a,a+=6,tmp));
t52=C_mutate((C_word*)lf[291]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3744,tmp=(C_word)a,a+=2,tmp));
t53=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3789,tmp=(C_word)a,a+=2,tmp);
t54=*((C_word*)lf[293]+1);
t55=C_mutate((C_word*)lf[294]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3808,a[2]=t54,a[3]=t53,tmp=(C_word)a,a+=4,tmp));
t56=C_mutate((C_word*)lf[296]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3898,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[298]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3977,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3980,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3983,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[301]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3990,tmp=(C_word)a,a+=2,tmp));
t61=*((C_word*)lf[291]+1);
t62=*((C_word*)lf[294]+1);
t63=*((C_word*)lf[303]+1);
t64=C_mutate((C_word*)lf[304]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4020,a[2]=t61,a[3]=t63,a[4]=t62,tmp=(C_word)a,a+=5,tmp));
t65=*((C_word*)lf[118]+1);
t66=*((C_word*)lf[291]+1);
t67=*((C_word*)lf[223]+1);
t68=*((C_word*)lf[44]+1);
t69=*((C_word*)lf[304]+1);
t70=*((C_word*)lf[46]+1);
t71=*((C_word*)lf[47]+1);
t72=*((C_word*)lf[308]+1);
t73=*((C_word*)lf[309]+1);
t74=*((C_word*)lf[51]+1);
t75=*((C_word*)lf[296]+1);
t76=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4070,a[2]=t75,tmp=(C_word)a,a+=3,tmp);
t77=C_mutate((C_word*)lf[310]+1,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4090,a[2]=t66,a[3]=t67,a[4]=t70,a[5]=t72,a[6]=t73,a[7]=t68,a[8]=t76,a[9]=t65,tmp=(C_word)a,a+=10,tmp));
t78=*((C_word*)lf[287]+1);
t79=*((C_word*)lf[288]+1);
t80=*((C_word*)lf[285]+1);
t81=*((C_word*)lf[93]+1);
t82=C_mutate((C_word*)lf[318]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4350,a[2]=t81,a[3]=t80,a[4]=t78,a[5]=t79,tmp=(C_word)a,a+=6,tmp));
t83=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t83+1)))(2,t83,t82);}

/* find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4350(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_4350r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4350r(t0,t1,t2,t3,t4);}}

static void f_4350r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4352,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4491,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4496,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4501,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
t9=t8;
f_4501(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
t11=t7;
f_4496(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
t13=t6;
f_4491(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
t15=t5;
f_4352(t15,t1,t9,t11,t13);}
else{
t15=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action789 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4501(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4501,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4507,tmp=(C_word)a,a+=2,tmp);
t3=((C_word*)t0)[2];
f_4496(t3,t1,t2);}

/* a4506 in def-action789 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4507(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4507,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id790 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4496(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4496,NULL,3,t0,t1,t2);}
t3=((C_word*)t0)[2];
f_4491(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit791 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4491(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4491,NULL,4,t0,t1,t2,t3);}
t4=((C_word*)t0)[2];
f_4352(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4352(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4352,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[318]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4359,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_4359(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4486,a[2]=t4,a[3]=t7,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t10=t8;
f_4359(t10,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4478,tmp=(C_word)a,a+=2,tmp));}}

/* f_4478 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4478(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4478,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_4486 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4486(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4486,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4359(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4359,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4470,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4369,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4466,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[324]);}

/* k4464 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4369(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4369,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4371,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_4371(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4371(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4371,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4390,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4390,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4446,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=*((C_word*)lf[323]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4452,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k4450 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4452(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4452,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4459,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)((C_word*)t0)[7])[1];
f_4371(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k4457 in k4450 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4459(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
f_4371(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4446(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4446,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[319]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[320]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
t2=((C_word*)((C_word*)t0)[10])[1];
f_4371(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4405,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4405,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4415,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4417,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4422,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4436,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t11=*((C_word*)lf[322]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=((C_word*)((C_word*)t0)[8])[1];
f_4371(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a4435 in k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4436(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4436,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4421 in k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4422,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4430,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4434,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[321]);}

/* k4432 in a4421 in k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4434(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4428 in a4421 in k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
f_4371(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a4416 in k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4417,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4413 in k4403 in k4444 in k4388 in loop in k4367 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
f_4371(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_4470 in k4357 in body787 in find-files in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4470(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4470,3,t0,t1,t2);}
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4090(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4090,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4096,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4102,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
C_call_with_values(4,0,t1,t3,t4);}

/* a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4102(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[15],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4102,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4108,a[2]=((C_word*)t0)[10],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_4114,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=t3,tmp=(C_word)a,a+=12,tmp);
C_call_with_values(4,0,t1,t4,t5);}

/* a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4114(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[22],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4114,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4118,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=t1,a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4304,a[2]=((C_word*)t0)[11],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=t3,a[8]=((C_word*)t0)[10],tmp=(C_word)a,a+=9,tmp);
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t4,t5);}

/* a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4304,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4308,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t1,a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4308,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4311,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=((C_word*)t0)[5];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4309 in k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4311,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4314,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[206]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f_4314(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4345,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[206]+1));}}

/* k4343 in k4309 in k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4312 in k4309 in k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4314(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4314,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4317,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[207]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f_4317(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4336,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[207]+1));}}

/* k4334 in k4312 in k4309 in k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4336(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4315 in k4312 in k4309 in k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4317,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4320,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[303]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[317]);}

/* k4318 in k4315 in k4312 in k4309 in k4306 in a4303 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4320,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[315]);
t3=(C_word)C_a_i_list(&a,2,lf[316],((C_word*)t0)[3]);
t4=*((C_word*)lf[294]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,((C_word*)t0)[2],t2,t3);}

/* k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4118,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_4121,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
t7=((C_word*)t0)[7];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[2]);}

/* k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4121(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4121,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_4124,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
t3=((C_word*)t0)[6];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4124(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4124,2,t0,t1);}
t2=f_1029(((C_word*)t0)[13]);
t3=f_1029(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_4137,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

/* k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4137(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[41],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4137,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4139,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4184,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4256,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4275,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4291,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t11=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t11))(5,t11,t7,t8,t9,t10);}

/* a4290 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4291,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4295,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4293 in a4290 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
t3=((C_word*)t0)[4];
f_4070(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4274 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4275(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4275,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)C_i_foreign_fixnum_argumentp(t3);
t5=(C_word)stub709(C_SCHEME_UNDEFINED,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_eqp(C_fix(1),t5));}}

/* a4255 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4256,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4260,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[2];
f_4139(t3,t2);}

/* k4258 in a4255 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4260(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fudge(C_fix(1)));}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4184,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4188,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4190,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4243,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t2,t3,t4);}

/* a4242 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4243(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4243,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4247,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k4245 in a4242 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
t3=((C_word*)t0)[4];
f_4070(t3,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a4189 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4190(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[13],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4190,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4199,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_4199(t10,t1);}

/* loop in a4189 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4199(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4199,NULL,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4215,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
f_1036(t5);}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4221,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4234,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=*((C_word*)lf[89]+1);
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4232 in loop in a4189 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
t5=((C_word*)((C_word*)t0)[3])[1];
f_4199(t5,((C_word*)t0)[2]);}

/* k4219 in loop in a4189 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[39],lf[314],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4213 in loop in a4189 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4215(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
f_4199(t2,((C_word*)t0)[2]);}

/* k4186 in k4182 in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4139(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4139,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4149,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4153,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_4153(t6,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4153(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4153,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4169,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[312]+1);
((C_proc5)C_retrieve_proc(t6))(5,t6,t5,*((C_word*)lf[4]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4178,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k4176 in loop in fetch in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4178(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[310],lf[313],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k4167 in loop in fetch in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4169(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4169,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4172,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
f_1036(t2);}

/* k4170 in k4167 in loop in fetch in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
f_4153(t2,((C_word*)t0)[2]);}

/* k4147 in fetch in k4135 in k4122 in k4119 in k4116 in a4113 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a4107 in a4101 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4108,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* a4095 in process in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4096,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* wait in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_4070(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4070,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4076,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4082,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
C_call_with_values(4,0,t1,t3,t4);}

/* a4081 in wait in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4082(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4082,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[98]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[310],lf[311],((C_word*)t0)[2],t4);}}

/* a4075 in wait in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4076,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4020(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4020r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4020r(t0,t1,t2,t3);}}

static void f_4020r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4027,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k4025 in process-run in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4027,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
t3=((C_word*)t0)[5];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4042,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,lf[307]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k4040 in k4025 in process-run in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4042(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4042,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[305]);
t3=(C_word)C_a_i_list(&a,2,lf[306],((C_word*)t0)[4]);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3990(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3990r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3990r(t0,t1,t2,t3);}}

static void f_3990r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[301]);
t7=(C_word)C_i_check_exact_2(t5,lf[301]);
t8=(C_word)C_kill(t2,t5);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4003,a[2]=t5,a[3]=t2,a[4]=t1,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
t10=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}

/* k4001 in process-signal in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_4003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[98]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[4],lf[301],lf[302],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* sleep in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3983(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3983,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub676(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3980,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub673(C_SCHEME_UNDEFINED));}

/* current-process-id in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3977(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3977,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub671(C_SCHEME_UNDEFINED));}

/* process-wait in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3898(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2r,(void*)f_3898r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3898r(t0,t1,t2);}}

static void f_3898r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a=C_alloc(6);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_i_check_exact_2(t11,lf[296]);
t14=(C_word)C_waitpid(t11,t12);
t15=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3929,a[2]=t15,a[3]=t11,a[4]=t1,a[5]=t14,tmp=(C_word)a,a+=6,tmp);
t17=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t17+1)))(2,t17,t16);}
else{
t11=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* k3927 in process-wait in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[4],lf[296],lf[297],((C_word*)t0)[3]);}
else{
t3=(C_truep(((C_word*)t0)[2])?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[2],t3);}}

/* process-execute in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3808(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3808r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3808r(t0,t1,t2,t3);}}

static void f_3808r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(6);
t4=(C_word)C_i_check_string_2(t2,lf[294]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_END_OF_LIST);
t7=(C_word)C_i_check_list_2(t6,lf[294]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3821,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t9=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t9))(3,t9,t8,t2);}

/* k3819 in process-execute in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3821,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_3789(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3829,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_3829(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do639 in k3819 in process-execute in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_3829(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3829,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_3789(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3843,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3862,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[3]);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[294]);
t6=(C_word)C_block_size(t4);
t7=f_3789(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t14=t1;
t15=t8;
t16=t9;
t1=t14;
t2=t15;
t3=t16;
goto loop;}}

/* k3860 in do639 in k3819 in process-execute in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3841 in do639 in k3819 in process-execute in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3843(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3843,2,t0,t1);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3846,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3844 in k3841 in do639 in k3819 in process-execute in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3846(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=(C_word)stub633(C_SCHEME_UNDEFINED);
t4=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],lf[294],lf[295],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* setarg in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_3789(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub626(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3744(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3744r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3744r(t0,t1,t2);}}

static void f_3744r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t3=(C_word)stub610(C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3751,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

/* k3749 in process-fork in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3751(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3751,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],lf[291],lf[292]);}
else{
t3=(C_word)C_notvemptyp(((C_word*)t0)[2]);
t4=(C_truep(t3)?(C_word)C_eqp(((C_word*)t0)[4],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3769,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_i_vector_ref(((C_word*)t0)[2],C_fix(0));
t7=t6;
((C_proc2)C_retrieve_proc(t7))(2,t7,t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[4]);}}}

/* k3767 in k3749 in process-fork in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3769,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3773,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_3773 in k3767 in k3749 in process-fork in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3773(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3773,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub615(C_SCHEME_UNDEFINED,t3));}

/* glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3638(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3638r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3638r(t0,t1,t2);}}

static void f_3638r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3644,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3644(t6,t1,t2);}

/* conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_3644(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3644,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3659,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3665,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
C_call_with_values(4,0,t1,t4,t5);}}

/* a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3665(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3665,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3669,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3736,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[290]);
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3734 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k3667 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3669(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3669,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3676,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[289]);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t2,t3);}

/* k3674 in k3667 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3676(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3676,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3678,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3678(t5,((C_word*)t0)[2],t1);}

/* loop in k3674 in k3667 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_3678(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3678,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
t4=((C_word*)((C_word*)t0)[6])[1];
f_3644(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3695,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
t5=*((C_word*)lf[288]+1);
((C_proc4)C_retrieve_proc(t5))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3693 in loop in k3674 in k3667 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3695(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3695,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3705,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
t3=((C_word*)((C_word*)t0)[4])[1];
f_3678(t3,((C_word*)t0)[6],t2);}}

/* k3703 in k3693 in loop in k3674 in k3667 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3705,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3709,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
t4=((C_word*)((C_word*)t0)[2])[1];
f_3678(t4,t2,t3);}

/* k3707 in k3703 in k3693 in loop in k3674 in k3667 in a3664 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3709,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3658 in conc in glob in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3659,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3623,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3627,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t4=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub574(t3),C_fix(0));}

/* k3625 in get-host-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3627(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3627,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3630,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3630(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3633,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3631 in k3625 in get-host-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3633(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[282],lf[283]);}

/* k3628 in k3625 in get-host-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3593(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3593,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3597,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[280]);}

/* k3595 in terminal-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3597(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3597,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3600,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[2],C_fix(7));
t4=(C_word)C_eqp(lf[73],t3);
t5=(C_truep(t4)?(C_word)C_tty_portp(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;
f_3600(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t2,lf[280],lf[281],((C_word*)t0)[2]);}}

/* k3598 in k3595 in terminal-name in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3600,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub566(t4,t5);
t7=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* terminal-port? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3564(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3564,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3568,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[279]);}

/* k3566 in terminal-port? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3568(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3568,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3571,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[222]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k3569 in k3566 in terminal-port? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3505(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3505r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3505r(t0,t1,t2,t3,t4);}}

static void f_3505r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3509,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[273]);}

/* k3507 in set-buffering-mode! in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3509,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3515,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[275]);
if(C_truep(t6)){
t7=t5;
f_3515(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[276]);
if(C_truep(t7)){
t8=t5;
f_3515(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[277]);
if(C_truep(t8)){
t9=t5;
f_3515(2,t9,C_fix((C_word)_IONBF));}
else{
t9=*((C_word*)lf[98]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[273],lf[278],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k3513 in k3507 in set-buffering-mode! in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[273]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[73],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
t6=*((C_word*)lf[98]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[273],lf[274],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3498(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3498,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub549(C_SCHEME_UNDEFINED,t3));}

/* _exit in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3479(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3479r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3479r(t0,t1,t2);}}

static void f_3479r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3483,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[271]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k3481 in _exit in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub543(C_SCHEME_UNDEFINED,t5));}

/* time->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3445(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3445,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[267]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3452,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
t6=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[267],lf[269],t2);}
else{
t6=t4;
f_3452(2,t6,C_SCHEME_UNDEFINED);}}

/* k3450 in time->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3452(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3452,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3455,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub532(t4,t3),C_fix(0));}

/* k3453 in k3450 in time->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3455(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3455,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3458,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3458(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[267],lf[268],((C_word*)t0)[2]);}}

/* k3456 in k3453 in k3450 in time->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3428(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3428,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3432,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub523(t5,t6);
t8=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3430 in seconds->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3432,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3435,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_3435(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[265],lf[266],((C_word*)t0)[2]);}}

/* k3433 in k3430 in seconds->string in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3435(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3409(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3409,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[264]);
t4=*((C_word*)lf[263]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3400(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3400,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[262]);
t4=*((C_word*)lf[263]+1);
((C_proc4)C_retrieve_proc(t4))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file-pointer in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3391(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3391,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[254],lf[261]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3353(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3353r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3353r(t0,t1,t2,t3);}}

static void f_3353r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_structure_2(t2,lf[254],lf[259]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub504(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3369,a[2]=t6,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t13=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,t12);}}

/* k3367 in unmap-file-from-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3369(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[259],lf[260],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* map-file-to-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3288(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc(c,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_3288r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_3288r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f_3288r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3292,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_3292(2,t10,t2);}
else{
t10=*((C_word*)lf[258]+1);
((C_proc2)C_retrieve_proc(t10))(2,t10,t8);}}

/* k3290 in map-file-to-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3292,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3298,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_3298(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[49],lf[253],lf[257],t1);}}

/* k3296 in k3290 in map-file-to-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3298,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub478(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3304,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3320,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
t17=*((C_word*)lf[256]+1);
((C_proc3)C_retrieve_proc(t17))(3,t17,t16,t14);}

/* k3318 in k3296 in k3290 in map-file-to-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3320,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3313,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[8];
f_3304(2,t3,C_SCHEME_UNDEFINED);}}

/* k3311 in k3318 in k3296 in k3290 in map-file-to-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3313(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc11)(void*)(*((C_word*)t2+1)))(11,t2,((C_word*)t0)[8],lf[39],lf[253],lf[255],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3302 in k3296 in k3290 in map-file-to-memory in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3304,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[254],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3185(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3185,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3191,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3191(t5,t1,C_fix(0));}

/* loop in current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_3191(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3191,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3195,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub460(t5,t6);
t8=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k3193 in loop in current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3195(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3195,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3203,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_3203(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k3193 in loop in current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_3203(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3203,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3229,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[3];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k3227 in scan in k3193 in loop in current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3229,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3233,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k3231 in k3227 in scan in k3193 in loop in current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3233(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3233,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3221,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[2])[1];
f_3191(t5,t3,t4);}

/* k3219 in k3231 in k3227 in scan in k3193 in loop in current-environment in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3221,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3165(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3165,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[242]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3173,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3171 in unsetenv in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3173(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3148(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3148,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[241]);
t5=(C_word)C_i_check_string_2(t3,lf[241]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3159,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3157 in setenv in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3159(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3159,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3163,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3161 in k3157 in setenv in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3119(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3119,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[239]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3126,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3146,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k3144 in fifo? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[94]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3124 in fifo? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3126(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3126,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3129,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3127 in k3124 in fifo? in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[239],lf[240],((C_word*)t0)[2]);}}

/* create-fifo in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3073(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3073r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3073r(t0,t1,t2,t3);}}

static void f_3073r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[237]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3080,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_3080(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_3080(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k3078 in create-fifo in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_3080(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3080,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[237]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3100,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3104,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,((C_word*)t0)[2]);}

/* k3102 in k3078 in create-fifo in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3104(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3098 in k3078 in create-fifo in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3100,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3092,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3090 in k3098 in k3078 in create-fifo in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[237],lf[238],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-unlock in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3042(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3042,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[228],lf[235]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3063,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t10=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t9);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* k3061 in file-unlock in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[235],lf[236],((C_word*)t0)[2]);}

/* file-test-lock in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3020(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3020r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3020r(t0,t1,t2,t3);}}

static void f_3020r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3024,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f_2895(t4,t2,t3,lf[233]);}

/* k3022 in file-test-lock in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
f_2969(((C_word*)t0)[3],lf[234],t1,lf[233]);}}

/* file-lock/blocking in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3005(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3005r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3005r(t0,t1,t2,t3);}}

static void f_3005r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3009,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f_2895(t4,t2,t3,lf[231]);}

/* k3007 in file-lock/blocking in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_3009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
f_2969(((C_word*)t0)[2],lf[232],t1,lf[231]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2990(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2990r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2990r(t0,t1,t2,t3);}}

static void f_2990r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2994,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f_2895(t4,t2,t3,lf[229]);}

/* k2992 in file-lock in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2994(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
f_2969(((C_word*)t0)[2],lf[230],t1,lf[229]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2969(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2969,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2973,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k2971 in err in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(2));
t4=(C_word)C_slot(((C_word*)t0)[5],C_fix(3));
t5=*((C_word*)lf[38]+1);
((C_proc8)(void*)(*((C_word*)t5+1)))(8,t5,((C_word*)t0)[4],lf[39],((C_word*)t0)[3],((C_word*)t0)[2],t2,t3,t4);}

/* setup in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2895(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2895,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2917,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
t16=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
t15=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k2915 in setup in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2917,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2923,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_2923(t6,t5);}
else{
t5=t3;
f_2923(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k2921 in k2915 in setup in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2923(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2923,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[228],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2853(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2853,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[225]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2873,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2880,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2884,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_2873(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
t6=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[225],lf[227],t2);}}}

/* k2882 in file-truncate in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2884(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2878 in file-truncate in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2873(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k2871 in file-truncate in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2873,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2866,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2864 in k2871 in file-truncate in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2866(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[225],lf[226],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* duplicate-fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2823(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2823r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2823r(t0,t1,t2,t3);}}

static void f_2823r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[223]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2830,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_2830(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[223]);
t8=t5;
f_2830(t8,(C_word)C_dup2(t2,t6));}}

/* k2828 in duplicate-fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2830(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2830,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2833,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2839,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2833(2,t3,C_SCHEME_UNDEFINED);}}

/* k2837 in k2828 in duplicate-fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[223],lf[224],((C_word*)t0)[2]);}

/* k2831 in k2828 in duplicate-fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2833(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2788(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2788,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2792,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[219]);}

/* k2790 in port->fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2792,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2821,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[222]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k2819 in k2790 in port->fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2821,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[49],lf[219],lf[220],((C_word*)t0)[2]);}
else{
t2=(C_word)C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2801,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2807,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2801(2,t4,C_SCHEME_UNDEFINED);}}}

/* k2805 in k2819 in k2790 in port->fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2807(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[219],lf[221],((C_word*)t0)[2]);}

/* k2799 in k2819 in k2790 in port->fileno in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2774(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2774r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2774r(t0,t1,t2,t3);}}

static void f_2774r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[218]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2786,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f_2705(t5,C_SCHEME_FALSE,t3);}

/* k2784 in open-output-file* in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2786,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
f_2742(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2760(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_2760r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2760r(t0,t1,t2,t3);}}

static void f_2760r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[217]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2772,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
f_2705(t5,C_SCHEME_TRUE,t3);}

/* k2770 in open-input-file* in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2772,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
f_2742(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2742(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2742,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2746,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k2744 in check in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2746(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2746,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[38]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[39],lf[215],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2758,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[101]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[102]+1),lf[216],lf[73]);}}

/* k2756 in k2744 in check in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2705(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2705,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2713,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[209]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
t8=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[210],t5);}
else{
t8=t4;
f_2713(2,t8,lf[211]);}}
else{
t7=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[212],t5);}}
else{
t5=t4;
f_2713(2,t5,(C_truep(t2)?lf[213]:lf[214]));}}

/* k2711 in mode in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* read-symbolic-link in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2673(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2673,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[204]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2681,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2700,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k2698 in read-symbolic-link in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2679 in read-symbolic-link in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2681,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2684,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2693,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2684(2,t4,C_SCHEME_UNDEFINED);}}

/* k2691 in k2679 in read-symbolic-link in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[204],lf[205],((C_word*)t0)[2]);}

/* k2682 in k2679 in read-symbolic-link in k2670 in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2632(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2632,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[201]);
t5=(C_word)C_i_check_string_2(t3,lf[201]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2656,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2668,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2666 in create-symbolic-link in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2654 in create-symbolic-link in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2656,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2660,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2664,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2662 in k2654 in create-symbolic-link in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2658 in k2654 in create-symbolic-link in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2660(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2660,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2648,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2646 in k2658 in k2654 in create-symbolic-link in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[202],lf[203],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-execute-access? in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2626(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2626,3,t0,t1,t2);}
f_2590(t1,t2,C_fix((C_word)X_OK),lf[200]);}

/* file-write-access? in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2620(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2620,3,t0,t1,t2);}
f_2590(t1,t2,C_fix((C_word)W_OK),lf[199]);}

/* file-read-access? in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2614(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2614,3,t0,t1,t2);}
f_2590(t1,t2,C_fix((C_word)R_OK),lf[198]);}

/* check in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2590(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2590,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2608,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2612,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2610 in check in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2612(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2606 in check in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2608(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2608,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2600,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_2600(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k2598 in k2606 in check in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-user-id! in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2575(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2575,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2585,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2583 in set-user-id! in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[196],lf[197],((C_word*)t0)[2]);}

/* current-effective-group-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2572(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2572,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub329(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2569,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub327(C_SCHEME_UNDEFINED));}

/* current-group-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2566,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub325(C_SCHEME_UNDEFINED));}

/* current-user-id in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2563,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub323(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2530(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc(c,5);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_2530,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[190]);
t6=(C_word)C_i_check_exact_2(t3,lf[190]);
t7=(C_word)C_i_check_exact_2(t4,lf[190]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2557,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2561,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t10))(3,t10,t9,t2);}

/* k2559 in change-file-owner in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2555 in change-file-owner in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2557,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2549,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2547 in k2555 in change-file-owner in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[39],lf[190],lf[191],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* change-file-mode in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2500(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2500,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[188]);
t5=(C_word)C_i_check_exact_2(t3,lf[188]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2524,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2528,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t2);}

/* k2526 in change-file-mode in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2522 in change-file-mode in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2524(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2524,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2516,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2514 in k2522 in change-file-mode in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2516(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[188],lf[189],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* initialize-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2453(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2453,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[164]);
t5=(C_word)C_i_check_exact_2(t3,lf[164]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2441,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
t10=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_2441(2,t9,C_SCHEME_FALSE);}}

/* k2439 in initialize-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2441(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2441,2,t0,t1);}
t2=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=(C_word)stub300(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2469,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2467 in k2439 in initialize-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2469(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[164],lf[165],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2379(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2379,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2383,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_2309(t4);
if(C_truep(t5)){
t6=t3;
f_2383(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[161],lf[163]);}}

/* k2381 in set-groups! in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2383(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2383,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2388,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2388(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do287 in k2381 in set-groups! in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2388(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2388,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2404,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[161]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k2402 in do287 in k2381 in set-groups! in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2404(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[161],lf[162],((C_word*)t0)[2]);}

/* get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2316,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2320,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2374,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2320(2,t4,C_SCHEME_UNDEFINED);}}

/* k2372 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[157],lf[160]);}

/* k2318 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2320,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2323,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_2309(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_2323(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[157],lf[159]);}}

/* k2321 in k2318 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2323(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2323,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2326,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=(C_word)stub269(C_SCHEME_UNDEFINED,t3);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2355,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t2;
f_2326(2,t5,C_SCHEME_UNDEFINED);}}

/* k2353 in k2321 in k2318 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[157],lf[158]);}

/* k2324 in k2321 in k2318 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2326(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2326,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2331,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2331(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k2324 in k2321 in k2318 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2331(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2331,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2345,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2343 in loop in k2324 in k2321 in k2318 in get-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2345,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_2309(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub273(C_SCHEME_UNDEFINED,t2));}

/* group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2248(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2248,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2252,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2252(t4,(C_word)C_getgrgid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[155]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2300,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2298 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2252(t2,(C_word)C_getgrnam(t1));}

/* k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2252(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2252,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2262,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2260 in k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2262,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2266,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2264 in k2260 in k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2266,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2270,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2272,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f_2272(t6,t2,C_fix(0));}

/* rec in k2264 in k2260 in k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2272(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2272,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2276,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub257(t5,t6);
t8=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2274 in rec in k2264 in k2260 in k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2276,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2286,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=((C_word*)((C_word*)t0)[2])[1];
f_2272(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2284 in k2274 in rec in k2264 in k2260 in k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2286(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2286,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2268 in k2264 in k2260 in k2250 in group-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2270(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(6,0,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2195(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2195,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2199,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2199(t4,(C_word)C_getpwuid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[153]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2235,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2233 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2199(t2,(C_word)C_getpwnam(t1));}

/* k2197 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_2199(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2199,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2209,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2207 in k2197 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2209(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2209,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2213,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2211 in k2207 in k2197 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2213,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2217,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2215 in k2211 in k2207 in k2197 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2217,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2221,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2219 in k2215 in k2211 in k2207 in k2197 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2221(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2221,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2225,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[154]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2223 in k2219 in k2215 in k2211 in k2207 in k2197 in user-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2225(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2225,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,7,((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2157,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2161,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2190,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2161(2,t3,C_SCHEME_UNDEFINED);}}

/* k2188 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[150],lf[152]);}

/* k2159 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2161,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2168,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2166 in k2159 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2168,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2172,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2170 in k2166 in k2159 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2172,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2176,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2174 in k2170 in k2166 in k2159 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2176(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2176,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2180,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2178 in k2174 in k2170 in k2166 in k2159 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2180,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2184,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[151]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2182 in k2178 in k2174 in k2170 in k2166 in k2159 in system-information in k2153 in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(7,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* set-signal-mask! in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2127(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2127,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[148]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2134,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2148,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[60]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a2147 in set-signal-mask! in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2148(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2148,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[148]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k2132 in set-signal-mask! in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2134(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2134,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2143,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2141 in k2132 in set-signal-mask! in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2143(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[148],lf[149]);}

/* ##sys#interrupt-hook in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2109(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2109,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2119,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k2117 in ##sys#interrupt-hook in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[147]+1);
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2092 in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2096(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc(c,4);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2096,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[146]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2050,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2054,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2063,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2054(2,t3,C_SCHEME_UNDEFINED);}}

/* k2061 in create-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[39],lf[118],lf[119]);}

/* k2052 in create-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2054(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2030(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2030r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2030r(t0,t1,t2,t3,t4);}}

static void f_2030r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[117]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2034,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2032 in with-output-to-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2034(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2034,2,t0,t1);}
t2=C_mutate((C_word*)lf[117]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2040,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2039 in k2032 in with-output-to-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2040(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2040r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2040r(t0,t1,t2);}}

static void f_2040r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2044,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2042 in a2039 in k2032 in with-output-to-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[117]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[112]+1),((C_word*)t0)[2]);}

/* with-input-from-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2010(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2010r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2010r(t0,t1,t2,t3,t4);}}

static void f_2010r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[115]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2014,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2012 in with-input-from-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2014,2,t0,t1);}
t2=C_mutate((C_word*)lf[115]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2020,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2019 in k2012 in with-input-from-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2020(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2020r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2020r(t0,t1,t2);}}

static void f_2020r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2024,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2022 in a2019 in k2012 in with-input-from-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[115]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[112]+1),((C_word*)t0)[2]);}

/* call-with-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1986(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1986r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1986r(t0,t1,t2,t3,t4);}}

static void f_1986r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1990,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k1988 in call-with-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1990,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1995,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2001,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2000 in k1988 in call-with-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2001(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2001r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2001r(t0,t1,t2);}}

static void f_2001r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2005,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2003 in a2000 in k1988 in call-with-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_2005(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[112]+1),((C_word*)t0)[2]);}

/* a1994 in k1988 in call-with-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1995(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1995,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1962(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1962r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1962r(t0,t1,t2,t3,t4);}}

static void f_1962r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1966,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k1964 in call-with-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1966,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1971,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1977,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a1976 in k1964 in call-with-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1977(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_1977r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_1977r(t0,t1,t2);}}

static void f_1977r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1981,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k1979 in a1976 in k1964 in call-with-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[112]+1),((C_word*)t0)[2]);}

/* a1970 in k1964 in call-with-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1971(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1971,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1943(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1943,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1947,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[109]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[107]);}

/* k1945 in close-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1947(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1947,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1950,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1948 in k1945 in close-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[39],lf[107],lf[108],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1907(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_1907r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1907r(t0,t1,t2,t3);}}

static void f_1907r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[106]);
t5=f_1835(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1921,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[97]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1928,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[105]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1938,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
f_1847(t6,t5);}}}

/* k1936 in open-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1938(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1938,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1921(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k1926 in open-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1928,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1921(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k1919 in open-output-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f_1853(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1871(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc(c,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_1871r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1871r(t0,t1,t2,t3);}}

static void f_1871r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[104]);
t5=f_1835(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1885,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[97]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1892,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[105]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1902,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t10=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
f_1847(t6,t5);}}}

/* k1900 in open-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1902(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1902,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1885(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k1890 in open-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1892,2,t0,t1);}
t2=((C_word*)t0)[2];
f_1885(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k1883 in open-input-pipe in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1885(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f_1853(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1853(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1853,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1857,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1855 in check in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1857(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1857,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[38]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[39],lf[100],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1869,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[101]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[102]+1),lf[103],lf[73]);}}

/* k1867 in k1855 in check in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1847(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1847,NULL,2,t1,t2);}
t3=*((C_word*)lf[98]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[99],t2);}

/* mode in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_1835(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[97]));}

/* current-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1817(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1817,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1821,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}

/* k1819 in current-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1821(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1821,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1824,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1822 in k1819 in current-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1824(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[5]);}
else{
t2=*((C_word*)lf[38]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[39],lf[95],lf[96]);}}

/* directory? in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1794(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1794,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[93]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1801,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1815,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1813 in directory? in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1815(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[94]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1799 in directory? in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1801(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1737(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1737,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1744,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,C_fix(256));}

/* k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1744(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1744,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1747,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[92]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1747(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1747,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1750,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[92]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t2);}

/* k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1750(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1750,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1754,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1792,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1790 in k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1752 in k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1754(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1754,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1763,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1771,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_1771(t6,((C_word*)t0)[6]);}}

/* loop in k1752 in k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1771(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1771,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1781,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t5))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k1779 in loop in k1752 in k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1781(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1781,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1788,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)((C_word*)t0)[2])[1];
f_1771(t3,t2);}

/* k1786 in k1779 in loop in k1752 in k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1788,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k1761 in k1752 in k1748 in k1745 in k1742 in directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1763(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[90],lf[91],((C_word*)t0)[2]);}

/* delete-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1710(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1710,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[85]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1731,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1735,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1733 in delete-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1735(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1729 in delete-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1731(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1731,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1723,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1721 in k1729 in delete-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[85],lf[86],((C_word*)t0)[2]);}

/* change-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1683(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1683,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[83]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1704,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1708,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1706 in change-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1708(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1702 in change-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1704,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1696,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1694 in k1702 in change-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[83],lf[84],((C_word*)t0)[2]);}

/* create-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1656(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1656,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[81]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1677,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1681,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}

/* k1679 in create-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1675 in create-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1677,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1669,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1667 in k1675 in create-directory in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1669(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[81],lf[82],((C_word*)t0)[2]);}

/* set-file-position! in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1595(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1595r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1595r(t0,t1,t2,t3,t4);}}

static void f_1595r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[76]);
t8=(C_word)C_i_check_exact_2(t6,lf[76]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1608,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t10=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[79],lf[76],lf[80],t3,t2);}
else{
t10=t9;
f_1608(2,t10,C_SCHEME_UNDEFINED);}}

/* k1606 in set-file-position! in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1608(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1608,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1614,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1623,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[75]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[4]);}

/* k1621 in k1606 in set-file-position! in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[73]);
t4=((C_word*)t0)[4];
f_1614(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_1614(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[49],lf[76],lf[78],((C_word*)t0)[5]);}}}

/* k1612 in k1606 in set-file-position! in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1614,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1617,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k1615 in k1612 in k1606 in set-file-position! in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1617(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[76],lf[77],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1555(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1555,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1559,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1574,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[75]+1);
((C_proc3)C_retrieve_proc(t5))(3,t5,t4,t2);}

/* k1572 in file-position in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[73]);
t4=((C_word*)t0)[2];
f_1559(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_1559(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[49],lf[71],lf[74],((C_word*)t0)[3]);}}}

/* k1557 in file-position in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1559(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1559,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1562,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1568,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_1562(2,t3,C_SCHEME_UNDEFINED);}}

/* k1566 in k1557 in file-position in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1568(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[71],lf[72],((C_word*)t0)[2]);}

/* k1560 in k1557 in file-position in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1562(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-permissions in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1549(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1549,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1553,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f_1493(t3,t2);}

/* k1551 in file-permissions in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_mode));}

/* file-owner in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1543(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1543,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1547,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f_1493(t3,t2);}

/* k1545 in file-owner in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_uid));}

/* file-modification-time in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1537(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1537,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1541,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f_1493(t3,t2);}

/* k1539 in file-modification-time in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1541(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1541,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1531(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1531,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1535,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f_1493(t3,t2);}

/* k1533 in file-size in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_size));}

/* ##sys#stat in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1493(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1493,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1497,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_1497(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1522,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1526,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
t4=*((C_word*)lf[38]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[49],lf[66],t2);}}}

/* k1524 in ##sys#stat in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1520 in ##sys#stat in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1522(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_1497(2,t2,(C_word)C_stat(t1));}

/* k1495 in ##sys#stat in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1497(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1497,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1506,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k1504 in k1495 in ##sys#stat in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1506(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[39],lf[65],((C_word*)t0)[2]);}

/* file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1298(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1298r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1298r(t0,t1,t2,t3,t4);}}

static void f_1298r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1272(C_fix(0));
t10=f_1272(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1314,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1314(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
t14=t12;
f_1314(2,t14,f_1278(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[58]);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1474,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t15=*((C_word*)lf[60]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a1473 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1474(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1474,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[58]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1278(C_fix(0),t2));}

/* k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1314(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1314,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1320,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1320(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
t5=t3;
f_1320(2,t5,f_1278(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[58]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1448,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[60]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a1447 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1448(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1448,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[58]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1278(C_fix(1),t2));}

/* k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1320(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1320,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1323,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[58]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_1323(t5,(C_word)C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1323(t4,(C_word)C_select(t3));}}

/* k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1323(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1323,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1332,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1365,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
t4=t3;
f_1365(t4,f_1288(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1406,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1408,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t8=*((C_word*)lf[60]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_1365(t4,C_SCHEME_FALSE);}}}}

/* a1407 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1408(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1408,3,t0,t1,t2);}
t3=f_1288(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1404 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1365(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1363 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1365(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1365,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1369,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t3=t2;
f_1369(t3,f_1288(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1381,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1383,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=*((C_word*)lf[60]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_1369(t3,C_SCHEME_FALSE);}}

/* a1382 in k1363 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1383(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1383,3,t0,t1,t2);}
t3=f_1288(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1379 in k1363 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1381(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1369(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1367 in k1363 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1369(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k1330 in k1321 in k1318 in k1312 in file-select in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1332(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[58],lf[59],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* fd_test in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_1288(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub67(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_1278(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub61(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_zero in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_1272(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub56(C_SCHEME_UNDEFINED,t2));}

/* file-mkstemp in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1237(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1237,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[55]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1244,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1242 in file-mkstemp in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1244,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1247,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,t1);}

/* k1245 in k1242 in file-mkstemp in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1247,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1250,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1267,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_1250(2,t4,C_SCHEME_UNDEFINED);}}

/* k1265 in k1245 in k1242 in file-mkstemp in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[55],lf[57],((C_word*)t0)[2]);}

/* k1248 in k1245 in k1242 in file-mkstemp in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1250(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1250,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1257,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
t4=*((C_word*)lf[56]+1);
((C_proc5)C_retrieve_proc(t4))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1255 in k1248 in k1245 in k1242 in file-mkstemp in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1257(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1195(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1195r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1195r(t0,t1,t2,t3,t4);}}

static void f_1195r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[51]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1202,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1202(2,t8,C_SCHEME_UNDEFINED);}
else{
t8=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[49],lf[51],lf[53],t3);}}

/* k1200 in file-write in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1202(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1202,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[51]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1211,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1217,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f_1211(2,t8,C_SCHEME_UNDEFINED);}}

/* k1215 in k1200 in file-write in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[51],lf[52],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1209 in k1200 in file-write in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1150(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1150r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1150r(t0,t1,t2,t3,t4);}}

static void f_1150r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[47]);
t6=(C_word)C_i_check_exact_2(t3,lf[47]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1160,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1160(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1158 in file-read in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1160,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1163,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1163(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[49],lf[47],lf[50],t1);}}

/* k1161 in k1158 in file-read in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1163,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1166,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1175,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_1166(2,t5,C_SCHEME_UNDEFINED);}}

/* k1173 in k1161 in k1158 in file-read in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[39],lf[47],lf[48],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1164 in k1161 in k1158 in file-read in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1166(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1166,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1132(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1132,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[44]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1145,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1143 in file-close in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[39],lf[44],lf[45],((C_word*)t0)[2]);}

/* file-open in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1091(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc(c,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1091r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1091r(t0,t1,t2,t3,t4);}}

static void f_1091r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[37]);
t8=(C_word)C_i_check_exact_2(t3,lf[37]);
t9=(C_word)C_i_check_exact_2(t6,lf[37]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1108,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1124,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
t12=*((C_word*)lf[43]+1);
((C_proc3)C_retrieve_proc(t12))(3,t12,t11,t2);}

/* k1122 in file-open in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1124(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[42]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1106 in file-open in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1108,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1111,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1117,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[41]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_1111(2,t5,C_SCHEME_UNDEFINED);}}

/* k1115 in k1106 in file-open in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1117(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[38]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[39],lf[37],lf[40],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1109 in k1106 in file-open in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1025 in k1022 in k1019 in k1016 in k1013 */
static void C_fcall f_1036(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1036,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1042,tmp=(C_word)a,a+=2,tmp);
C_call_cc(3,0,t1,t2);}

/* a1041 in yield in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1042(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc(c,3);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1042,3,t0,t1,t2);}
t3=*((C_word*)lf[4]+1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1051,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
t6=*((C_word*)lf[5]+1);
((C_proc2)C_retrieve_proc(t6))(2,t6,t1);}

/* a1050 in a1041 in yield in k1025 in k1022 in k1019 in k1016 in k1013 */
static void f_1051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc(c,2);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1051,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* make-nonblocking in k1025 in k1022 in k1019 in k1016 in k1013 */
static C_word C_fcall f_1029(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub3(C_SCHEME_UNDEFINED,t2));}
/* end of file */
