/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com>
 *
 */

#ifndef _CTK_MENU_SEPERATOR_H_
#define _CTK_MENU_SEPERATOR_H_

#include <glib.h>
#include <clutk/ctk-actor.h>
#include <clutk/ctk-menu-item.h>

G_BEGIN_DECLS

#define CTK_TYPE_MENU_SEPERATOR (ctk_menu_seperator_get_type ())

#define CTK_MENU_SEPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
  CTK_TYPE_MENU_SEPERATOR, CtkMenuSeperator))

#define CTK_MENU_SEPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
  CTK_TYPE_MENU_SEPERATOR, CtkMenuSeperatorClass))

#define CTK_IS_MENU_SEPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
  CTK_TYPE_MENU_SEPERATOR))

#define CTK_IS_MENU_SEPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
  CTK_TYPE_MENU_SEPERATOR))

#define CTK_MENU_SEPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
  CTK_TYPE_MENU_SEPERATOR, CtkmMenuSeperatorClass))

typedef struct _CtkMenuSeperator CtkMenuSeperator;
typedef struct _CtkMenuSeperatorClass CtkMenuSeperatorClass;

struct _CtkMenuSeperator
{
  CtkMenuItem parent_instance;
};

struct _CtkMenuSeperatorClass
{
  CtkMenuItemClass parent_class;
};

GType          ctk_menu_seperator_get_type (void) G_GNUC_CONST;

CtkMenuSeperator *ctk_menu_seperator_new  (void);

G_END_DECLS

#endif /* _CTK_MENU_SEPERATOR_H_ */
