# state.py - store persistent state of crufts
# Copyright (C) 2008, 2009  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import ConfigParser


class State(object):

    def __init__(self):
        self._cp = ConfigParser.ConfigParser()
        self._previously_ignored = set()

    def load(self, filename):
        self._cp.read(filename)
        self._previously_ignored = set()
        for cruft_name in self._cp.sections():
            if not self.is_enabled(cruft_name):
                self._previously_ignored.add(cruft_name)
    
    def save(self, filename):
        f = file(filename, "w")
        self._cp.write(f)
        f.close()

    def is_enabled(self, cruft_name):
        if self._cp.has_section(cruft_name):
            return self._cp.getboolean(cruft_name, "enabled")
        else:
            return True
    
    def enable(self, cruft_name):
        if not self._cp.has_section(cruft_name):
            self._cp.add_section(cruft_name)
        self._cp.set(cruft_name, "enabled", "true")

    def disable(self, cruft_name):
        if not self._cp.has_section(cruft_name):
            self._cp.add_section(cruft_name)
        self._cp.set(cruft_name, "enabled", "false")
        
    def was_previously_ignored(self, cruft_name):
        return cruft_name in self._previously_ignored

