# Copyright (C) 2008, 2009, 2010  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""computerjanitorapp module."""

from __future__ import absolute_import, unicode_literals

__metaclass__ = type
__all__ = [
    '__version__',
    'setup_gettext',
    ]


__version__ = '2.0.4'


# Set up gettext.
def setup_gettext():
    """Set up gettext for a module.

    Return a method to be used for looking up translations.  Usage:

    >>> import computerjanitorapp
    >>> _ = computerjanitorapp.setup_gettext()
    """
    import gettext
    import os

    domain = 'computerjanitor'
    localedir = os.environ.get('LOCPATH', None)
    t = gettext.translation(domain, localedir=localedir, fallback=True)
    return t.ugettext
