# Copyright (C) 2008, 2009, 2010  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Common utilities."""

from __future__ import absolute_import, unicode_literals

__metaclass__ = type
__all__ = [
    'format_size',
    ]


from math import log10


TABLE = (
    'B',
    'kB',
    'MB',
    'GB',
    'TB',
    )


def format_size(bytes):
    """Format size in bytes.

    :param bytes: Integer size in bytes.
    :type bytes: integer
    :return: Formatted size
    :rtype: string
    """
    assert bytes >= 0, 'Cannot have negative sizes'
    if bytes == 0:
        return '0B'
    if bytes > 10**12:
        return '>1TB'
    key = divmod(int(log10(bytes)), 3)[0]
    return '{0}{1}'.format(bytes // 10**(key * 3), TABLE[key])
