/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 */

#if !defined (_DEE_H_INSIDE) && !defined (DEE_COMPILATION)
#error "Only <dee.h> can be included directly."
#endif

#ifndef _HAVE_DEE_VERSIONED_MODEL_H
#define _HAVE_DEE_VERSIONED_MODEL_H

#include <glib.h>
#include <glib-object.h>

#include <dee-model.h>

G_BEGIN_DECLS

#define DEE_TYPE_VERSIONED_MODEL (dee_versioned_model_get_type ())

#define DEE_VERSIONED_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        DEE_TYPE_VERSIONED_MODEL, DeeVersionedModel))

#define DEE_VERSIONED_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        DEE_TYPE_VERSIONED_MODEL, DeeVersionedModelClass))

#define DEE_IS_VERSIONED_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        DEE_TYPE_VERSIONED_MODEL))

#define DEE_IS_VERSIONED_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        DEE_TYPE_VERSIONED_MODEL))

#define DEE_VERSIONED_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        DBUS_TYPE_ABSTRACT_MODEL, DeeVersionedModelClass))

/**
 * DeeSeqnumState:
 * @DEE_SEQNUM_STATE_NOT_CONSECUTIVE:
 * @DEE_SEQNUM_STATE_IN_THE_FUTURE:
 * @DEE_SEQNUM_STATE_IN_THE_PAST:
 * @DEE_SEQNUM_STATE_OK:
 *
 */
typedef enum
{
  DEE_SEQNUM_STATE_NOT_CONSECUTIVE,
  DEE_SEQNUM_STATE_IN_THE_FUTURE,
  DEE_SEQNUM_STATE_IN_THE_PAST,
  DEE_SEQNUM_STATE_OK,
} DeeSeqnumState;

typedef struct _DeeVersionedModel DeeVersionedModel;
typedef struct _DeeVersionedModelClass DeeVersionedModelClass;
typedef struct _DeeVersionedModelPrivate DeeVersionedModelPrivate;

/**
 * DeeVersionedModel:
 *
 * All fields in the DeeVersionedModel structure are private and should never be
 * accessed directly
 */
struct _DeeVersionedModel
{
  /*< private >*/
  GObject          parent;

  DeeVersionedModelPrivate *priv;
};

struct _DeeVersionedModelClass
{
  /*< private >*/
  GObjectClass parent_class;

  /*< vatable >*/
  DeeSeqnumState   (* check_seqnums)        (DeeModel     *self,
                                             GArray       *seqnums);
  DeeSeqnumState   (* check_seqnum)         (DeeModel     *self,
                                             guint64       seqnum);
  guint64          (* inc_seqnum)           (DeeModel     *self,
                                             guint         pos);
  void             (* set_seqnum)           (DeeModel     *self,
                                             guint         pos,
                                             guint64       seqnum);

  guint64          (* append_next_seqnum)   (DeeModel     *self);

  guint64          (* prepend_next_seqnum)  (DeeModel     *self);

  guint64          (* insert_next_seqnum)   (DeeModel     *self,
                                             guint         pos);

  guint64          (* get_seqnum)           (DeeModel     *self,
                                             guint         pos);
  guint64          (* get_last_seqnum)      (DeeModel     *self);
  void             (* set_last_seqnum)      (DeeModel     *self,
                                             guint64       seqnum);

  void             (* remove_seqnum)        (DeeModel     *self,
                                             guint         pos);
                                             
  /*< private >*/
  void     (*_dee_versioned_model_1) (void);
  void     (*_dee_versioned_model_2) (void);
  void     (*_dee_versioned_model_3) (void);
  void     (*_dee_versioned_model_4) (void);
};

/**
 * dee_versioned_model_get_type:
 *
 * The GType of #DeeVersionedModel
 *
 * Return value: the #GType of #DeeVersionedModel
 **/
GType          dee_versioned_model_get_type               (void) G_GNUC_CONST;

DeeSeqnumState dee_versioned_model_check_seqnums          (DeeModel     *self,
                                                          GArray       *seqnums);

DeeSeqnumState dee_versioned_model_check_seqnum           (DeeModel     *self,
                                                          guint64       seqnum);

guint64        dee_versioned_model_inc_seqnum             (DeeModel     *self,
                                                          guint         pos);
                                                          
void           dee_versioned_model_set_seqnum             (DeeModel     *self,
                                                          guint         pos,
                                                          guint64       seqnum);

guint64       dee_versioned_model_append_next_seqnum      (DeeModel     *self);

guint64       dee_versioned_model_prepend_next_seqnum     (DeeModel     *self);

guint64       dee_versioned_model_insert_next_seqnum      (DeeModel     *self,
                                                          guint         pos);

guint64        dee_versioned_model_get_seqnum             (DeeModel     *self,
                                                          guint         pos);

guint64        dee_versioned_model_get_last_seqnum        (DeeModel     *self);

void           dee_versioned_model_set_last_seqnum        (DeeModel     *self,
                                                           guint64       seqnum);

void           dee_versioned_model_remove_seqnum          (DeeModel     *self,
                                                          guint         pos);

G_END_DECLS

#endif /* _HAVE_DEE_VERSIONED_MODEL_H */
