/* Prompt.c generated by valac 0.12.1, the Vala compiler
 * generated from Prompt.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <widgets.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <libnotify/notify.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Block3Data {
	int _ref_count_;
	NotifyNotification* note;
};



GtkWindow* prompt (void);
void show_prompt_notification (void);
GtkWindow* show_prompt_dialog (void);
gchar* get_header (void);
gchar* get_body (void);
gchar* get_cancel_button (gboolean mnemonics);
gchar* get_ok_button (gboolean mnemonics);
void cancel (void);
void ok (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda35_ (Block3Data* _data3_);
static void __lambda35__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void _lambda36_ (Block3Data* _data3_);
static void __lambda36__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void _lambda37_ (GtkDialog* dlg, gint resp);
static void __lambda37__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);


GtkWindow* prompt (void) {
	GtkWindow* result = NULL;
	DejaDupShellEnv _tmp0_;
	deja_dup_update_prompt_time (FALSE);
	_tmp0_ = deja_dup_get_shell ();
	if (_tmp0_ == DEJA_DUP_SHELL_ENV_GNOME) {
		show_prompt_notification ();
		result = NULL;
		return result;
	} else {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = show_prompt_dialog ();
		result = _tmp1_;
		return result;
	}
}


gchar* get_header (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	_tmp0_ = _ ("Keep your files safe by backing up regularly");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* get_body (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	_tmp0_ = _ ("Important documents, data, and settings can be protected by storing th" \
"em in a backup. In the case of a disaster, you would be able to recove" \
"r them from that backup.");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* get_cancel_button (gboolean mnemonics) {
	gchar* result = NULL;
	if (mnemonics) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = _ ("_Don't Show Again");
		_tmp1_ = g_strdup (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = _ ("Don't Show Again");
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
}


gchar* get_ok_button (gboolean mnemonics) {
	gchar* result = NULL;
	if (mnemonics) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = _ ("_Open Backup Settings");
		_tmp1_ = g_strdup (_tmp0_);
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = _ ("Open Backup Settings");
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
}


void cancel (void) {
	deja_dup_update_prompt_time (TRUE);
}


void ok (void) {
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* app;
	GDesktopAppInfo* _tmp4_ = NULL;
	GdkScreen* _tmp5_ = NULL;
	GdkDisplay* _tmp6_ = NULL;
	GdkAppLaunchContext* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	deja_dup_update_prompt_time (TRUE);
	_tmp0_ = g_desktop_app_info_new ("deja-dup-ccpanel.desktop");
	app = _tmp0_;
	if (app != NULL) {
		GdkScreen* _tmp1_ = NULL;
		GdkDisplay* _tmp2_ = NULL;
		GdkAppLaunchContext* _tmp3_ = NULL;
		_tmp1_ = gdk_screen_get_default ();
		_tmp2_ = gdk_screen_get_display (_tmp1_);
		_tmp3_ = gdk_display_get_app_launch_context (_tmp2_);
		g_app_info_launch ((GAppInfo*) app, NULL, (GAppLaunchContext*) _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (app);
		return;
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (app);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = g_desktop_app_info_new ("deja-dup-preferences.desktop");
	_g_object_unref0 (app);
	app = _tmp4_;
	_tmp5_ = gdk_screen_get_default ();
	_tmp6_ = gdk_screen_get_display (_tmp5_);
	_tmp7_ = gdk_display_get_app_launch_context (_tmp6_);
	g_app_info_launch ((GAppInfo*) app, NULL, (GAppLaunchContext*) _tmp7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Prompt.vala:87: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (app);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->note);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda35_ (Block3Data* _data3_) {
	GError * _inner_error_ = NULL;
	cancel ();
	notify_notification_close (_data3_->note, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Prompt.vala:101: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda35__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_lambda35_ (self);
}


static void _lambda36_ (Block3Data* _data3_) {
	GError * _inner_error_ = NULL;
	ok ();
	notify_notification_close (_data3_->note, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Prompt.vala:110: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda36__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_lambda36_ (self);
}


void show_prompt_notification (void) {
	Block3Data* _data3_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	NotifyNotification* _tmp5_ = NULL;
	NotifyNotification* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GError * _inner_error_ = NULL;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = _ ("Backup");
	notify_init (_tmp0_);
	_tmp1_ = get_header ();
	_tmp2_ = _tmp1_;
	_tmp3_ = get_body ();
	_tmp4_ = _tmp3_;
	_tmp5_ = notify_notification_new (_tmp2_, _tmp4_, "deja-dup");
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_data3_->note = _tmp6_;
	_tmp7_ = get_cancel_button (FALSE);
	_tmp8_ = _tmp7_;
	notify_notification_add_action (_data3_->note, "cancel", _tmp8_, __lambda35__notify_action_callback, block3_data_ref (_data3_), block3_data_unref);
	_g_free0 (_tmp8_);
	_tmp9_ = get_ok_button (FALSE);
	_tmp10_ = _tmp9_;
	notify_notification_add_action (_data3_->note, "ok", _tmp10_, __lambda36__notify_action_callback, block3_data_ref (_data3_), block3_data_unref);
	_g_free0 (_tmp10_);
	notify_notification_show (_data3_->note, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Prompt.vala:117: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void _lambda37_ (GtkDialog* dlg, gint resp) {
	g_return_if_fail (dlg != NULL);
	if (resp == GTK_RESPONSE_REJECT) {
		cancel ();
	} else {
		if (resp == GTK_RESPONSE_ACCEPT) {
			ok ();
		}
	}
	deja_dup_destroy_widget ((GtkWidget*) dlg);
}


static void __lambda37__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda37_ (_sender, response_id);
}


GtkWindow* show_prompt_dialog (void) {
	GtkWindow* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GtkMessageDialog* _tmp2_ = NULL;
	GtkMessageDialog* _tmp3_;
	GtkMessageDialog* dlg;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* img;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	_tmp0_ = get_header ();
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_free0 (_tmp1_);
	dlg = _tmp3_;
	_tmp4_ = get_body ();
	_tmp5_ = _tmp4_;
	gtk_message_dialog_format_secondary_text (dlg, "%s", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) dlg, FALSE);
	_tmp6_ = _ ("Backup");
	gtk_window_set_title ((GtkWindow*) dlg, _tmp6_);
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("deja-dup", GTK_ICON_SIZE_DIALOG);
	img = g_object_ref_sink (_tmp7_);
	g_object_set ((GtkMisc*) img, "yalign", 0.0f, NULL);
	gtk_widget_show ((GtkWidget*) img);
	gtk_message_dialog_set_image (dlg, (GtkWidget*) img);
	_tmp8_ = get_cancel_button (TRUE);
	_tmp9_ = _tmp8_;
	_tmp10_ = get_ok_button (TRUE);
	_tmp11_ = _tmp10_;
	gtk_dialog_add_buttons ((GtkDialog*) dlg, _tmp9_, GTK_RESPONSE_REJECT, _tmp11_, GTK_RESPONSE_ACCEPT, NULL);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	g_signal_connect ((GtkDialog*) dlg, "response", (GCallback) __lambda37__gtk_dialog_response, NULL);
	deja_dup_show_background_window_for_shell ((GtkWindow*) dlg);
	result = (GtkWindow*) dlg;
	_g_object_unref0 (img);
	return result;
}



