/* figure.cpp
 *
 * Functions for the manipulations of figured basses
 *
 * for Denemo, a gtk+ frontend for GNU Lilypond
 * (c) 2003 Richard Shann
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chordops.h"
#include "calculatepositions.h"
#include "commandfuncs.h"
#include "contexts.h"
#include "figure.h"
#include "dialogs.h"
#include "draw.h"
#include "objops.h"
#include "staffops.h"
#include "utils.h"

struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *entry;
};

/**
 * Allocate new figure structure from the heap
 * and initialise
 *
 */
mudelaobject *
newfigure (gint baseduration, gint numdots, gchar * figs)
{
  mudelaobject *thefigure = newchord (baseduration, numdots);

  ((chord *) thefigure->object)->figure = (gpointer) g_string_new (figs);
  ((chord *) thefigure->object)->is_figure = TRUE;
  /*  thefigure->isinvisible = TRUE; */
  set_basic_numticks (thefigure);

  return thefigure;
}



static void
apply_figure (chord * ch, gchar * fig)
{

  if (!ch->figure)
    {
      ch->figure =
	g_list_append (NULL, newfigure (ch->baseduration, ch->numdots, fig));
      ch->is_figure = FALSE;	
      /* this chord is a note, the figure is stored in
	 the chord (mudelaobject*)(ch->figure->data)->object */
      /* we should now link this to any previous and following mudelaobjects 
	 in the figured bass staff */
    }
  else
    {
      mudelaobject *mud = (mudelaobject *) (((GList *) ch->figure)->data);
      chord *mych = (chord *) mud->object;
      GString *mygstr = (GString *) mych->figure;
      g_string_assign (mygstr, fig);	/* FIXME g_free(mygstr->str) first ? */
      if (mud->user_string)
	{
	  g_free (mud->user_string);
	  mud->user_string = NULL;
	}
    }
}

static GString *
get_figure (chord * ch)
{
  mudelaobject *mud;
  chord *mych;
  if (!ch->figure)
    {
      g_warning ("No figure attached to this note - useless to edit it!");
      return NULL;
    }
  g_assert (!ch->is_figure);
  mud = (mudelaobject *) (((GList *) ch->figure)->data);
  g_assert (mud);
  mych = (chord *) mud->object;
  g_assert (mych);
  return (GString *) mych->figure;
}


void
insertfigure (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *) data;
  struct scoreinfo *si = cbdata->si;
  static staff_info null_info;
  GString *current_figure;
  mudelaobject *curObj = (mudelaobject *) si->currentobject ?
    (mudelaobject *) si->currentobject->data : NULL;
  gchar *figure = (gchar *) gtk_entry_get_text (GTK_ENTRY (cbdata->entry));
  if (curObj && curObj->type == CHORD)
    apply_figure ((chord *) curObj->object, figure);

  do
    {
      if (si->currentobject->next)
	cursorright (si);
      else
	measureright (si);
      curObj =
	si->currentobject ? (mudelaobject *) si->currentobject->data : NULL;
    }
  while ((curObj != NULL) && (curObj->type != CHORD));


  if (curObj && curObj->type == CHORD && (chord *) curObj->object
      && (current_figure = get_figure ((chord *) curObj->object)))
    gtk_entry_set_text (GTK_ENTRY (cbdata->entry), current_figure->str);
  else
    gtk_entry_set_text (GTK_ENTRY (cbdata->entry), "");

  si->has_figures = &null_info;
  si->haschanged = TRUE;
  gtk_widget_draw (si->scorearea, NULL);
}
static void
insertfigurenomove (GtkWidget * widget, gpointer data)
{
  struct callbackdata *cbdata = (struct callbackdata *) data;
  struct scoreinfo *si = cbdata->si;

  mudelaobject *curObj =
    si->currentobject ? (mudelaobject *) si->currentobject->data : NULL;
  gchar *figure = (gchar *) gtk_entry_get_text (GTK_ENTRY (cbdata->entry));
  if (curObj && curObj->type == CHORD)
    {
      apply_figure ((chord *) curObj->object, figure);
    }
  gtk_widget_draw (si->scorearea, NULL);
}
static gint
checkforcr (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  if (event->key.keyval == 65293 /* enter key */ )
    {
      insertfigure (widget, data);
      return TRUE;
    }
  insertfigurenomove (widget, data);
  return FALSE;
}

void
figure_insert (gpointer callback_data, guint callback_action,
	       GtkWidget * widget)
{
  GtkWidget *dialog;
  GtkWidget *entry;
  GtkWidget *label;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;

  static struct callbackdata cbdata;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;
  mudelaobject *curObj = (mudelaobject *) si->currentobject ?
    (mudelaobject *) si->currentobject->data : NULL;
  /* if (si->lily_file)
     return; edit lily text instead */
  if (curObj && curObj->type == CHORD
      && ((chord *) curObj->object)->is_figure)
    return;			/* edit the lily text */
  dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog), _("Insert/Edit Figure"));

  label = gtk_label_new (_("Give figures followed by Enter key"));

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label,
		      TRUE, TRUE, 0);
  gtk_widget_show (label);

  entry = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (entry), "key_press_event",
		      GTK_SIGNAL_FUNC (checkforcr), &cbdata);
  if (curObj && curObj->type == CHORD && ((chord *) curObj->object)->figure)
    {
      chord *ch = (chord *) (curObj->object);
      GList *g = (GList *) ch->figure;
      mudelaobject *mud = (mudelaobject *) g->data;
      chord *mych = (chord *) mud->object;

      gtk_entry_set_text (GTK_ENTRY (entry),
			  ((GString *) (mych->figure))->str);
    }
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), entry,
		      TRUE, TRUE, 0);
  gtk_widget_show (entry);



  cbdata.si = si;
  cbdata.entry = entry;

  gtk_widget_grab_focus (entry);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show (dialog);

}
