/* playback.cpp
 * Midi playback for a specific portion of
 * a score
 *
 * (c) 2000-2005 Adam Tee
 */


#include <denemo/denemo.h>
#include "exportmudela.h"
#include "exportmidi.h"
#include "staffops.h"
#include "scoreops.h"
#include "dialogs.h"
#include "prefops.h"
#include "utils.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif
#include <errno.h>



void
playback (GtkAction * action, gpointer callback_data)
{
  static GString *filename = NULL;
  static GString *passtosystem;

  pid_t pid;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;
  /*gtk_statusbar_pop(GTK_STATUSBAR(si->statusbar), si->status_context_id);
     if(strcmp("timidity",si->prefs->midiplayer->str) == 0)
     gtk_statusbar_push(GTK_STATUSBAR(si->statusbar),si->status_context_id,
     "Playback using Timidity");
     else
     gtk_statusbar_push(GTK_STATUSBAR(si->statusbar),si->status_context_id,
     "Playback using Playmidi");
   */
  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoplayback.mid");
      passtosystem = g_string_new (NULL);
    }

#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      /*
       * Fork failed to create a process :
       */
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;

    }
  else if (pid == 0)
    {
      int status = 0;
      if (si->prefs->playbackoutput)
	{
	  exportmidi (filename->str, si, si->start, si->end);
	  fflush (0);
	}
      else
	{
	  /*
	   * This is the child process, which exports the mudela, invokes
	   * lilypond, then invokes the midi player
	   */
	  exportmudela (filename->str, si, si->start, si->end);

	  /* Invoke lilypond */

	  g_string_assign (passtosystem, si->prefs->lilypath->str);
	  g_string_append (passtosystem, " -o ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, " -m ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, ".ly");
	  status = system (passtosystem->str);
	}

      /* Invoke the midi player */

      if (!status)
	{
	  g_string_assign (passtosystem, si->prefs->midiplayer->str);
	  g_string_append (passtosystem, " ");
	  g_string_append (passtosystem, filename->str);
	  //g_string_append (passtosystem, ".midi");
	  system (passtosystem->str);
	}
      _exit (0);
    }
  /* Otherwise, this is the parent process, in which case we simply
   * want to return the user to his or her regularly scheduled
   * music-making */
}

void
playback_local (gpointer callback_data, guint callback_action,
		GtkWidget * widget)
{
  static GString *filename = NULL;
  static GString *passtosystem;
  pid_t pid;
  struct scoreinfo *si = (struct scoreinfo *) callback_data;

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoplayback");
      passtosystem = g_string_new (NULL);
    }

#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      /*
       * Fork failed to create a process :
       */
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;

    }
  else if (pid == 0)
    {
      int status = 0;
      gint start, end;

      start = si->currentmeasurenum - 1;
      end = si->currentmeasurenum + 1;

      if (si->prefs->playbackoutput)
	{
	  GString *thefilename = g_string_new (filename->str);
	  g_string_append (thefilename, ".midi");
	  exportmidi (thefilename->str, si, start, end);
	  fflush (0);
	}
      else
	{
	  /*
	   * This is the child process, which exports the mudela, invokes
	   * lilypond, then invokes the midi player
	   */
	  exportmudela (filename->str, si, start, end);

	  /* Invoke lilypond */

	  g_string_assign (passtosystem, si->prefs->lilypath->str);
	  g_string_append (passtosystem, " -o ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, " -m ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, ".ly");
	  status = system (passtosystem->str);
	}

      /* Invoke the midi player */
      if (!status)
	{
	  g_string_assign (passtosystem, si->prefs->midiplayer->str);
	  g_string_append (passtosystem, " ");
	  g_string_append (passtosystem, filename->str);
	  g_string_append (passtosystem, ".midi");
	  system (passtosystem->str);
	}

      _exit (0);
    }
  /* Otherwise, this is the parent process, in which case we simply
   * want to return the user to his or her regularly scheduled
   * music-making */
}
