# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch-contacts.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Rick Spencer <rick.spencer@canonical.com>

"""Tests for the ContactsPicker class"""

import testtools
import gtk

from desktopcouch.tests import xdg_cache

from desktopcouch.contacts.contactspicker import ContactsPicker
from desktopcouch.records.server import CouchDatabase

class TestContactsPicker(testtools.TestCase):
    """Test the Contact Picker Window."""

    def setUp(self):
        """setup each test"""
        # Connect to CouchDB server
        self.assert_(xdg_cache)
        self.dbname = 'contacts'
        self.database = CouchDatabase(self.dbname, create=True)

    def tearDown(self):
        """tear down each test"""
        del self.database._server[self.dbname]

    def test_can_contruct_contactspicker(self):
        """Test that we can build the window"""
        # Create and show a test window
        win = gtk.Dialog("ContactsPicker widget test", None, 0,
                        (gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE))
        win.connect("response", gtk.main_quit)
        win.resize(300, 450)

        # Create the contacts picker widget
        picker = ContactsPicker()
        win.get_content_area().pack_start(picker, True, True, 3)
        self.assert_(picker.get_contacts_list())
