;;File: debian-ispell.el
;;; -----------------------------------------------------------------------
;;;	$Id: debian-ispell.el,v 1.33 2007-11-16 16:50:30 agmartin Exp $	
;;; -----------------------------------------------------------------------
;;Description: Emacsen support for Debian package dictionaries-common
;;Authors: Rafael Laboissire <rafael@debian.org>
;;         Agustin Martin     <agmartin@debian.org>
;;Created on: Tue Oct 26 10:16:12 CEST 1999
;;; -----------------------------------------------------------------------

(defcustom debian-dict-common-debug nil
  "A lot of debugging info will be shown if non nil."
  :type 'boolean
  :group 'ispell)

(defvar debian-ispell-only-dictionary-alist nil
  "Alist of Debian installed ispell dicts and properties.
Its value will be used to set `ispell-dictionary-alist' after
ispell.el is loaded when ispell is in use.
Do not change this variable directly.")

(defvar debian-aspell-only-dictionary-alist nil
  "Alist of Debian installed aspell dicts and properties.
Its value will be used to set `ispell-dictionary-alist' after
ispell.el is loaded when aspell is in use.
Do not change this variable directly.")

(defvar debian-ispell-valid-dictionary-list nil
  "A list that will contain the list of emacsen names provided by
registered ispell or aspell dicts")

(defun debian-ispell-add-dictionary-entry (entry &optional name)
  "Obsolete function!!. Entries in ~/.emacs must be adapted to
modify `ispell-local-dictionary-alist'"
  (message "`debian-ispell-add-dictionary-entry': Obsolete function!!.
Entries in ~/.emacs must be adapted to modify `ispell-local-dictionary-alist'. See dictionaries-common README.emacs")
  )

;;; ----------------------------------------------------------------------
;;;  Handle ispell.el load at startup
;;; ----------------------------------------------------------------------

(defun debian-ispell-build-startup-menu (mylist)
;;; ----------------------------------------------------------------------
;;; Extracted from ispell.el, by Ken Stevens, part of GNU emacs.
;;; Original code released under the GNU GPL license
;;; ----------------------------------------------------------------------
  "Build startup menu, trying to not explicitely load ispell.el"
  (if ispell-menu-map-needed
      (let ((dicts (reverse mylist)))
	(setq ispell-menu-map (make-sparse-keymap "Spell"))
	;; add the dictionaries to the bottom of the list.
	(dolist (name dicts)
	  (if (string-equal "default" name)
	      (define-key ispell-menu-map (vector 'default)
		(cons "Select Default Dict"
		      (cons "Dictionary for which Ispell was configured"
			    (list 'lambda () '(interactive)
				  (list
				   'ispell-change-dictionary "default")))))
	    (define-key ispell-menu-map (vector (intern name))
	      (cons (concat "Select " (capitalize name) " Dict")
		    (list 'lambda () '(interactive)
			  (list 'ispell-change-dictionary name))))))))
  
  (if ispell-menu-map-needed
      (progn
	(define-key ispell-menu-map [ispell-change-dictionary]
	  '(menu-item "Change Dictionary..." ispell-change-dictionary
		      :help "Supply explicit dictionary file name"))
	;; --
	(define-key ispell-menu-map [ispell-kill-ispell]
	  '(menu-item "Kill Process" ispell-kill-ispell
		      :enable (and (boundp 'ispell-process) ispell-process
	 			   (eq (ispell-process-status) 'run))
		      :visible (featurep 'ispell)
		      :help "Terminate Ispell subprocess"))
	;; --
	(define-key ispell-menu-map [ispell-pdict-save]
	  '(menu-item "Save Dictionary"
	 	      (lambda () (interactive) (ispell-pdict-save t t))
		      :visible (featurep 'ispell)
	 	      :help "Save personal dictionary"))
	;; --
	(define-key ispell-menu-map [ispell-customize]
	  '(menu-item "Customize..."
		      (lambda () (interactive) (customize-group 'ispell))
		      :help "Customize spell checking options"))
	;; --
	(define-key ispell-menu-map [ispell-help]
	  ;; use (x-popup-menu last-nonmenu-event(list "" ispell-help-list)) ?
	  '(menu-item "Help"
		      (lambda () (interactive) (describe-function 'ispell-help))
		      :help "Show standard Ispell keybindings and commands"))
	;; --
	(define-key ispell-menu-map [flyspell-mode]
	  '(menu-item "Automatic spell checking (Flyspell)"
		      flyspell-mode
		      :help "Check spelling while you edit the text"
		      :button (:toggle . (and (boundp 'flyspell-mode)
					      flyspell-mode))))
	;; --
	(define-key ispell-menu-map [ispell-complete-word]
	  '(menu-item "Complete Word" ispell-complete-word
		      :help "Complete word at cursor using dictionary"))
	;; --
	(define-key ispell-menu-map [ispell-complete-word-interior-frag]
	  '(menu-item "Complete Word Fragment" ispell-complete-word-interior-frag
		      :help "Complete word fragment at cursor"))))
  
  (if ispell-menu-map-needed
      (progn
	(define-key ispell-menu-map [ispell-continue]
	  '(menu-item "Continue Spell-Checking" ispell-continue
	 	      :enable (and (boundp 'ispell-region-end)
				   (marker-position ispell-region-end)
				   (equal (marker-buffer ispell-region-end)
					  (current-buffer)))
		      :visible (featurep 'ispell)
	 	      :help "Continue spell checking last region"))
	;; --
	(define-key ispell-menu-map [ispell-word]
	  '(menu-item "Spell-Check Word" ispell-word
		      :help "Spell-check word at cursor"))
	;; --
	(define-key ispell-menu-map [ispell-comments-and-strings]
	  '(menu-item "Spell-Check Comments" ispell-comments-and-strings
		      :help "Spell-check only comments and strings"))))
  
  
  (if ispell-menu-map-needed
      (progn
	(define-key ispell-menu-map [ispell-region]
	  '(menu-item "Spell-Check Region" ispell-region
		      :enable mark-active
		      :help "Spell-check text in marked region"))
	(define-key ispell-menu-map [ispell-message]
	  '(menu-item "Spell-Check Message" ispell-message
		      :visible (eq major-mode 'mail-mode)
		      :help "Skip headers and included message text"))
	(define-key ispell-menu-map [ispell-buffer]
	  '(menu-item "Spell-Check Buffer" ispell-buffer
		      :help "Check spelling of selected buffer"))
	;;(put 'ispell-region 'menu-enable 'mark-active)
	(fset 'ispell-menu-map (symbol-value 'ispell-menu-map))))
  
  (if (and (featurep 'xemacs)
	   (featurep 'menubar)
	   ;;(null ispell-menu-xemacs)
	   (not (and (boundp 'infodock-version) infodock-version)))
      (let ((dicts mylist)
	    (current-menubar (or current-menubar default-menubar))
	    (menu
	     '(["Help"		(describe-function 'ispell-help) t]
		;;["Help"		(popup-menu ispell-help-list)	t]
		["Check Message"       ispell-message (eq major-mode 'mail-mode)]
		["Check Buffer"	       ispell-buffer			    t]
		["Check Comments"      ispell-comments-and-strings	    t]
		["Check Word"	       ispell-word			    t]
		["Check Region"	       ispell-region  (or (not zmacs-regions) (mark))]
		["Continue Check"      ispell-continue	      (featurep 'ispell)]
		["Complete Word Frag"  ispell-complete-word-interior-frag   t]
		["Complete Word"       ispell-complete-word		    t]
		["Kill Process"	       ispell-kill-ispell     (featurep 'ispell)]
		["Customize..."	       (customize-group 'ispell)	    t]
		;; flyspell-mode may not be bound...
		["flyspell"	       flyspell-mode
		:style toggle :selected flyspell-mode ]
		"-"
		["Save Personal Dict"  (ispell-pdict-save t t)(featurep 'ispell)]
		["Change Dictionary"   ispell-change-dictionary	t])))
	(if (null dicts)
	    (setq dicts (cons "default" nil)))
	(dolist (name dicts)
	  (setq menu (append menu
			     (list
			      (vector
			       (concat "Select " (capitalize name))
			       (list 'ispell-change-dictionary name)
			       t)))))
	(setq ispell-menu-xemacs menu)
	(if current-menubar
	    (progn
	      (if (car (find-menu-item current-menubar '("Cmds")))
		  (progn
		    ;; XEmacs 21.2
		    (delete-menu-item '("Cmds" "Spell-Check"))
		    (add-menu '("Cmds") "Spell-Check" ispell-menu-xemacs))
		;; previous
		(delete-menu-item '("Edit" "Spell")) ; in case already defined
		(add-menu '("Edit") "Spell" ispell-menu-xemacs))))))
  
  )

(defun debian-ispell-set-startup-menu (&optional force)
  "Make sure ispell startup menu is ready after startup.
To be run at `after-init-hook' or at any time if FORCE is given."
  ;; I know let* is cleaner, but this helps debugging
  (let (really-aspell debian-valid-dictionary-list dicts-list)
    (setq really-aspell
	  (if (boundp 'ispell-really-aspell)
	      ispell-really-aspell
	    (and (boundp 'ispell-program-name)
		 (string-match "aspell" ispell-program-name)
		 t)))
    (setq debian-valid-dictionary-list
	  (if really-aspell
	      (mapcar 'car debian-aspell-only-dictionary-alist)
	    (mapcar 'car debian-ispell-only-dictionary-alist)))
    (setq dicts-list
	  (if (boundp 'ispell-local-dictionary-alist)
	      (append (mapcar 'car ispell-local-dictionary-alist)
		      debian-valid-dictionary-list)
	    debian-valid-dictionary-list))
    (if (and (featurep 'ispell)
	     (not force))
	(message "ispell.el is already loaded")
      (when (fboundp 'debian-ispell-build-startup-menu)
	(debian-ispell-build-startup-menu dicts-list)
	;; (fmakunbound 'debian-ispell-build-startup-menu)
	))))

(add-hook 'after-init-hook 'debian-ispell-set-startup-menu)

;;; -----------------------------------------------------------------------
;;;  Guess default ispell dictionary under emacs and make ispell.el use it
;;; -----------------------------------------------------------------------

(defvar debian-ispell-dictionary 
  nil
  "The name of the ispell dictionary that will become the default after
loading of ispell.el.")

;; Load the file containing the default value for debian-ispell-dictionary

(if (file-exists-p "/var/cache/dictionaries-common/emacsen-ispell-default.el")
    (load "/var/cache/dictionaries-common/emacsen-ispell-default.el"))

;;; ----------------

(defvar debian-aspell-dictionary 
  nil
  "The name of the aspell dictionary that will become the default after
loading of ispell.el.")

(defvar debian-aspell-equivs-alist 
  '((nil . nil))
  "Alist of equivalences between locales and aspell dictionaries,
used internally by the debian ispell.el initialization scheme.
Do not change this variable directly. It is autogenerated 
from data supplied by aspell dictionaries maintainers")

;;; -------------
;;; Guess emacsen entry for aspell after LANG or other envvar
;;; Intended to be called from /var/cache/emacsen-ispell-dicts.el
;;; to set debian-aspell-dictionary if possible
;;; ---------------

(defun debian-get-aspell-default ()
  "Guess emacsen entry associated to the given aspell lang option
value. Will try calling <aspell config lang> for this and return
nil in case of error or no match be found"
  (let (prefixes
	(suffixes '("^" "@" "_"))
	debian-aspell-default
	(lang (condition-case ()
		  (with-temp-buffer
		    (call-process "aspell" nil t nil "config" "lang")
		    (car (split-string (buffer-string))))
		(error nil))))
    ;; (message "aspell-lang: %s" lang)
    (if lang
	(progn
	  (setq lang (car (split-string lang ":")))
	  (catch 'tag
	    (dolist (suffix suffixes)
	      (setq prefixes '("" "1:"))
	      (dolist (prefix prefixes)
		(if (setq debian-aspell-default
			  (cdr (assoc (concat prefix
					      (car (split-string lang suffix)))
				      debian-aspell-equivs-alist)))
		    (throw 'tag (car debian-aspell-default)))))))
      nil)))

;;; --------------

(defvar ispell-aspell-dictionary-alist nil
  "alist of parsed aspell dicts and associated parameters. Internal use.")

(defun debian-ispell-find-aspell-dictionaries ()
  "Find Aspell's dictionaries, and record in `ispell-aspell-dictionary-alist'."
  (unless ispell-really-aspell
    (error "This function only works with aspell"))
  (let* ((dictionaries
	  (split-string
	   (with-temp-buffer
	     (call-process ispell-program-name nil t nil "dicts")
	     (buffer-string))))
	 ;; Search for the named dictionaries.
	 (found
	  (delq nil 
		(mapcar #'ispell-aspell-find-dictionary dictionaries))))
    ;; Ensure aspell's alias dictionary will override standard
    ;; definitions.
    (setq ispell-aspell-dictionary-alist (ispell-aspell-add-aliases found))
    ;; Add a default entry
    (let* ((english-dict (assoc "en" ispell-aspell-dictionary-alist))
	   (default-dict
	     (cons nil (or (cdr english-dict)
			   (cdr (car ispell-dictionary-alist-1))))))
      (push default-dict ispell-aspell-dictionary-alist))))

;;; --------------

(defvar debian-ispell-last-program-name nil
  "Last value of ispell-program name. Internal use.")

(defun debian-ispell-initialize-program-params ( &optional dummy )
  "Initialize some spellchecker params when it is changed."
  (unless (eq debian-ispell-last-program-name ispell-program-name)
    (if debian-dict-common-debug
	(message "- (debian-ispell-initialize-program-params) original %s %s"
		 debian-ispell-last-program-name ispell-program-name))
    (ispell-kill-ispell t)
    (if (and (condition-case ()
		 (progn
		   (setq ispell-library-directory (ispell-check-version))
		   t)
	       (error nil))
	     ispell-really-aspell
	     ispell-aspell-supports-utf8
	     ;; xemacs does not like [[:alpha:]] regexps
	     (not (featurep 'xemacs)))
	(unless ispell-aspell-dictionary-alist
	  (debian-ispell-find-aspell-dictionaries)))
    ;; Substitute ispell-dictionary-alist with the list of really installed
    ;; dictionaries and add to it elements of the original list that are not
    ;; in `ispell-dictionary-alist' so they are available through
    ;; `ispell-change-dictionary' (not from the pop-up menus) if the corresponding
    ;; hash is installed (as with personally installed dicts)
    (let ((debian-dicts
	   (if ispell-really-aspell
	       debian-aspell-only-dictionary-alist
	     debian-ispell-only-dictionary-alist))
	  (base-dicts
	   (append ispell-dictionary-alist-1 ispell-dictionary-alist-2
		   ispell-dictionary-alist-3 ispell-dictionary-alist-4
		   ispell-dictionary-alist-5 ispell-dictionary-alist-6))
	  (aspell-dicts
	   (if (and ispell-really-aspell
		    ispell-aspell-supports-utf8)
	       ispell-aspell-dictionary-alist
	     nil))
	  all-dicts)
      
      (setq debian-ispell-valid-dictionary-list
	    (mapcar 'car debian-dicts))
      ;; Merge into ispell-dictionary-alist any elements from the
      ;; original standard ispell-dictionary-alist which have no
      ;; element in debian-ispell-dictionary-alist
      (setq all-dicts debian-dicts)
      (dolist (dict (append aspell-dicts base-dicts))
	(unless (assoc (car dict) all-dicts)
	  (add-to-list 'all-dicts dict)))
      (setq ispell-dictionary-alist all-dicts))
    
    (setq debian-ispell-last-program-name ispell-program-name)
    (if debian-dict-common-debug
	(message "- (debian-ispell-initialize-program-params) initialized, final %s %s"
		 debian-ispell-last-program-name ispell-program-name))
    (debian-ispell-set-startup-menu 'force)
    ))

;;; --------------

(defun debian-ispell-set-default-dictionary ()
  "Set ispell default to the debconf selected one if ispell-program-name is
ispell or, when ispell-program-name is aspell, to the value guessed after
LANG if any."
  (let ((really-aspell
	 (if (boundp 'ispell-really-aspell)
	     ispell-really-aspell
	   (and (boundp 'ispell-program-name)
		(string-match "aspell" ispell-program-name)
		t))))
    
    (unless (and (boundp 'ispell-local-dictionary)
		 ispell-local-dictionary)
      (setq ispell-local-dictionary
	    (if really-aspell
		debian-aspell-dictionary
	      debian-ispell-dictionary)))
    
    ; The debugging output if required
    
    (if debian-dict-common-debug
	(message "- dictionaries DID:%s, DAD:%s, RA:%s, ILD:%s, IPN:%s" 
		 debian-ispell-dictionary 
		 debian-aspell-dictionary
		 really-aspell
		 ispell-local-dictionary
		 ispell-program-name))
    )) ;; let and defun ends

(add-hook 'after-init-hook 'debian-ispell-set-default-dictionary)

;;; ---------------------------------------------------------------------------
;;;   Make sure patched ispell.el is first in the loadpath if not already there
;;; ---------------------------------------------------------------------------

(let ((mypath (concat "/usr/share/" 
		      (symbol-name debian-emacs-flavor) 
		      "/site-lisp/dictionaries-common")))
  (unless (member mypath load-path)
    (debian-pkg-add-load-path-item mypath)))

;;; --------------------------------------------------------------------------
;;; A home made exec-installed-p to test for {i,a}spell executable existence
;;; Implemented here to avoid apel dependency. Will be nulled at the end
;;; --------------------------------------------------------------------------

(defun debiandc-exec-installed-p (infile)
  "Checking for an executable file in the exec-path. 
Implemented here to avoid apel dependency. This is much much simpler,
we do not need all that apel's portability. Internal use funcion."
  (let (file)
    (catch 'tag
      (dolist (path exec-path)
	(setq file (expand-file-name infile path))
	(if (file-executable-p file)
	    (throw 'tag t))))))

;; Fallback to aspell if ispell is not present.
;; Will be overriden by ~/.emacs selection if present

(setq ispell-program-name
      (if (debiandc-exec-installed-p "ispell")
	  "ispell"
	"aspell"))

(fmakunbound 'debiandc-exec-installed-p)

;;; -----------------------------------------------------------------------

;; Local Variables:
;; mode: lisp
;; End:
