/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "discover.h"
#include "utils.h"



struct cdrom_info *cdrom_detect(struct bus_lst *bus){
  struct ide_info *ide= (struct ide_info *)NULL;
  struct scsi_info *scsi= (struct scsi_info *)NULL;
  static struct cdrom_info *first = (struct cdrom_info *) NULL;
  struct cdrom_info *result = (struct cdrom_info *) NULL;

  if(first){
    return first; 
  }/*endif*/

  if(debug)
    printf(_("\nProbing CDROM drive...\n"));
  

  /********************************************************************/
  /******************* ATAPI/IDE CDROM DRIVE **************************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing ATAPI/IDE cdrom drive...\n"));

  for(ide = bus->ide; ide; ide = ide->next){
    if(ide->type == CDROM){
      if(!first){
        first = result = (struct cdrom_info *) 
                                   my_malloc(sizeof(struct cdrom_info));
      }else{
        result->next = (struct cdrom_info *) 
                                   my_malloc(sizeof(struct cdrom_info));
        result = result->next;
      }/*endif*/
      result->next = (struct cdrom_info *) NULL;
      result->vendor = s_unknown;
      result->model = ide->model;
      result->device = ide->device;
      result->module = s_ignore;
      result->bus = IDE;
      if(debug)
	printf(_(("\t\tFound %s on %s\n")), 
	       result->model, result->device);
    }/*endif*/
  }/*next ide*/
  
  
  /********************************************************************/
  /************************ SCSI CDROM DRIVE **************************/
  /********************************************************************/
  if(debug)
    printf(_("\tProbing SCSI cdrom drive...\n"));

  for(scsi = bus->scsi; scsi; scsi = scsi->next){
    if(scsi->type == CDROM){
      if(!first){
        first = result = (struct cdrom_info *) 
                                   my_malloc(sizeof(struct cdrom_info));
      }else{
        result->next = (struct cdrom_info *) 
                                   my_malloc(sizeof(struct cdrom_info));
        result = result->next;
      }/*endif*/
      result->next = (struct cdrom_info *) NULL;
      result->vendor = scsi->vendor;
      result->model = scsi->model;
      result->device = scsi->device;
      result->module = s_ignore;
      result->bus = SCSI;
      if(debug)
	fprintf(stdout, _(("\t\tFound %s on %s\n")), 
		result->model, result->device);
    }/*endif*/
  }/*next scsi*/
  return first;
}/*endfunc cdrom_detect*/
