#!/bin/sh
# Make sure configure is synced with configure.ac.

CONFIGURE="$(grep '^CVSID' configure)"
CONFIGURE_AC="$(grep '^CVSID' configure.ac)"

if [ "$CONFIGURE" != "$CONFIGURE_AC" ]; then
  echo "You must run autogen.sh first! CVS IDs do not match."
  echo "configure says: $CONFIGURE"
  echo "configure.ac says: $CONFIGURE_AC"
  exit 1
fi

VERSION="$(dpkg-parsechangelog | awk '/^Version: / { print $2 }' | sed 's/[a-z].*//')"
MISMATCH="$(grep '^PACKAGE_VERSION=' configure | cut -d= -f2 | tr -d "'")"

if [ "$MISMATCH" != "$VERSION" ]; then
  echo "Versions in AC_INIT/changelog do not match. Fix and run autogen.sh."
  echo "Configure says: $MISMATCH       debian/changelog says: $VERSION"
  exit 1
fi

echo "configure, configure.ac, and debian/changelog are in sync. Continuing."
exit 0
