# vim: set fileencoding=utf-8 :

import unittest
import os
import glob
from ConfigParser import ConfigParser

class AbstractionTestCase(unittest.TestCase):
    def testRun(self):
        for ini in glob.glob("tests/data/abstraction/*.ini"):
            xconfig = "%s.conf" % os.path.splitext(ini)[0]
            pcitable = "%s.pci" % os.path.splitext(ini)[0]
            xsetup = self.getXSetup(xconfig, pcitable)
            xsetup._syncXorgConfig()
            reference = ConfigParser()
            reference.read(ini)
            sections = reference.sections()
            # Check basic layout
            sections.remove("xsetup")
            self.assertEqual(xsetup.getLayout(),
                             reference.getint("xsetup", "layout"))
            self.assertEqual(xsetup.getDualheadOrientation(),
                             reference.getint("xsetup", "orientation"))
            primary = xsetup.getPrimaryScreen()
            self.assertEqual(primary._getXorgScreenSection().identifier,
                             reference.get("xsetup", "primary"))
            secondary = xsetup.getSecondaryScreen()
            self.assertEqual(secondary._getXorgScreenSection().identifier,
                             reference.get("xsetup", "secondary"))
            # Check gfx cards
            for gfxcard in xsetup.getGfxCards():
                gfx_device = gfxcard.getXorgDeviceSection(0)
                section = gfx_device.identifier
                sections.remove(section)
                self.assertEqual(gfxcard.getGfxCardModel().getDriver(),
                                 reference.get(section, "driver"))
                self.assertEqual(gfxcard.getPCIBusID(),
                                 reference.get(section, "pcibusid"))
                self.assertEqual(gfxcard.getVideoRam(),
                                 reference.getint(section, "videoram"))
                self.assertEqual(str(map(lambda g: g.identifier,
                                                  gfxcard.x_device)),
                                 reference.get(section, "devices"))
                for screen in gfxcard.getScreens():
                    screen_device = screen._getXorgScreenSection()
                    section = screen_device.identifier
                    sections.remove(section)
 #                   self.assertEqual(gfx_device,
#                                     reference.get(section, "gfxcard"))
                    self.assertEqual(str(screen.getAvailableResolutions()),
                                     reference.get(section, "resolutions"))
                    self.assertEqual(screen.getResolutionIndex(),
                                     reference.getint(section, "resolution"))
                    self.assertEqual(str(screen.getAvailableRefreshRates()),
                                     reference.get(section, "rates"))
                    self.assertEqual(screen.getRefreshRateIndex(),
                                     reference.getint(section, "rate"))
                    self.assertEqual(screen.getMonitorAspect(),
                                     reference.getint(section, "aspect"))
                    self.assertEqual(str(screen.getMonitorModel()),
                                     reference.get(section, "model"))
                    self.assertEqual(screen.getAllGamma(),
                                     reference.getfloat(section, "gamma"))
            self.assert_(len(sections) == 0)

    def getXSetup(self, xconfig, pcitable):
        import displayconfigabstraction
        displayconfigabstraction.SetDataFileDir("/usr/share/apps/guidance")
        return displayconfigabstraction.XSetup(xconfig,
                                               debug_scan_pci_filename=pcitable)
