/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright (c) 2007-2013 Broadcom Corporation.
 *
 * Eric Davis        <edavis@broadcom.com>
 * David Christensen <davidch@broadcom.com>
 * Gary Zambrano     <zambrano@broadcom.com>
 *
 * Copyright (c) 2014-2018 Cavium Inc.
 * All rights reserved.
 * www.cavium.com
 */

#ifndef ECORE_REG_H
#define ECORE_REG_H


#define ATC_ATC_INT_STS_REG_ADDRESS_ERROR \
	(0x1<<0)
#define ATC_ATC_INT_STS_REG_ATC_GPA_MULTIPLE_HITS \
	(0x1<<2)
#define ATC_ATC_INT_STS_REG_ATC_IREQ_LESS_THAN_STU \
	(0x1<<5)
#define ATC_ATC_INT_STS_REG_ATC_RCPL_TO_EMPTY_CNT \
	(0x1<<3)
#define ATC_ATC_INT_STS_REG_ATC_TCPL_ERROR \
	(0x1<<4)
#define ATC_ATC_INT_STS_REG_ATC_TCPL_TO_NOT_PEND \
	(0x1<<1)
#define ATC_REG_ATC_INIT_DONE \
	0x1100bcUL
#define ATC_REG_ATC_INT_STS_CLR \
	0x1101c0UL
#define ATC_REG_ATC_PRTY_MASK \
	0x1101d8UL
#define ATC_REG_ATC_PRTY_STS_CLR \
	0x1101d0UL
#define BRB1_REG_BRB1_INT_MASK \
	0x60128UL
#define BRB1_REG_BRB1_PRTY_MASK \
	0x60138UL
#define BRB1_REG_BRB1_PRTY_STS_CLR \
	0x60130UL
#define BRB1_REG_MAC_GUARANTIED_0 \
	0x601e8UL
#define BRB1_REG_MAC_GUARANTIED_1 \
	0x60240UL
#define BRB1_REG_NUM_OF_FULL_BLOCKS \
	0x60090UL
#define BRB1_REG_PAUSE_HIGH_THRESHOLD_0 \
	0x60078UL
#define BRB1_REG_PAUSE_LOW_THRESHOLD_0 \
	0x60068UL
#define BRB1_REG_PORT_NUM_OCC_BLOCKS_0 \
	0x60094UL
#define CCM_REG_CCM_INT_MASK \
	0xd01e4UL
#define CCM_REG_CCM_PRTY_MASK \
	0xd01f4UL
#define CCM_REG_CCM_PRTY_STS_CLR \
	0xd01ecUL
#define CDU_REG_CDU_GLOBAL_PARAMS \
	0x101020UL
#define CDU_REG_CDU_INT_MASK \
	0x10103cUL
#define CDU_REG_CDU_PRTY_MASK \
	0x10104cUL
#define CDU_REG_CDU_PRTY_STS_CLR \
	0x101044UL
#define CFC_REG_AC_INIT_DONE \
	0x104078UL
#define CFC_REG_CAM_INIT_DONE \
	0x10407cUL
#define CFC_REG_CFC_INT_MASK \
	0x104108UL
#define CFC_REG_CFC_INT_STS_CLR \
	0x104100UL
#define CFC_REG_CFC_PRTY_MASK \
	0x104118UL
#define CFC_REG_CFC_PRTY_STS_CLR \
	0x104110UL
#define CFC_REG_DEBUG0 \
	0x104050UL
#define CFC_REG_INIT_REG \
	0x10404cUL
#define CFC_REG_LL_INIT_DONE \
	0x104074UL
#define CFC_REG_NUM_LCIDS_INSIDE_PF \
	0x104120UL
#define CFC_REG_STRONG_ENABLE_PF \
	0x104128UL
#define CFC_REG_WEAK_ENABLE_PF \
	0x104124UL
#define CSDM_REG_CSDM_INT_MASK_0 \
	0xc229cUL
#define CSDM_REG_CSDM_INT_MASK_1 \
	0xc22acUL
#define CSDM_REG_CSDM_PRTY_MASK \
	0xc22bcUL
#define CSDM_REG_CSDM_PRTY_STS_CLR \
	0xc22b4UL
#define CSEM_REG_CSEM_INT_MASK_0 \
	0x200110UL
#define CSEM_REG_CSEM_INT_MASK_1 \
	0x200120UL
#define CSEM_REG_CSEM_PRTY_MASK_0 \
	0x200130UL
#define CSEM_REG_CSEM_PRTY_MASK_1 \
	0x200140UL
#define CSEM_REG_CSEM_PRTY_STS_CLR_0 \
	0x200128UL
#define CSEM_REG_CSEM_PRTY_STS_CLR_1 \
	0x200138UL
#define CSEM_REG_FAST_MEMORY \
	0x220000UL
#define CSEM_REG_INT_TABLE \
	0x200400UL
#define CSEM_REG_PASSIVE_BUFFER \
	0x202000UL
#define CSEM_REG_PRAM \
	0x240000UL
#define CSEM_REG_VFPF_ERR_NUM \
	0x200380UL
#define DBG_REG_DBG_PRTY_MASK \
	0xc0a8UL
#define DBG_REG_DBG_PRTY_STS_CLR \
	0xc0a0UL
#define DMAE_REG_BACKWARD_COMP_EN \
	0x10207cUL
#define DMAE_REG_CMD_MEM \
	0x102400UL
#define DMAE_REG_DMAE_INT_MASK \
	0x102054UL
#define DMAE_REG_DMAE_PRTY_MASK \
	0x102064UL
#define DMAE_REG_DMAE_PRTY_STS_CLR \
	0x10205cUL
#define DMAE_REG_GO_C0 \
	0x102080UL
#define DMAE_REG_GO_C1 \
	0x102084UL
#define DMAE_REG_GO_C10 \
	0x102088UL
#define DMAE_REG_GO_C11 \
	0x10208cUL
#define DMAE_REG_GO_C12 \
	0x102090UL
#define DMAE_REG_GO_C13 \
	0x102094UL
#define DMAE_REG_GO_C14 \
	0x102098UL
#define DMAE_REG_GO_C15 \
	0x10209cUL
#define DMAE_REG_GO_C2 \
	0x1020a0UL
#define DMAE_REG_GO_C3 \
	0x1020a4UL
#define DMAE_REG_GO_C4 \
	0x1020a8UL
#define DMAE_REG_GO_C5 \
	0x1020acUL
#define DMAE_REG_GO_C6 \
	0x1020b0UL
#define DMAE_REG_GO_C7 \
	0x1020b4UL
#define DMAE_REG_GO_C8 \
	0x1020b8UL
#define DMAE_REG_GO_C9 \
	0x1020bcUL
#define DORQ_REG_DORQ_INT_MASK \
	0x170180UL
#define DORQ_REG_DORQ_INT_STS_CLR \
	0x170178UL
#define DORQ_REG_DORQ_PRTY_MASK \
	0x170190UL
#define DORQ_REG_DORQ_PRTY_STS_CLR \
	0x170188UL
#define DORQ_REG_DPM_CID_OFST \
	0x170030UL
#define DORQ_REG_MAX_RVFID_SIZE \
	0x1701ecUL
#define DORQ_REG_NORM_CID_OFST \
	0x17002cUL
#define DORQ_REG_PF_USAGE_CNT \
	0x1701d0UL
#define DORQ_REG_VF_NORM_CID_BASE \
	0x1701a0UL
#define DORQ_REG_VF_NORM_CID_OFST \
	0x1701f4UL
#define DORQ_REG_VF_NORM_CID_WND_SIZE \
	0x1701a4UL
#define DORQ_REG_VF_NORM_MAX_CID_COUNT \
	0x1701e4UL
#define DORQ_REG_VF_NORM_VF_BASE \
	0x1701a8UL
#define DORQ_REG_VF_TYPE_MASK_0 \
	0x170218UL
#define DORQ_REG_VF_TYPE_MAX_MCID_0 \
	0x1702d8UL
#define DORQ_REG_VF_TYPE_MIN_MCID_0 \
	0x170298UL
#define DORQ_REG_VF_TYPE_VALUE_0 \
	0x170258UL
#define DORQ_REG_VF_USAGE_CNT \
	0x170320UL
#define DORQ_REG_VF_USAGE_CT_LIMIT \
	0x170340UL
#define HC_CONFIG_0_REG_ATTN_BIT_EN_0 \
	(0x1<<4)
#define HC_CONFIG_0_REG_BLOCK_DISABLE_0 \
	(0x1<<0)
#define HC_CONFIG_0_REG_INT_LINE_EN_0 \
	(0x1<<3)
#define HC_CONFIG_0_REG_MSI_ATTN_EN_0 \
	(0x1<<7)
#define HC_CONFIG_0_REG_MSI_MSIX_INT_EN_0 \
	(0x1<<2)
#define HC_CONFIG_0_REG_SINGLE_ISR_EN_0 \
	(0x1<<1)
#define HC_CONFIG_1_REG_BLOCK_DISABLE_1 \
	(0x1<<0)
#define HC_REG_ATTN_MSG0_ADDR_L \
	0x108018UL
#define HC_REG_ATTN_MSG1_ADDR_L \
	0x108020UL
#define HC_REG_COMMAND_REG \
	0x108180UL
#define HC_REG_CONFIG_0 \
	0x108000UL
#define HC_REG_CONFIG_1 \
	0x108004UL
#define HC_REG_HC_PRTY_MASK \
	0x1080a0UL
#define HC_REG_HC_PRTY_STS_CLR \
	0x108098UL
#define HC_REG_INT_MASK \
	0x108108UL
#define HC_REG_LEADING_EDGE_0 \
	0x108040UL
#define HC_REG_MAIN_MEMORY \
	0x108800UL
#define HC_REG_MAIN_MEMORY_SIZE \
	152
#define HC_REG_TRAILING_EDGE_0 \
	0x108044UL
#define IGU_BLOCK_CONFIGURATION_REG_BACKWARD_COMP_EN \
	(0x1<<1)
#define IGU_BLOCK_CONFIGURATION_REG_BLOCK_ENABLE \
	(0x1<<0)
#define IGU_REG_ATTENTION_ACK_BITS \
	0x130108UL
#define IGU_REG_ATTN_MSG_ADDR_H \
	0x13011cUL
#define IGU_REG_ATTN_MSG_ADDR_L \
	0x130120UL
#define IGU_REG_BLOCK_CONFIGURATION \
	0x130000UL
#define IGU_REG_COMMAND_REG_32LSB_DATA \
	0x130124UL
#define IGU_REG_COMMAND_REG_CTRL \
	0x13012cUL
#define IGU_REG_CSTORM_TYPE_0_SB_CLEANUP \
	0x130200UL
#define IGU_REG_IGU_PRTY_MASK \
	0x1300a8UL
#define IGU_REG_IGU_PRTY_STS_CLR \
	0x1300a0UL
#define IGU_REG_LEADING_EDGE_LATCH \
	0x130134UL
#define IGU_REG_MAPPING_MEMORY \
	0x131000UL
#define IGU_REG_MAPPING_MEMORY_SIZE \
	136
#define IGU_REG_PBA_STATUS_LSB \
	0x130138UL
#define IGU_REG_PBA_STATUS_MSB \
	0x13013cUL
#define IGU_REG_PCI_PF_MSIX_EN \
	0x130144UL
#define IGU_REG_PCI_PF_MSIX_FUNC_MASK \
	0x130148UL
#define IGU_REG_PCI_PF_MSI_EN \
	0x130140UL
#define IGU_REG_PENDING_BITS_STATUS \
	0x130300UL
#define IGU_REG_PF_CONFIGURATION \
	0x130154UL
#define IGU_REG_PROD_CONS_MEMORY \
	0x132000UL
#define IGU_REG_RESET_MEMORIES \
	0x130158UL
#define IGU_REG_SB_INT_BEFORE_MASK_LSB \
	0x13015cUL
#define IGU_REG_SB_INT_BEFORE_MASK_MSB \
	0x130160UL
#define IGU_REG_SB_MASK_LSB \
	0x130164UL
#define IGU_REG_SB_MASK_MSB \
	0x130168UL
#define IGU_REG_STATISTIC_NUM_MESSAGE_SENT \
	0x130800UL
#define IGU_REG_TRAILING_EDGE_LATCH \
	0x130104UL
#define IGU_REG_VF_CONFIGURATION \
	0x130170UL
#define MCP_REG_MCPR_ACCESS_LOCK \
	0x8009c
#define MCP_REG_MCPR_GP_INPUTS \
	0x800c0
#define MCP_REG_MCPR_GP_OENABLE \
	0x800c8
#define MCP_REG_MCPR_GP_OUTPUTS \
	0x800c4
#define MCP_REG_MCPR_IMC_COMMAND \
	0x85900
#define MCP_REG_MCPR_IMC_DATAREG0 \
	0x85920
#define MCP_REG_MCPR_IMC_SLAVE_CONTROL \
	0x85904
#define MCP_REG_MCPR_NVM_ACCESS_ENABLE \
	0x86424
#define MCP_REG_MCPR_NVM_ADDR \
	0x8640c
#define MCP_REG_MCPR_NVM_CFG4 \
	0x8642c
#define MCP_REG_MCPR_NVM_COMMAND \
	0x86400
#define MCP_REG_MCPR_NVM_READ \
	0x86410
#define MCP_REG_MCPR_NVM_SW_ARB \
	0x86420
#define MCP_REG_MCPR_NVM_WRITE \
	0x86408
#define MISC_AEU_GENERAL_MASK_REG_AEU_NIG_CLOSE_MASK \
	(0x1<<1)
#define MISC_AEU_GENERAL_MASK_REG_AEU_PXP_CLOSE_MASK \
	(0x1<<0)
#define MISC_REG_AEU_AFTER_INVERT_1_FUNC_0 \
	0xa42cUL
#define MISC_REG_AEU_AFTER_INVERT_2_FUNC_0 \
	0xa438UL
#define MISC_REG_AEU_AFTER_INVERT_3_FUNC_0 \
	0xa444UL
#define MISC_REG_AEU_AFTER_INVERT_4_FUNC_0 \
	0xa450UL
#define MISC_REG_AEU_AFTER_INVERT_4_MCP \
	0xa458UL
#define MISC_REG_AEU_AFTER_INVERT_5_FUNC_0 \
	0xa700UL
#define MISC_REG_AEU_CLR_LATCH_SIGNAL \
	0xa45cUL
#define MISC_REG_AEU_ENABLE1_FUNC_0_OUT_0 \
	0xa06cUL
#define MISC_REG_AEU_ENABLE1_FUNC_0_OUT_1 \
	0xa07cUL
#define MISC_REG_AEU_ENABLE1_FUNC_0_OUT_2 \
	0xa08cUL
#define MISC_REG_AEU_ENABLE1_FUNC_1_OUT_0 \
	0xa10cUL
#define MISC_REG_AEU_ENABLE1_FUNC_1_OUT_1 \
	0xa11cUL
#define MISC_REG_AEU_ENABLE1_FUNC_1_OUT_2 \
	0xa12cUL
#define MISC_REG_AEU_ENABLE4_FUNC_0_OUT_0 \
	0xa078UL
#define MISC_REG_AEU_ENABLE4_FUNC_1_OUT_0 \
	0xa118UL
#define MISC_REG_AEU_ENABLE4_NIG_0 \
	0xa0f8UL
#define MISC_REG_AEU_ENABLE4_NIG_1 \
	0xa198UL
#define MISC_REG_AEU_ENABLE4_PXP_0 \
	0xa108UL
#define MISC_REG_AEU_ENABLE4_PXP_1 \
	0xa1a8UL
#define MISC_REG_AEU_ENABLE5_FUNC_0_OUT_0 \
	0xa688UL
#define MISC_REG_AEU_ENABLE5_FUNC_1_OUT_0 \
	0xa6b0UL
#define MISC_REG_AEU_GENERAL_ATTN_0 \
	0xa000UL
#define MISC_REG_AEU_GENERAL_ATTN_1 \
	0xa004UL
#define MISC_REG_AEU_GENERAL_ATTN_10 \
	0xa028UL
#define MISC_REG_AEU_GENERAL_ATTN_11 \
	0xa02cUL
#define MISC_REG_AEU_GENERAL_ATTN_12 \
	0xa030UL
#define MISC_REG_AEU_GENERAL_ATTN_2 \
	0xa008UL
#define MISC_REG_AEU_GENERAL_ATTN_3 \
	0xa00cUL
#define MISC_REG_AEU_GENERAL_ATTN_4 \
	0xa010UL
#define MISC_REG_AEU_GENERAL_ATTN_5 \
	0xa014UL
#define MISC_REG_AEU_GENERAL_ATTN_6 \
	0xa018UL
#define MISC_REG_AEU_GENERAL_ATTN_7 \
	0xa01cUL
#define MISC_REG_AEU_GENERAL_ATTN_8 \
	0xa020UL
#define MISC_REG_AEU_GENERAL_ATTN_9 \
	0xa024UL
#define MISC_REG_AEU_GENERAL_MASK \
	0xa61cUL
#define MISC_REG_AEU_MASK_ATTN_FUNC_0 \
	0xa060UL
#define MISC_REG_AEU_MASK_ATTN_FUNC_1 \
	0xa064UL
#define MISC_REG_BOND_ID \
	0xa400UL
#define MISC_REG_CHIP_NUM \
	0xa408UL
#define MISC_REG_CHIP_REV \
	0xa40cUL
#define MISC_REG_CHIP_TYPE \
	0xac60UL
#define MISC_REG_CHIP_TYPE_57811_MASK \
	(1<<1)
#define MISC_REG_CPMU_LP_DR_ENABLE \
	0xa858UL
#define MISC_REG_CPMU_LP_FW_ENABLE_P0 \
	0xa84cUL
#define MISC_REG_CPMU_LP_IDLE_THR_P0 \
	0xa8a0UL
#define MISC_REG_CPMU_LP_MASK_ENT_P0 \
	0xa880UL
#define MISC_REG_CPMU_LP_MASK_EXT_P0 \
	0xa888UL
#define MISC_REG_CPMU_LP_SM_ENT_CNT_P0 \
	0xa8b8UL
#define MISC_REG_CPMU_LP_SM_ENT_CNT_P1 \
	0xa8bcUL
#define MISC_REG_DRIVER_CONTROL_1 \
	0xa510UL
#define MISC_REG_DRIVER_CONTROL_7 \
	0xa3c8UL
#define MISC_REG_FOUR_PORT_PATH_SWAP \
	0xa75cUL
#define MISC_REG_FOUR_PORT_PATH_SWAP_OVWR \
	0xa738UL
#define MISC_REG_FOUR_PORT_PORT_SWAP \
	0xa754UL
#define MISC_REG_FOUR_PORT_PORT_SWAP_OVWR \
	0xa734UL
#define MISC_REG_GENERIC_CR_0 \
	0xa460UL
#define MISC_REG_GENERIC_CR_1 \
	0xa464UL
#define MISC_REG_GENERIC_POR_1 \
	0xa474UL
#define MISC_REG_GEN_PURP_HWG \
	0xa9a0UL
#define MISC_REG_GPIO \
	0xa490UL
#define MISC_REG_GPIO_EVENT_EN \
	0xa2bcUL
#define MISC_REG_GPIO_INT \
	0xa494UL
#define MISC_REG_GRC_RSV_ATTN \
	0xa3c0UL
#define MISC_REG_GRC_TIMEOUT_ATTN \
	0xa3c4UL
#define MISC_REG_LCPLL_E40_PWRDWN \
	0xaa74UL
#define MISC_REG_LCPLL_E40_RESETB_ANA \
	0xaa78UL
#define MISC_REG_LCPLL_E40_RESETB_DIG \
	0xaa7cUL
#define MISC_REG_MISC_INT_MASK \
	0xa388UL
#define MISC_REG_MISC_PRTY_MASK \
	0xa398UL
#define MISC_REG_MISC_PRTY_STS_CLR \
	0xa390UL
#define MISC_REG_PORT4MODE_EN \
	0xa750UL
#define MISC_REG_PORT4MODE_EN_OVWR \
	0xa720UL
#define MISC_REG_RESET_REG_1 \
	0xa580UL
#define MISC_REG_RESET_REG_2 \
	0xa590UL
#define MISC_REG_SHARED_MEM_ADDR \
	0xa2b4UL
#define MISC_REG_SPIO \
	0xa4fcUL
#define MISC_REG_SPIO_EVENT_EN \
	0xa2b8UL
#define MISC_REG_SPIO_INT \
	0xa500UL
#define MISC_REG_TWO_PORT_PATH_SWAP \
	0xa758UL
#define MISC_REG_TWO_PORT_PATH_SWAP_OVWR \
	0xa72cUL
#define MISC_REG_UNPREPARED \
	0xa424UL
#define MISC_REG_WC0_CTRL_PHY_ADDR \
	0xa9ccUL
#define MISC_REG_WC0_RESET \
	0xac30UL
#define MISC_REG_XMAC_CORE_PORT_MODE \
	0xa964UL
#define MISC_REG_XMAC_PHY_PORT_MODE \
	0xa960UL
#define MSTAT_REG_RX_STAT_GR64_LO \
	0x200UL
#define MSTAT_REG_TX_STAT_GTXPOK_LO \
	0UL
#define NIG_LLH0_XCM_MASK_REG_LLH0_XCM_MASK_BCN \
	(0x1<<0)
#define NIG_LLH1_XCM_MASK_REG_LLH1_XCM_MASK_BCN \
	(0x1<<0)
#define NIG_MASK_INTERRUPT_PORT0_REG_MASK_EMAC0_MISC_MI_INT \
	(0x1<<0)
#define NIG_MASK_INTERRUPT_PORT0_REG_MASK_SERDES0_LINK_STATUS \
	(0x1<<9)
#define NIG_MASK_INTERRUPT_PORT0_REG_MASK_XGXS0_LINK10G \
	(0x1<<15)
#define NIG_MASK_INTERRUPT_PORT0_REG_MASK_XGXS0_LINK_STATUS \
	(0xf<<18)
#define NIG_REG_BMAC0_IN_EN \
	0x100acUL
#define NIG_REG_BMAC0_OUT_EN \
	0x100e0UL
#define NIG_REG_BMAC0_PAUSE_OUT_EN \
	0x10110UL
#define NIG_REG_BMAC0_REGS_OUT_EN \
	0x100e8UL
#define NIG_REG_BRB0_PAUSE_IN_EN \
	0x100c4UL
#define NIG_REG_BRB1_PAUSE_IN_EN \
	0x100c8UL
#define NIG_REG_DEBUG_PACKET_LB \
	0x10800UL
#define NIG_REG_EGRESS_DRAIN0_MODE \
	0x10060UL
#define NIG_REG_EGRESS_EMAC0_OUT_EN \
	0x10120UL
#define NIG_REG_EGRESS_EMAC0_PORT \
	0x10058UL
#define NIG_REG_EMAC0_IN_EN \
	0x100a4UL
#define NIG_REG_EMAC0_PAUSE_OUT_EN \
	0x10118UL
#define NIG_REG_EMAC0_STATUS_MISC_MI_INT \
	0x10494UL
#define NIG_REG_INGRESS_BMAC0_MEM \
	0x10c00UL
#define NIG_REG_INGRESS_BMAC1_MEM \
	0x11000UL
#define NIG_REG_INGRESS_EOP_LB_EMPTY \
	0x104e0UL
#define NIG_REG_INGRESS_EOP_LB_FIFO \
	0x104e4UL
#define NIG_REG_LATCH_BC_0 \
	0x16210UL
#define NIG_REG_LATCH_STATUS_0 \
	0x18000UL
#define NIG_REG_LED_10G_P0 \
	0x10320UL
#define NIG_REG_LED_CONTROL_BLINK_RATE_ENA_P0 \
	0x10318UL
#define NIG_REG_LED_CONTROL_BLINK_RATE_P0 \
	0x10310UL
#define NIG_REG_LED_CONTROL_BLINK_TRAFFIC_P0 \
	0x10308UL
#define NIG_REG_LED_CONTROL_OVERRIDE_TRAFFIC_P0 \
	0x102f8UL
#define NIG_REG_LED_CONTROL_TRAFFIC_P0 \
	0x10300UL
#define NIG_REG_LED_MODE_P0 \
	0x102f0UL
#define NIG_REG_LLFC_EGRESS_SRC_ENABLE_0 \
	0x16070UL
#define NIG_REG_LLFC_EGRESS_SRC_ENABLE_1 \
	0x16074UL
#define NIG_REG_LLFC_ENABLE_0 \
	0x16208UL
#define NIG_REG_LLFC_ENABLE_1 \
	0x1620cUL
#define NIG_REG_LLFC_HIGH_PRIORITY_CLASSES_0 \
	0x16058UL
#define NIG_REG_LLFC_HIGH_PRIORITY_CLASSES_1 \
	0x1605cUL
#define NIG_REG_LLFC_LOW_PRIORITY_CLASSES_0 \
	0x16060UL
#define NIG_REG_LLFC_LOW_PRIORITY_CLASSES_1 \
	0x16064UL
#define NIG_REG_LLFC_OUT_EN_0 \
	0x160c8UL
#define NIG_REG_LLFC_OUT_EN_1 \
	0x160ccUL
#define NIG_REG_LLH0_BRB1_DRV_MASK \
	0x10244UL
#define NIG_REG_LLH0_BRB1_DRV_MASK_MF \
	0x16048UL
#define NIG_REG_LLH0_BRB1_NOT_MCP \
	0x1025cUL
#define NIG_REG_LLH0_CLS_TYPE \
	0x16080UL
#define NIG_REG_LLH0_FUNC_EN \
	0x160fcUL
#define NIG_REG_LLH0_FUNC_MEM \
	0x16180UL
#define NIG_REG_LLH0_FUNC_MEM_ENABLE \
	0x16140UL
#define NIG_REG_LLH0_FUNC_VLAN_ID \
	0x16100UL
#define NIG_REG_LLH0_XCM_MASK \
	0x10130UL
#define NIG_REG_LLH1_BRB1_NOT_MCP \
	0x102dcUL
#define NIG_REG_LLH1_CLS_TYPE \
	0x16084UL
#define NIG_REG_LLH1_FUNC_MEM \
	0x161c0UL
#define NIG_REG_LLH1_FUNC_MEM_ENABLE \
	0x16160UL
#define NIG_REG_LLH1_FUNC_MEM_SIZE \
	16
#define NIG_REG_LLH1_MF_MODE \
	0x18614UL
#define NIG_REG_LLH1_XCM_MASK \
	0x10134UL
#define NIG_REG_LLH_E1HOV_MODE \
	0x160d8UL
#define NIG_REG_LLH_MF_MODE \
	0x16024UL
#define NIG_REG_MASK_INTERRUPT_PORT0 \
	0x10330UL
#define NIG_REG_MASK_INTERRUPT_PORT1 \
	0x10334UL
#define NIG_REG_NIG_EMAC0_EN \
	0x1003cUL
#define NIG_REG_NIG_INGRESS_EMAC0_NO_CRC \
	0x10044UL
#define NIG_REG_NIG_INT_STS_CLR_0 \
	0x103b4UL
#define NIG_REG_NIG_PRTY_MASK \
	0x103dcUL
#define NIG_REG_NIG_PRTY_MASK_0 \
	0x183c8UL
#define NIG_REG_NIG_PRTY_MASK_1 \
	0x183d8UL
#define NIG_REG_NIG_PRTY_STS_CLR \
	0x103d4UL
#define NIG_REG_NIG_PRTY_STS_CLR_0 \
	0x183c0UL
#define NIG_REG_NIG_PRTY_STS_CLR_1 \
	0x183d0UL
#define NIG_REG_P0_HDRS_AFTER_BASIC \
	0x18038UL
#define NIG_REG_P0_HWPFC_ENABLE \
	0x18078UL
#define NIG_REG_P0_LLH_FUNC_MEM2 \
	0x18480UL
#define NIG_REG_P0_MAC_IN_EN \
	0x185acUL
#define NIG_REG_P0_MAC_OUT_EN \
	0x185b0UL
#define NIG_REG_P0_MAC_PAUSE_OUT_EN \
	0x185b4UL
#define NIG_REG_P0_PKT_PRIORITY_TO_COS \
	0x18054UL
#define NIG_REG_P0_RX_COS0_PRIORITY_MASK \
	0x18058UL
#define NIG_REG_P0_RX_COS1_PRIORITY_MASK \
	0x1805cUL
#define NIG_REG_P0_RX_COS2_PRIORITY_MASK \
	0x186b0UL
#define NIG_REG_P0_RX_COS3_PRIORITY_MASK \
	0x186b4UL
#define NIG_REG_P0_RX_COS4_PRIORITY_MASK \
	0x186b8UL
#define NIG_REG_P0_RX_COS5_PRIORITY_MASK \
	0x186bcUL
#define NIG_REG_P0_TX_ARB_CLIENT_CREDIT_MAP \
	0x180f0UL
#define NIG_REG_P0_TX_ARB_CLIENT_CREDIT_MAP2_LSB \
	0x18688UL
#define NIG_REG_P0_TX_ARB_CLIENT_CREDIT_MAP2_MSB \
	0x1868cUL
#define NIG_REG_P0_TX_ARB_CLIENT_IS_STRICT \
	0x180e8UL
#define NIG_REG_P0_TX_ARB_CLIENT_IS_SUBJECT2WFQ \
	0x180ecUL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_0 \
	0x1810cUL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_1 \
	0x18110UL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_2 \
	0x18114UL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_3 \
	0x18118UL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_4 \
	0x1811cUL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_5 \
	0x186a0UL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_6 \
	0x186a4UL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_7 \
	0x186a8UL
#define NIG_REG_P0_TX_ARB_CREDIT_UPPER_BOUND_8 \
	0x186acUL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_0 \
	0x180f8UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_1 \
	0x180fcUL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_2 \
	0x18100UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_3 \
	0x18104UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_4 \
	0x18108UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_5 \
	0x18690UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_6 \
	0x18694UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_7 \
	0x18698UL
#define NIG_REG_P0_TX_ARB_CREDIT_WEIGHT_8 \
	0x1869cUL
#define NIG_REG_P0_TX_ARB_NUM_STRICT_ARB_SLOTS \
	0x180f4UL
#define NIG_REG_P0_TX_ARB_PRIORITY_CLIENT \
	0x180e4UL
#define NIG_REG_P0_TX_ARB_PRIORITY_CLIENT2_LSB \
	0x18680UL
#define NIG_REG_P0_TX_ARB_PRIORITY_CLIENT2_MSB \
	0x18684UL
#define NIG_REG_P1_HDRS_AFTER_BASIC \
	0x1818cUL
#define NIG_REG_P1_HWPFC_ENABLE \
	0x181d0UL
#define NIG_REG_P1_LLH_FUNC_MEM2 \
	0x184c0UL
#define NIG_REG_P1_MAC_IN_EN \
	0x185c0UL
#define NIG_REG_P1_MAC_OUT_EN \
	0x185c4UL
#define NIG_REG_P1_MAC_PAUSE_OUT_EN \
	0x185c8UL
#define NIG_REG_P1_PKT_PRIORITY_TO_COS \
	0x181a8UL
#define NIG_REG_P1_RX_COS0_PRIORITY_MASK \
	0x181acUL
#define NIG_REG_P1_RX_COS1_PRIORITY_MASK \
	0x181b0UL
#define NIG_REG_P1_RX_COS2_PRIORITY_MASK \
	0x186f8UL
#define NIG_REG_P1_TX_ARB_CLIENT_CREDIT_MAP2_LSB \
	0x186e8UL
#define NIG_REG_P1_TX_ARB_CLIENT_CREDIT_MAP2_MSB \
	0x186ecUL
#define NIG_REG_P1_TX_ARB_CLIENT_IS_STRICT \
	0x18234UL
#define NIG_REG_P1_TX_ARB_CLIENT_IS_SUBJECT2WFQ \
	0x18238UL
#define NIG_REG_P1_TX_ARB_CREDIT_UPPER_BOUND_0 \
	0x18258UL
#define NIG_REG_P1_TX_ARB_CREDIT_UPPER_BOUND_1 \
	0x1825cUL
#define NIG_REG_P1_TX_ARB_CREDIT_UPPER_BOUND_2 \
	0x18260UL
#define NIG_REG_P1_TX_ARB_CREDIT_UPPER_BOUND_3 \
	0x18264UL
#define NIG_REG_P1_TX_ARB_CREDIT_UPPER_BOUND_4 \
	0x18268UL
#define NIG_REG_P1_TX_ARB_CREDIT_UPPER_BOUND_5 \
	0x186f4UL
#define NIG_REG_P1_TX_ARB_CREDIT_WEIGHT_0 \
	0x18244UL
#define NIG_REG_P1_TX_ARB_CREDIT_WEIGHT_1 \
	0x18248UL
#define NIG_REG_P1_TX_ARB_CREDIT_WEIGHT_2 \
	0x1824cUL
#define NIG_REG_P1_TX_ARB_CREDIT_WEIGHT_3 \
	0x18250UL
#define NIG_REG_P1_TX_ARB_CREDIT_WEIGHT_4 \
	0x18254UL
#define NIG_REG_P1_TX_ARB_CREDIT_WEIGHT_5 \
	0x186f0UL
#define NIG_REG_P1_TX_ARB_NUM_STRICT_ARB_SLOTS \
	0x18240UL
#define NIG_REG_P1_TX_ARB_PRIORITY_CLIENT2_LSB \
	0x186e0UL
#define NIG_REG_P1_TX_ARB_PRIORITY_CLIENT2_MSB \
	0x186e4UL
#define NIG_REG_PAUSE_ENABLE_0 \
	0x160c0UL
#define NIG_REG_PAUSE_ENABLE_1 \
	0x160c4UL
#define NIG_REG_PORT_SWAP \
	0x10394UL
#define NIG_REG_PPP_ENABLE_0 \
	0x160b0UL
#define NIG_REG_PPP_ENABLE_1 \
	0x160b4UL
#define NIG_REG_PRS_REQ_IN_EN \
	0x100b8UL
#define NIG_REG_SERDES0_CTRL_MD_DEVAD \
	0x10370UL
#define NIG_REG_SERDES0_CTRL_MD_ST \
	0x1036cUL
#define NIG_REG_SERDES0_CTRL_PHY_ADDR \
	0x10374UL
#define NIG_REG_SERDES0_STATUS_LINK_STATUS \
	0x10578UL
#define NIG_REG_STAT0_BRB_DISCARD \
	0x105f0UL
#define NIG_REG_STAT0_BRB_TRUNCATE \
	0x105f8UL
#define NIG_REG_STAT0_EGRESS_MAC_PKT0 \
	0x10750UL
#define NIG_REG_STAT0_EGRESS_MAC_PKT1 \
	0x10760UL
#define NIG_REG_STAT1_BRB_DISCARD \
	0x10628UL
#define NIG_REG_STAT1_EGRESS_MAC_PKT0 \
	0x107a0UL
#define NIG_REG_STAT1_EGRESS_MAC_PKT1 \
	0x107b0UL
#define NIG_REG_STAT2_BRB_OCTET \
	0x107e0UL
#define NIG_REG_STATUS_INTERRUPT_PORT0 \
	0x10328UL
#define NIG_REG_STRAP_OVERRIDE \
	0x10398UL
#define NIG_REG_XCM0_OUT_EN \
	0x100f0UL
#define NIG_REG_XCM1_OUT_EN \
	0x100f4UL
#define NIG_REG_XGXS0_CTRL_MD_DEVAD \
	0x1033cUL
#define NIG_REG_XGXS0_CTRL_MD_ST \
	0x10338UL
#define NIG_REG_XGXS0_CTRL_PHY_ADDR \
	0x10340UL
#define NIG_REG_XGXS0_STATUS_LINK10G \
	0x10680UL
#define NIG_REG_XGXS0_STATUS_LINK_STATUS \
	0x10684UL
#define NIG_REG_XGXS_LANE_SEL_P0 \
	0x102e8UL
#define NIG_REG_XGXS_SERDES0_MODE_SEL \
	0x102e0UL
#define NIG_STATUS_INTERRUPT_PORT0_REG_STATUS_EMAC0_MISC_MI_INT \
	(0x1<<0)
#define NIG_STATUS_INTERRUPT_PORT0_REG_STATUS_SERDES0_LINK_STATUS \
	(0x1<<9)
#define NIG_STATUS_INTERRUPT_PORT0_REG_STATUS_XGXS0_LINK10G \
	(0x1<<15)
#define NIG_STATUS_INTERRUPT_PORT0_REG_STATUS_XGXS0_LINK_STATUS \
	(0xf<<18)
#define NIG_STATUS_INTERRUPT_PORT0_REG_STATUS_XGXS0_LINK_STATUS_SIZE \
	18
#define PBF_REG_COS0_UPPER_BOUND \
	0x15c05cUL
#define PBF_REG_COS0_UPPER_BOUND_P0 \
	0x15c2ccUL
#define PBF_REG_COS0_UPPER_BOUND_P1 \
	0x15c2e4UL
#define PBF_REG_COS0_WEIGHT \
	0x15c054UL
#define PBF_REG_COS0_WEIGHT_P0 \
	0x15c2a8UL
#define PBF_REG_COS0_WEIGHT_P1 \
	0x15c2c0UL
#define PBF_REG_COS1_UPPER_BOUND \
	0x15c060UL
#define PBF_REG_COS1_WEIGHT \
	0x15c058UL
#define PBF_REG_COS1_WEIGHT_P0 \
	0x15c2acUL
#define PBF_REG_COS1_WEIGHT_P1 \
	0x15c2c4UL
#define PBF_REG_COS2_WEIGHT_P0 \
	0x15c2b0UL
#define PBF_REG_COS2_WEIGHT_P1 \
	0x15c2c8UL
#define PBF_REG_COS3_WEIGHT_P0 \
	0x15c2b4UL
#define PBF_REG_COS4_WEIGHT_P0 \
	0x15c2b8UL
#define PBF_REG_COS5_WEIGHT_P0 \
	0x15c2bcUL
#define PBF_REG_CREDIT_LB_Q \
	0x140338UL
#define PBF_REG_CREDIT_Q0 \
	0x14033cUL
#define PBF_REG_CREDIT_Q1 \
	0x140340UL
#define PBF_REG_DISABLE_NEW_TASK_PROC_P0 \
	0x14005cUL
#define PBF_REG_DISABLE_PF \
	0x1402e8UL
#define PBF_REG_DISABLE_VF \
	0x1402ecUL
#define PBF_REG_ETS_ARB_CLIENT_CREDIT_MAP_P0 \
	0x15c288UL
#define PBF_REG_ETS_ARB_CLIENT_CREDIT_MAP_P1 \
	0x15c28cUL
#define PBF_REG_ETS_ARB_CLIENT_IS_STRICT_P0 \
	0x15c278UL
#define PBF_REG_ETS_ARB_CLIENT_IS_STRICT_P1 \
	0x15c27cUL
#define PBF_REG_ETS_ARB_CLIENT_IS_SUBJECT2WFQ_P0 \
	0x15c280UL
#define PBF_REG_ETS_ARB_CLIENT_IS_SUBJECT2WFQ_P1 \
	0x15c284UL
#define PBF_REG_ETS_ARB_NUM_STRICT_ARB_SLOTS_P0 \
	0x15c2a0UL
#define PBF_REG_ETS_ARB_NUM_STRICT_ARB_SLOTS_P1 \
	0x15c2a4UL
#define PBF_REG_ETS_ARB_PRIORITY_CLIENT_P0 \
	0x15c270UL
#define PBF_REG_ETS_ARB_PRIORITY_CLIENT_P1 \
	0x15c274UL
#define PBF_REG_ETS_ENABLED \
	0x15c050UL
#define PBF_REG_HDRS_AFTER_BASIC \
	0x15c0a8UL
#define PBF_REG_HDRS_AFTER_TAG_0 \
	0x15c0b8UL
#define PBF_REG_HIGH_PRIORITY_COS_NUM \
	0x15c04cUL
#define PBF_REG_INIT_CRD_LB_Q \
	0x15c248UL
#define PBF_REG_INIT_CRD_Q0 \
	0x15c230UL
#define PBF_REG_INIT_CRD_Q1 \
	0x15c234UL
#define PBF_REG_INIT_P0 \
	0x140004UL
#define PBF_REG_INTERNAL_CRD_FREED_CNT_LB_Q \
	0x140354UL
#define PBF_REG_INTERNAL_CRD_FREED_CNT_Q0 \
	0x140358UL
#define PBF_REG_INTERNAL_CRD_FREED_CNT_Q1 \
	0x14035cUL
#define PBF_REG_MUST_HAVE_HDRS \
	0x15c0c4UL
#define PBF_REG_NUM_STRICT_ARB_SLOTS \
	0x15c064UL
#define PBF_REG_P0_ARB_THRSH \
	0x1400e4UL
#define PBF_REG_P0_CREDIT \
	0x140200UL
#define PBF_REG_P0_INIT_CRD \
	0x1400d0UL
#define PBF_REG_P0_INTERNAL_CRD_FREED_CNT \
	0x140308UL
#define PBF_REG_P0_PAUSE_ENABLE \
	0x140014UL
#define PBF_REG_P0_TQ_LINES_FREED_CNT \
	0x1402f0UL
#define PBF_REG_P0_TQ_OCCUPANCY \
	0x1402fcUL
#define PBF_REG_P1_CREDIT \
	0x140208UL
#define PBF_REG_P1_INIT_CRD \
	0x1400d4UL
#define PBF_REG_P1_INTERNAL_CRD_FREED_CNT \
	0x14030cUL
#define PBF_REG_P1_TQ_LINES_FREED_CNT \
	0x1402f4UL
#define PBF_REG_P1_TQ_OCCUPANCY \
	0x140300UL
#define PBF_REG_P4_CREDIT \
	0x140210UL
#define PBF_REG_P4_INIT_CRD \
	0x1400e0UL
#define PBF_REG_P4_INTERNAL_CRD_FREED_CNT \
	0x140310UL
#define PBF_REG_P4_TQ_LINES_FREED_CNT \
	0x1402f8UL
#define PBF_REG_P4_TQ_OCCUPANCY \
	0x140304UL
#define PBF_REG_PBF_INT_MASK \
	0x1401d4UL
#define PBF_REG_PBF_PRTY_MASK \
	0x1401e4UL
#define PBF_REG_PBF_PRTY_STS_CLR \
	0x1401dcUL
#define PBF_REG_TAG_ETHERTYPE_0 \
	0x15c090UL
#define PBF_REG_TAG_LEN_0 \
	0x15c09cUL
#define PBF_REG_TQ_LINES_FREED_CNT_LB_Q \
	0x14038cUL
#define PBF_REG_TQ_LINES_FREED_CNT_Q0 \
	0x140390UL
#define PBF_REG_TQ_LINES_FREED_CNT_Q1 \
	0x140394UL
#define PBF_REG_TQ_OCCUPANCY_LB_Q \
	0x1403a8UL
#define PBF_REG_TQ_OCCUPANCY_Q0 \
	0x1403acUL
#define PBF_REG_TQ_OCCUPANCY_Q1 \
	0x1403b0UL
#define PB_REG_PB_INT_MASK \
	0x28UL
#define PB_REG_PB_PRTY_MASK \
	0x38UL
#define PB_REG_PB_PRTY_STS_CLR \
	0x30UL
#define PGLUE_B_PGLUE_B_INT_STS_REG_ADDRESS_ERROR \
	(0x1<<0)
#define PGLUE_B_PGLUE_B_INT_STS_REG_CSSNOOP_FIFO_OVERFLOW \
	(0x1<<8)
#define PGLUE_B_PGLUE_B_INT_STS_REG_INCORRECT_RCV_BEHAVIOR \
	(0x1<<1)
#define PGLUE_B_PGLUE_B_INT_STS_REG_TCPL_ERROR_ATTN \
	(0x1<<6)
#define PGLUE_B_PGLUE_B_INT_STS_REG_TCPL_IN_TWO_RCBS_ATTN \
	(0x1<<7)
#define PGLUE_B_PGLUE_B_INT_STS_REG_VF_GRC_SPACE_VIOLATION_ATTN \
	(0x1<<4)
#define PGLUE_B_PGLUE_B_INT_STS_REG_VF_LENGTH_VIOLATION_ATTN \
	(0x1<<3)
#define PGLUE_B_PGLUE_B_INT_STS_REG_VF_MSIX_BAR_VIOLATION_ATTN \
	(0x1<<5)
#define PGLUE_B_PGLUE_B_INT_STS_REG_WAS_ERROR_ATTN \
	(0x1<<2)
#define PGLUE_B_REG_FLR_REQUEST_PF_7_0_CLR \
	0x9418UL
#define PGLUE_B_REG_WAS_ERROR_VF_31_0_CLR \
	0x9478UL
#define PGLUE_B_REG_WAS_ERROR_VF_63_32_CLR \
	0x947cUL
#define PGLUE_B_REG_WAS_ERROR_VF_95_64_CLR \
	0x9480UL
#define PGLUE_B_REG_WAS_ERROR_VF_127_96_CLR \
	0x9474UL
#define PGLUE_B_REG_INTERNAL_PFID_ENABLE_MASTER \
	0x942cUL
#define PGLUE_B_REG_INTERNAL_PFID_ENABLE_TARGET_READ \
	0x9430UL
#define PGLUE_B_REG_INTERNAL_VFID_ENABLE \
	0x9438UL
#define PGLUE_B_REG_PGLUE_B_INT_STS \
	0x9298UL
#define PGLUE_B_REG_PGLUE_B_INT_STS_CLR \
	0x929cUL
#define PGLUE_B_REG_PGLUE_B_PRTY_MASK \
	0x92b4UL
#define PGLUE_B_REG_PGLUE_B_PRTY_STS_CLR \
	0x92acUL
#define PGLUE_B_REG_SHADOW_BME_PF_7_0_CLR \
	0x9458UL
#define PGLUE_B_REG_TAGS_63_32 \
	0x9244UL
#define PGLUE_B_REG_WAS_ERROR_PF_7_0_CLR \
	0x9470UL
#define PRS_REG_A_PRSU_20 \
	0x40134UL
#define PRS_REG_CFC_SEARCH_INITIAL_CREDIT \
	0x4011cUL
#define PRS_REG_E1HOV_MODE \
	0x401c8UL
#define PRS_REG_HDRS_AFTER_BASIC \
	0x40238UL
#define PRS_REG_HDRS_AFTER_BASIC_PORT_0 \
	0x40270UL
#define PRS_REG_HDRS_AFTER_BASIC_PORT_1 \
	0x40290UL
#define PRS_REG_HDRS_AFTER_TAG_0 \
	0x40248UL
#define PRS_REG_HDRS_AFTER_TAG_0_PORT_0 \
	0x40280UL
#define PRS_REG_HDRS_AFTER_TAG_0_PORT_1 \
	0x402a0UL
#define PRS_REG_MUST_HAVE_HDRS \
	0x40254UL
#define PRS_REG_MUST_HAVE_HDRS_PORT_0 \
	0x4028cUL
#define PRS_REG_MUST_HAVE_HDRS_PORT_1 \
	0x402acUL
#define PRS_REG_NIC_MODE \
	0x40138UL
#define PRS_REG_NUM_OF_PACKETS \
	0x40124UL
#define PRS_REG_PRS_PRTY_MASK \
	0x401a4UL
#define PRS_REG_PRS_PRTY_STS_CLR \
	0x4019cUL
#define PRS_REG_TAG_ETHERTYPE_0 \
	0x401d4UL
#define PRS_REG_TAG_LEN_0 \
	0x4022cUL
#define PXP2_PXP2_INT_MASK_0_REG_PGL_CPL_AFT \
	(0x1<<19)
#define PXP2_PXP2_INT_MASK_0_REG_PGL_CPL_OF \
	(0x1<<20)
#define PXP2_PXP2_INT_MASK_0_REG_PGL_PCIE_ATTN \
	(0x1<<22)
#define PXP2_PXP2_INT_MASK_0_REG_PGL_READ_BLOCKED \
	(0x1<<23)
#define PXP2_PXP2_INT_MASK_0_REG_PGL_WRITE_BLOCKED \
	(0x1<<24)
#define PXP2_PXP2_INT_STS_0_REG_WR_PGLUE_EOP_ERROR \
	(0x1<<7)
#define PXP2_PXP2_INT_STS_CLR_0_REG_WR_PGLUE_EOP_ERROR \
	(0x1<<7)
#define PXP2_REG_PGL_ADDR_88_F0 \
	0x120534UL
#define PXP2_REG_PGL_ADDR_88_F1 \
	0x120544UL
#define PXP2_REG_PGL_ADDR_8C_F0 \
	0x120538UL
#define PXP2_REG_PGL_ADDR_8C_F1 \
	0x120548UL
#define PXP2_REG_PGL_ADDR_90_F0 \
	0x12053cUL
#define PXP2_REG_PGL_ADDR_90_F1 \
	0x12054cUL
#define PXP2_REG_PGL_ADDR_94_F0 \
	0x120540UL
#define PXP2_REG_PGL_ADDR_94_F1 \
	0x120550UL
#define PXP2_REG_PGL_EXP_ROM2 \
	0x120808UL
#define PXP2_REG_PGL_PRETEND_FUNC_F0 \
	0x120674UL
#define PXP2_REG_PGL_PRETEND_FUNC_F1 \
	0x120678UL
#define PXP2_REG_PGL_TAGS_LIMIT \
	0x1205a8UL
#define PXP2_REG_PSWRQ_BW_ADD1 \
	0x1201c0UL
#define PXP2_REG_PSWRQ_BW_ADD10 \
	0x1201e4UL
#define PXP2_REG_PSWRQ_BW_ADD11 \
	0x1201e8UL
#define PXP2_REG_PSWRQ_BW_ADD2 \
	0x1201c4UL
#define PXP2_REG_PSWRQ_BW_ADD28 \
	0x120228UL
#define PXP2_REG_PSWRQ_BW_ADD3 \
	0x1201c8UL
#define PXP2_REG_PSWRQ_BW_ADD6 \
	0x1201d4UL
#define PXP2_REG_PSWRQ_BW_ADD7 \
	0x1201d8UL
#define PXP2_REG_PSWRQ_BW_ADD8 \
	0x1201dcUL
#define PXP2_REG_PSWRQ_BW_ADD9 \
	0x1201e0UL
#define PXP2_REG_PSWRQ_BW_L1 \
	0x1202b0UL
#define PXP2_REG_PSWRQ_BW_L10 \
	0x1202d4UL
#define PXP2_REG_PSWRQ_BW_L11 \
	0x1202d8UL
#define PXP2_REG_PSWRQ_BW_L2 \
	0x1202b4UL
#define PXP2_REG_PSWRQ_BW_L28 \
	0x120318UL
#define PXP2_REG_PSWRQ_BW_L3 \
	0x1202b8UL
#define PXP2_REG_PSWRQ_BW_L6 \
	0x1202c4UL
#define PXP2_REG_PSWRQ_BW_L7 \
	0x1202c8UL
#define PXP2_REG_PSWRQ_BW_L8 \
	0x1202ccUL
#define PXP2_REG_PSWRQ_BW_L9 \
	0x1202d0UL
#define PXP2_REG_PSWRQ_BW_RD \
	0x120324UL
#define PXP2_REG_PSWRQ_BW_UB1 \
	0x120238UL
#define PXP2_REG_PSWRQ_BW_UB10 \
	0x12025cUL
#define PXP2_REG_PSWRQ_BW_UB11 \
	0x120260UL
#define PXP2_REG_PSWRQ_BW_UB2 \
	0x12023cUL
#define PXP2_REG_PSWRQ_BW_UB28 \
	0x1202a0UL
#define PXP2_REG_PSWRQ_BW_UB3 \
	0x120240UL
#define PXP2_REG_PSWRQ_BW_UB6 \
	0x12024cUL
#define PXP2_REG_PSWRQ_BW_UB7 \
	0x120250UL
#define PXP2_REG_PSWRQ_BW_UB8 \
	0x120254UL
#define PXP2_REG_PSWRQ_BW_UB9 \
	0x120258UL
#define PXP2_REG_PSWRQ_BW_WR \
	0x120328UL
#define PXP2_REG_PSWRQ_CDU0_L2P \
	0x120000UL
#define PXP2_REG_PSWRQ_QM0_L2P \
	0x120038UL
#define PXP2_REG_PSWRQ_SRC0_L2P \
	0x120054UL
#define PXP2_REG_PSWRQ_TM0_L2P \
	0x12001cUL
#define PXP2_REG_PXP2_INT_MASK_0 \
	0x120578UL
#define PXP2_REG_PXP2_INT_MASK_1 \
	0x120614UL
#define PXP2_REG_PXP2_INT_STS_0 \
	0x12056cUL
#define PXP2_REG_PXP2_INT_STS_1 \
	0x120608UL
#define PXP2_REG_PXP2_INT_STS_CLR_0 \
	0x120570UL
#define PXP2_REG_PXP2_PRTY_MASK_0 \
	0x120588UL
#define PXP2_REG_PXP2_PRTY_MASK_1 \
	0x120598UL
#define PXP2_REG_PXP2_PRTY_STS_CLR_0 \
	0x120580UL
#define PXP2_REG_PXP2_PRTY_STS_CLR_1 \
	0x120590UL
#define PXP2_REG_RD_BLK_CNT \
	0x120418UL
#define PXP2_REG_RD_CDURD_SWAP_MODE \
	0x120404UL
#define PXP2_REG_RD_DISABLE_INPUTS \
	0x120374UL
#define PXP2_REG_RD_INIT_DONE \
	0x120370UL
#define PXP2_REG_RD_PBF_SWAP_MODE \
	0x1203f4UL
#define PXP2_REG_RD_PORT_IS_IDLE_0 \
	0x12041cUL
#define PXP2_REG_RD_PORT_IS_IDLE_1 \
	0x120420UL
#define PXP2_REG_RD_QM_SWAP_MODE \
	0x1203f8UL
#define PXP2_REG_RD_SRC_SWAP_MODE \
	0x120400UL
#define PXP2_REG_RD_SR_CNT \
	0x120414UL
#define PXP2_REG_RD_START_INIT \
	0x12036cUL
#define PXP2_REG_RD_TM_SWAP_MODE \
	0x1203fcUL
#define PXP2_REG_RQ_BW_RD_ADD0 \
	0x1201bcUL
#define PXP2_REG_RQ_BW_RD_ADD12 \
	0x1201ecUL
#define PXP2_REG_RQ_BW_RD_ADD13 \
	0x1201f0UL
#define PXP2_REG_RQ_BW_RD_ADD14 \
	0x1201f4UL
#define PXP2_REG_RQ_BW_RD_ADD15 \
	0x1201f8UL
#define PXP2_REG_RQ_BW_RD_ADD16 \
	0x1201fcUL
#define PXP2_REG_RQ_BW_RD_ADD17 \
	0x120200UL
#define PXP2_REG_RQ_BW_RD_ADD18 \
	0x120204UL
#define PXP2_REG_RQ_BW_RD_ADD19 \
	0x120208UL
#define PXP2_REG_RQ_BW_RD_ADD20 \
	0x12020cUL
#define PXP2_REG_RQ_BW_RD_ADD22 \
	0x120210UL
#define PXP2_REG_RQ_BW_RD_ADD23 \
	0x120214UL
#define PXP2_REG_RQ_BW_RD_ADD24 \
	0x120218UL
#define PXP2_REG_RQ_BW_RD_ADD25 \
	0x12021cUL
#define PXP2_REG_RQ_BW_RD_ADD26 \
	0x120220UL
#define PXP2_REG_RQ_BW_RD_ADD27 \
	0x120224UL
#define PXP2_REG_RQ_BW_RD_ADD4 \
	0x1201ccUL
#define PXP2_REG_RQ_BW_RD_ADD5 \
	0x1201d0UL
#define PXP2_REG_RQ_BW_RD_L0 \
	0x1202acUL
#define PXP2_REG_RQ_BW_RD_L12 \
	0x1202dcUL
#define PXP2_REG_RQ_BW_RD_L13 \
	0x1202e0UL
#define PXP2_REG_RQ_BW_RD_L14 \
	0x1202e4UL
#define PXP2_REG_RQ_BW_RD_L15 \
	0x1202e8UL
#define PXP2_REG_RQ_BW_RD_L16 \
	0x1202ecUL
#define PXP2_REG_RQ_BW_RD_L17 \
	0x1202f0UL
#define PXP2_REG_RQ_BW_RD_L18 \
	0x1202f4UL
#define PXP2_REG_RQ_BW_RD_L19 \
	0x1202f8UL
#define PXP2_REG_RQ_BW_RD_L20 \
	0x1202fcUL
#define PXP2_REG_RQ_BW_RD_L22 \
	0x120300UL
#define PXP2_REG_RQ_BW_RD_L23 \
	0x120304UL
#define PXP2_REG_RQ_BW_RD_L24 \
	0x120308UL
#define PXP2_REG_RQ_BW_RD_L25 \
	0x12030cUL
#define PXP2_REG_RQ_BW_RD_L26 \
	0x120310UL
#define PXP2_REG_RQ_BW_RD_L27 \
	0x120314UL
#define PXP2_REG_RQ_BW_RD_L4 \
	0x1202bcUL
#define PXP2_REG_RQ_BW_RD_L5 \
	0x1202c0UL
#define PXP2_REG_RQ_BW_RD_UBOUND0 \
	0x120234UL
#define PXP2_REG_RQ_BW_RD_UBOUND12 \
	0x120264UL
#define PXP2_REG_RQ_BW_RD_UBOUND13 \
	0x120268UL
#define PXP2_REG_RQ_BW_RD_UBOUND14 \
	0x12026cUL
#define PXP2_REG_RQ_BW_RD_UBOUND15 \
	0x120270UL
#define PXP2_REG_RQ_BW_RD_UBOUND16 \
	0x120274UL
#define PXP2_REG_RQ_BW_RD_UBOUND17 \
	0x120278UL
#define PXP2_REG_RQ_BW_RD_UBOUND18 \
	0x12027cUL
#define PXP2_REG_RQ_BW_RD_UBOUND19 \
	0x120280UL
#define PXP2_REG_RQ_BW_RD_UBOUND20 \
	0x120284UL
#define PXP2_REG_RQ_BW_RD_UBOUND22 \
	0x120288UL
#define PXP2_REG_RQ_BW_RD_UBOUND23 \
	0x12028cUL
#define PXP2_REG_RQ_BW_RD_UBOUND24 \
	0x120290UL
#define PXP2_REG_RQ_BW_RD_UBOUND25 \
	0x120294UL
#define PXP2_REG_RQ_BW_RD_UBOUND26 \
	0x120298UL
#define PXP2_REG_RQ_BW_RD_UBOUND27 \
	0x12029cUL
#define PXP2_REG_RQ_BW_RD_UBOUND4 \
	0x120244UL
#define PXP2_REG_RQ_BW_RD_UBOUND5 \
	0x120248UL
#define PXP2_REG_RQ_BW_WR_ADD29 \
	0x12022cUL
#define PXP2_REG_RQ_BW_WR_ADD30 \
	0x120230UL
#define PXP2_REG_RQ_BW_WR_L29 \
	0x12031cUL
#define PXP2_REG_RQ_BW_WR_L30 \
	0x120320UL
#define PXP2_REG_RQ_BW_WR_UBOUND29 \
	0x1202a4UL
#define PXP2_REG_RQ_BW_WR_UBOUND30 \
	0x1202a8UL
#define PXP2_REG_RQ_CDU_ENDIAN_M \
	0x1201a0UL
#define PXP2_REG_RQ_CDU_FIRST_ILT \
	0x12061cUL
#define PXP2_REG_RQ_CDU_LAST_ILT \
	0x120620UL
#define PXP2_REG_RQ_CDU_P_SIZE \
	0x120018UL
#define PXP2_REG_RQ_CFG_DONE \
	0x1201b4UL
#define PXP2_REG_RQ_DBG_ENDIAN_M \
	0x1201a4UL
#define PXP2_REG_RQ_DISABLE_INPUTS \
	0x120330UL
#define PXP2_REG_RQ_DRAM_ALIGN \
	0x1205b0UL
#define PXP2_REG_RQ_DRAM_ALIGN_RD \
	0x12092cUL
#define PXP2_REG_RQ_DRAM_ALIGN_SEL \
	0x120930UL
#define PXP2_REG_RQ_HC_ENDIAN_M \
	0x1201a8UL
#define PXP2_REG_RQ_ONCHIP_AT \
	0x122000UL
#define PXP2_REG_RQ_ONCHIP_AT_B0 \
	0x128000UL
#define PXP2_REG_RQ_PDR_LIMIT \
	0x12033cUL
#define PXP2_REG_RQ_QM_ENDIAN_M \
	0x120194UL
#define PXP2_REG_RQ_QM_FIRST_ILT \
	0x120634UL
#define PXP2_REG_RQ_QM_LAST_ILT \
	0x120638UL
#define PXP2_REG_RQ_QM_P_SIZE \
	0x120050UL
#define PXP2_REG_RQ_RBC_DONE \
	0x1201b0UL
#define PXP2_REG_RQ_RD_MBS0 \
	0x120160UL
#define PXP2_REG_RQ_RD_MBS1 \
	0x120168UL
#define PXP2_REG_RQ_SRC_ENDIAN_M \
	0x12019cUL
#define PXP2_REG_RQ_SRC_FIRST_ILT \
	0x12063cUL
#define PXP2_REG_RQ_SRC_LAST_ILT \
	0x120640UL
#define PXP2_REG_RQ_SRC_P_SIZE \
	0x12006cUL
#define PXP2_REG_RQ_TM_ENDIAN_M \
	0x120198UL
#define PXP2_REG_RQ_TM_FIRST_ILT \
	0x120644UL
#define PXP2_REG_RQ_TM_LAST_ILT \
	0x120648UL
#define PXP2_REG_RQ_TM_P_SIZE \
	0x120034UL
#define PXP2_REG_RQ_WR_MBS0 \
	0x12015cUL
#define PXP2_REG_RQ_WR_MBS1 \
	0x120164UL
#define PXP2_REG_WR_CDU_MPS \
	0x1205f0UL
#define PXP2_REG_WR_CSDM_MPS \
	0x1205d0UL
#define PXP2_REG_WR_DBG_MPS \
	0x1205e8UL
#define PXP2_REG_WR_DMAE_MPS \
	0x1205ecUL
#define PXP2_REG_WR_HC_MPS \
	0x1205c8UL
#define PXP2_REG_WR_QM_MPS \
	0x1205dcUL
#define PXP2_REG_WR_SRC_MPS \
	0x1205e4UL
#define PXP2_REG_WR_TM_MPS \
	0x1205e0UL
#define PXP2_REG_WR_TSDM_MPS \
	0x1205d4UL
#define PXP2_REG_WR_USDMDP_TH \
	0x120348UL
#define PXP2_REG_WR_USDM_MPS \
	0x1205ccUL
#define PXP2_REG_WR_XSDM_MPS \
	0x1205d8UL
#define PXP_REG_HST_DISCARD_DOORBELLS \
	0x1030a4UL
#define PXP_REG_HST_DISCARD_INTERNAL_WRITES \
	0x1030a8UL
#define PXP_REG_HST_ZONE_PERMISSION_TABLE \
	0x103400UL
#define PXP_REG_PXP_INT_MASK_0 \
	0x103074UL
#define PXP_REG_PXP_INT_MASK_1 \
	0x103084UL
#define PXP_REG_PXP_INT_STS_CLR_0 \
	0x10306cUL
#define PXP_REG_PXP_INT_STS_CLR_1 \
	0x10307cUL
#define PXP_REG_PXP_PRTY_MASK \
	0x103094UL
#define PXP_REG_PXP_PRTY_STS_CLR \
	0x10308cUL
#define QM_REG_BASEADDR \
	0x168900UL
#define QM_REG_BASEADDR_EXT_A \
	0x16e100UL
#define QM_REG_BYTECRDCMDQ_0 \
	0x16e6e8UL
#define QM_REG_CONNNUM_0 \
	0x168020UL
#define QM_REG_PF_EN \
	0x16e70cUL
#define QM_REG_PF_USG_CNT_0 \
	0x16e040UL
#define QM_REG_PTRTBL \
	0x168a00UL
#define QM_REG_PTRTBL_EXT_A \
	0x16e200UL
#define QM_REG_QM_INT_MASK \
	0x168444UL
#define QM_REG_QM_PRTY_MASK \
	0x168454UL
#define QM_REG_QM_PRTY_STS_CLR \
	0x16844cUL
#define QM_REG_QVOQIDX_0 \
	0x1680f4UL
#define QM_REG_SOFT_RESET \
	0x168428UL
#define QM_REG_VOQQMASK_0_LSB \
	0x168240UL
#define SEM_FAST_REG_PARITY_RST \
	0x18840UL
#define SRC_REG_COUNTFREE0 \
	0x40500UL
#define SRC_REG_FIRSTFREE0 \
	0x40510UL
#define SRC_REG_KEYSEARCH_0 \
	0x40458UL
#define SRC_REG_KEYSEARCH_1 \
	0x4045cUL
#define SRC_REG_KEYSEARCH_2 \
	0x40460UL
#define SRC_REG_KEYSEARCH_3 \
	0x40464UL
#define SRC_REG_KEYSEARCH_4 \
	0x40468UL
#define SRC_REG_KEYSEARCH_5 \
	0x4046cUL
#define SRC_REG_KEYSEARCH_6 \
	0x40470UL
#define SRC_REG_KEYSEARCH_7 \
	0x40474UL
#define SRC_REG_KEYSEARCH_8 \
	0x40478UL
#define SRC_REG_KEYSEARCH_9 \
	0x4047cUL
#define SRC_REG_LASTFREE0 \
	0x40530UL
#define SRC_REG_NUMBER_HASH_BITS0 \
	0x40400UL
#define SRC_REG_SOFT_RST \
	0x4049cUL
#define SRC_REG_SRC_PRTY_MASK \
	0x404c8UL
#define SRC_REG_SRC_PRTY_STS_CLR \
	0x404c0UL
#define TCM_REG_PRS_IFEN \
	0x50020UL
#define TCM_REG_TCM_INT_MASK \
	0x501dcUL
#define TCM_REG_TCM_PRTY_MASK \
	0x501ecUL
#define TCM_REG_TCM_PRTY_STS_CLR \
	0x501e4UL
#define TM_REG_EN_LINEAR0_TIMER \
	0x164014UL
#define TM_REG_LIN0_MAX_ACTIVE_CID \
	0x164048UL
#define TM_REG_LIN0_NUM_SCANS \
	0x1640a0UL
#define TM_REG_LIN0_SCAN_ON \
	0x1640d0UL
#define TM_REG_LIN0_SCAN_TIME \
	0x16403cUL
#define TM_REG_LIN0_VNIC_UC \
	0x164128UL
#define TM_REG_TM_INT_MASK \
	0x1640fcUL
#define TM_REG_TM_PRTY_MASK \
	0x16410cUL
#define TM_REG_TM_PRTY_STS_CLR \
	0x164104UL
#define TSDM_REG_ENABLE_IN1 \
	0x42238UL
#define TSDM_REG_TSDM_INT_MASK_0 \
	0x4229cUL
#define TSDM_REG_TSDM_INT_MASK_1 \
	0x422acUL
#define TSDM_REG_TSDM_PRTY_MASK \
	0x422bcUL
#define TSDM_REG_TSDM_PRTY_STS_CLR \
	0x422b4UL
#define TSEM_REG_FAST_MEMORY \
	0x1a0000UL
#define TSEM_REG_INT_TABLE \
	0x180400UL
#define TSEM_REG_PASSIVE_BUFFER \
	0x181000UL
#define TSEM_REG_PRAM \
	0x1c0000UL
#define TSEM_REG_TSEM_INT_MASK_0 \
	0x180100UL
#define TSEM_REG_TSEM_INT_MASK_1 \
	0x180110UL
#define TSEM_REG_TSEM_PRTY_MASK_0 \
	0x180120UL
#define TSEM_REG_TSEM_PRTY_MASK_1 \
	0x180130UL
#define TSEM_REG_TSEM_PRTY_STS_CLR_0 \
	0x180118UL
#define TSEM_REG_TSEM_PRTY_STS_CLR_1 \
	0x180128UL
#define TSEM_REG_VFPF_ERR_NUM \
	0x180380UL
#define UCM_REG_UCM_INT_MASK \
	0xe01d4UL
#define UCM_REG_UCM_PRTY_MASK \
	0xe01e4UL
#define UCM_REG_UCM_PRTY_STS_CLR \
	0xe01dcUL
#define UMAC_COMMAND_CONFIG_REG_HD_ENA \
	(0x1<<10)
#define UMAC_COMMAND_CONFIG_REG_IGNORE_TX_PAUSE \
	(0x1<<28)
#define UMAC_COMMAND_CONFIG_REG_LOOP_ENA \
	(0x1<<15)
#define UMAC_COMMAND_CONFIG_REG_NO_LGTH_CHECK \
	(0x1<<24)
#define UMAC_COMMAND_CONFIG_REG_PAD_EN \
	(0x1<<5)
#define UMAC_COMMAND_CONFIG_REG_PAUSE_IGNORE \
	(0x1<<8)
#define UMAC_COMMAND_CONFIG_REG_PROMIS_EN \
	(0x1<<4)
#define UMAC_COMMAND_CONFIG_REG_RX_ENA \
	(0x1<<1)
#define UMAC_COMMAND_CONFIG_REG_SW_RESET \
	(0x1<<13)
#define UMAC_COMMAND_CONFIG_REG_TX_ENA \
	(0x1<<0)
#define UMAC_REG_COMMAND_CONFIG \
	0x8UL
#define UMAC_REG_EEE_WAKE_TIMER \
	0x6cUL
#define UMAC_REG_MAC_ADDR0 \
	0xcUL
#define UMAC_REG_MAC_ADDR1 \
	0x10UL
#define UMAC_REG_MAXFR \
	0x14UL
#define UMAC_REG_UMAC_EEE_CTRL \
	0x64UL
#define UMAC_UMAC_EEE_CTRL_REG_EEE_EN \
	(0x1<<3)
#define USDM_REG_USDM_INT_MASK_0 \
	0xc42a0UL
#define USDM_REG_USDM_INT_MASK_1 \
	0xc42b0UL
#define USDM_REG_USDM_PRTY_MASK \
	0xc42c0UL
#define USDM_REG_USDM_PRTY_STS_CLR \
	0xc42b8UL
#define USEM_REG_FAST_MEMORY \
	0x320000UL
#define USEM_REG_INT_TABLE \
	0x300400UL
#define USEM_REG_PASSIVE_BUFFER \
	0x302000UL
#define USEM_REG_PRAM \
	0x340000UL
#define USEM_REG_USEM_INT_MASK_0 \
	0x300110UL
#define USEM_REG_USEM_INT_MASK_1 \
	0x300120UL
#define USEM_REG_USEM_PRTY_MASK_0 \
	0x300130UL
#define USEM_REG_USEM_PRTY_MASK_1 \
	0x300140UL
#define USEM_REG_USEM_PRTY_STS_CLR_0 \
	0x300128UL
#define USEM_REG_USEM_PRTY_STS_CLR_1 \
	0x300138UL
#define USEM_REG_VFPF_ERR_NUM \
	0x300380UL
#define VFC_MEMORIES_RST_REG_CAM_RST \
	(0x1<<0)
#define VFC_MEMORIES_RST_REG_RAM_RST \
	(0x1<<1)
#define VFC_REG_MEMORIES_RST \
	0x1943cUL
#define XCM_REG_XCM_INT_MASK \
	0x202b4UL
#define XCM_REG_XCM_PRTY_MASK \
	0x202c4UL
#define XCM_REG_XCM_PRTY_STS_CLR \
	0x202bcUL
#define XMAC_CLEAR_RX_LSS_STATUS_REG_CLEAR_LOCAL_FAULT_STATUS \
	(0x1<<0)
#define XMAC_CLEAR_RX_LSS_STATUS_REG_CLEAR_REMOTE_FAULT_STATUS \
	(0x1<<1)
#define XMAC_CTRL_REG_LINE_LOCAL_LPBK \
	(0x1<<2)
#define XMAC_CTRL_REG_RX_EN \
	(0x1<<1)
#define XMAC_CTRL_REG_SOFT_RESET \
	(0x1<<6)
#define XMAC_CTRL_REG_TX_EN \
	(0x1<<0)
#define XMAC_CTRL_REG_XLGMII_ALIGN_ENB \
	(0x1<<7)
#define XMAC_PAUSE_CTRL_REG_RX_PAUSE_EN \
	(0x1<<18)
#define XMAC_PAUSE_CTRL_REG_TX_PAUSE_EN \
	(0x1<<17)
#define XMAC_PFC_CTRL_HI_REG_FORCE_PFC_XON \
	(0x1<<1)
#define XMAC_PFC_CTRL_HI_REG_PFC_REFRESH_EN \
	(0x1<<0)
#define XMAC_PFC_CTRL_HI_REG_PFC_STATS_EN \
	(0x1<<3)
#define XMAC_PFC_CTRL_HI_REG_RX_PFC_EN \
	(0x1<<4)
#define XMAC_PFC_CTRL_HI_REG_TX_PFC_EN \
	(0x1<<5)
#define XMAC_REG_CLEAR_RX_LSS_STATUS \
	0x60UL
#define XMAC_REG_CTRL \
	0UL
#define XMAC_REG_CTRL_SA_HI \
	0x2cUL
#define XMAC_REG_CTRL_SA_LO \
	0x28UL
#define XMAC_REG_EEE_CTRL \
	0xd8UL
#define XMAC_REG_EEE_TIMERS_HI \
	0xe4UL
#define XMAC_REG_PAUSE_CTRL \
	0x68UL
#define XMAC_REG_PFC_CTRL \
	0x70UL
#define XMAC_REG_PFC_CTRL_HI \
	0x74UL
#define XMAC_REG_RX_LSS_CTRL \
	0x50UL
#define XMAC_REG_RX_LSS_STATUS \
	0x58UL
#define XMAC_REG_RX_MAX_SIZE \
	0x40UL
#define XMAC_REG_TX_CTRL \
	0x20UL
#define XMAC_RX_LSS_CTRL_REG_LOCAL_FAULT_DISABLE \
	(0x1<<0)
#define XMAC_RX_LSS_CTRL_REG_REMOTE_FAULT_DISABLE \
	(0x1<<1)
#define XSDM_REG_OPERATION_GEN \
	0x1664c4UL
#define XSDM_REG_XSDM_INT_MASK_0 \
	0x16629cUL
#define XSDM_REG_XSDM_INT_MASK_1 \
	0x1662acUL
#define XSDM_REG_XSDM_PRTY_MASK \
	0x1662bcUL
#define XSDM_REG_XSDM_PRTY_STS_CLR \
	0x1662b4UL
#define XSEM_REG_FAST_MEMORY \
	0x2a0000UL
#define XSEM_REG_INT_TABLE \
	0x280400UL
#define XSEM_REG_PASSIVE_BUFFER \
	0x282000UL
#define XSEM_REG_PRAM \
	0x2c0000UL
#define XSEM_REG_VFPF_ERR_NUM \
	0x280380UL
#define XSEM_REG_XSEM_INT_MASK_0 \
	0x280110UL
#define XSEM_REG_XSEM_INT_MASK_1 \
	0x280120UL
#define XSEM_REG_XSEM_PRTY_MASK_0 \
	0x280130UL
#define XSEM_REG_XSEM_PRTY_MASK_1 \
	0x280140UL
#define XSEM_REG_XSEM_PRTY_STS_CLR_0 \
	0x280128UL
#define XSEM_REG_XSEM_PRTY_STS_CLR_1 \
	0x280138UL
#define MCPR_ACCESS_LOCK_LOCK			     (1L<<31)
#define MCPR_IMC_COMMAND_ENABLE			    (1L<<31)
#define MCPR_IMC_COMMAND_IMC_STATUS_BITSHIFT	    16
#define MCPR_IMC_COMMAND_OPERATION_BITSHIFT	    28
#define MCPR_IMC_COMMAND_TRANSFER_ADDRESS_BITSHIFT  8
#define MCPR_NVM_ACCESS_ENABLE_EN		     (1L<<0)
#define MCPR_NVM_ACCESS_ENABLE_WR_EN		     (1L<<1)
#define MCPR_NVM_ADDR_NVM_ADDR_VALUE		     (0xffffffL<<0)
#define MCPR_NVM_CFG4_FLASH_SIZE		     (0x7L<<0)
#define MCPR_NVM_COMMAND_DOIT			     (1L<<4)
#define MCPR_NVM_COMMAND_DONE			     (1L<<3)
#define MCPR_NVM_COMMAND_FIRST			     (1L<<7)
#define MCPR_NVM_COMMAND_LAST			     (1L<<8)
#define MCPR_NVM_COMMAND_WR			     (1L<<5)
#define MCPR_NVM_SW_ARB_ARB_ARB1		     (1L<<9)
#define MCPR_NVM_SW_ARB_ARB_REQ_CLR1		     (1L<<5)
#define MCPR_NVM_SW_ARB_ARB_REQ_SET1		     (1L<<1)


#define BIGMAC_REGISTER_BMAC_CONTROL	    (0x00<<3)
#define BIGMAC_REGISTER_BMAC_XGXS_CONTROL   (0x01<<3)
#define BIGMAC_REGISTER_CNT_MAX_SIZE	    (0x05<<3)
#define BIGMAC_REGISTER_RX_CONTROL	    (0x21<<3)
#define BIGMAC_REGISTER_RX_LLFC_MSG_FLDS    (0x46<<3)
#define BIGMAC_REGISTER_RX_LSS_STATUS	    (0x43<<3)
#define BIGMAC_REGISTER_RX_MAX_SIZE	    (0x23<<3)
#define BIGMAC_REGISTER_RX_STAT_GR64	    (0x26<<3)
#define BIGMAC_REGISTER_RX_STAT_GRIPJ	    (0x42<<3)
#define BIGMAC_REGISTER_TX_CONTROL	    (0x07<<3)
#define BIGMAC_REGISTER_TX_MAX_SIZE	    (0x09<<3)
#define BIGMAC_REGISTER_TX_PAUSE_THRESHOLD  (0x0A<<3)
#define BIGMAC_REGISTER_TX_SOURCE_ADDR	    (0x08<<3)
#define BIGMAC_REGISTER_TX_STAT_GTBYT	    (0x20<<3)
#define BIGMAC_REGISTER_TX_STAT_GTPKT	    (0x0C<<3)
#define BIGMAC2_REGISTER_BMAC_CONTROL	    (0x00<<3)
#define BIGMAC2_REGISTER_BMAC_XGXS_CONTROL  (0x01<<3)
#define BIGMAC2_REGISTER_CNT_MAX_SIZE	    (0x05<<3)
#define BIGMAC2_REGISTER_PFC_CONTROL	    (0x06<<3)
#define BIGMAC2_REGISTER_RX_CONTROL	    (0x3A<<3)
#define BIGMAC2_REGISTER_RX_LLFC_MSG_FLDS   (0x62<<3)
#define BIGMAC2_REGISTER_RX_LSS_STAT	    (0x3E<<3)
#define BIGMAC2_REGISTER_RX_MAX_SIZE	    (0x3C<<3)
#define BIGMAC2_REGISTER_RX_STAT_GR64	    (0x40<<3)
#define BIGMAC2_REGISTER_RX_STAT_GRIPJ	    (0x5f<<3)
#define BIGMAC2_REGISTER_TX_CONTROL	    (0x1C<<3)
#define BIGMAC2_REGISTER_TX_MAX_SIZE	    (0x1E<<3)
#define BIGMAC2_REGISTER_TX_PAUSE_CONTROL   (0x20<<3)
#define BIGMAC2_REGISTER_TX_SOURCE_ADDR	    (0x1D<<3)
#define BIGMAC2_REGISTER_TX_STAT_GTBYT	    (0x39<<3)
#define BIGMAC2_REGISTER_TX_STAT_GTPOK	    (0x22<<3)


#define EMAC_LED_1000MB_OVERRIDE		   (1L<<1)
#define EMAC_LED_100MB_OVERRIDE			   (1L<<2)
#define EMAC_LED_10MB_OVERRIDE			   (1L<<3)
#define EMAC_LED_OVERRIDE			   (1L<<0)
#define EMAC_MDIO_COMM_COMMAND_ADDRESS	       (0L<<26)
#define EMAC_MDIO_COMM_COMMAND_READ_22	       (2L<<26)
#define EMAC_MDIO_COMM_COMMAND_READ_45	       (3L<<26)
#define EMAC_MDIO_COMM_COMMAND_WRITE_22	       (1L<<26)
#define EMAC_MDIO_COMM_COMMAND_WRITE_45	       (1L<<26)
#define EMAC_MDIO_COMM_DATA			   (0xffffL<<0)
#define EMAC_MDIO_COMM_START_BUSY		   (1L<<29)
#define EMAC_MDIO_MODE_AUTO_POLL		   (1L<<4)
#define EMAC_MDIO_MODE_CLAUSE_45		   (1L<<31)
#define EMAC_MDIO_MODE_CLOCK_CNT		   (0x3ffL<<16)
#define EMAC_MDIO_MODE_CLOCK_CNT_BITSHIFT	   16
#define EMAC_MDIO_STATUS_10MB			   (1L<<1)
#define EMAC_MODE_25G_MODE			   (1L<<5)
#define EMAC_MODE_HALF_DUPLEX			   (1L<<1)
#define EMAC_MODE_PORT_GMII		       (2L<<2)
#define EMAC_MODE_PORT_MII		       (1L<<2)
#define EMAC_MODE_PORT_MII_10M		       (3L<<2)
#define EMAC_MODE_RESET				   (1L<<0)
#define EMAC_REG_EMAC_LED					  0xc
#define EMAC_REG_EMAC_MAC_MATCH					  0x10
#define EMAC_REG_EMAC_MDIO_COMM					  0xac
#define EMAC_REG_EMAC_MDIO_MODE					  0xb4
#define EMAC_REG_EMAC_MDIO_STATUS				  0xb0
#define EMAC_REG_EMAC_MODE					  0x0
#define EMAC_REG_EMAC_RX_MODE					  0xc8
#define EMAC_REG_EMAC_RX_MTU_SIZE				  0x9c
#define EMAC_REG_EMAC_RX_STAT_AC				  0x180
#define EMAC_REG_EMAC_RX_STAT_AC_28				  0x1f4
#define EMAC_REG_EMAC_RX_STAT_AC_COUNT				  23
#define EMAC_REG_EMAC_TX_MODE					  0xbc
#define EMAC_REG_EMAC_TX_STAT_AC				  0x280
#define EMAC_REG_EMAC_TX_STAT_AC_COUNT				  22
#define EMAC_REG_RX_PFC_MODE					  0x320
#define EMAC_REG_RX_PFC_MODE_PRIORITIES			  (1L<<2)
#define EMAC_REG_RX_PFC_MODE_RX_EN			  (1L<<1)
#define EMAC_REG_RX_PFC_MODE_TX_EN			  (1L<<0)
#define EMAC_REG_RX_PFC_PARAM					  0x324
#define EMAC_REG_RX_PFC_PARAM_OPCODE_BITSHIFT		  0
#define EMAC_REG_RX_PFC_PARAM_PRIORITY_EN_BITSHIFT	  16
#define EMAC_REG_RX_PFC_STATS_XOFF_RCVD			    0x328
#define EMAC_REG_RX_PFC_STATS_XOFF_RCVD_COUNT		(0xffff<<0)
#define EMAC_REG_RX_PFC_STATS_XOFF_SENT			    0x330
#define EMAC_REG_RX_PFC_STATS_XOFF_SENT_COUNT		(0xffff<<0)
#define EMAC_REG_RX_PFC_STATS_XON_RCVD			    0x32c
#define EMAC_REG_RX_PFC_STATS_XON_RCVD_COUNT		(0xffff<<0)
#define EMAC_REG_RX_PFC_STATS_XON_SENT			    0x334
#define EMAC_REG_RX_PFC_STATS_XON_SENT_COUNT		(0xffff<<0)
#define EMAC_RX_MODE_FLOW_EN			   (1L<<2)
#define EMAC_RX_MODE_KEEP_MAC_CONTROL		   (1L<<3)
#define EMAC_RX_MODE_KEEP_VLAN_TAG		   (1L<<10)
#define EMAC_RX_MODE_PROMISCUOUS		   (1L<<8)
#define EMAC_RX_MODE_RESET			   (1L<<0)
#define EMAC_RX_MTU_SIZE_JUMBO_ENA		   (1L<<31)
#define EMAC_TX_MODE_EXT_PAUSE_EN		   (1L<<3)
#define EMAC_TX_MODE_FLOW_EN			   (1L<<4)
#define EMAC_TX_MODE_RESET			   (1L<<0)


#define MISC_REGISTERS_GPIO_0			 0
#define MISC_REGISTERS_GPIO_1			 1
#define MISC_REGISTERS_GPIO_2			 2
#define MISC_REGISTERS_GPIO_3			 3
#define MISC_REGISTERS_GPIO_CLR_POS		 16
#define MISC_REGISTERS_GPIO_FLOAT		 (0xffL<<24)
#define MISC_REGISTERS_GPIO_FLOAT_POS		 24
#define MISC_REGISTERS_GPIO_HIGH		 1
#define MISC_REGISTERS_GPIO_INPUT_HI_Z		 2
#define MISC_REGISTERS_GPIO_INT_CLR_POS		 24
#define MISC_REGISTERS_GPIO_INT_OUTPUT_CLR	 0
#define MISC_REGISTERS_GPIO_INT_OUTPUT_SET	 1
#define MISC_REGISTERS_GPIO_INT_SET_POS		 16
#define MISC_REGISTERS_GPIO_LOW			 0
#define MISC_REGISTERS_GPIO_OUTPUT_HIGH		 1
#define MISC_REGISTERS_GPIO_OUTPUT_LOW		 0
#define MISC_REGISTERS_GPIO_PORT_SHIFT		 4
#define MISC_REGISTERS_GPIO_SET_POS		 8
#define MISC_REGISTERS_RESET_REG_1_CLEAR				0x588
#define MISC_REGISTERS_RESET_REG_1_RST_BRB1				(0x1<<0)
#define MISC_REGISTERS_RESET_REG_1_RST_DORQ \
	(0x1<<19)
#define MISC_REGISTERS_RESET_REG_1_RST_HC \
	(0x1<<29)
#define MISC_REGISTERS_RESET_REG_1_RST_PXP \
	(0x1<<26)
#define MISC_REGISTERS_RESET_REG_1_RST_PXPV \
	(0x1<<27)
#define MISC_REGISTERS_RESET_REG_1_RST_QM \
	(0x1<<17)
#define MISC_REGISTERS_RESET_REG_1_SET					0x584
#define MISC_REGISTERS_RESET_REG_2_CLEAR				0x598
#define MISC_REGISTERS_RESET_REG_2_MSTAT0 \
	(0x1<<24)
#define MISC_REGISTERS_RESET_REG_2_MSTAT1 \
	(0x1<<25)
#define MISC_REGISTERS_RESET_REG_2_PGLC \
	(0x1<<19)
#define MISC_REGISTERS_RESET_REG_2_RST_ATC \
	(0x1<<17)
#define MISC_REGISTERS_RESET_REG_2_RST_BMAC0				(0x1<<0)
#define MISC_REGISTERS_RESET_REG_2_RST_BMAC1				(0x1<<1)
#define MISC_REGISTERS_RESET_REG_2_RST_EMAC0				(0x1<<2)
#define MISC_REGISTERS_RESET_REG_2_RST_EMAC0_HARD_CORE \
	(0x1<<14)
#define MISC_REGISTERS_RESET_REG_2_RST_EMAC1				(0x1<<3)
#define MISC_REGISTERS_RESET_REG_2_RST_EMAC1_HARD_CORE \
	(0x1<<15)
#define MISC_REGISTERS_RESET_REG_2_RST_GRC				(0x1<<4)
#define MISC_REGISTERS_RESET_REG_2_RST_MCP_N_HARD_CORE_RST_B		(0x1<<6)
#define MISC_REGISTERS_RESET_REG_2_RST_MCP_N_RESET_CMN_CORE		(0x1<<8)
#define MISC_REGISTERS_RESET_REG_2_RST_MCP_N_RESET_CMN_CPU		(0x1<<7)
#define MISC_REGISTERS_RESET_REG_2_RST_MCP_N_RESET_REG_HARD_CORE	(0x1<<5)
#define MISC_REGISTERS_RESET_REG_2_RST_MISC_CORE \
	(0x1<<11)
#define MISC_REGISTERS_RESET_REG_2_RST_PCI_MDIO \
	(0x1<<13)
#define MISC_REGISTERS_RESET_REG_2_RST_PXP_RQ_RD_WR \
	(0x1<<16)
#define MISC_REGISTERS_RESET_REG_2_RST_RBCN				(0x1<<9)
#define MISC_REGISTERS_RESET_REG_2_SET					0x594
#define MISC_REGISTERS_RESET_REG_2_UMAC0 \
	(0x1<<20)
#define MISC_REGISTERS_RESET_REG_2_UMAC1 \
	(0x1<<21)
#define MISC_REGISTERS_RESET_REG_2_XMAC \
	(0x1<<22)
#define MISC_REGISTERS_RESET_REG_2_XMAC_SOFT \
	(0x1<<23)
#define MISC_REGISTERS_RESET_REG_3_CLEAR				0x5a8
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_SERDES0_IDDQ		(0x1<<1)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_SERDES0_PWRDWN		(0x1<<2)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_SERDES0_PWRDWN_SD	(0x1<<3)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_SERDES0_RSTB_HW		(0x1<<0)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_XGXS0_IDDQ		(0x1<<5)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_XGXS0_PWRDWN		(0x1<<6)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_XGXS0_PWRDWN_SD		(0x1<<7)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_XGXS0_RSTB_HW		(0x1<<4)
#define MISC_REGISTERS_RESET_REG_3_MISC_NIG_MUX_XGXS0_TXD_FIFO_RSTB	(0x1<<8)
#define MISC_REGISTERS_RESET_REG_3_SET					0x5a4
#define MISC_SPIO_CLR_POS	       16
#define MISC_SPIO_FLOAT		       (0xffL<<24)
#define MISC_SPIO_FLOAT_POS	       24
#define MISC_SPIO_INPUT_HI_Z	       2
#define MISC_SPIO_INT_OLD_SET_POS      16
#define MISC_SPIO_OUTPUT_HIGH	       1
#define MISC_SPIO_OUTPUT_LOW	       0
#define MISC_SPIO_SET_POS	       8
#define MISC_SPIO_SPIO4		       0x10
#define MISC_SPIO_SPIO5		       0x20
#define HW_LOCK_MAX_RESOURCE_VALUE		 31
#define HW_LOCK_RESOURCE_DRV_FLAGS		 10
#define HW_LOCK_RESOURCE_GPIO			 1
#define HW_LOCK_RESOURCE_MDIO			 0
#define HW_LOCK_RESOURCE_NVRAM			 12
#define HW_LOCK_RESOURCE_PORT0_ATT_MASK		 3
#define HW_LOCK_RESOURCE_RECOVERY_LEADER_0	 8
#define HW_LOCK_RESOURCE_RECOVERY_LEADER_1	 9
#define HW_LOCK_RESOURCE_RECOVERY_REG		 11
#define HW_LOCK_RESOURCE_RESET			 5
#define HW_LOCK_RESOURCE_SPIO			 2


#define AEU_INPUTS_ATTN_BITS_ATC_HW_INTERRUPT		      (0x1<<4)
#define AEU_INPUTS_ATTN_BITS_ATC_PARITY_ERROR		      (0x1<<5)
#define AEU_INPUTS_ATTN_BITS_BRB_HW_INTERRUPT		      (0x1<<19)
#define AEU_INPUTS_ATTN_BITS_BRB_PARITY_ERROR		      (0x1<<18)
#define AEU_INPUTS_ATTN_BITS_CCM_HW_INTERRUPT		      (0x1<<31)
#define AEU_INPUTS_ATTN_BITS_CCM_PARITY_ERROR		      (0x1<<30)
#define AEU_INPUTS_ATTN_BITS_CDU_HW_INTERRUPT		      (0x1<<9)
#define AEU_INPUTS_ATTN_BITS_CDU_PARITY_ERROR		      (0x1<<8)
#define AEU_INPUTS_ATTN_BITS_CFC_HW_INTERRUPT		      (0x1<<7)
#define AEU_INPUTS_ATTN_BITS_CFC_PARITY_ERROR		      (0x1<<6)
#define AEU_INPUTS_ATTN_BITS_CSDM_HW_INTERRUPT		      (0x1<<29)
#define AEU_INPUTS_ATTN_BITS_CSDM_PARITY_ERROR		      (0x1<<28)
#define AEU_INPUTS_ATTN_BITS_CSEMI_HW_INTERRUPT		      (0x1<<1)
#define AEU_INPUTS_ATTN_BITS_CSEMI_PARITY_ERROR		      (0x1<<0)
#define AEU_INPUTS_ATTN_BITS_DEBUG_PARITY_ERROR		      (0x1<<18)
#define AEU_INPUTS_ATTN_BITS_DMAE_HW_INTERRUPT		      (0x1<<11)
#define AEU_INPUTS_ATTN_BITS_DMAE_PARITY_ERROR		      (0x1<<10)
#define AEU_INPUTS_ATTN_BITS_DOORBELLQ_HW_INTERRUPT	      (0x1<<13)
#define AEU_INPUTS_ATTN_BITS_DOORBELLQ_PARITY_ERROR	      (0x1<<12)
#define AEU_INPUTS_ATTN_BITS_GPIO0_FUNCTION_0		      (0x1<<2)
#define AEU_INPUTS_ATTN_BITS_IGU_PARITY_ERROR		      (0x1<<12)
#define AEU_INPUTS_ATTN_BITS_MCP_LATCHED_ROM_PARITY	      (0x1<<28)
#define AEU_INPUTS_ATTN_BITS_MCP_LATCHED_SCPAD_PARITY	      (0x1UL<<31)
#define AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_RX_PARITY	      (0x1<<29)
#define AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_TX_PARITY	      (0x1<<30)
#define AEU_INPUTS_ATTN_BITS_MISC_HW_INTERRUPT		      (0x1<<15)
#define AEU_INPUTS_ATTN_BITS_MISC_PARITY_ERROR		      (0x1<<14)
#define AEU_INPUTS_ATTN_BITS_NIG_PARITY_ERROR		      (0x1<<14)
#define AEU_INPUTS_ATTN_BITS_PARSER_PARITY_ERROR	      (0x1<<20)
#define AEU_INPUTS_ATTN_BITS_PBCLIENT_HW_INTERRUPT	      (0x1UL<<31)
#define AEU_INPUTS_ATTN_BITS_PBCLIENT_PARITY_ERROR	      (0x1<<30)
#define AEU_INPUTS_ATTN_BITS_PBF_PARITY_ERROR		      (0x1<<0)
#define AEU_INPUTS_ATTN_BITS_PGLUE_HW_INTERRUPT		      (0x1<<2)
#define AEU_INPUTS_ATTN_BITS_PGLUE_PARITY_ERROR		      (0x1<<3)
#define AEU_INPUTS_ATTN_BITS_PXPPCICLOCKCLIENT_HW_INTERRUPT   (0x1<<5)
#define AEU_INPUTS_ATTN_BITS_PXPPCICLOCKCLIENT_PARITY_ERROR   (0x1<<4)
#define AEU_INPUTS_ATTN_BITS_PXP_HW_INTERRUPT		      (0x1<<3)
#define AEU_INPUTS_ATTN_BITS_PXP_PARITY_ERROR		      (0x1<<2)
#define AEU_INPUTS_ATTN_BITS_QM_HW_INTERRUPT		      (0x1<<3)
#define AEU_INPUTS_ATTN_BITS_QM_PARITY_ERROR		      (0x1<<2)
#define AEU_INPUTS_ATTN_BITS_SEARCHER_PARITY_ERROR	      (0x1<<22)
#define AEU_INPUTS_ATTN_BITS_SPIO5			      (0x1<<15)
#define AEU_INPUTS_ATTN_BITS_TCM_HW_INTERRUPT		      (0x1<<27)
#define AEU_INPUTS_ATTN_BITS_TCM_PARITY_ERROR		      (0x1<<26)
#define AEU_INPUTS_ATTN_BITS_TIMERS_HW_INTERRUPT	      (0x1<<5)
#define AEU_INPUTS_ATTN_BITS_TIMERS_PARITY_ERROR	      (0x1<<4)
#define AEU_INPUTS_ATTN_BITS_TSDM_HW_INTERRUPT		      (0x1<<25)
#define AEU_INPUTS_ATTN_BITS_TSDM_PARITY_ERROR		      (0x1<<24)
#define AEU_INPUTS_ATTN_BITS_TSEMI_HW_INTERRUPT		      (0x1<<29)
#define AEU_INPUTS_ATTN_BITS_TSEMI_PARITY_ERROR		      (0x1<<28)
#define AEU_INPUTS_ATTN_BITS_UCM_HW_INTERRUPT		      (0x1<<23)
#define AEU_INPUTS_ATTN_BITS_UCM_PARITY_ERROR		      (0x1<<22)
#define AEU_INPUTS_ATTN_BITS_UPB_HW_INTERRUPT		      (0x1<<27)
#define AEU_INPUTS_ATTN_BITS_UPB_PARITY_ERROR		      (0x1<<26)
#define AEU_INPUTS_ATTN_BITS_USDM_HW_INTERRUPT		      (0x1<<21)
#define AEU_INPUTS_ATTN_BITS_USDM_PARITY_ERROR		      (0x1<<20)
#define AEU_INPUTS_ATTN_BITS_USEMI_HW_INTERRUPT		      (0x1<<25)
#define AEU_INPUTS_ATTN_BITS_USEMI_PARITY_ERROR		      (0x1<<24)
#define AEU_INPUTS_ATTN_BITS_VAUX_PCI_CORE_PARITY_ERROR	      (0x1<<16)
#define AEU_INPUTS_ATTN_BITS_XCM_HW_INTERRUPT		      (0x1<<9)
#define AEU_INPUTS_ATTN_BITS_XCM_PARITY_ERROR		      (0x1<<8)
#define AEU_INPUTS_ATTN_BITS_XSDM_HW_INTERRUPT		      (0x1<<7)
#define AEU_INPUTS_ATTN_BITS_XSDM_PARITY_ERROR		      (0x1<<6)
#define AEU_INPUTS_ATTN_BITS_XSEMI_HW_INTERRUPT		      (0x1<<11)
#define AEU_INPUTS_ATTN_BITS_XSEMI_PARITY_ERROR		      (0x1<<10)
#define HW_PRTY_ASSERT_SET_0 \
(AEU_INPUTS_ATTN_BITS_BRB_PARITY_ERROR	    |\
  AEU_INPUTS_ATTN_BITS_PARSER_PARITY_ERROR   |\
  AEU_INPUTS_ATTN_BITS_TSDM_PARITY_ERROR     |\
  AEU_INPUTS_ATTN_BITS_SEARCHER_PARITY_ERROR |\
  AEU_INPUTS_ATTN_BITS_TSEMI_PARITY_ERROR |\
  AEU_INPUTS_ATTN_BITS_TCM_PARITY_ERROR |\
  AEU_INPUTS_ATTN_BITS_PBCLIENT_PARITY_ERROR)
#define HW_PRTY_ASSERT_SET_1 \
(AEU_INPUTS_ATTN_BITS_PBF_PARITY_ERROR		 |\
  AEU_INPUTS_ATTN_BITS_QM_PARITY_ERROR		  |\
  AEU_INPUTS_ATTN_BITS_TIMERS_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_XSDM_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_XCM_PARITY_ERROR		  |\
  AEU_INPUTS_ATTN_BITS_XSEMI_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_DOORBELLQ_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_NIG_PARITY_ERROR		  |\
  AEU_INPUTS_ATTN_BITS_VAUX_PCI_CORE_PARITY_ERROR |\
  AEU_INPUTS_ATTN_BITS_DEBUG_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_USDM_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_UCM_PARITY_ERROR		  |\
  AEU_INPUTS_ATTN_BITS_USEMI_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_UPB_PARITY_ERROR		  |\
  AEU_INPUTS_ATTN_BITS_CSDM_PARITY_ERROR	  |\
  AEU_INPUTS_ATTN_BITS_CCM_PARITY_ERROR)
#define HW_PRTY_ASSERT_SET_2 \
(AEU_INPUTS_ATTN_BITS_CSEMI_PARITY_ERROR	     |\
  AEU_INPUTS_ATTN_BITS_PXP_PARITY_ERROR		      |\
  AEU_INPUTS_ATTN_BITS_PXPPCICLOCKCLIENT_PARITY_ERROR |\
  AEU_INPUTS_ATTN_BITS_CFC_PARITY_ERROR		      |\
  AEU_INPUTS_ATTN_BITS_CDU_PARITY_ERROR		      |\
  AEU_INPUTS_ATTN_BITS_DMAE_PARITY_ERROR	      |\
  AEU_INPUTS_ATTN_BITS_IGU_PARITY_ERROR		      |\
  AEU_INPUTS_ATTN_BITS_MISC_PARITY_ERROR)
#define HW_PRTY_ASSERT_SET_3 \
(AEU_INPUTS_ATTN_BITS_MCP_LATCHED_ROM_PARITY	     | \
  AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_RX_PARITY      | \
  AEU_INPUTS_ATTN_BITS_MCP_LATCHED_UMP_TX_PARITY      | \
  AEU_INPUTS_ATTN_BITS_MCP_LATCHED_SCPAD_PARITY)
#define HW_PRTY_ASSERT_SET_4 \
(AEU_INPUTS_ATTN_BITS_PGLUE_PARITY_ERROR |\
  AEU_INPUTS_ATTN_BITS_ATC_PARITY_ERROR)
#define HW_INTERRUT_ASSERT_SET_0 \
(AEU_INPUTS_ATTN_BITS_TSDM_HW_INTERRUPT  |\
  AEU_INPUTS_ATTN_BITS_TCM_HW_INTERRUPT   |\
  AEU_INPUTS_ATTN_BITS_TSEMI_HW_INTERRUPT |\
  AEU_INPUTS_ATTN_BITS_BRB_HW_INTERRUPT   |\
  AEU_INPUTS_ATTN_BITS_PBCLIENT_HW_INTERRUPT)
#define HW_INTERRUT_ASSERT_SET_1 \
(AEU_INPUTS_ATTN_BITS_QM_HW_INTERRUPT	    |\
  AEU_INPUTS_ATTN_BITS_TIMERS_HW_INTERRUPT   |\
  AEU_INPUTS_ATTN_BITS_XSDM_HW_INTERRUPT     |\
  AEU_INPUTS_ATTN_BITS_XCM_HW_INTERRUPT      |\
  AEU_INPUTS_ATTN_BITS_XSEMI_HW_INTERRUPT    |\
  AEU_INPUTS_ATTN_BITS_USDM_HW_INTERRUPT     |\
  AEU_INPUTS_ATTN_BITS_UCM_HW_INTERRUPT      |\
  AEU_INPUTS_ATTN_BITS_USEMI_HW_INTERRUPT    |\
  AEU_INPUTS_ATTN_BITS_UPB_HW_INTERRUPT      |\
  AEU_INPUTS_ATTN_BITS_CSDM_HW_INTERRUPT     |\
  AEU_INPUTS_ATTN_BITS_CCM_HW_INTERRUPT)
#define HW_INTERRUT_ASSERT_SET_2 \
(AEU_INPUTS_ATTN_BITS_CSEMI_HW_INTERRUPT	       |\
  AEU_INPUTS_ATTN_BITS_PXP_HW_INTERRUPT			|\
  AEU_INPUTS_ATTN_BITS_CFC_HW_INTERRUPT			|\
  AEU_INPUTS_ATTN_BITS_CDU_HW_INTERRUPT			|\
  AEU_INPUTS_ATTN_BITS_DMAE_HW_INTERRUPT		|\
  AEU_INPUTS_ATTN_BITS_PXPPCICLOCKCLIENT_HW_INTERRUPT	|\
  AEU_INPUTS_ATTN_BITS_MISC_HW_INTERRUPT)


#define RESERVED_GENERAL_ATTENTION_BIT_0	0

#define EVEREST_GEN_ATTN_IN_USE_MASK		0x7ffe0
#define EVEREST_LATCHED_ATTN_IN_USE_MASK	0xffe00000

#define RESERVED_GENERAL_ATTENTION_BIT_6	6
#define RESERVED_GENERAL_ATTENTION_BIT_7	7
#define RESERVED_GENERAL_ATTENTION_BIT_8	8
#define RESERVED_GENERAL_ATTENTION_BIT_9	9
#define RESERVED_GENERAL_ATTENTION_BIT_10	10
#define RESERVED_GENERAL_ATTENTION_BIT_11	11
#define RESERVED_GENERAL_ATTENTION_BIT_12	12
#define RESERVED_GENERAL_ATTENTION_BIT_13	13
#define RESERVED_GENERAL_ATTENTION_BIT_14	14
#define RESERVED_GENERAL_ATTENTION_BIT_15	15
#define RESERVED_GENERAL_ATTENTION_BIT_16	16
#define RESERVED_GENERAL_ATTENTION_BIT_17	17
#define RESERVED_GENERAL_ATTENTION_BIT_18	18
#define RESERVED_GENERAL_ATTENTION_BIT_19	19
#define RESERVED_GENERAL_ATTENTION_BIT_20	20
#define RESERVED_GENERAL_ATTENTION_BIT_21	21

/* storm asserts attention bits */
#define TSTORM_FATAL_ASSERT_ATTENTION_BIT     RESERVED_GENERAL_ATTENTION_BIT_7
#define USTORM_FATAL_ASSERT_ATTENTION_BIT     RESERVED_GENERAL_ATTENTION_BIT_8
#define CSTORM_FATAL_ASSERT_ATTENTION_BIT     RESERVED_GENERAL_ATTENTION_BIT_9
#define XSTORM_FATAL_ASSERT_ATTENTION_BIT     RESERVED_GENERAL_ATTENTION_BIT_10

/* mcp error attention bit */
#define MCP_FATAL_ASSERT_ATTENTION_BIT	      RESERVED_GENERAL_ATTENTION_BIT_11

/*E1H NIG status sync attention mapped to group 4-7*/
#define LINK_SYNC_ATTENTION_BIT_FUNC_0	    RESERVED_GENERAL_ATTENTION_BIT_12
#define LINK_SYNC_ATTENTION_BIT_FUNC_1	    RESERVED_GENERAL_ATTENTION_BIT_13
#define LINK_SYNC_ATTENTION_BIT_FUNC_2	    RESERVED_GENERAL_ATTENTION_BIT_14
#define LINK_SYNC_ATTENTION_BIT_FUNC_3	    RESERVED_GENERAL_ATTENTION_BIT_15
#define LINK_SYNC_ATTENTION_BIT_FUNC_4	    RESERVED_GENERAL_ATTENTION_BIT_16
#define LINK_SYNC_ATTENTION_BIT_FUNC_5	    RESERVED_GENERAL_ATTENTION_BIT_17
#define LINK_SYNC_ATTENTION_BIT_FUNC_6	    RESERVED_GENERAL_ATTENTION_BIT_18
#define LINK_SYNC_ATTENTION_BIT_FUNC_7	    RESERVED_GENERAL_ATTENTION_BIT_19

	/* Used For Error Recovery: changing this will require more \
	changes in code that assume
 * error recovery uses general attn bit20 ! */
#define ERROR_RECOVERY_ATTENTION_BIT \
	RESERVED_GENERAL_ATTENTION_BIT_20
#define RESERVED_ATTENTION_BIT \
	RESERVED_GENERAL_ATTENTION_BIT_21

#define LATCHED_ATTN_RBCR			23
#define LATCHED_ATTN_RBCT			24
#define LATCHED_ATTN_RBCN			25
#define LATCHED_ATTN_RBCU			26
#define LATCHED_ATTN_RBCP			27
#define LATCHED_ATTN_TIMEOUT_GRC		28
#define LATCHED_ATTN_RSVD_GRC			29
#define LATCHED_ATTN_ROM_PARITY_MCP		30
#define LATCHED_ATTN_UM_RX_PARITY_MCP		31
#define LATCHED_ATTN_UM_TX_PARITY_MCP		32
#define LATCHED_ATTN_SCPAD_PARITY_MCP		33

#define GENERAL_ATTEN_WORD(atten_name)	       ((94 + atten_name) / 32)
#define GENERAL_ATTEN_OFFSET(atten_name)       (1UL << ((94 + atten_name) % 32))


/*
 * This file defines GRC base address for every block.
 * This file is included by chipsim, asm microcode and cpp microcode.
 * These values are used in Design.xml on regBase attribute
 * Use the base with the generated offsets of specific registers.
 */

#define GRCBASE_PXPCS	    0x000000
#define GRCBASE_PCICONFIG   0x002000
#define GRCBASE_PCIREG	    0x002400
#define GRCBASE_EMAC0	    0x008000
#define GRCBASE_EMAC1	    0x008400
#define GRCBASE_DBU		0x008800
#define GRCBASE_PGLUE_B	    0x009000
#define GRCBASE_MISC	    0x00A000
#define GRCBASE_DBG		0x00C000
#define GRCBASE_NIG		0x010000
#define GRCBASE_XCM		0x020000
#define GRCBASE_PRS	    0x040000
#define GRCBASE_SRCH	    0x040400
#define GRCBASE_TSDM	    0x042000
#define GRCBASE_TCM		0x050000
#define GRCBASE_BRB1	    0x060000
#define GRCBASE_MCP		0x080000
#define GRCBASE_UPB		0x0C1000
#define GRCBASE_CSDM	    0x0C2000
#define GRCBASE_USDM	    0x0C4000
#define GRCBASE_CCM		0x0D0000
#define GRCBASE_UCM		0x0E0000
#define GRCBASE_CDU		0x101000
#define GRCBASE_DMAE	    0x102000
#define GRCBASE_PXP		0x103000
#define GRCBASE_CFC		0x104000
#define GRCBASE_HC		0x108000
#define GRCBASE_ATC		0x110000
#define GRCBASE_PXP2	    0x120000
#define GRCBASE_IGU	    0x130000
#define GRCBASE_PBF	    0x140000
#define GRCBASE_UMAC0	    0x160000
#define GRCBASE_UMAC1	    0x160400
#define GRCBASE_XPB	    0x161000
#define GRCBASE_MSTAT0	    0x162000
#define GRCBASE_MSTAT1	    0x162800
#define GRCBASE_XMAC0	    0x163000
#define GRCBASE_XMAC1	    0x163800
#define GRCBASE_TIMERS	    0x164000
#define GRCBASE_XSDM	    0x166000
#define GRCBASE_QM		0x168000
#define GRCBASE_QM_4PORT    0x168000
#define GRCBASE_DQ		0x170000
#define GRCBASE_TSEM	    0x180000
#define GRCBASE_CSEM	    0x200000
#define GRCBASE_XSEM	    0x280000
#define GRCBASE_XSEM_4PORT  0x280000
#define GRCBASE_USEM	    0x300000
#define GRCBASE_MCP_A	    0x380000
#define GRCBASE_MISC_AEU    GRCBASE_MISC
#define GRCBASE_Tstorm	    GRCBASE_TSEM
#define GRCBASE_Cstorm	    GRCBASE_CSEM
#define GRCBASE_Xstorm	    GRCBASE_XSEM
#define GRCBASE_Ustorm	    GRCBASE_USEM


/* offset of configuration space in the pci core register */
#define PCICFG_OFFSET					0x2000
#define PCICFG_VENDOR_ID_OFFSET				0x00
#define PCICFG_DEVICE_ID_OFFSET				0x02
#define PCICFG_COMMAND_OFFSET				0x04
#define PCICFG_COMMAND_IO_SPACE			(1<<0)
#define PCICFG_COMMAND_MEM_SPACE		(1<<1)
#define PCICFG_COMMAND_BUS_MASTER		(1<<2)
#define PCICFG_COMMAND_SPECIAL_CYCLES		(1<<3)
#define PCICFG_COMMAND_MWI_CYCLES		(1<<4)
#define PCICFG_COMMAND_VGA_SNOOP		(1<<5)
#define PCICFG_COMMAND_PERR_ENA			(1<<6)
#define PCICFG_COMMAND_STEPPING			(1<<7)
#define PCICFG_COMMAND_SERR_ENA			(1<<8)
#define PCICFG_COMMAND_FAST_B2B			(1<<9)
#define PCICFG_COMMAND_INT_DISABLE		(1<<10)
#define PCICFG_COMMAND_RESERVED			(0x1f<<11)
#define PCICFG_STATUS_OFFSET				0x06
#define PCICFG_REVISION_ID_OFFSET			0x08
#define PCICFG_REVESION_ID_MASK			0xff
#define PCICFG_REVESION_ID_ERROR_VAL		0xff
#define PCICFG_CACHE_LINE_SIZE				0x0c
#define PCICFG_LATENCY_TIMER				0x0d
#define PCICFG_HEADER_TYPE				0x0e
#define PCICFG_HEADER_TYPE_NORMAL	   0
#define PCICFG_HEADER_TYPE_BRIDGE	   1
#define PCICFG_HEADER_TYPE_CARDBUS	   2
#define PCICFG_BAR_1_LOW				0x10
#define PCICFG_BAR_1_HIGH				0x14
#define PCICFG_BAR_2_LOW				0x18
#define PCICFG_BAR_2_HIGH				0x1c
#define PCICFG_BAR_3_LOW				0x20
#define PCICFG_BAR_3_HIGH				0x24
#define PCICFG_SUBSYSTEM_VENDOR_ID_OFFSET		0x2c
#define PCICFG_SUBSYSTEM_ID_OFFSET			0x2e
#define PCICFG_INT_LINE					0x3c
#define PCICFG_INT_PIN					0x3d
#define PCICFG_PM_CAPABILITY				0x48
#define PCICFG_PM_CAPABILITY_VERSION		(0x3<<16)
#define PCICFG_PM_CAPABILITY_CLOCK		(1<<19)
#define PCICFG_PM_CAPABILITY_RESERVED		(1<<20)
#define PCICFG_PM_CAPABILITY_DSI		(1<<21)
#define PCICFG_PM_CAPABILITY_AUX_CURRENT	(0x7<<22)
#define PCICFG_PM_CAPABILITY_D1_SUPPORT		(1<<25)
#define PCICFG_PM_CAPABILITY_D2_SUPPORT		(1<<26)
#define PCICFG_PM_CAPABILITY_PME_IN_D0		(1<<27)
#define PCICFG_PM_CAPABILITY_PME_IN_D1		(1<<28)
#define PCICFG_PM_CAPABILITY_PME_IN_D2		(1<<29)
#define PCICFG_PM_CAPABILITY_PME_IN_D3_HOT	(1<<30)
#define PCICFG_PM_CAPABILITY_PME_IN_D3_COLD	(1<<31)
#define PCICFG_PM_CSR_OFFSET				0x4c
#define PCICFG_PM_CSR_STATE			(0x3<<0)
#define PCICFG_PM_CSR_PME_ENABLE		(1<<8)
#define PCICFG_PM_CSR_PME_STATUS		(1<<15)
#define PCICFG_VPD_FLAG_ADDR_OFFSET			0x50
#define PCICFG_VPD_DATA_OFFSET				0x54
#define PCICFG_MSI_CAP_ID_OFFSET			0x58
#define PCICFG_MSI_CONTROL_ENABLE		(0x1<<16)
#define PCICFG_MSI_CONTROL_MCAP			(0x7<<17)
#define PCICFG_MSI_CONTROL_MENA			(0x7<<20)
#define PCICFG_MSI_CONTROL_64_BIT_ADDR_CAP	(0x1<<23)
#define PCICFG_MSI_CONTROL_MSI_PVMASK_CAPABLE	(0x1<<24)
#define PCICFG_MSI_ADDR_LOW_OFFSET			0x5c
#define PCICFG_MSI_ADDR_HIGH_OFFSET			0x60
#define PCICFG_MSI_DATA_OFFSET				0x64
#define PCICFG_GRC_ADDRESS				0x78
#define PCICFG_GRC_DATA					0x80
#define PCICFG_ME_REGISTER		    0x98
#define PCICFG_MSIX_CAP_ID_OFFSET			0xa0
#define PCICFG_MSIX_CONTROL_TABLE_SIZE		(0x7ff<<16)
#define PCICFG_MSIX_CONTROL_RESERVED		(0x7<<27)
#define PCICFG_MSIX_CONTROL_FUNC_MASK		(0x1<<30)
#define PCICFG_MSIX_CONTROL_MSIX_ENABLE		(0x1<<31)

#define PCICFG_DEVICE_CONTROL				0xb4
#define PCICFG_DEVICE_CONTROL_NP_TRANSACTION_PEND   (1<<21)
#define PCICFG_DEVICE_STATUS				0xb6
#define PCICFG_DEVICE_STATUS_CORR_ERR_DET	(1<<0)
#define PCICFG_DEVICE_STATUS_NON_FATAL_ERR_DET	(1<<1)
#define PCICFG_DEVICE_STATUS_FATAL_ERR_DET	(1<<2)
#define PCICFG_DEVICE_STATUS_UNSUP_REQ_DET	(1<<3)
#define PCICFG_DEVICE_STATUS_AUX_PWR_DET	(1<<4)
#define PCICFG_DEVICE_STATUS_NO_PEND		(1<<5)
#define PCICFG_LINK_CONTROL				0xbc


/* config_2 offset */
#define GRC_CONFIG_2_SIZE_REG				0x408
#define PCI_CONFIG_2_BAR1_SIZE			(0xfL<<0)
#define PCI_CONFIG_2_BAR1_SIZE_DISABLED		(0L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_64K		(1L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_128K		(2L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_256K		(3L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_512K		(4L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_1M		(5L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_2M		(6L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_4M		(7L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_8M		(8L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_16M		(9L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_32M		(10L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_64M		(11L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_128M		(12L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_256M		(13L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_512M		(14L<<0)
#define PCI_CONFIG_2_BAR1_SIZE_1G		(15L<<0)
#define PCI_CONFIG_2_BAR1_64ENA			(1L<<4)
#define PCI_CONFIG_2_EXP_ROM_RETRY		(1L<<5)
#define PCI_CONFIG_2_CFG_CYCLE_RETRY		(1L<<6)
#define PCI_CONFIG_2_FIRST_CFG_DONE		(1L<<7)
#define PCI_CONFIG_2_EXP_ROM_SIZE		(0xffL<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_DISABLED	(0L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_2K		(1L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_4K		(2L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_8K		(3L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_16K		(4L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_32K		(5L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_64K		(6L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_128K		(7L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_256K		(8L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_512K		(9L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_1M		(10L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_2M		(11L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_4M		(12L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_8M		(13L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_16M		(14L<<8)
#define PCI_CONFIG_2_EXP_ROM_SIZE_32M		(15L<<8)
#define PCI_CONFIG_2_BAR_PREFETCH		(1L<<16)
#define PCI_CONFIG_2_RESERVED0			(0x7fffL<<17)

/* config_3 offset */
#define GRC_CONFIG_3_SIZE_REG				0x40c
#define PCI_CONFIG_3_STICKY_BYTE			(0xffL<<0)
#define PCI_CONFIG_3_FORCE_PME			(1L<<24)
#define PCI_CONFIG_3_PME_STATUS			(1L<<25)
#define PCI_CONFIG_3_PME_ENABLE			(1L<<26)
#define PCI_CONFIG_3_PM_STATE			(0x3L<<27)
#define PCI_CONFIG_3_VAUX_PRESET			(1L<<30)
#define PCI_CONFIG_3_PCI_POWER			(1L<<31)

#define GRC_REG_DEVICE_CONTROL		    0x4d8
#define PCIE_SRIOV_DISABLE_IN_PROGRESS \
	(1 << 29) /*When VF Enable is cleared(after it was previously set),
 this register will read a value of 1, indicating that all the
 VFs that belong to this PF should be flushed.
 Software should clear this bit within 1 second of VF Enable
 being set by writing a 1 to it, so that VFs are visible to the system again.
							WC */
#define PCIE_FLR_IN_PROGRESS \
	(1 << 27) /*When FLR is initiated, this register will read a \
	value of 1 indicating that the
 Function is in FLR state. Func can be brought out of FLR state either by
 writing 1 to this register (at least 50 ms after FLR was initiated),
 or it can also be cleared automatically after 55 ms if auto_clear bit
 in private reg space is set. This bit also exists in VF register space
							WC */

#define GRC_BAR2_CONFIG					0x4e0
#define PCI_CONFIG_2_BAR2_SIZE			(0xfL<<0)
#define PCI_CONFIG_2_BAR2_SIZE_DISABLED		(0L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_64K		(1L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_128K		(2L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_256K		(3L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_512K		(4L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_1M		(5L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_2M		(6L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_4M		(7L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_8M		(8L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_16M		(9L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_32M		(10L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_64M		(11L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_128M		(12L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_256M		(13L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_512M		(14L<<0)
#define PCI_CONFIG_2_BAR2_SIZE_1G		(15L<<0)
#define PCI_CONFIG_2_BAR2_64ENA			(1L<<4)

#define GRC_BAR3_CONFIG					0x4f4
#define PCI_CONFIG_2_BAR3_SIZE			(0xfL<<0)
#define PCI_CONFIG_2_BAR3_SIZE_DISABLED		(0L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_64K		(1L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_128K		(2L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_256K		(3L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_512K		(4L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_1M		(5L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_2M		(6L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_4M		(7L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_8M		(8L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_16M		(9L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_32M		(10L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_64M		(11L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_128M		(12L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_256M		(13L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_512M		(14L<<0)
#define PCI_CONFIG_2_BAR3_SIZE_1G		(15L<<0)
#define PCI_CONFIG_2_BAR3_64ENA			(1L<<4)

#define PCI_PM_DATA_A					0x410
#define PCI_PM_DATA_B					0x414
#define PCI_ID_VAL1					0x434
#define PCI_ID_VAL2					0x438
#define PCI_ID_VAL3					0x43c
#define PCI_ID_VAL3_REVISION_ID_ERROR		  (0xffL<<24)


#define GRC_CONFIG_REG_VF_BAR_REG_1		0x608
#define GRC_CONFIG_REG_VF_BAR_REG_BAR0_SIZE	0xf

#define GRC_CONFIG_REG_VF_MSIX_CONTROL		    0x61C
#define GRC_CR_VF_MSIX_CTRL_VF_MSIX_TBL_SIZE_MASK \
	0x3F  /*This field resides in VF only and does not exist in PF.
 This register controls the read value of the MSIX_CONTROL[10:0] register
 in the VF configuration space. A value of "00000000011" indicates
 a table size of 4. The value is controlled by IOV_MSIX_TBL_SIZ
 define in version.v */

#define GRC_CONFIG_REG_PF_INIT_VF		0x624
#define GRC_CR_PF_INIT_VF_PF_FIRST_VF_NUM_MASK \
	0xf /*First VF_NUM for PF is encoded in this register.
 The number of VFs assigned to a PF is assumed to be a multiple of 8.
	Software should program these bits based on Total Number of VFs \
	programmed for each PF.
 Since registers from 0x000-0x7ff are spilt across functions, each PF will have
 the same location for the same 4 bits*/

#define PXPCS_TL_CONTROL_5			0x814
#define PXPCS_TL_CONTROL_5_UNKNOWNTYPE_ERR_ATTN	   (1 << 29) /*WC*/
#define PXPCS_TL_CONTROL_5_BOUNDARY4K_ERR_ATTN	   (1 << 28)   /*WC*/
#define PXPCS_TL_CONTROL_5_MRRS_ERR_ATTN   (1 << 27)   /*WC*/
#define PXPCS_TL_CONTROL_5_MPS_ERR_ATTN	   (1 << 26)   /*WC*/
#define PXPCS_TL_CONTROL_5_TTX_BRIDGE_FORWARD_ERR  (1 << 25)   /*WC*/
#define PXPCS_TL_CONTROL_5_TTX_TXINTF_OVERFLOW	   (1 << 24)   /*WC*/
#define PXPCS_TL_CONTROL_5_PHY_ERR_ATTN	   (1 << 23)   /*RO*/
#define PXPCS_TL_CONTROL_5_DL_ERR_ATTN	   (1 << 22)   /*RO*/
#define PXPCS_TL_CONTROL_5_TTX_ERR_NP_TAG_IN_USE   (1 << 21)   /*WC*/
#define PXPCS_TL_CONTROL_5_TRX_ERR_UNEXP_RTAG  (1 << 20)   /*WC*/
#define PXPCS_TL_CONTROL_5_PRI_SIG_TARGET_ABORT1   (1 << 19)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_UNSPPORT1   (1 << 18)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_ECRC1   (1 << 17)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_MALF_TLP1   (1 << 16)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_RX_OFLOW1   (1 << 15)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_UNEXP_CPL1  (1 << 14)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_MASTER_ABRT1    (1 << 13)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_CPL_TIMEOUT1    (1 << 12)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_FC_PRTL1	   (1 << 11)   /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_PSND_TLP1   (1 << 10)   /*WC*/
#define PXPCS_TL_CONTROL_5_PRI_SIG_TARGET_ABORT	   (1 << 9)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_UNSPPORT	   (1 << 8)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_ECRC    (1 << 7)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_MALF_TLP	   (1 << 6)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_RX_OFLOW	   (1 << 5)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_UNEXP_CPL   (1 << 4)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_MASTER_ABRT     (1 << 3)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_CPL_TIMEOUT     (1 << 2)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_FC_PRTL	   (1 << 1)    /*WC*/
#define PXPCS_TL_CONTROL_5_ERR_PSND_TLP	   (1 << 0)    /*WC*/


#define PXPCS_TL_FUNC345_STAT	   0x854
#define PXPCS_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT4    (1 << 29)   /* WC */
#define PXPCS_TL_FUNC345_STAT_ERR_UNSPPORT4 \
	(1 << 28) /* Unsupported Request Error Status in function4, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_ECRC4 \
	(1 << 27) /* ECRC Error TLP Status Status in function 4, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_MALF_TLP4 \
	(1 << 26) /* Malformed TLP Status Status in function 4, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_RX_OFLOW4 \
	(1 << 25) /* Receiver Overflow Status Status in function 4, if \
	set, generate pcie_err_attn output when this error is seen.. WC \
	*/
#define PXPCS_TL_FUNC345_STAT_ERR_UNEXP_CPL4 \
	(1 << 24) /* Unexpected Completion Status Status in function 4, \
	if set, generate pcie_err_attn output when this error is seen. WC \
	*/
#define PXPCS_TL_FUNC345_STAT_ERR_MASTER_ABRT4 \
	(1 << 23) /* Receive UR Statusin function 4. If set, generate \
	pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_CPL_TIMEOUT4 \
	(1 << 22) /* Completer Timeout Status Status in function 4, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_FC_PRTL4 \
	(1 << 21) /* Flow Control Protocol Error Status Status in \
	function 4, if set, generate pcie_err_attn output when this error \
	is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_PSND_TLP4 \
	(1 << 20) /* Poisoned Error Status Status in function 4, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT3    (1 << 19)   /* WC */
#define PXPCS_TL_FUNC345_STAT_ERR_UNSPPORT3 \
	(1 << 18) /* Unsupported Request Error Status in function3, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_ECRC3 \
	(1 << 17) /* ECRC Error TLP Status Status in function 3, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_MALF_TLP3 \
	(1 << 16) /* Malformed TLP Status Status in function 3, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_RX_OFLOW3 \
	(1 << 15) /* Receiver Overflow Status Status in function 3, if \
	set, generate pcie_err_attn output when this error is seen.. WC \
	*/
#define PXPCS_TL_FUNC345_STAT_ERR_UNEXP_CPL3 \
	(1 << 14) /* Unexpected Completion Status Status in function 3, \
	if set, generate pcie_err_attn output when this error is seen. WC \
	*/
#define PXPCS_TL_FUNC345_STAT_ERR_MASTER_ABRT3 \
	(1 << 13) /* Receive UR Statusin function 3. If set, generate \
	pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_CPL_TIMEOUT3 \
	(1 << 12) /* Completer Timeout Status Status in function 3, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_FC_PRTL3 \
	(1 << 11) /* Flow Control Protocol Error Status Status in \
	function 3, if set, generate pcie_err_attn output when this error \
	is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_PSND_TLP3 \
	(1 << 10) /* Poisoned Error Status Status in function 3, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_PRI_SIG_TARGET_ABORT2    (1 << 9)    /* WC */
#define PXPCS_TL_FUNC345_STAT_ERR_UNSPPORT2 \
	(1 << 8) /* Unsupported Request Error Status for Function 2, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_ECRC2 \
	(1 << 7) /* ECRC Error TLP Status Status for Function 2, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_MALF_TLP2 \
	(1 << 6) /* Malformed TLP Status Status for Function 2, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_RX_OFLOW2 \
	(1 << 5) /* Receiver Overflow Status Status for Function 2, if \
	set, generate pcie_err_attn output when this error is seen.. WC \
	*/
#define PXPCS_TL_FUNC345_STAT_ERR_UNEXP_CPL2 \
	(1 << 4) /* Unexpected Completion Status Status for Function 2, \
	if set, generate pcie_err_attn output when this error is seen. WC \
	*/
#define PXPCS_TL_FUNC345_STAT_ERR_MASTER_ABRT2 \
	(1 << 3) /* Receive UR Statusfor Function 2. If set, generate \
	pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_CPL_TIMEOUT2 \
	(1 << 2) /* Completer Timeout Status Status for Function 2, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_FC_PRTL2 \
	(1 << 1) /* Flow Control Protocol Error Status Status for \
	Function 2, if set, generate pcie_err_attn output when this error \
	is seen. WC */
#define PXPCS_TL_FUNC345_STAT_ERR_PSND_TLP2 \
	(1 << 0) /* Poisoned Error Status Status for Function 2, if set, \
	generate pcie_err_attn output when this error is seen.. WC */


#define PXPCS_TL_FUNC678_STAT  0x85C
#define PXPCS_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT7    (1 << 29)   /*	 WC */
#define PXPCS_TL_FUNC678_STAT_ERR_UNSPPORT7 \
	(1 << 28) /* Unsupported Request Error Status in function7, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_ECRC7 \
	(1 << 27) /* ECRC Error TLP Status Status in function 7, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_MALF_TLP7 \
	(1 << 26) /* Malformed TLP Status Status in function 7, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_RX_OFLOW7 \
	(1 << 25) /* Receiver Overflow Status Status in function 7, if \
	set, generate pcie_err_attn output when this error is seen.. WC \
	*/
#define PXPCS_TL_FUNC678_STAT_ERR_UNEXP_CPL7 \
	(1 << 24) /* Unexpected Completion Status Status in function 7, \
	if set, generate pcie_err_attn output when this error is seen. WC \
	*/
#define PXPCS_TL_FUNC678_STAT_ERR_MASTER_ABRT7 \
	(1 << 23) /* Receive UR Statusin function 7. If set, generate \
	pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_CPL_TIMEOUT7 \
	(1 << 22) /* Completer Timeout Status Status in function 7, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_FC_PRTL7 \
	(1 << 21) /* Flow Control Protocol Error Status Status in \
	function 7, if set, generate pcie_err_attn output when this error \
	is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_PSND_TLP7 \
	(1 << 20) /* Poisoned Error Status Status in function 7, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT6    (1 << 19)    /*	  WC */
#define PXPCS_TL_FUNC678_STAT_ERR_UNSPPORT6 \
	(1 << 18) /* Unsupported Request Error Status in function6, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_ECRC6 \
	(1 << 17) /* ECRC Error TLP Status Status in function 6, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_MALF_TLP6 \
	(1 << 16) /* Malformed TLP Status Status in function 6, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_RX_OFLOW6 \
	(1 << 15) /* Receiver Overflow Status Status in function 6, if \
	set, generate pcie_err_attn output when this error is seen.. WC \
	*/
#define PXPCS_TL_FUNC678_STAT_ERR_UNEXP_CPL6 \
	(1 << 14) /* Unexpected Completion Status Status in function 6, \
	if set, generate pcie_err_attn output when this error is seen. WC \
	*/
#define PXPCS_TL_FUNC678_STAT_ERR_MASTER_ABRT6 \
	(1 << 13) /* Receive UR Statusin function 6. If set, generate \
	pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_CPL_TIMEOUT6 \
	(1 << 12) /* Completer Timeout Status Status in function 6, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_FC_PRTL6 \
	(1 << 11) /* Flow Control Protocol Error Status Status in \
	function 6, if set, generate pcie_err_attn output when this error \
	is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_PSND_TLP6 \
	(1 << 10) /* Poisoned Error Status Status in function 6, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_PRI_SIG_TARGET_ABORT5    (1 << 9) /*    WC */
#define PXPCS_TL_FUNC678_STAT_ERR_UNSPPORT5 \
	(1 << 8) /* Unsupported Request Error Status for Function 5, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_ECRC5 \
	(1 << 7) /* ECRC Error TLP Status Status for Function 5, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_MALF_TLP5 \
	(1 << 6) /* Malformed TLP Status Status for Function 5, if set, \
	generate pcie_err_attn output when this error is seen.. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_RX_OFLOW5 \
	(1 << 5) /* Receiver Overflow Status Status for Function 5, if \
	set, generate pcie_err_attn output when this error is seen.. WC \
	*/
#define PXPCS_TL_FUNC678_STAT_ERR_UNEXP_CPL5 \
	(1 << 4) /* Unexpected Completion Status Status for Function 5, \
	if set, generate pcie_err_attn output when this error is seen. WC \
	*/
#define PXPCS_TL_FUNC678_STAT_ERR_MASTER_ABRT5 \
	(1 << 3) /* Receive UR Statusfor Function 5. If set, generate \
	pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_CPL_TIMEOUT5 \
	(1 << 2) /* Completer Timeout Status Status for Function 5, if \
	set, generate pcie_err_attn output when this error is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_FC_PRTL5 \
	(1 << 1) /* Flow Control Protocol Error Status Status for \
	Function 5, if set, generate pcie_err_attn output when this error \
	is seen. WC */
#define PXPCS_TL_FUNC678_STAT_ERR_PSND_TLP5 \
	(1 << 0) /* Poisoned Error Status Status for Function 5, if set, \
	generate pcie_err_attn output when this error is seen.. WC */


#define BAR_USTRORM_INTMEM				0x400000
#define BAR_CSTRORM_INTMEM				0x410000
#define BAR_XSTRORM_INTMEM				0x420000
#define BAR_TSTRORM_INTMEM				0x430000

/* for accessing the IGU in case of status block ACK */
#define BAR_IGU_INTMEM					0x440000

#define BAR_DOORBELL_OFFSET				0x800000

#define BAR_ME_REGISTER					0x450000
#define ME_REG_PF_NUM_SHIFT		0
#define ME_REG_PF_NUM \
	(7L<<ME_REG_PF_NUM_SHIFT) /* Relative PF Num */
#define ME_REG_VF_VALID			(1<<8)
#define ME_REG_VF_NUM_SHIFT		9
#define ME_REG_VF_NUM_MASK		(0x3f<<ME_REG_VF_NUM_SHIFT)
#define VF_ID(x)			((x & ME_REG_VF_NUM_MASK) >> ME_REG_VF_NUM_SHIFT)
#define ME_REG_VF_ERR			(0x1<<3)
#define ME_REG_ABS_PF_NUM_SHIFT		16
#define ME_REG_ABS_PF_NUM \
	(7L<<ME_REG_ABS_PF_NUM_SHIFT) /* Absolute PF Num */


#define PXP_VF_ADRR_NUM_QUEUES		136
#define PXP_ADDR_QUEUE_SIZE			32
#define PXP_ADDR_REG_SIZE			512


#define PXP_VF_ADDR_IGU_START		0
#define PXP_VF_ADDR_IGU_SIZE		(0x3000)
#define PXP_VF_ADDR_IGU_END \
	((PXP_VF_ADDR_IGU_START) + (PXP_VF_ADDR_IGU_SIZE) - 1)

#define PXP_VF_ADDR_USDM_QUEUES_START		0x3000
#define PXP_VF_ADDR_USDM_QUEUES_SIZE \
	(PXP_VF_ADRR_NUM_QUEUES * PXP_ADDR_QUEUE_SIZE)
#define PXP_VF_ADDR_USDM_QUEUES_END \
	((PXP_VF_ADDR_USDM_QUEUES_START) + (PXP_VF_ADDR_USDM_QUEUES_SIZE) - 1)

#define PXP_VF_ADDR_CSDM_QUEUES_START		0x4100
#define PXP_VF_ADDR_CSDM_QUEUES_SIZE \
	(PXP_VF_ADRR_NUM_QUEUES * PXP_ADDR_QUEUE_SIZE)
#define PXP_VF_ADDR_CSDM_QUEUES_END \
	((PXP_VF_ADDR_CSDM_QUEUES_START) + (PXP_VF_ADDR_CSDM_QUEUES_SIZE) - 1)

#define PXP_VF_ADDR_XSDM_QUEUES_START		0x5200
#define PXP_VF_ADDR_XSDM_QUEUES_SIZE \
	(PXP_VF_ADRR_NUM_QUEUES * PXP_ADDR_QUEUE_SIZE)
#define PXP_VF_ADDR_XSDM_QUEUES_END \
	((PXP_VF_ADDR_XSDM_QUEUES_START) + (PXP_VF_ADDR_XSDM_QUEUES_SIZE) - 1)

#define PXP_VF_ADDR_TSDM_QUEUES_START		0x6300
#define PXP_VF_ADDR_TSDM_QUEUES_SIZE \
	(PXP_VF_ADRR_NUM_QUEUES * PXP_ADDR_QUEUE_SIZE)
#define PXP_VF_ADDR_TSDM_QUEUES_END \
	((PXP_VF_ADDR_TSDM_QUEUES_START) + (PXP_VF_ADDR_TSDM_QUEUES_SIZE) - 1)

#define PXP_VF_ADDR_USDM_GLOBAL_START		0x7400
#define PXP_VF_ADDR_USDM_GLOBAL_SIZE		(PXP_ADDR_REG_SIZE)
#define PXP_VF_ADDR_USDM_GLOBAL_END \
	((PXP_VF_ADDR_USDM_GLOBAL_START) + (PXP_VF_ADDR_USDM_GLOBAL_SIZE) - 1)

#define PXP_VF_ADDR_CSDM_GLOBAL_START		0x7600
#define PXP_VF_ADDR_CSDM_GLOBAL_SIZE		(PXP_ADDR_REG_SIZE)
#define PXP_VF_ADDR_CSDM_GLOBAL_END \
	((PXP_VF_ADDR_CSDM_GLOBAL_START) + (PXP_VF_ADDR_CSDM_GLOBAL_SIZE) - 1)

#define PXP_VF_ADDR_XSDM_GLOBAL_START		0x7800
#define PXP_VF_ADDR_XSDM_GLOBAL_SIZE		(PXP_ADDR_REG_SIZE)
#define PXP_VF_ADDR_XSDM_GLOBAL_END \
	((PXP_VF_ADDR_XSDM_GLOBAL_START) + (PXP_VF_ADDR_XSDM_GLOBAL_SIZE) - 1)

#define PXP_VF_ADDR_TSDM_GLOBAL_START		0x7a00
#define PXP_VF_ADDR_TSDM_GLOBAL_SIZE		(PXP_ADDR_REG_SIZE)
#define PXP_VF_ADDR_TSDM_GLOBAL_END \
	((PXP_VF_ADDR_TSDM_GLOBAL_START) + (PXP_VF_ADDR_TSDM_GLOBAL_SIZE) - 1)

#define PXP_VF_ADDR_DB_START				0x7c00
#define PXP_VF_ADDR_DB_SIZE					(0x200)
#define PXP_VF_ADDR_DB_END \
	((PXP_VF_ADDR_DB_START) + (PXP_VF_ADDR_DB_SIZE) - 1)

#define PXP_VF_ADDR_GRC_START				0x7e00
#define PXP_VF_ADDR_GRC_SIZE				(0x200)
#define PXP_VF_ADDR_GRC_END \
	((PXP_VF_ADDR_GRC_START) + (PXP_VF_ADDR_GRC_SIZE) - 1)

#define PXP_VF_ADDR_DORQ_START				(0x0)
#define PXP_VF_ADDR_DORQ_SIZE				(0xffffffff)
#define PXP_VF_ADDR_DORQ_END				(0xffffffff)

#define PXP_BAR_GRC		0
#define PXP_BAR_TSDM	0
#define PXP_BAR_USDM	0
#define PXP_BAR_XSDM	0
#define PXP_BAR_CSDM	0
#define PXP_BAR_IGU		0
#define PXP_BAR_DQ		1

#define PXP_VF_BAR_IGU	0
#define PXP_VF_BAR_USDM_QUEUES	0
#define PXP_VF_BAR_TSDM_QUEUES	0
#define PXP_VF_BAR_XSDM_QUEUES	0
#define PXP_VF_BAR_CSDM_QUEUES	0
#define PXP_VF_BAR_USDM_GLOBAL	0
#define PXP_VF_BAR_TSDM_GLOBAL	0
#define PXP_VF_BAR_XSDM_GLOBAL	0
#define PXP_VF_BAR_CSDM_GLOBAL	0
#define PXP_VF_BAR_DB	0
#define PXP_VF_BAR_GRC	0
#define PXP_VF_BAR_DORQ	1

/* PCI CAPABILITIES*/

#define PCI_CAP_PCIE				0x10	/*PCIe capability ID*/

#define PCIE_DEV_CAPS				0x04

#define PCIE_DEV_CTRL				0x08
#define PCIE_DEV_CTRL_FLR				0x8000;

#define PCIE_DEV_STATUS				0x0A

#define PCI_CAP_MSIX				0x11	/*MSI-X capability ID*/
#define PCI_MSIX_CONTROL_SHIFT			16
#define PCI_MSIX_TABLE_SIZE_MASK		0x07FF
#define PCI_MSIX_TABLE_ENABLE_MASK		0x8000


#define MDIO_REG_BANK_CL73_IEEEB0			0x0
#define MDIO_CL73_IEEEB0_CL73_AN_CONTROL		0x0
#define MDIO_CL73_IEEEB0_CL73_AN_CONTROL_RESTART_AN	0x0200
#define MDIO_CL73_IEEEB0_CL73_AN_CONTROL_AN_EN		0x1000
#define MDIO_CL73_IEEEB0_CL73_AN_CONTROL_MAIN_RST	0x8000

#define MDIO_REG_BANK_CL73_IEEEB1			0x10
#define MDIO_CL73_IEEEB1_AN_ADV1			0x00
#define MDIO_CL73_IEEEB1_AN_ADV1_PAUSE			0x0400
#define MDIO_CL73_IEEEB1_AN_ADV1_ASYMMETRIC		0x0800
#define MDIO_CL73_IEEEB1_AN_ADV1_PAUSE_BOTH		0x0C00
#define MDIO_CL73_IEEEB1_AN_ADV1_PAUSE_MASK		0x0C00
#define MDIO_CL73_IEEEB1_AN_ADV2				0x01
#define MDIO_CL73_IEEEB1_AN_ADV2_ADVR_1000M		0x0000
#define MDIO_CL73_IEEEB1_AN_ADV2_ADVR_1000M_KX		0x0020
#define MDIO_CL73_IEEEB1_AN_ADV2_ADVR_10G_KX4		0x0040
#define MDIO_CL73_IEEEB1_AN_ADV2_ADVR_10G_KR		0x0080
#define MDIO_CL73_IEEEB1_AN_LP_ADV1			0x03
#define MDIO_CL73_IEEEB1_AN_LP_ADV1_PAUSE		0x0400
#define MDIO_CL73_IEEEB1_AN_LP_ADV1_ASYMMETRIC		0x0800
#define MDIO_CL73_IEEEB1_AN_LP_ADV1_PAUSE_BOTH		0x0C00
#define MDIO_CL73_IEEEB1_AN_LP_ADV1_PAUSE_MASK		0x0C00
#define MDIO_CL73_IEEEB1_AN_LP_ADV2			0x04

#define MDIO_REG_BANK_RX0				0x80b0
#define MDIO_RX0_RX_STATUS				0x10
#define MDIO_RX0_RX_STATUS_SIGDET			0x8000
#define MDIO_RX0_RX_STATUS_RX_SEQ_DONE			0x1000
#define MDIO_RX0_RX_EQ_BOOST				0x1c
#define MDIO_RX0_RX_EQ_BOOST_EQUALIZER_CTRL_MASK	0x7
#define MDIO_RX0_RX_EQ_BOOST_OFFSET_CTRL		0x10

#define MDIO_REG_BANK_RX1				0x80c0
#define MDIO_RX1_RX_EQ_BOOST				0x1c
#define MDIO_RX1_RX_EQ_BOOST_EQUALIZER_CTRL_MASK	0x7
#define MDIO_RX1_RX_EQ_BOOST_OFFSET_CTRL		0x10

#define MDIO_REG_BANK_RX2				0x80d0
#define MDIO_RX2_RX_EQ_BOOST				0x1c
#define MDIO_RX2_RX_EQ_BOOST_EQUALIZER_CTRL_MASK	0x7
#define MDIO_RX2_RX_EQ_BOOST_OFFSET_CTRL		0x10

#define MDIO_REG_BANK_RX3				0x80e0
#define MDIO_RX3_RX_EQ_BOOST				0x1c
#define MDIO_RX3_RX_EQ_BOOST_EQUALIZER_CTRL_MASK	0x7
#define MDIO_RX3_RX_EQ_BOOST_OFFSET_CTRL		0x10

#define MDIO_REG_BANK_RX_ALL				0x80f0
#define MDIO_RX_ALL_RX_EQ_BOOST				0x1c
#define MDIO_RX_ALL_RX_EQ_BOOST_EQUALIZER_CTRL_MASK	0x7
#define MDIO_RX_ALL_RX_EQ_BOOST_OFFSET_CTRL	0x10

#define MDIO_REG_BANK_TX0				0x8060
#define MDIO_TX0_TX_DRIVER				0x17
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_MASK		0xf000
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_SHIFT		12
#define MDIO_TX0_TX_DRIVER_IDRIVER_MASK			0x0f00
#define MDIO_TX0_TX_DRIVER_IDRIVER_SHIFT		8
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_MASK		0x00f0
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_SHIFT		4
#define MDIO_TX0_TX_DRIVER_IFULLSPD_MASK		0x000e
#define MDIO_TX0_TX_DRIVER_IFULLSPD_SHIFT		1
#define MDIO_TX0_TX_DRIVER_ICBUF1T			1

#define MDIO_REG_BANK_TX1				0x8070
#define MDIO_TX1_TX_DRIVER				0x17
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_MASK		0xf000
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_SHIFT		12
#define MDIO_TX0_TX_DRIVER_IDRIVER_MASK			0x0f00
#define MDIO_TX0_TX_DRIVER_IDRIVER_SHIFT		8
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_MASK		0x00f0
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_SHIFT		4
#define MDIO_TX0_TX_DRIVER_IFULLSPD_MASK		0x000e
#define MDIO_TX0_TX_DRIVER_IFULLSPD_SHIFT		1
#define MDIO_TX0_TX_DRIVER_ICBUF1T			1

#define MDIO_REG_BANK_TX2				0x8080
#define MDIO_TX2_TX_DRIVER				0x17
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_MASK		0xf000
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_SHIFT		12
#define MDIO_TX0_TX_DRIVER_IDRIVER_MASK			0x0f00
#define MDIO_TX0_TX_DRIVER_IDRIVER_SHIFT		8
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_MASK		0x00f0
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_SHIFT		4
#define MDIO_TX0_TX_DRIVER_IFULLSPD_MASK		0x000e
#define MDIO_TX0_TX_DRIVER_IFULLSPD_SHIFT		1
#define MDIO_TX0_TX_DRIVER_ICBUF1T			1

#define MDIO_REG_BANK_TX3				0x8090
#define MDIO_TX3_TX_DRIVER				0x17
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_MASK		0xf000
#define MDIO_TX0_TX_DRIVER_PREEMPHASIS_SHIFT		12
#define MDIO_TX0_TX_DRIVER_IDRIVER_MASK			0x0f00
#define MDIO_TX0_TX_DRIVER_IDRIVER_SHIFT		8
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_MASK		0x00f0
#define MDIO_TX0_TX_DRIVER_IPREDRIVER_SHIFT		4
#define MDIO_TX0_TX_DRIVER_IFULLSPD_MASK		0x000e
#define MDIO_TX0_TX_DRIVER_IFULLSPD_SHIFT		1
#define MDIO_TX0_TX_DRIVER_ICBUF1T			1

#define MDIO_REG_BANK_XGXS_BLOCK0			0x8000
#define MDIO_BLOCK0_XGXS_CONTROL			0x10

#define MDIO_REG_BANK_XGXS_BLOCK1			0x8010
#define MDIO_BLOCK1_LANE_CTRL0				0x15
#define MDIO_BLOCK1_LANE_CTRL1				0x16
#define MDIO_BLOCK1_LANE_CTRL2				0x17
#define MDIO_BLOCK1_LANE_PRBS				0x19

#define MDIO_REG_BANK_XGXS_BLOCK2			0x8100
#define MDIO_XGXS_BLOCK2_RX_LN_SWAP			0x10
#define MDIO_XGXS_BLOCK2_RX_LN_SWAP_ENABLE		0x8000
#define MDIO_XGXS_BLOCK2_RX_LN_SWAP_FORCE_ENABLE	0x4000
#define MDIO_XGXS_BLOCK2_TX_LN_SWAP		0x11
#define MDIO_XGXS_BLOCK2_TX_LN_SWAP_ENABLE		0x8000
#define MDIO_XGXS_BLOCK2_UNICORE_MODE_10G	0x14
#define MDIO_XGXS_BLOCK2_UNICORE_MODE_10G_CX4_XGXS	0x0001
#define MDIO_XGXS_BLOCK2_UNICORE_MODE_10G_HIGIG_XGXS	0x0010
#define MDIO_XGXS_BLOCK2_TEST_MODE_LANE		0x15

#define MDIO_REG_BANK_GP_STATUS				0x8120
#define MDIO_GP_STATUS_TOP_AN_STATUS1				0x1B
#define MDIO_GP_STATUS_TOP_AN_STATUS1_CL73_AUTONEG_COMPLETE	0x0001
#define MDIO_GP_STATUS_TOP_AN_STATUS1_CL37_AUTONEG_COMPLETE	0x0002
#define MDIO_GP_STATUS_TOP_AN_STATUS1_LINK_STATUS		0x0004
#define MDIO_GP_STATUS_TOP_AN_STATUS1_DUPLEX_STATUS		0x0008
#define MDIO_GP_STATUS_TOP_AN_STATUS1_CL73_MR_LP_NP_AN_ABLE	0x0010
#define MDIO_GP_STATUS_TOP_AN_STATUS1_CL73_LP_NP_BAM_ABLE	0x0020
#define MDIO_GP_STATUS_TOP_AN_STATUS1_PAUSE_RSOLUTION_TXSIDE	0x0040
#define MDIO_GP_STATUS_TOP_AN_STATUS1_PAUSE_RSOLUTION_RXSIDE	0x0080
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_MASK		0x3f00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10M		0x0000
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_100M		0x0100
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_1G		0x0200
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_2_5G		0x0300
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_5G		0x0400
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_6G		0x0500
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10G_HIG	0x0600
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10G_CX4	0x0700
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_12G_HIG	0x0800
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_12_5G	0x0900
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_13G		0x0A00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_15G		0x0B00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_16G		0x0C00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_1G_KX	0x0D00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10G_KX4	0x0E00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10G_KR	0x0F00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10G_XFI	0x1B00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_20G_DXGXS	0x1E00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_10G_SFI	0x1F00
#define MDIO_GP_STATUS_TOP_AN_STATUS1_ACTUAL_SPEED_20G_KR2	0x3900


#define MDIO_REG_BANK_10G_PARALLEL_DETECT		0x8130
#define MDIO_10G_PARALLEL_DETECT_PAR_DET_10G_STATUS		0x10
#define MDIO_10G_PARALLEL_DETECT_PAR_DET_10G_STATUS_PD_LINK		0x8000
#define MDIO_10G_PARALLEL_DETECT_PAR_DET_10G_CONTROL		0x11
#define MDIO_10G_PARALLEL_DETECT_PAR_DET_10G_CONTROL_PARDET10G_EN	0x1
#define MDIO_10G_PARALLEL_DETECT_PAR_DET_10G_LINK		0x13
#define MDIO_10G_PARALLEL_DETECT_PAR_DET_10G_LINK_CNT		(0xb71<<1)

#define MDIO_REG_BANK_SERDES_DIGITAL			0x8300
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1			0x10
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1_FIBER_MODE			0x0001
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1_TBI_IF			0x0002
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1_SIGNAL_DETECT_EN		0x0004
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1_INVERT_SIGNAL_DETECT	0x0008
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1_AUTODET			0x0010
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL1_MSTR_MODE			0x0020
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL2			0x11
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL2_PRL_DT_EN			0x0001
#define MDIO_SERDES_DIGITAL_A_1000X_CONTROL2_AN_FST_TMR			0x0040
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1			0x14
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SGMII			0x0001
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_LINK			0x0002
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_DUPLEX			0x0004
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SPEED_MASK			0x0018
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SPEED_SHIFT			3
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SPEED_2_5G			0x0018
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SPEED_1G			0x0010
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SPEED_100M			0x0008
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS1_SPEED_10M			0x0000
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS2			0x15
#define MDIO_SERDES_DIGITAL_A_1000X_STATUS2_AN_DISABLED			0x0002
#define MDIO_SERDES_DIGITAL_MISC1				0x18
#define MDIO_SERDES_DIGITAL_MISC1_REFCLK_SEL_MASK			0xE000
#define MDIO_SERDES_DIGITAL_MISC1_REFCLK_SEL_25M			0x0000
#define MDIO_SERDES_DIGITAL_MISC1_REFCLK_SEL_100M			0x2000
#define MDIO_SERDES_DIGITAL_MISC1_REFCLK_SEL_125M			0x4000
#define MDIO_SERDES_DIGITAL_MISC1_REFCLK_SEL_156_25M			0x6000
#define MDIO_SERDES_DIGITAL_MISC1_REFCLK_SEL_187_5M			0x8000
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_SEL			0x0010
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_MASK			0x000f
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_2_5G			0x0000
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_5G			0x0001
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_6G			0x0002
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_10G_HIG			0x0003
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_10G_CX4			0x0004
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_12G			0x0005
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_12_5G			0x0006
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_13G			0x0007
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_15G			0x0008
#define MDIO_SERDES_DIGITAL_MISC1_FORCE_SPEED_16G			0x0009

#define MDIO_REG_BANK_OVER_1G				0x8320
#define MDIO_OVER_1G_DIGCTL_3_4					0x14
#define MDIO_OVER_1G_DIGCTL_3_4_MP_ID_MASK				0xffe0
#define MDIO_OVER_1G_DIGCTL_3_4_MP_ID_SHIFT				5
#define MDIO_OVER_1G_UP1					0x19
#define MDIO_OVER_1G_UP1_2_5G						0x0001
#define MDIO_OVER_1G_UP1_5G						0x0002
#define MDIO_OVER_1G_UP1_6G						0x0004
#define MDIO_OVER_1G_UP1_10G						0x0010
#define MDIO_OVER_1G_UP1_10GH						0x0008
#define MDIO_OVER_1G_UP1_12G						0x0020
#define MDIO_OVER_1G_UP1_12_5G						0x0040
#define MDIO_OVER_1G_UP1_13G						0x0080
#define MDIO_OVER_1G_UP1_15G						0x0100
#define MDIO_OVER_1G_UP1_16G						0x0200
#define MDIO_OVER_1G_UP2					0x1A
#define MDIO_OVER_1G_UP2_IPREDRIVER_MASK				0x0007
#define MDIO_OVER_1G_UP2_IDRIVER_MASK					0x0038
#define MDIO_OVER_1G_UP2_PREEMPHASIS_MASK				0x03C0
#define MDIO_OVER_1G_UP3					0x1B
#define MDIO_OVER_1G_UP3_HIGIG2						0x0001
#define MDIO_OVER_1G_LP_UP1					0x1C
#define MDIO_OVER_1G_LP_UP2					0x1D
#define MDIO_OVER_1G_LP_UP2_MR_ADV_OVER_1G_MASK				0x03ff
#define MDIO_OVER_1G_LP_UP2_PREEMPHASIS_MASK				0x0780
#define MDIO_OVER_1G_LP_UP2_PREEMPHASIS_SHIFT				7
#define MDIO_OVER_1G_LP_UP3						0x1E

#define MDIO_REG_BANK_REMOTE_PHY			0x8330
#define MDIO_REMOTE_PHY_MISC_RX_STATUS				0x10
#define MDIO_REMOTE_PHY_MISC_RX_STATUS_CL37_FSM_RECEIVED_OVER1G_MSG	0x0010
#define MDIO_REMOTE_PHY_MISC_RX_STATUS_CL37_FSM_RECEIVED_BRCM_OUI_MSG	0x0600

#define MDIO_REG_BANK_BAM_NEXT_PAGE			0x8350
#define MDIO_BAM_NEXT_PAGE_MP5_NEXT_PAGE_CTRL			0x10
#define MDIO_BAM_NEXT_PAGE_MP5_NEXT_PAGE_CTRL_BAM_MODE			0x0001
#define MDIO_BAM_NEXT_PAGE_MP5_NEXT_PAGE_CTRL_TETON_AN			0x0002

#define MDIO_REG_BANK_CL73_USERB0		0x8370
#define MDIO_CL73_USERB0_CL73_UCTRL				0x10
#define MDIO_CL73_USERB0_CL73_UCTRL_USTAT1_MUXSEL			0x0002
#define MDIO_CL73_USERB0_CL73_USTAT1				0x11
#define MDIO_CL73_USERB0_CL73_USTAT1_LINK_STATUS_CHECK			0x0100
#define MDIO_CL73_USERB0_CL73_USTAT1_AN_GOOD_CHECK_BAM37		0x0400
#define MDIO_CL73_USERB0_CL73_BAM_CTRL1				0x12
#define MDIO_CL73_USERB0_CL73_BAM_CTRL1_BAM_EN				0x8000
#define MDIO_CL73_USERB0_CL73_BAM_CTRL1_BAM_STATION_MNGR_EN		0x4000
#define MDIO_CL73_USERB0_CL73_BAM_CTRL1_BAM_NP_AFTER_BP_EN		0x2000
#define MDIO_CL73_USERB0_CL73_BAM_CTRL3				0x14
#define MDIO_CL73_USERB0_CL73_BAM_CTRL3_USE_CL73_HCD_MR			0x0001

#define MDIO_REG_BANK_AER_BLOCK			0xFFD0
#define MDIO_AER_BLOCK_AER_REG					0x1E

#define MDIO_REG_BANK_COMBO_IEEE0		0xFFE0
#define MDIO_COMBO_IEEE0_MII_CONTROL				0x10
#define MDIO_COMBO_IEEO_MII_CONTROL_MAN_SGMII_SP_MASK			0x2040
#define MDIO_COMBO_IEEO_MII_CONTROL_MAN_SGMII_SP_10			0x0000
#define MDIO_COMBO_IEEO_MII_CONTROL_MAN_SGMII_SP_100			0x2000
#define MDIO_COMBO_IEEO_MII_CONTROL_MAN_SGMII_SP_1000			0x0040
#define MDIO_COMBO_IEEO_MII_CONTROL_FULL_DUPLEX				0x0100
#define MDIO_COMBO_IEEO_MII_CONTROL_RESTART_AN				0x0200
#define MDIO_COMBO_IEEO_MII_CONTROL_AN_EN				0x1000
#define MDIO_COMBO_IEEO_MII_CONTROL_LOOPBACK				0x4000
#define MDIO_COMBO_IEEO_MII_CONTROL_RESET				0x8000
#define MDIO_COMBO_IEEE0_MII_STATUS				0x11
#define MDIO_COMBO_IEEE0_MII_STATUS_LINK_PASS				0x0004
#define MDIO_COMBO_IEEE0_MII_STATUS_AUTONEG_COMPLETE			0x0020
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV				0x14
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_FULL_DUPLEX			0x0020
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_HALF_DUPLEX			0x0040
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_PAUSE_MASK			0x0180
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_PAUSE_NONE			0x0000
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_PAUSE_SYMMETRIC			0x0080
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_PAUSE_ASYMMETRIC			0x0100
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_PAUSE_BOTH			0x0180
#define MDIO_COMBO_IEEE0_AUTO_NEG_ADV_NEXT_PAGE				0x8000
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1		0x15
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_NEXT_PAGE	0x8000
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_ACK		0x4000
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_PAUSE_MASK	0x0180
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_PAUSE_NONE	0x0000
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_PAUSE_BOTH	0x0180
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_HALF_DUP_CAP	0x0040
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_FULL_DUP_CAP	0x0020
/*WhenthelinkpartnerisinSGMIImode(bit0=1), then
bit15=link, bit12=duplex, bits11:10=speed, bit14=acknowledge.
Theotherbitsarereservedandshouldbezero*/
#define MDIO_COMBO_IEEE0_AUTO_NEG_LINK_PARTNER_ABILITY1_SGMII_MODE	0x0001


#define MDIO_PMA_DEVAD			0x1
/*ieee*/
#define MDIO_PMA_REG_CTRL		0x0
#define MDIO_PMA_REG_STATUS		0x1
#define MDIO_PMA_REG_10G_CTRL2		0x7
#define MDIO_PMA_REG_TX_DISABLE		0x0009
#define MDIO_PMA_REG_RX_SD		0xa
/*bnx2x*/
#define MDIO_PMA_REG_BNX2X_CTRL		0x0096
#define MDIO_PMA_REG_FEC_CTRL		0x00ab
#define MDIO_PMA_LASI_RXCTRL		0x9000
#define MDIO_PMA_LASI_TXCTRL		0x9001
#define MDIO_PMA_LASI_CTRL		0x9002
#define MDIO_PMA_LASI_RXSTAT		0x9003
#define MDIO_PMA_LASI_TXSTAT		0x9004
#define MDIO_PMA_LASI_STAT		0x9005
#define MDIO_PMA_REG_PHY_IDENTIFIER	0xc800
#define MDIO_PMA_REG_DIGITAL_CTRL	0xc808
#define MDIO_PMA_REG_DIGITAL_STATUS	0xc809
#define MDIO_PMA_REG_TX_POWER_DOWN	0xca02
#define MDIO_PMA_REG_CMU_PLL_BYPASS	0xca09
#define MDIO_PMA_REG_MISC_CTRL		0xca0a
#define MDIO_PMA_REG_GEN_CTRL		0xca10
#define MDIO_PMA_REG_GEN_CTRL_ROM_RESET_INTERNAL_MP	0x0188
#define MDIO_PMA_REG_GEN_CTRL_ROM_MICRO_RESET		0x018a
#define MDIO_PMA_REG_M8051_MSGIN_REG	0xca12
#define MDIO_PMA_REG_M8051_MSGOUT_REG	0xca13
#define MDIO_PMA_REG_ROM_VER1		0xca19
#define MDIO_PMA_REG_ROM_VER2		0xca1a
#define MDIO_PMA_REG_EDC_FFE_MAIN	0xca1b
#define MDIO_PMA_REG_PLL_BANDWIDTH	0xca1d
#define MDIO_PMA_REG_PLL_CTRL		0xca1e
#define MDIO_PMA_REG_MISC_CTRL0		0xca23
#define MDIO_PMA_REG_LRM_MODE		0xca3f
#define MDIO_PMA_REG_CDR_BANDWIDTH	0xca46
#define MDIO_PMA_REG_MISC_CTRL1		0xca85

#define MDIO_PMA_REG_SFP_TWO_WIRE_CTRL		0x8000
#define MDIO_PMA_REG_SFP_TWO_WIRE_CTRL_STATUS_MASK	0x000c
#define MDIO_PMA_REG_SFP_TWO_WIRE_STATUS_IDLE		0x0000
#define MDIO_PMA_REG_SFP_TWO_WIRE_STATUS_COMPLETE	0x0004
#define MDIO_PMA_REG_SFP_TWO_WIRE_STATUS_IN_PROGRESS	0x0008
#define MDIO_PMA_REG_SFP_TWO_WIRE_STATUS_FAILED		0x000c
#define MDIO_PMA_REG_SFP_TWO_WIRE_BYTE_CNT	0x8002
#define MDIO_PMA_REG_SFP_TWO_WIRE_MEM_ADDR	0x8003
#define MDIO_PMA_REG_8726_TWO_WIRE_DATA_BUF	0xc820
#define MDIO_PMA_REG_8726_TWO_WIRE_DATA_MASK 0xff
#define MDIO_PMA_REG_8726_TX_CTRL1		0xca01
#define MDIO_PMA_REG_8726_TX_CTRL2		0xca05

#define MDIO_PMA_REG_8727_TWO_WIRE_SLAVE_ADDR	0x8005
#define MDIO_PMA_REG_8727_TWO_WIRE_DATA_BUF	0x8007
#define MDIO_PMA_REG_8727_TWO_WIRE_DATA_MASK 0xff
#define MDIO_PMA_REG_8727_MISC_CTRL		0x8309
#define MDIO_PMA_REG_8727_TX_CTRL1		0xca02
#define MDIO_PMA_REG_8727_TX_CTRL2		0xca05
#define MDIO_PMA_REG_8727_PCS_OPT_CTRL		0xc808
#define MDIO_PMA_REG_8727_GPIO_CTRL		0xc80e
#define MDIO_PMA_REG_8727_PCS_GP		0xc842
#define MDIO_PMA_REG_8727_OPT_CFG_REG		0xc8e4

#define MDIO_AN_REG_8727_MISC_CTRL		0x8309
#define MDIO_PMA_REG_8073_CHIP_REV			0xc801
#define MDIO_PMA_REG_8073_SPEED_LINK_STATUS		0xc820
#define MDIO_PMA_REG_8073_XAUI_WA			0xc841
#define MDIO_PMA_REG_8073_OPT_DIGITAL_CTRL		0xcd08

#define MDIO_PMA_REG_7101_RESET		0xc000
#define MDIO_PMA_REG_7107_LED_CNTL	0xc007
#define MDIO_PMA_REG_7107_LINK_LED_CNTL	0xc009
#define MDIO_PMA_REG_7101_VER1		0xc026
#define MDIO_PMA_REG_7101_VER2		0xc027

#define MDIO_PMA_REG_8481_PMD_SIGNAL	0xa811
#define MDIO_PMA_REG_8481_LED1_MASK	0xa82c
#define MDIO_PMA_REG_8481_LED2_MASK	0xa82f
#define MDIO_PMA_REG_8481_LED3_MASK	0xa832
#define MDIO_PMA_REG_8481_LED3_BLINK	0xa834
#define MDIO_PMA_REG_8481_LED5_MASK			0xa838
#define MDIO_PMA_REG_8481_SIGNAL_MASK	0xa835
#define MDIO_PMA_REG_8481_LINK_SIGNAL	0xa83b
#define MDIO_PMA_REG_8481_LINK_SIGNAL_LED4_ENABLE_MASK	0x800
#define MDIO_PMA_REG_8481_LINK_SIGNAL_LED4_ENABLE_SHIFT	11


#define MDIO_WIS_DEVAD			0x2
/*bnx2x*/
#define MDIO_WIS_REG_LASI_CNTL		0x9002
#define MDIO_WIS_REG_LASI_STATUS	0x9005

#define MDIO_PCS_DEVAD			0x3
#define MDIO_PCS_REG_STATUS		0x0020
#define MDIO_PCS_REG_LASI_STATUS	0x9005
#define MDIO_PCS_REG_7101_DSP_ACCESS	0xD000
#define MDIO_PCS_REG_7101_SPI_MUX	0xD008
#define MDIO_PCS_REG_7101_SPI_CTRL_ADDR	0xE12A
#define MDIO_PCS_REG_7101_SPI_RESET_BIT	(5)
#define MDIO_PCS_REG_7101_SPI_FIFO_ADDR	0xE02A
#define MDIO_PCS_REG_7101_SPI_FIFO_ADDR_WRITE_ENABLE_CMD (6)
#define MDIO_PCS_REG_7101_SPI_FIFO_ADDR_BULK_ERASE_CMD	 (0xC7)
#define MDIO_PCS_REG_7101_SPI_FIFO_ADDR_PAGE_PROGRAM_CMD (2)
#define MDIO_PCS_REG_7101_SPI_BYTES_TO_TRANSFER_ADDR 0xE028


#define MDIO_XS_DEVAD			0x4
#define MDIO_XS_REG_STATUS		0x0001
#define MDIO_XS_PLL_SEQUENCER		0x8000
#define MDIO_XS_SFX7101_XGXS_TEST1	0xc00a

#define MDIO_XS_8706_REG_BANK_RX0	0x80bc
#define MDIO_XS_8706_REG_BANK_RX1	0x80cc
#define MDIO_XS_8706_REG_BANK_RX2	0x80dc
#define MDIO_XS_8706_REG_BANK_RX3	0x80ec
#define MDIO_XS_8706_REG_BANK_RXA	0x80fc

#define MDIO_XS_REG_8073_RX_CTRL_PCIE	0x80FA

#define MDIO_AN_DEVAD			0x7
/*ieee*/
#define MDIO_AN_REG_CTRL		0x0000
#define MDIO_AN_REG_STATUS		0x0001
#define MDIO_AN_REG_STATUS_AN_COMPLETE		0x0020
#define MDIO_AN_REG_ADV_PAUSE		0x0010
#define MDIO_AN_REG_ADV_PAUSE_PAUSE		0x0400
#define MDIO_AN_REG_ADV_PAUSE_ASYMMETRIC	0x0800
#define MDIO_AN_REG_ADV_PAUSE_BOTH		0x0C00
#define MDIO_AN_REG_ADV_PAUSE_MASK		0x0C00
#define MDIO_AN_REG_ADV			0x0011
#define MDIO_AN_REG_ADV2		0x0012
#define MDIO_AN_REG_LP_AUTO_NEG		0x0013
#define MDIO_AN_REG_LP_AUTO_NEG2	0x0014
#define MDIO_AN_REG_MASTER_STATUS	0x0021
#define MDIO_AN_REG_EEE_ADV		0x003c
#define MDIO_AN_REG_LP_EEE_ADV		0x003d
/*bnx2x*/
#define MDIO_AN_REG_LINK_STATUS		0x8304
#define MDIO_AN_REG_CL37_CL73		0x8370
#define MDIO_AN_REG_CL37_AN		0xffe0
#define MDIO_AN_REG_CL37_FC_LD		0xffe4
#define		MDIO_AN_REG_CL37_FC_LP		0xffe5
#define		MDIO_AN_REG_1000T_STATUS	0xffea

#define MDIO_AN_REG_8073_2_5G		0x8329
#define MDIO_AN_REG_8073_BAM		0x8350

#define MDIO_AN_REG_8481_10GBASE_T_AN_CTRL	0x0020
#define MDIO_AN_REG_8481_LEGACY_MII_CTRL	0xffe0
#define MDIO_AN_REG_8481_MII_CTRL_FORCE_1G	0x40
#define MDIO_AN_REG_8481_LEGACY_MII_STATUS	0xffe1
#define MDIO_AN_REG_8481_LEGACY_AN_ADV		0xffe4
#define MDIO_AN_REG_8481_LEGACY_AN_EXPANSION	0xffe6
#define MDIO_AN_REG_8481_1000T_CTRL		0xffe9
#define MDIO_AN_REG_8481_1G_100T_EXT_CTRL	0xfff0
#define MIDO_AN_REG_8481_EXT_CTRL_FORCE_LEDS_OFF	0x0008
#define MDIO_AN_REG_8481_EXPANSION_REG_RD_RW	0xfff5
#define MDIO_AN_REG_8481_EXPANSION_REG_ACCESS	0xfff7
#define MDIO_AN_REG_8481_AUX_CTRL		0xfff8
#define MDIO_AN_REG_8481_LEGACY_SHADOW		0xfffc

/* BNX2X84823 only */
#define MDIO_CTL_DEVAD			0x1e
#define MDIO_CTL_REG_84823_MEDIA		0x401a
#define MDIO_CTL_REG_84823_MEDIA_MAC_MASK		0x0018
	/* These pins configure the BNX2X84823 interface to MAC after reset. */
#define MDIO_CTL_REG_84823_CTRL_MAC_XFI			0x0008
#define MDIO_CTL_REG_84823_MEDIA_MAC_XAUI_M		0x0010
	/* These pins configure the BNX2X84823 interface to Line after reset. */
#define MDIO_CTL_REG_84823_MEDIA_LINE_MASK		0x0060
#define MDIO_CTL_REG_84823_MEDIA_LINE_XAUI_L		0x0020
#define MDIO_CTL_REG_84823_MEDIA_LINE_XFI		0x0040
	/* When this pin is active high during reset, 10GBASE-T core is power
	 * down, When it is active low the 10GBASE-T is power up
	 */
#define MDIO_CTL_REG_84823_MEDIA_COPPER_CORE_DOWN	0x0080
#define MDIO_CTL_REG_84823_MEDIA_PRIORITY_MASK		0x0100
#define MDIO_CTL_REG_84823_MEDIA_PRIORITY_COPPER	0x0000
#define MDIO_CTL_REG_84823_MEDIA_PRIORITY_FIBER		0x0100
#define MDIO_CTL_REG_84823_MEDIA_FIBER_1G			0x1000
#define MDIO_CTL_REG_84823_USER_CTRL_REG			0x4005
#define MDIO_CTL_REG_84823_USER_CTRL_CMS			0x0080
#define MDIO_PMA_REG_84823_CTL_SLOW_CLK_CNT_HIGH		0xa82b
#define MDIO_PMA_REG_84823_BLINK_RATE_VAL_15P9HZ	0x2f
#define MDIO_PMA_REG_84823_CTL_LED_CTL_1			0xa8e3
#define MDIO_PMA_REG_84833_CTL_LED_CTL_1			0xa8ec
#define MDIO_PMA_REG_84823_LED3_STRETCH_EN			0x0080

/* BNX2X84833 only */
#define MDIO_84833_TOP_CFG_FW_REV			0x400f
#define MDIO_84833_TOP_CFG_FW_EEE		0x10b1
#define MDIO_84833_TOP_CFG_FW_NO_EEE		0x1f81
#define MDIO_84833_TOP_CFG_XGPHY_STRAP1			0x401a
#define MDIO_84833_SUPER_ISOLATE		0x8000
/* These are mailbox register set used by 84833. */
#define MDIO_84833_TOP_CFG_SCRATCH_REG0			0x4005
#define MDIO_84833_TOP_CFG_SCRATCH_REG1			0x4006
#define MDIO_84833_TOP_CFG_SCRATCH_REG2			0x4007
#define MDIO_84833_TOP_CFG_SCRATCH_REG3			0x4008
#define MDIO_84833_TOP_CFG_SCRATCH_REG4			0x4009
#define MDIO_84833_TOP_CFG_SCRATCH_REG26		0x4037
#define MDIO_84833_TOP_CFG_SCRATCH_REG27		0x4038
#define MDIO_84833_TOP_CFG_SCRATCH_REG28		0x4039
#define MDIO_84833_TOP_CFG_SCRATCH_REG29		0x403a
#define MDIO_84833_TOP_CFG_SCRATCH_REG30		0x403b
#define MDIO_84833_TOP_CFG_SCRATCH_REG31		0x403c
#define MDIO_84833_CMD_HDLR_COMMAND	MDIO_84833_TOP_CFG_SCRATCH_REG0
#define MDIO_84833_CMD_HDLR_STATUS	MDIO_84833_TOP_CFG_SCRATCH_REG26
#define MDIO_84833_CMD_HDLR_DATA1	MDIO_84833_TOP_CFG_SCRATCH_REG27
#define MDIO_84833_CMD_HDLR_DATA2	MDIO_84833_TOP_CFG_SCRATCH_REG28
#define MDIO_84833_CMD_HDLR_DATA3	MDIO_84833_TOP_CFG_SCRATCH_REG29
#define MDIO_84833_CMD_HDLR_DATA4	MDIO_84833_TOP_CFG_SCRATCH_REG30
#define MDIO_84833_CMD_HDLR_DATA5	MDIO_84833_TOP_CFG_SCRATCH_REG31

/* Mailbox command set used by 84833. */
#define PHY84833_CMD_SET_PAIR_SWAP			0x8001
#define PHY84833_CMD_GET_EEE_MODE			0x8008
#define PHY84833_CMD_SET_EEE_MODE			0x8009
#define PHY84833_CMD_GET_CURRENT_TEMP			0x8031
/* Mailbox status set used by 84833. */
#define PHY84833_STATUS_CMD_RECEIVED			0x0001
#define PHY84833_STATUS_CMD_IN_PROGRESS			0x0002
#define PHY84833_STATUS_CMD_COMPLETE_PASS		0x0004
#define PHY84833_STATUS_CMD_COMPLETE_ERROR		0x0008
#define PHY84833_STATUS_CMD_OPEN_FOR_CMDS		0x0010
#define PHY84833_STATUS_CMD_SYSTEM_BOOT			0x0020
#define PHY84833_STATUS_CMD_NOT_OPEN_FOR_CMDS		0x0040
#define PHY84833_STATUS_CMD_CLEAR_COMPLETE		0x0080
#define PHY84833_STATUS_CMD_OPEN_OVERRIDE		0xa5a5


/* Warpcore clause 45 addressing */
#define MDIO_WC_DEVAD					0x3
#define MDIO_WC_REG_IEEE0BLK_MIICNTL			0x0
#define MDIO_WC_REG_IEEE0BLK_AUTONEGNP			0x7
#define MDIO_WC_REG_AN_IEEE1BLK_AN_ADVERTISEMENT0	0x10
#define MDIO_WC_REG_AN_IEEE1BLK_AN_ADVERTISEMENT1	0x11
#define MDIO_WC_REG_AN_IEEE1BLK_AN_ADVERTISEMENT2	0x12
#define MDIO_WC_REG_AN_IEEE1BLK_AN_ADV2_FEC_ABILITY	0x4000
#define MDIO_WC_REG_AN_IEEE1BLK_AN_ADV2_FEC_REQ		0x8000
#define MDIO_WC_REG_PCS_STATUS2				0x0021
#define MDIO_WC_REG_PMD_KR_CONTROL			0x0096
#define MDIO_WC_REG_XGXSBLK0_XGXSCONTROL		0x8000
#define MDIO_WC_REG_XGXSBLK0_MISCCONTROL1		0x800e
#define MDIO_WC_REG_XGXSBLK1_DESKEW			0x8010
#define MDIO_WC_REG_XGXSBLK1_LANECTRL0			0x8015
#define MDIO_WC_REG_XGXSBLK1_LANECTRL1			0x8016
#define MDIO_WC_REG_XGXSBLK1_LANECTRL2			0x8017
#define MDIO_WC_REG_XGXSBLK1_LANECTRL3			0x8018
#define MDIO_WC_REG_XGXSBLK1_LANETEST0			0x801a
#define MDIO_WC_REG_TX0_ANA_CTRL0			0x8061
#define MDIO_WC_REG_TX1_ANA_CTRL0			0x8071
#define MDIO_WC_REG_TX2_ANA_CTRL0			0x8081
#define MDIO_WC_REG_TX3_ANA_CTRL0			0x8091
#define MDIO_WC_REG_TX0_TX_DRIVER			0x8067
#define MDIO_WC_REG_TX0_TX_DRIVER_IPRE_DRIVER_OFFSET		0x04
#define MDIO_WC_REG_TX0_TX_DRIVER_IPRE_DRIVER_MASK			0x00f0
#define MDIO_WC_REG_TX0_TX_DRIVER_IDRIVER_OFFSET		0x08
#define MDIO_WC_REG_TX0_TX_DRIVER_IDRIVER_MASK				0x0f00
#define MDIO_WC_REG_TX0_TX_DRIVER_POST2_COEFF_OFFSET		0x0c
#define MDIO_WC_REG_TX0_TX_DRIVER_POST2_COEFF_MASK			0x7000
#define MDIO_WC_REG_TX1_TX_DRIVER			0x8077
#define MDIO_WC_REG_TX2_TX_DRIVER			0x8087
#define MDIO_WC_REG_TX3_TX_DRIVER			0x8097
#define MDIO_WC_REG_RX0_ANARXCONTROL1G			0x80b9
#define MDIO_WC_REG_RX2_ANARXCONTROL1G			0x80d9
#define MDIO_WC_REG_RX0_PCI_CTRL			0x80ba
#define MDIO_WC_REG_RX1_PCI_CTRL			0x80ca
#define MDIO_WC_REG_RX2_PCI_CTRL			0x80da
#define MDIO_WC_REG_RX3_PCI_CTRL			0x80ea
#define MDIO_WC_REG_XGXSBLK2_UNICORE_MODE_10G		0x8104
#define MDIO_WC_REG_XGXS_STATUS3			0x8129
#define MDIO_WC_REG_PAR_DET_10G_STATUS			0x8130
#define MDIO_WC_REG_PAR_DET_10G_CTRL			0x8131
#define MDIO_WC_REG_XGXS_STATUS4			0x813c
#define MDIO_WC_REG_XGXS_X2_CONTROL2			0x8141
#define MDIO_WC_REG_XGXS_X2_CONTROL3			0x8142
#define MDIO_WC_REG_XGXS_RX_LN_SWAP1			0x816B
#define MDIO_WC_REG_XGXS_TX_LN_SWAP1			0x8169
#define MDIO_WC_REG_GP2_STATUS_GP_2_0			0x81d0
#define MDIO_WC_REG_GP2_STATUS_GP_2_1			0x81d1
#define MDIO_WC_REG_GP2_STATUS_GP_2_2			0x81d2
#define MDIO_WC_REG_GP2_STATUS_GP_2_3			0x81d3
#define MDIO_WC_REG_GP2_STATUS_GP_2_4			0x81d4
#define MDIO_WC_REG_GP2_STATUS_GP_2_4_CL73_AN_CMPL 0x1000
#define MDIO_WC_REG_GP2_STATUS_GP_2_4_CL37_AN_CMPL 0x0100
#define MDIO_WC_REG_GP2_STATUS_GP_2_4_CL37_LP_AN_CAP 0x0010
#define MDIO_WC_REG_GP2_STATUS_GP_2_4_CL37_AN_CAP 0x1
#define MDIO_WC_REG_UC_INFO_B0_DEAD_TRAP		0x81EE
#define MDIO_WC_REG_UC_INFO_B1_VERSION			0x81F0
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_MODE		0x81F2
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_LANE0_OFFSET	0x0
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_MODE_DEFAULT	    0x0
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_MODE_SFP_OPT_LR	    0x1
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_MODE_SFP_DAC	    0x2
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_MODE_SFP_XLAUI	    0x3
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_MODE_LONG_CH_6G	    0x4
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_LANE1_OFFSET	0x4
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_LANE2_OFFSET	0x8
#define MDIO_WC_REG_UC_INFO_B1_FIRMWARE_LANE3_OFFSET	0xc
#define MDIO_WC_REG_UC_INFO_B1_CRC			0x81FE
#define MDIO_WC_REG_DSC1B0_UC_CTRL				0x820e
#define MDIO_WC_REG_DSC1B0_UC_CTRL_RDY4CMD			(1<<7)
#define MDIO_WC_REG_DSC_SMC				0x8213
#define MDIO_WC_REG_DSC2B0_DSC_MISC_CTRL0		0x821e
#define MDIO_WC_REG_TX_FIR_TAP				0x82e2
#define MDIO_WC_REG_TX_FIR_TAP_PRE_TAP_OFFSET		0x00
#define MDIO_WC_REG_TX_FIR_TAP_PRE_TAP_MASK			0x000f
#define MDIO_WC_REG_TX_FIR_TAP_MAIN_TAP_OFFSET		0x04
#define MDIO_WC_REG_TX_FIR_TAP_MAIN_TAP_MASK		0x03f0
#define MDIO_WC_REG_TX_FIR_TAP_POST_TAP_OFFSET		0x0a
#define MDIO_WC_REG_TX_FIR_TAP_POST_TAP_MASK		0x7c00
#define MDIO_WC_REG_TX_FIR_TAP_ENABLE		0x8000
#define MDIO_WC_REG_CL72_USERB0_CL72_TX_FIR_TAP		0x82e2
#define MDIO_WC_REG_CL72_USERB0_CL72_MISC1_CONTROL	0x82e3
#define MDIO_WC_REG_CL72_USERB0_CL72_OS_DEF_CTRL	0x82e6
#define MDIO_WC_REG_CL72_USERB0_CL72_BR_DEF_CTRL	0x82e7
#define MDIO_WC_REG_CL72_USERB0_CL72_2P5_DEF_CTRL	0x82e8
#define MDIO_WC_REG_CL72_USERB0_CL72_MISC4_CONTROL	0x82ec
#define MDIO_WC_REG_SERDESDIGITAL_CONTROL1000X1		0x8300
#define MDIO_WC_REG_SERDESDIGITAL_CONTROL1000X2		0x8301
#define MDIO_WC_REG_SERDESDIGITAL_CONTROL1000X3		0x8302
#define MDIO_WC_REG_SERDESDIGITAL_STATUS1000X1		0x8304
#define MDIO_WC_REG_SERDESDIGITAL_MISC1			0x8308
#define MDIO_WC_REG_SERDESDIGITAL_MISC2			0x8309
#define MDIO_WC_REG_DIGITAL3_UP1			0x8329
#define MDIO_WC_REG_DIGITAL3_LP_UP1			0x832c
#define MDIO_WC_REG_DIGITAL4_MISC3			0x833c
#define MDIO_WC_REG_DIGITAL4_MISC5			0x833e
#define MDIO_WC_REG_DIGITAL5_MISC6			0x8345
#define MDIO_WC_REG_DIGITAL5_MISC7			0x8349
#define MDIO_WC_REG_DIGITAL5_LINK_STATUS		0x834d
#define MDIO_WC_REG_DIGITAL5_ACTUAL_SPEED		0x834e
#define MDIO_WC_REG_DIGITAL6_MP5_NEXTPAGECTRL		0x8350
#define MDIO_WC_REG_CL49_USERB0_CTRL			0x8368
#define MDIO_WC_REG_CL73_USERB0_CTRL			0x8370
#define MDIO_WC_REG_CL73_USERB0_USTAT			0x8371
#define MDIO_WC_REG_CL73_BAM_CTRL1			0x8372
#define MDIO_WC_REG_CL73_BAM_CTRL2			0x8373
#define MDIO_WC_REG_CL73_BAM_CTRL3			0x8374
#define MDIO_WC_REG_CL73_BAM_CODE_FIELD			0x837b
#define MDIO_WC_REG_EEE_COMBO_CONTROL0			0x8390
#define MDIO_WC_REG_TX66_CONTROL			0x83b0
#define MDIO_WC_REG_RX66_CONTROL			0x83c0
#define MDIO_WC_REG_RX66_SCW0				0x83c2
#define MDIO_WC_REG_RX66_SCW1				0x83c3
#define MDIO_WC_REG_RX66_SCW2				0x83c4
#define MDIO_WC_REG_RX66_SCW3				0x83c5
#define MDIO_WC_REG_RX66_SCW0_MASK			0x83c6
#define MDIO_WC_REG_RX66_SCW1_MASK			0x83c7
#define MDIO_WC_REG_RX66_SCW2_MASK			0x83c8
#define MDIO_WC_REG_RX66_SCW3_MASK			0x83c9
#define MDIO_WC_REG_FX100_CTRL1				0x8400
#define MDIO_WC_REG_FX100_CTRL3				0x8402
#define MDIO_WC_REG_CL82_USERB1_TX_CTRL5		0x8436
#define MDIO_WC_REG_CL82_USERB1_TX_CTRL6		0x8437
#define MDIO_WC_REG_CL82_USERB1_TX_CTRL7		0x8438
#define MDIO_WC_REG_CL82_USERB1_TX_CTRL9		0x8439
#define MDIO_WC_REG_CL82_USERB1_RX_CTRL10		0x843a
#define MDIO_WC_REG_CL82_USERB1_RX_CTRL11		0x843b
#define MDIO_WC_REG_ETA_CL73_OUI1			0x8453
#define MDIO_WC_REG_ETA_CL73_OUI2			0x8454
#define MDIO_WC_REG_ETA_CL73_OUI3			0x8455
#define MDIO_WC_REG_ETA_CL73_LD_BAM_CODE		0x8456
#define MDIO_WC_REG_ETA_CL73_LD_UD_CODE			0x8457
#define MDIO_WC_REG_MICROBLK_CMD			0xffc2
#define MDIO_WC_REG_MICROBLK_DL_STATUS			0xffc5
#define MDIO_WC_REG_MICROBLK_CMD3			0xffcc

#define MDIO_WC_REG_AERBLK_AER				0xffde
#define MDIO_WC_REG_COMBO_IEEE0_MIICTRL			0xffe0
#define MDIO_WC_REG_COMBO_IEEE0_MIIISTAT		0xffe1

#define MDIO_WC0_XGXS_BLK2_LANE_RESET			0x810A
#define MDIO_WC0_XGXS_BLK2_LANE_RESET_RX_BITSHIFT	0
#define MDIO_WC0_XGXS_BLK2_LANE_RESET_TX_BITSHIFT	4

#define MDIO_WC0_XGXS_BLK6_XGXS_X2_CONTROL2		0x8141

#define DIGITAL5_ACTUAL_SPEED_TX_MASK			0x003f

/* 54618se */
#define MDIO_REG_GPHY_MII_STATUS			0x1
#define MDIO_REG_GPHY_PHYID_LSB				0x3
#define MDIO_REG_GPHY_CL45_ADDR_REG			0xd
#define MDIO_REG_GPHY_CL45_REG_WRITE		0x4000
#define MDIO_REG_GPHY_CL45_REG_READ		0xc000
#define MDIO_REG_GPHY_CL45_DATA_REG			0xe
#define MDIO_REG_GPHY_EEE_RESOLVED		0x803e
#define MDIO_REG_GPHY_EXP_ACCESS_GATE			0x15
#define MDIO_REG_GPHY_EXP_ACCESS			0x17
#define MDIO_REG_GPHY_EXP_ACCESS_TOP		0xd00
#define MDIO_REG_GPHY_EXP_TOP_2K_BUF		0x40
#define MDIO_REG_GPHY_AUX_STATUS			0x19
#define MDIO_REG_INTR_STATUS				0x1a
#define MDIO_REG_INTR_MASK				0x1b
#define MDIO_REG_INTR_MASK_LINK_STATUS			(0x1 << 1)
#define MDIO_REG_GPHY_SHADOW				0x1c
#define MDIO_REG_GPHY_SHADOW_LED_SEL1			(0x0d << 10)
#define MDIO_REG_GPHY_SHADOW_LED_SEL2			(0x0e << 10)
#define MDIO_REG_GPHY_SHADOW_WR_ENA			(0x1 << 15)
#define MDIO_REG_GPHY_SHADOW_AUTO_DET_MED		(0x1e << 10)
#define MDIO_REG_GPHY_SHADOW_INVERT_FIB_SD		(0x1 << 8)


#define IGU_FUNC_BASE			0x0400

#define IGU_ADDR_MSIX			0x0000
#define IGU_ADDR_INT_ACK		0x0200
#define IGU_ADDR_PROD_UPD		0x0201
#define IGU_ADDR_ATTN_BITS_UPD	0x0202
#define IGU_ADDR_ATTN_BITS_SET	0x0203
#define IGU_ADDR_ATTN_BITS_CLR	0x0204
#define IGU_ADDR_COALESCE_NOW	0x0205
#define IGU_ADDR_SIMD_MASK		0x0206
#define IGU_ADDR_SIMD_NOMASK	0x0207
#define IGU_ADDR_MSI_CTL		0x0210
#define IGU_ADDR_MSI_ADDR_LO	0x0211
#define IGU_ADDR_MSI_ADDR_HI	0x0212
#define IGU_ADDR_MSI_DATA		0x0213


#define IGU_USE_REGISTER_ustorm_type_0_sb_cleanup  0
#define IGU_USE_REGISTER_ustorm_type_1_sb_cleanup  1
#define IGU_USE_REGISTER_cstorm_type_0_sb_cleanup  2
#define IGU_USE_REGISTER_cstorm_type_1_sb_cleanup  3

#define COMMAND_REG_INT_ACK	    0x0
#define COMMAND_REG_PROD_UPD	    0x4
#define COMMAND_REG_ATTN_BITS_UPD   0x8
#define COMMAND_REG_ATTN_BITS_SET   0xc
#define COMMAND_REG_ATTN_BITS_CLR   0x10
#define COMMAND_REG_COALESCE_NOW    0x14
#define COMMAND_REG_SIMD_MASK	    0x18
#define COMMAND_REG_SIMD_NOMASK	    0x1c


#define IGU_MEM_BASE						0x0000

#define IGU_MEM_MSIX_BASE					0x0000
#define IGU_MEM_MSIX_UPPER					0x007f
#define IGU_MEM_MSIX_RESERVED_UPPER			0x01ff

#define IGU_MEM_PBA_MSIX_BASE				0x0200
#define IGU_MEM_PBA_MSIX_UPPER				0x0200

#define IGU_CMD_BACKWARD_COMP_PROD_UPD		0x0201
#define IGU_MEM_PBA_MSIX_RESERVED_UPPER		0x03ff

#define IGU_CMD_INT_ACK_BASE				0x0400
#define IGU_CMD_INT_ACK_UPPER \
	(IGU_CMD_INT_ACK_BASE + MAX_SB_PER_PATH - 1)
#define IGU_CMD_INT_ACK_RESERVED_UPPER		0x04ff

#define IGU_CMD_E2_PROD_UPD_BASE			0x0500
#define IGU_CMD_E2_PROD_UPD_UPPER \
	(IGU_CMD_E2_PROD_UPD_BASE + MAX_SB_PER_PATH  - 1)
#define IGU_CMD_E2_PROD_UPD_RESERVED_UPPER	0x059f

#define IGU_CMD_ATTN_BIT_UPD_UPPER			0x05a0
#define IGU_CMD_ATTN_BIT_SET_UPPER			0x05a1
#define IGU_CMD_ATTN_BIT_CLR_UPPER			0x05a2

#define IGU_REG_SISR_MDPC_WMASK_UPPER		0x05a3
#define IGU_REG_SISR_MDPC_WMASK_LSB_UPPER	0x05a4
#define IGU_REG_SISR_MDPC_WMASK_MSB_UPPER	0x05a5
#define IGU_REG_SISR_MDPC_WOMASK_UPPER		0x05a6


#define IGU_REG_RESERVED_UPPER				0x05ff

#define IGU_SEG_IDX_ATTN	2
#define IGU_SEG_IDX_DEFAULT	1
/* Fields of IGU PF CONFIGRATION REGISTER */
#define IGU_PF_CONF_FUNC_EN	  (0x1<<0)  /* function enable	      */
#define IGU_PF_CONF_MSI_MSIX_EN	  (0x1<<1)  /* MSI/MSIX enable	      */
#define IGU_PF_CONF_INT_LINE_EN	  (0x1<<2)  /* INT enable	      */
#define IGU_PF_CONF_ATTN_BIT_EN	  (0x1<<3)  /* attention enable       */
#define IGU_PF_CONF_SINGLE_ISR_EN (0x1<<4)  /* single ISR mode enable */
#define IGU_PF_CONF_SIMD_MODE	  (0x1<<5)  /* simd all ones mode     */

/* Fields of IGU VF CONFIGRATION REGISTER */
#define IGU_VF_CONF_FUNC_EN	   (0x1<<0)  /* function enable        */
#define IGU_VF_CONF_MSI_MSIX_EN	   (0x1<<1)  /* MSI/MSIX enable        */
#define IGU_VF_CONF_PARENT_MASK	   (0x3<<2)  /* Parent PF	       */
#define IGU_VF_CONF_PARENT_SHIFT   2	     /* Parent PF	       */
#define IGU_VF_CONF_SINGLE_ISR_EN  (0x1<<4)  /* single ISR mode enable */


#define IGU_BC_DSB_NUM_SEGS    5
#define IGU_BC_NDSB_NUM_SEGS   2
#define IGU_NORM_DSB_NUM_SEGS  2
#define IGU_NORM_NDSB_NUM_SEGS 1
#define IGU_BC_BASE_DSB_PROD   128
#define IGU_NORM_BASE_DSB_PROD 136

	/* FID (if VF - [6] = 0; [5:0] = VF number; if PF - [6] = 1; \
	[5:2] = 0; [1:0] = PF number) */
#define IGU_FID_ENCODE_IS_PF	    (0x1<<6)
#define IGU_FID_ENCODE_IS_PF_SHIFT  6
#define IGU_FID_VF_NUM_MASK	    (0x3f)
#define IGU_FID_PF_NUM_MASK	    (0x7)

#define IGU_REG_MAPPING_MEMORY_VALID		(1<<0)
#define IGU_REG_MAPPING_MEMORY_VECTOR_MASK	(0x3F<<1)
#define IGU_REG_MAPPING_MEMORY_VECTOR_SHIFT	1
#define IGU_REG_MAPPING_MEMORY_FID_MASK		(0x7F<<7)
#define IGU_REG_MAPPING_MEMORY_FID_SHIFT	7


#define CDU_REGION_NUMBER_XCM_AG 2
#define CDU_REGION_NUMBER_UCM_AG 4


/* String-to-compress [31:8] = CID (all 24 bits)
 * String-to-compress [7:4] = Region
 * String-to-compress [3:0] = Type
 */
#define CDU_VALID_DATA(_cid, _region, _type) \
	(((_cid) << 8) | (((_region)&0xf)<<4) | (((_type)&0xf)))
#define CDU_CRC8(_cid, _region, _type) \
	(ecore_calc_crc8(CDU_VALID_DATA(_cid, _region, _type), 0xff))
#define CDU_RSRVD_VALUE_TYPE_A(_cid, _region, _type) \
	(0x80 | ((CDU_CRC8(_cid, _region, _type)) & 0x7f))
#define CDU_RSRVD_VALUE_TYPE_B(_crc, _type) \
	(0x80 | ((_type)&0xf << 3) | ((CDU_CRC8(_cid, _region, _type)) & 0x7))
#define CDU_RSRVD_INVALIDATE_CONTEXT_VALUE(_val) ((_val) & ~0x80)

#endif /* ECORE_REG_H */
