# Upload the files with scp in a batch.

import os,sys,stat,dputhelper

def upload(fqdn,login,incoming,files_to_upload,debug,compress):

    files_to_fix = []

    for file in files_to_upload:
        to_fix = os.path.basename(file)
        file_to_fix = os.path.join(incoming, to_fix)
        files_to_fix.append(file_to_fix)
    
    if compress:
        command = ['scp', '-Cp', '%s@%s:%s' % (login, fqdn, incoming)]
    else:
        command = ['scp', '-p', '%s@%s:%s' % (login, fqdn, incoming)]
    command[2:2] = files_to_upload
    change_mode = 0
    for file in files_to_upload:
        if not stat.S_IMODE(os.lstat(file)[stat.ST_MODE])==0644:
            change_mode = 1
    if debug:
        print "D: Uploading with scp to %s@%s:%s" % \
            (login, fqdn, incoming)
        print "D: %s" % command
    if dputhelper.spawnv(os.P_WAIT, '/usr/bin/scp', command):
        print "Error while uploading."
        sys.exit(1)
    if change_mode:
        fix_command = ['ssh', '%s@%s' % (login, fqdn), 'chmod', '0644'] \
        + files_to_fix
        if dputhelper.spawnv(os.P_WAIT, '/usr/bin/ssh', fix_command):
            print "Error while fixing permission."
            sys.exit(1)
