/* $Id: ssl.h,v 1.18 2003/10/27 23:58:58 jonas Exp $ */

#ifndef EL__SSL_SSL_H
#define EL__SSL_SSL_H

#ifdef HAVE_SSL

#include "modules/module.h"
#include "sched/connection.h"

extern struct module ssl_module;

/* Initializes the SSL connection data. Returns S_OK on success and S_SSL_ERROR
 * on failure. */
int init_ssl_connection(struct connection *conn);

/* Releases the SSL connection data */
void done_ssl_connection(struct connection *conn);

unsigned char *get_ssl_connection_cipher(struct connection *conn);


/* Internal type used in ssl module. */

#ifdef HAVE_OPENSSL
#define	ssl_t	SSL
#elif defined(HAVE_GNUTLS)
#define	ssl_t	GNUTLS_STATE
#endif

#endif /* HAVE_SSL */
#endif
