# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core import common

import pgm
from pgm.graph.group import Group
from pgm.graph.image import Image
from pgm.timing import implicit
from pgm.widgets import const

from raval_widgets.context_bar import ContextBar
import constants

plugin_registry = common.application.plugin_registry
PigmentView = plugin_registry.get_component_class('pigment:pigment_view')

from elisa.core.observers.list import ListObserver
class ContextView(PigmentView, ListObserver):

    supported_controllers = ('raval:context_controller',)
    bindings = (('current_index', 'current_index'),
                ('icon', 'icon'),
                ('text', 'text'))

    def clean(self):
        super(ContextView, self).clean()
        self._context_bar.context = None

    def current_index__set(self, value):
        #if ask to unselect all the buttion
        if value == -1:
            self._context_bar.button_panel.current_index = value
        else:
            #looking for the next (or previous) buttion with an valid action
            if (value - self._context_bar.button_panel.current_index) > 0:
                next_action_index = self._get_next_action_index(value)
            else:
                next_action_index = self._get_previous_action_index(value)
    

            if next_action_index == -1:
                next_action_index = self._context_bar.button_panel.current_index
                
            if self.controller.current_index != next_action_index:
                self.controller.current_index = next_action_index
            else:
                self._context_bar.button_panel.current_index = next_action_index
    
    
    def _get_next_action_index(self, current_index):
        
        if current_index >= len(self.controller.model):
            current_index = len(self.controller.model) -1
        #return the next model with an activate action defined
        for i in range(current_index, len(self.controller.model)):
            next_model = self.controller.model[i]
            if next_model.activate_action:
                return i
            
        return -1
    
    def _get_previous_action_index(self, current_index):
        #return the next model with an activate action defined
        
        if current_index < 0:
            current_index = 0
             
        for i in reversed( range(0, current_index+1) ):
            next_model = self.controller.model[i]
            if next_model.activate_action:
                return i
            
        return -1
        
        
    def create_widgets(self):
        canvas = self.frontend.context.viewport_handle.get_canvas()
        theme = self.frontend.theme
        self._context_bar = ContextBar()
        self.load_from_theme("context_bg", self._context_bar.background)
        self.context_handle.add(self._context_bar)
     
        # Animation support for both context and status bar 
        self._animated_context_bar = implicit.AnimatedObject(self._context_bar)
        settings = {'duration': 1000,
                    'transformation': implicit.DECELERATE}
        self._animated_context_bar.setup_next_animations(**settings)
        self._animated_context_bar.mode = implicit.REPLACE
        
    
    def controller_changed(self, old_controller, new_controller):
        if new_controller == None:
            return    
    
        for model in new_controller.model:
            if model.theme_icon:
                img_path = self.frontend.theme.get_media(model.theme_icon)
            else:
                img_path = None
            self._context_bar.button_panel.add_button(img_path, 128)
        
        self._context_bar.button_panel.index_changed.connect(
                                                self._widget_index_clicked_cb)
        
        self.compute_layout()
        
    def _widget_index_clicked_cb(self, index):
        #self.controller.current_index = index
        self.controller.fire_activate_action(index, self.frontend)
        
    def compute_layout(self):
        canvas = self.frontend.context.viewport_handle.get_canvas()
        self._context_bar.size = (canvas.width, canvas.height * 
                                  (constants.context_bar_height/100) )
        self._context_bar.y = -self._context_bar.height * 2.0
        self._context_bar.compute_layout()
        
 
    def inserted(self, elements, position):
        #FIXME : not implemented
        pass

    def active__set(self, value):
        self._context_bar.button_panel.active = value

    def icon__set(self, icon):
        if icon:
            icon_file = self.frontend.theme.get_media(icon)
            self._context_bar.icon.set_from_file(icon_file, 64)
            self.show()
        else:
            self.hide()

    def text__set(self, text):
        if text:
            frontend = self.frontend
            self._context_bar.label = frontend.translate_text(text)
            self.show()
        else:
            self._context_bar.label = ""
            self.hide()

    def show(self):
        self.debug("Showing context bar")
        self._context_bar.visible = True
        self._animated_context_bar.y = 0.0
        
    def hide(self):
        self.debug("Hiding context bar")
        self._animated_context_bar.y = -self._context_bar.height*2.0

