# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import gobject

class Notifier(gobject.GObject):
    __gsignals__ = {'item-changed': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_PYOBJECT,
                                     (gobject.TYPE_PYOBJECT, gobject.TYPE_PYOBJECT,
                                      gobject.TYPE_PYOBJECT)),
                   }


class NotifyingDictionary(dict):

    # FIXME: incomplete: does not override all the dict methods that write

    def __init__(self, *args, **kwargs):
        dict.__init__(self, *args, **kwargs)
        self.notifier = Notifier()

    def __setitem__(self, key, value):
        dict.__setitem__(self, key, value)
        self.notifier.emit('item-changed', self, key, value)



if __name__ == "__main__":
    def on_item_changed(notifier, dictionary, key, value):
        print "[%s] %s set to %s" % (dictionary, key, value)

    d = NotifyingDictionary()
    d.notifier.connect('item-changed', on_item_changed)
    d['key']= 'value'
    d['key']= 'value2'
    d['key3']= 'value2'
