
from node_builder_test import NodeBuilderTest, StupidModel
from elisa.core.tests.elisa_test_case import ElisaTestCase

from elisa.extern.coherence.et import parse_xml

class StupidPlayerModel(object):
    pass

class Activity(object):
    player_model = StupidPlayerModel()

class PlaylistNodeBuilderTest(NodeBuilderTest, ElisaTestCase):
    component_path = 'xmlmenu:playlist_node_builder'
    entry_identifiers = ['playlist_node']

    def test_menu_node_builder(self):

        data = """
        <MenuEntry type='playlist_node'>
            <Label translate-domain='elisa-base'>Playlist</Label>
            <Icon>audio_playlist_icon</Icon>
        </MenuEntry>
        """

        xml = parse_xml(data)
        root = xml.getroot()

        def loadmore_done(result, data, a):
            # our 3 + Clear Playlist
            self.assertEquals(len(data.children), 4)
            self.component.unload(data) 
            # the clear playlist has be removed 
            self.assertEquals(len(a.player_model.playlist), 3)

        def done_callback(data, test_model, a):
            # got added
            self.assertEquals(len(test_model.children), 1)
            data = test_model.children[0]

            self.assertEquals(data.activity, self.component)

            # 3 items. Only loadmore gives us a third one
            self.assertEquals(len(data.children), 3)
            self.assertEquals(data.children, ['a', 'b', 'c'])

            # try the loadmore:
            dfr = self.component.loadmore(data)
            dfr.addCallback(loadmore_done, data, a)
            return dfr
        
        test_model = StupidModel()
        test_model.children = []
        menu_config =  {
                    'DefaultDirsIcon' : 'dir_icon',
                    'DefaultFilesIcon' : 'file_icon',
                    'MediaFilter' : 'ANY',
                    'ContentType' : 'sections' }
        a = Activity()
        a.player_model.playlist = ['a', 'b', 'c']
        test_model.activity = a
        self.xmlmenu._model_configs[test_model] = menu_config

        dfr = self.component.build_menu_entry(test_model, root)
        dfr.addCallback(done_callback, test_model, a)


