# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

# This script has to be used if you want to run Elisa from a SVN checkout.
# If you have a system-wide installation of Elisa already, it will be
# ignored

__maintainer__ = 'Guido Amoruso <guidonte@fluendo.com>'

import os
import sys
import site

def add_site_dirs():
    local_plugins_dir = os.path.expanduser('~/.elisa/core')
    if os.path.isdir(local_plugins_dir):
        path = sys.path
        sys.path = []
        site.addsitedir(local_plugins_dir)
        sys.path.extend(path)

    local_plugins_dir = os.path.expanduser('~/.elisa/plugins')
    if os.path.isdir(local_plugins_dir):
        path = sys.path
        sys.path = []
        site.addsitedir(local_plugins_dir)
        sys.path.extend(path)
    
def fix_paths():
    script = os.path.abspath(__file__)
    elisa_core = os.path.dirname(script)
    path = list(os.path.split(elisa_core)[:-1])
    path.append('elisa-plugins')
    elisa_plugins = os.path.join(*path)

    if os.path.exists(elisa_core):
        sys.path.insert(0, elisa_core)

    if os.path.exists(elisa_plugins):
        sys.path.insert(1, elisa_plugins)

        key = 'ELISA_PLUGIN_PATH'
        paths = [p for p in os.environ.get(key, '').split(':') if p != '']
        paths.append(os.path.join(elisa_plugins, 'elisa'))
        os.environ[key] = ':'.join(paths)

if __name__ == '__main__':
    # fix the path for svn version
    fix_paths()
    add_site_dirs()

    # FIXME: importing pkg_resources is needed just after new site dirs
    #        have been added so that the right egg distributions are
    #        chosen when importing elisa.core and the plugins
    import pkg_resources
    
    from elisa.core.epm import console_client
    from twisted.internet import reactor
    
    reactor.callWhenRunning(console_client.main)
    reactor.run()
