# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core.component import Component

class Context(Component):
    """
    DOCME

    @ivar viewport_handle:  main window instance (eg. Pigment viewport, GTK
                            window, etc.)
    @type viewport_handle:  any
    @ivar aspect_ratio:     can be '16:9', 'auto', 'mm'
    DOCME: what is 'mm'?
    @type aspect_ratio:     string
    """

    viewport_handle = None
    
    def __init__(self):
        Component.__init__(self)
        self._aspect_ratio = None

    def aspect_ratio__get(self):
        return self._aspect_ratio
    
    def aspect_ratio__set(self, aspect_ratio):
        if self._aspect_ratio == aspect_ratio:
            return
        
        if aspect_ratio not in ('auto', 'mm') and \
           not isinstance(aspect_ratio.split(':'), tuple) and \
           len(aspect_ratio.split(':')) != 2:
            raise TypeError
        
        old_aspect_ratio = self._aspect_ratio
        self._aspect_ratio = aspect_ratio
        
        self.aspect_ratio_changed(old_aspect_ratio, aspect_ratio)
       
    def aspect_ratio_changed(self, old_aspect_ratio, new_aspect_ratio):
        """
        DOCME
        """
        pass

    def theme_changed(self, old_theme, new_theme):
        """
        DOCME
        """
        pass
