# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import common
from elisa.core import media_manager, metadata_manager, media_uri
from elisa.core.components import media_provider, metadata_provider

from twisted.internet import defer, threads

class FooMetadataProvider(metadata_provider.MetadataProvider):

    def get_rank(self):
        rank = 220
        return rank

    def able_to_handle(self, dict):
        if not dict.has_key('uri'):
            return False

        uri = dict['uri']

        if uri.scheme == 'foo':
            return True
        return False

    def get_metadata(self, dict, low_priority=False):
        d = threads.deferToThread(self._get_metadata,dict)
        return d

    def _get_metadata(self, dict):
        if not dict.has_key('uri'):
            return dict
        dict['artist'] =  'foo'
        dict['album'] =  'bar'
        return dict

class BarMetadataProvider(metadata_provider.MetadataProvider):
    def get_rank(self):
        rank = 250
        return rank

    def able_to_handle(self, dict):
        if not dict.has_key('uri'):
            return False

        uri = dict['uri']

        if uri.scheme == 'foo' or uri.scheme == 'bar':
            return True
        return False

    def get_metadata(self, dict, low_priority=False):
        d = threads.deferToThread(self._get_metadata,dict)
        return d

    def _get_metadata(self, dict):
        if not dict.has_key('uri'):
            return dict

        dict['artist'] =  'foo'
        dict['album'] =  'bar'
        dict['cover'] = 'fool'

        return dict

class TestMetadataProvider(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._fooprovider = FooMetadataProvider()
        self._barprovider = BarMetadataProvider()

    def test_able_to_handle(self):
        foo_uri = media_uri.MediaUri(u'foo://bar')
        foo_dict = {'uri' : foo_uri}
        bar_uri = media_uri.MediaUri(u'bar://blah')
        bar_dict = {'uri' : bar_uri}
        self.assertEquals(self._fooprovider.able_to_handle(foo_dict), True)
        self.assertEquals(self._barprovider.able_to_handle(foo_dict), True)
        self.assertEquals(self._fooprovider.able_to_handle(bar_dict), False)
        self.assertEquals(self._barprovider.able_to_handle(bar_dict), True)


    def test_metadata_foo(self):
        foo_uri = media_uri.MediaUri(u'foo://bar')
        foo_dict = {'uri' : foo_uri}

        def dict_filled(dict):
            self.assertEquals(dict, {'uri': foo_uri,'artist': 'foo', 'album': 'bar'})

        df = self._fooprovider.get_metadata(foo_dict)
        df.addCallback(dict_filled)


    def test_metadata_bar(self):
        foo_uri = media_uri.MediaUri(u'foo://bar')
        foo_dict = {'uri' : foo_uri}

        def dict_filled(dict):
            self.assertEquals(dict, {'uri': foo_uri,'artist': 'foo', 'album':
                                     'bar','cover' : 'fool'})

        df = self._barprovider.get_metadata(foo_dict)
        df.addCallback(dict_filled)
