# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase, BoilerPlateApp
from elisa.core import common, player_engine_registry, player, media_uri
from elisa.core.components import player_engine

from elisa.core.player import STATES

from test_player_engine import FooEngine, StupidPipe

import gst

class StupidRegistry(object):

    engine = None

    def __init__(self):
        pass

    def create_engine_for_scheme(self, uri_scheme):
        if uri_scheme == 'non':
            self.engine = None
            raise player_engine_registry.NoEngineFound()

        self.engine = FooEngine()
        return self.engine

class simpleManager(object):
    def get_real_uri(self, res):
        return res

class TestPlayer(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._registry = StupidRegistry()
        self._player = player.Player(self._registry)

        app = BoilerPlateApp('empty.conf')
        common.set_application(app)

        from elisa.core.common import application
        application.media_manager = simpleManager()

    def test_player(self):
        player = self._player
        player.uri = media_uri.MediaUri('foo://host/path/file')
        engine = self._registry.engine
        self.assertFalse(engine == None)

        engine.state = STATES.STOPPED
        player.play()
        self.assertEquals(engine.state, STATES.LOADING)
        self.assertEquals(engine.pipeline.state, gst.STATE_PLAYING)

        engine.state = STATES.PLAYING
        player.pause()
        self.assertEquals(engine.pipeline.state, gst.STATE_PAUSED)
 
        engine.state = STATES.PLAYING
        player.toggle_play_pause()
        self.assertEquals(engine.pipeline.state, gst.STATE_PAUSED)
       
        engine.state = STATES.PAUSED
        player.toggle_play_pause()
        self.assertEquals(engine.pipeline.state, gst.STATE_PLAYING)
 
        engine.state = STATES.PAUSED
        player.play()
        self.assertEquals(engine.state, STATES.PLAYING)
        self.assertEquals(engine.pipeline.state, gst.STATE_PLAYING)

        engine.state = STATES.PLAYING
        player.stop()
        self.assertEquals(engine.pipeline.state, gst.STATE_READY)

        engine.state = STATES.PLAYING
        player.restart_from_beginning()
        self.assertEquals(engine.pipeline.state, gst.STATE_PLAYING)

        player.volume = 5
        self.assertEquals(engine.volume, 5)

        player.muted = True
        self.assertEquals(engine.volume, 0)
        self.assertTrue(player.muted)
        self.assertEquals(player.volume, 5)

        player.muted = False
        self.assertEquals(engine.volume, 5)
        self.assertEquals(player.volume, 5)
        self.assertEquals(player.muted, False)

        self.assertEquals(player.position, -1)
        self.assertEquals(player.duration, -1)

        player.video_sink = True
        self.assertTrue(engine.video_sink)
        self.assertTrue(player.video_sink)
        
        player.audio_sink = True
        self.assertTrue(engine.audio_sink)
        self.assertTrue(player.audio_sink)

        player.uri = media_uri.MediaUri('foo://host/path/file')
        self.assertEquals(engine, self._registry.engine)

        player.uri = media_uri.MediaUri('bar://host/path/file')
        self.assertFalse(engine == self._registry.engine)

        engine = self._registry.engine

        player.uri = media_uri.MediaUri('non://host/path/file')
        self.assertFalse(engine == self._registry.engine)

        player.uri = media_uri.MediaUri('non://host/path/wrong')
        self.assertEquals(self._registry.engine, None)



        




