# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.utils import typefinding
from elisa.core import media_uri

class TestTypefinding(unittest.TestCase):


    def test_get_media_infos_from_mime(self):

        uris = {'file://./foo.mp3': ['audio',],
                'file://./test.ogg': ['audio','video'],
                'file://./test.ogm': ['video',],
                'file://./test.ogv': ['video',],
                'file://./test.oga': ['audio',],
                'file://./test.jpg': ['image',],
                'file:///C:/Documents and Settings/yoyo/My Documents/My Music/JunoSoundtrack/18-Vampire.mp3': ['audio',],
                }
        for uri, expected in uris.iteritems():
            infos = typefinding.typefind(media_uri.MediaUri(uri))
            self.assertEquals(infos, expected)

    def test_unknown_extension(self):
        self.assertRaises(typefinding.UnknownFileExtension,
                          typefinding.typefind, media_uri.MediaUri('file://idontexist.idontknwo'))
        self.assertRaises(typefinding.UnknownFileExtension,
                          typefinding.typefind, media_uri.MediaUri('file://idontexist'))
