// -*- C++ -*-
#include <klistview.h>
#include <qpixmap.h>
#include <kapplication.h>
#include <qobjectlist.h>
#include <qlayout.h>
#include <kglobalsettings.h>
#include <vector>
#include <typeinfo>

#ifndef EPT_EXTENDABLELIST_H
#define EPT_EXTENDABLELIST_H
namespace ept {

class ExtendableItem;
class ExtendableList;
class ItemExtender;

class ExtendableList : public KListView {
    Q_OBJECT
public:
    typedef bool(*ItemCompare)( const ExtendableItem *,
                                const ExtendableItem * );
    ExtendableList( QWidget *p = 0, const char *n = 0 );
    virtual ~ExtendableList();
    QPixmap extendedIcon() { return m_extendedIcon; }
    QPixmap baseIcon() { return m_baseIcon; }
public slots:
    void addExtender( ExtendableItem *i );
    void removeExtender( ExtendableItem *i );
    void updateExtender( ExtendableItem *i );
    void delayedUpdateExtenders();
    void updateExtenders();
    void setToggleColumn( unsigned c ) {
        m_toggleColumn = c;
    }
    virtual void show();
protected slots:
    void processClick( QListViewItem *, const QPoint &, int );
protected:
    virtual void resizeEvent( QResizeEvent * );
protected:
    std::vector< ExtendableItem * > m_extenders;
    QPixmap m_extendedIcon;
    QPixmap m_baseIcon;
    unsigned m_toggleColumn;
    bool m_inDtor:1;
};

class ExtendableItem : public KListViewItem {
public:

    ExtendableItem( ExtendableList *l )
        : KListViewItem( l ), m_extender( 0 ) {
        updateIcon( list()->baseIcon() );
    }

    ExtendableItem( ExtendableList *l, ExtendableItem *prev )
        : KListViewItem( l, prev ), m_extender( 0 ) {
        updateIcon( list()->baseIcon() );
    }

    void toggleExtender();

    void hideExtender() {
        if (extender())
            toggleExtender();
    }

    void showExtender() {
        if (!extender())
            toggleExtender();
    }

    ItemExtender *extender() { return m_extender; }

    static bool s_less( const ExtendableItem *a, const ExtendableItem *b );

    ExtendableList *list();

    virtual void updateIcon( const QPixmap &p ) {
        setPixmap( 0, p );
    }

    virtual ItemExtender *createExtender() = 0;
    virtual bool less( const ExtendableItem * ) const = 0;
    virtual int compare( QListViewItem *other, int col, bool ascending ) const;

    virtual ~ExtendableItem();
    virtual void setHeight( int h ) { KListViewItem::setHeight( h ); }
protected:
    ItemExtender *m_extender;
};

class ItemExtender : public QWidget {
    Q_OBJECT
public:
    // ItemExtender( ExtendableItem *item );
    ItemExtender( QWidget *parent, const char *n )
        : QWidget( parent, n ), m_item( 0 )
        {}

    virtual void setItem( ExtendableItem *i ) {
        m_item = i;
    }

    virtual void polish() {
        setupColors();
    }

    ExtendableItem *item() {
        return m_item;
    }

    void resize( int w, int h ) {
        setUpdatesEnabled( false );
        QWidget::resize( w, h );
        setUpdatesEnabled( true );
        QWidget::resize( w, layout()->minimumSize().height() );
    }

    void resize( const QSize &s ) {
        resize( s.width(), s.height() );
    }

public slots:
    void setupColors() {
        if (m_item->isAlternate())
            setPaletteBackgroundColor(
                KGlobalSettings::alternateBackgroundColor() );
        else
            setBackgroundMode( PaletteBase );
        QObjectList *chld = queryList( "QWidget" );
        QObjectListIt it( *chld );
        QWidget *o;
        while ((o = dynamic_cast< QWidget * >( it.current() )) != 0) {
            if(m_item->isAlternate())
                o->setPaletteBackgroundColor(
                    KGlobalSettings::alternateBackgroundColor() );
            else
                o->setBackgroundMode( PaletteBase );
            ++it;
        }
    }
protected:
    ExtendableItem *m_item;
};

}

#endif
