/** -*- C++ -*-
	@file libept/filterwidgets.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>
#include <libept/lister.h>

#ifndef EPT_FILTERWIDGET_H
#define EPT_FILTERWIDGET_H

class KLineEdit;

namespace ept {

class FilterWidget : public QWidget
{
    Q_OBJECT
public:
    FilterWidget( QWidget *parent = 0, const char *n = 0 )
        : QWidget( parent, n ) {}
    virtual Lister::Predicate predicate() = 0;
    void connectLister( Lister *l );
protected slots:
    void changedInternal();
    void applyInternal();
    virtual void reset() = 0;
signals:
    void changed( Lister::Predicate op );
    void apply( Lister::Predicate op );
    void drop( Lister::Predicate op );
protected:
    Lister::Predicate m_old;
};

}

#endif
