/*  This file is part of the CAPTURE library
    Copyright (C) 2003 Peter Rockai (mornfall) <mornfall@mornfall.homeip.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef _TEST_UTIL_H
#define _TEST_UTIL_H

#include <tut.h>
#include <libcapture/pkgmanager.h>
#include <apt-pkg/configuration.h>

static inline bool cacheInit (bool extstate = false)
{
    capture::PkgManager::instance ();
    // _config -> Set("Dir::State", CACHE_DIR);
    _config -> Set ("Dir::Cache", CACHE_DIR);
    _config -> Set ("Capture::Cache::UseExtState", extstate);
    capture::PkgManager::instance () -> loadAll ();
}

#endif
