/** -*- C++ -*-
	@file libept/sourceseditor.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/sources.h>
#include <libept/sourceseditorui.h>
#include <klistview.h>

namespace ept {

using namespace aptFront;

class SourcesEditor : public SourcesEditorUi
{
    Q_OBJECT
public:
    SourcesEditor( std::string f, QWidget *p = 0, const char *n = 0 );
public slots:
    void save();
    void reset();
protected slots:
    void contextMenu( QListViewItem *, const QPoint & );
    void contextMenuActivated( int );
    void newAdd();
signals:
    void close();
protected:
    aptFront::Sources m_sources;
    std::string m_filename;
};

class EntryItem : public KListViewItem {
public:
    Sources::Entry entry() const {
        return m_entry;
    }
    void setEntry( const Sources::Entry &e ) {
        m_entry = e;
    }
    EntryItem( Sources::Entry e, KListView *v, EntryItem *prev )
        : KListViewItem( v, prev ), m_entry( e ) {
        init();
    }
    EntryItem( Sources::Entry e, KListView *v )
        : KListViewItem( v ), m_entry( e ) {
        init();
    }
    void init() {
        setRenameEnabled( 0, false );
        setRenameEnabled( 1, true );
        setRenameEnabled( 2, true );
        setRenameEnabled( 3, true );
    }
    QString text( int c ) const;
    void setText( int c, const QString &s );
    virtual void paintCell (QPainter *p, const QColorGroup &cg,
                            int column, int width, int alignment);
protected:
    Sources::Entry m_entry;
};

}
