Name:      evms
Version:   2.3.4
Release:   1
URL:       http://evms.sourceforge.net
Source:    http://dl.sourceforge.net/evms/%{name}-%{version}.tar.gz
Group:     System Environment/Base
Copyright: GPL
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Summary:   Enterprise Volume Management System (EVMS)
Prereq:    ldconfig

%description
The Enterprise Volume Management System (EVMS) Project has the goal of 
providing unparalleled flexibility and extensibility in managing storage.
It represents a new approach to logical volume management for Linux. The
architecture introduces a plug-in model that allows for easy expansion
and customization of various levels of volume management.

EVMS provides a single, unified system for handling all of your storage
management tasks. EVMS recognizes all of the disks on your system and 
allows for a variety of partitioning schemes. Software-RAID and logical
volume groups can be managed in EVMS. Filesystems can be created and
checked, and are automatically updated when changes are made to the
underlying volumes. With EVMS, there is no longer a need for several
individual utilities for performing each of these tasks.

%prep
%setup

%build
%configure
make

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc COPYING ChangeLog INSTALL* README PLUGIN.IDS TERMINOLOGY
%{_sbindir}/*
%{_includedir}/*
%{_mandir}/man?/*
%{_libdir}/*
%{_sysconfdir}/evms.conf
%{_sysconfdir}/evms.conf.sample

%changelog
* Thr June 3 2004
- evms 2.3.4
- Bug-fixes for the 2.3.3 release.
  - Engine
    - Add ability to expand a volume/filesystem in the event a volume's
      object is replaced by a larger object.
    - Don't allow operations on compatibility volumes that have their
      corresponding kernel volume mounted.
    - Use pthread IDs instead of PIDs in the log timestamps.
    - Fix memory-deallocate bug in object-replace.
    - Various clustering bug-fixes.
  - DOS
    - Fix segment naming inconsistency during comparison with kernel mappings.
  - CSM
    - Allow expanding and shrinking CSM containers.
    - Fix seg-fault caused by improperly initialized option-descriptor.
  - Local Disk Manager
    - Minor code restructuring.
  - MD
    - Properly handle arrays that were purposely created with missing disks.
    - Improved log and user messages.
  - GUI
    - Add a workaround for a GTK timer bug.
  - Installation
    - Check for either /etc/ha.d or /etc/heartbeat when checking for Linux-HA.
      [Matt Zimmerman]
- New evms_query tool.
- Updated documentation.

* Tue May 11 2004
- evms 2.3.3
- Bug-fixes for the 2.3.2 release.
  - Engine
    - Fix for online-replace. When replacing an object directly under an EVMS
      volume, the volume needs to be reactivated so it maps to the copy object.
    - Fix problem with sem_wait() returning due to a SIGCONT signal.
  - S390 segment manager
    - Remove out-of-date multipath detection code.
  - XFS FSIM
    - Add a "force" option for mkfs.
    - Display the error output if mkfs fails.
    - Correctly get "extra" extended information.
  - LVM
    - Fix incorrect return code when expanding a striped region.
  - Snapshot
    - Fix endian conversions during snapshot rollback.
  - GUI
    - Replace some help menu items with a new panel containing links to
      documentation on the EVMS web site.
  - CSM
    - Fix a bug with creating a CSM container with multiple disks.
  - Linux-HA
    - evms_failover script
      - Fix using old option name for setting the node for a private container.
      - Remove redundant calls to commit changes.
- Improvements to the evms_gather_info script.
- Additional test-suite test-cases.
- Updated documentation.

* Mon April 26 2004
- evms 2.3.2
- Bug-fixes for the 2.3.1 release.
  - Engine
    - Fix minor deactivation bug. Engine was trying to deactivate volumes that
      didn't have their own DM device, causing spurious kernel error messages.
  - GUI
    - Fix seg-fault caused by a potentially uninitialized mutex.
  - HA Cluster Manager
    - Allow EVMS to use HA 1.0 or 1.2.
    - Fix some memory allocation/deallocation problems.
  - Snapshotting
    - Fix activation problem caused by the kernel module not getting loaded.
    - Snapshot-rollback bug-fix.
  - Command-Line UI
    - Improved method for displaying the CLI output, based on the width of the
      terminal session.
    - Add "replace" command.
    - General cleanup.
- New test suite. See tests/suite/README for more details.
- Install plugins in /lib/evms/x.y.z/ instead of just /lib/evms/.
- Updated kernel patches and documentation.

* Wed Mar 31 2004
- evms 2.3.1
- Bug-fixes for the 2.3.0 release.
  - Engine
    - Fixes in API-remoting code.
    - Fix in make_directory for top-level directories.
    - Start pthreads detached. [Steve Landherr]
    - Use waitpid to terminate the daemon worker process. [Steve Landherr]
    - Use usleep instead of sleep to avoid being woken up by a signal.
    - Improved error checking when activating objects.
  - Cluster Segment Manager
    - Improved options for creation and reassignment.
    - Add rename capability.
    - Fixes in segment-discard.
  - HA Cluster Manager
    - Improved handling of membership events.
    - Improved method for launching the failover script.
    - Fix seg-fault in processing list of threads waiting for responses.
    - Better error logging.
    - Always install evms_failover. [Matt Zimmerman]
  - Software-RAID
    - Fix in removing stale disks.
    - Wait for recovery process to begin before rediscovery.
    - Fix segfault when discovering RAID-linear and RAID-0 regions
      with missing children.
  - Multipath
    - Improved path recovery detection.
    - Fixes and improvements in delete and discard.
  - LVM
    - Fix seg-fault while expanding striped regions. [Steve Landherr]
  - S/390 Segment Manager
    - Build fix [Bastian Blank, Matt Zimmerman]
  - Disk
    - Improved search for sysfs.
  - Snapshot
    - Disallow creation of snapshots of cluster-shared volumes.
- Minor changes to engine logging.
  - Move ENTRY_EXIT before DEBUG
  - Print log level as part of message timestamp.
  - Note: Run the EVMS UIs with "-d debug" instead of "-d everything" now to
    generate a detailed trace log.
- Remove get_dev_num utility.
- Updated kernel patches and documentation.

* Wed Mar 03 2004
- evms 2.3.0
- Clustering enhancements
  - Remote APIs
  - Object discard
  - Internal rediscover
- Multipath
  - Convert MD-multipath to use the new Device-Mapper multipath module.
  - Add a new plugin for detecting multipath LVM PVs.
- Software-RAID
  - Convert RAID-linear and RAID-0 to use Device-Mapper instead of MD.
- OpenGFS FSIM
- Enable online move for the LVM plugin.
- Replace dlist with new engine services.

* Wed Feb 11 2004 Peter Smith <peter.smith@utsouthwestern.edu>
- Updated for version 2.3.0

* Wed Feb 04 2004 Peter Smith <peter.smith@utsouthwestern.edu>
- Completed initial spec-file
