/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdrivelink.so
 *
 *   File: dl_metadata.h
 */

#ifndef _DL_METADATA_HEADER_
#define _DL_METADATA_HEADER_ 1


#define EVMS_DRIVELINK_FEATURE_ID       1
#define EVMS_DRIVELINK_SIGNATURE        0x4C767244      // DrvL
#define MISSING_CHILD_SIGNATURE 	0x0D0E0A0D	// DEAD
#define EVMS_DRIVELINK_MAX_ENTRIES      60
#define BAD_DOT_INDEX 			-1     	// we need a definition for a BAD index into 
						// a drivelink ordering table.

typedef struct evms_dl_ordering_table_entry_s {
        u_int64_t 	  child_serial_number;			      
        evms_sector_t 	  child_vsize;				      
} dot_entry_t;

typedef struct drivelink_metadata_s {
	u_int32_t 	  signature;					// drivelink feature signature
	u_int32_t 	  crc;						// verification
	evms_version_t 	  version;					// metadata version
	u_int32_t 	  flags;					// ...
	u_int64_t 	  sequence_number;				// metadata seq number
	u_int64_t 	  child_serial_number;				// my serial number
	u_int64_t 	  parent_serial_number;				// my parents serial number
	u_int64_t 	  child_count;					// total links in drivelink
	u_int64_t 	  pad;						// ...
	dot_entry_t 	  ordering_table[EVMS_DRIVELINK_MAX_ENTRIES];	// drivelink ordering table (dot)
} drivelink_metadata_t;	/* 1024 bytes */

#define DRIVELINK_METADATA_SECTOR_COUNT  (sizeof(drivelink_metadata_t)/EVMS_VSECTOR_SIZE)
#define FEATURE_HEADER_SECTOR_COUNT      (sizeof(evms_feature_header_t )/EVMS_VSECTOR_SIZE)


#define DL_FLAG_MISSING  		0x00000001                      // drive_link_t flags

typedef struct  {
	u_int64_t         start_lsn;                                 	// starting sector number of link
	u_int64_t         end_lsn;                                   	// last sector lsn in this object
	u_int64_t         sector_count;                              	// total useable sectors in this link
	u_int32_t         padding;                                   	// padding at end of useable area
	u_int32_t         serial_number;                             	// serial number of this link
	u_int32_t         index;                           		// its index in ordering_table[]
	u_int32_t         flags;                                     	// link flags
	storage_object_t  *object;                                   	// evms child storage object
} drive_link_t;


#define DL_DISCOVERY_COMPLETE		0x00000001			// drivelink_private_data_t flags

typedef struct  {
	u_int32_t         signature;                                 	// for verifying private data
	u_int32_t         parent_serial_number;                      	// SN of parent object
	u_int32_t         sequence_number;                        	// sequence number from feature header
	u_int32_t         drive_links_found;                         	// # of children found so far
	u_int32_t         drive_link_count;                          	// total # of children in drive link
	u_int32_t         flags;                                     	// drive link flags
	char		  parent_object_name[EVMS_NAME_SIZE+1];  	// name of parent linear object
	drive_link_t      drive_link[EVMS_DRIVELINK_MAX_ENTRIES];    	// drive link table
	dot_entry_t       ordering_table[EVMS_DRIVELINK_MAX_ENTRIES]; 	// metadata ordering table
} drivelink_private_data_t;                                      	// position in vector determines childs
									// sequence in the drive link

typedef struct  {
	u_int32_t         signature;                                 	// for verifying private data
} missing_child_private_data_t;                               
                                                               

#endif
