/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: raid0_discover.h
 */

#ifndef _RAID0_MGR_H_
#define _RAID0_MGR_H_ 1


struct strip_zone
{
	sector_count_t     zone_offset;		/* Zone offset in md_dev */
	sector_count_t     dev_offset;		/* Zone offset in real dev */
	sector_count_t     size;       		/* Zone size */
	int                nb_dev;		/* # of devices attached to the zone */
	storage_object_t * dev[MD_SB_DISKS];	/* Devices attached to the zone */
};

struct raid0_hash
{
	struct strip_zone * zone0;
	struct strip_zone * zone1;
};

typedef struct raid0_private_data
{
	struct raid0_hash * hash_table;
	struct strip_zone * strip_zone;
	struct strip_zone * smallest_zone;
	int nr_strip_zones;
	int nr_zones;
} raid0_conf_t;


#define mdvol_to_conf(mdvol) ((raid0_conf_t *) mdvol->private_data)

#define MD_OPTION_CHUNK_SIZE_INDEX  0
#define MD_OPTION_CHUNK_SIZE_NAME   "chunksize"

// Plug-in functions
#define MD_RAID0_FUNCTION_FIX			EVMS_Task_Plugin_Function
#define MD_RAID0_RESTORE_SUPERBLOCK		(EVMS_Task_Plugin_Function + 1)

#define MD_RAID0_FUNCTION_COUNT		2

#endif

