/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: Multipath Plugin
 * File: evms2/engine/plugins/multipath/multipath.h
 */

extern plugin_record_t		multipath_plugin;
extern engine_functions_t	*EngFncs;

#define my_plugin_record	(&multipath_plugin)
#define MP_NAME			"mp"

/**
 * multipath_module_t
 *
 * The multipath plugin can contain several sub-modules, each one recognizing
 * a different metadata format. This structure defines the API for these
 * modules.
 **/
typedef struct multipath_module {
	char *name;
	int (*setup)(void);
	void (*cleanup)(void);
	int (*probe)(storage_object_t *object);
	int (*process)(list_anchor_t output_list);
	int (*allocate)(storage_object_t *object);
	int (*discard)(storage_object_t *object);
	int (*delete)(storage_object_t *object);
	int (*map)(storage_object_t **object,
		   lsn_t *lsn, sector_count_t *count);
	int (*build_targets)(storage_object_t *object,
			     dm_target_t **target_list);
} multipath_module_t;

/**
 * multipath_type_t
 *
 * Indexes to identify each multipath sub-module.
 **/
typedef enum {
	MULTIPATH_LVM = 0,
} multipath_type_t;

/* Set to last entry in above multipath_type_t enum. */
#define MULTIPATH_TYPE_MAX (MULTIPATH_LVM + 1)

/**
 * multipath_t
 *
 * Private data for a multipath segment.
 **/
typedef struct multipath {
	multipath_type_t type;
	void *type_data;
	pid_t daemon_pid;
	unsigned long flags;
} multipath_t;

#define MP_FLAG_ACTIVATE_SEGMENT	(1 << 0)

extern multipath_module_t mp_modules[];

#include "mp_segments.h"
#include "mp_daemon.h"
#include "mp_lvm.h"

