/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: help.c
 */

#include <frontend.h>
#include <gtk/gtk.h>

#include "support.h"

inline gchar *get_options_window_help_text(void)
{
	return _("This dialog window allows the plug-in to ask specific configuration\n"
		 "questions about an object. All required fields have an \"*\"\n"
		 "(asterisk) character preceding the field title. You can either\n"
		 "accept any default value or change the value.\n\n"
		 "There may be fields displayed in the dialog box that cannot be\n"
		 "changed. These fields may be inactive due to a dependency on\n"
		 "another field's value.\n\n"
		 "Placing the mouse pointer over a field label for a few seconds will\n"
		 "provide a tooltip with a short description of the field.\n\n"
		 "Once all required fields contain a value, click on the button in\n"
		 "the lower right corner of the dialog window.. This button is only\n"
		 "available after all required fields have a value.");
}

inline gchar *get_create_evms_volume_help_text(void)
{
	return _("This dialog window allows you to create a native EVMS volume. A native\n"
		 "EVMS volume provides you with a persistent name and minor number.\n\n"
		 "To create a native EVMS volume, select one of the\n"
		 "topmost storage objects in the selection list and click\n"
		 "the 'Create' button. Next, supply a (descriptive) name for\n"
		 "the volume. EVMS will automatically apply the proper prefix, such as\n"
		 "/dev/evms/, to the volume name.");
}

inline gchar *get_create_compat_volume_help_text(void)
{
	return _("This dialog window allows you to create a compatibility volume.\n"
		 "A compatibility volume does not add EVMS meta-data to the object to\n"
		 "use for the volume. Unlike native EVMS volumes, there is no\n"
		 "opportunity to given the volume a persistent name. The name the\n"
		 "volume will use is generated from the storage object's name.\n\n"
		 "To create the compatibility volume, select one\n"
		 "of the topmost storage objects in the selection list and\n"
		 "click the 'Create' button.");
}

inline gchar *get_create_feature_help_text(void)
{
	return _("To create a storage object with a certain EVMS feature\n"
		 "applied, complete the following steps:\n\n"
		 "1. Select a feature plug-in and proceed to the next window.\n\n"
		 "2. Select one or more storage objects that the plug-in finds\n"
		 "acceptable.\n\n"
		 "3. If the plug-in offers configuration options, configure the\n"
		 "feature object properties.\n\n"
		 "4. Complete the operation by clicking the 'Create' button.");
}

inline gchar *get_create_region_help_text(void)
{
	return _("In order to create a storage region, complete the following steps:\n\n"
		 "1. Select a region manager plug-in and proceed to the next window.\n\n"
		 "2. Select one or more storage objects that the plug-in finds\n"
		 "acceptable.\n\n"
		 "3. If the plug-in offers configuration options, configure the\n"
		 "storage region properties.\n\n"
		 "4. Complete the operation by clicking the 'Create' button.");
}

inline gchar *get_create_container_help_text(void)
{
	return _("In order to create a storage container, complete the following steps:\n\n"
		 "1. Select a plug-in that supports containers and proceed to the\n"
		 "next window.\n\n"
		 "2. Select one or more storage objects that the plug-in finds\n"
		 "acceptable for the container to consume.\n\n"
		 "3. If the plug-in offers configuration options, configure the\n"
		 "storage container properties.\n\n"
		 "4. Complete the operation by clicking the 'Create' button.");
}

inline gchar *get_create_segment_help_text(void)
{
	return _("In order to create a disk segment, complete the following steps:\n\n"
		 "1. Select a segment manager plug-in and proceed to the next window.\n\n"
		 "2. Select a free space storage object from the list of objects\n"
		 "that the plug-in finds acceptable.\n\n"
		 "3. If the plug-in offers configuration options, configure the\n"
		 "disk segment properties.\n\n"
		 "4. Complete the operation by clicking the 'Create' button.");
}

inline gchar *get_delete_volume_help_text(void)
{
	return _("This dialog window allows you to delete a volume and the storage\n"
		 "objects that comprise it.\n\n"
		 "To delete only the volume, select a logical volume from the\n"
		 "volume list and click the 'Delete' button.\n\n"
		 "To delete the volume and its storage object hierarchy, select a volume\n"
		 "from the volume list and click the 'Recursive Delete' button.");
}

inline gchar *get_delete_object_help_text(void)
{
	return _("This dialog window allows you to delete a feature object and the\n"
		 "storage objects that comprise it.\n\n"
		 "To delete only the feature object, select a feature object from the\n"
		 "feature object list and click the 'Delete' button.\n\n"
		 "To delete the feature object and its storage object hierarchy,\n"
		 "select a feature object from the feature object list and click the\n"
		 "'Recursive Delete' button.");
}

inline gchar *get_delete_region_help_text(void)
{
	return _("This dialog window allows you to delete a storage region and the\n"
		 "storage objects that comprise it.\n\n"
		 "To delete only the storage region, select a storage region from the\n"
		 "storage region list and click the 'Delete' button.\n\n"
		 "To delete the storage region and storage object hierarchy,\n"
		 "select a storage region from the storage region list and click\n"
		 "the 'Recursive Delete' button.");
}

inline gchar *get_delete_container_help_text(void)
{
	return _("This dialog window allows you to delete a storage container\n"
		 "and any storage objects it consumes.\n\n"
		 "To delete only the storage container, select a container from the\n"
		 "storage container list and click the 'Delete' button.\n\n"
		 "To delete the storage container and the storage objects consumed,\n"
		 "select a container from the container list and click the\n"
		 "'Recursive Delete' button.");
}

inline gchar *get_delete_segment_help_text(void)
{
	return _("This dialog window allows you to delete a disk segment and the\n"
		 "storage objects that comprise it.\n\n"
		 "To delete only the disk segment, select a segment from the\n"
		 "disk segment list and click the 'Delete' button.\n\n"
		 "To delete the disk segment and storage object hierarchy, select\n"
		 "a segment from the segment list and click the 'Recursive Delete' button.");
}

inline gchar *get_delete_storage_object_help_text(void)
{
	return _("This dialog window allows you to delete a storage object and the\n"
		 "storage objects that comprise it.\n\n"
		 "To delete only the topmost storage object, select a storage object\n"
		 "from the storage object list and click the 'Delete' button.\n\n"
		 "To delete the topmost storage object and storage object hierarchy,\n"
		 "select a storage object from the storage object list and click the\n"
		 "'Recursive Delete' button.");
}

inline gchar *get_assign_segment_manager_help_text(void)
{
	return _("In order to subdivide (partition) a new disk,\n"
		 "first assign a segment manager to the new storage object\n"
		 "to provide the partitioning scheme to use.\n\n"
		 "This dialog box will allow you to select the segment\n"
		 "manager plug-in. After proceeding to the next\n"
		 "window, the plug-in will provide a list of storage objects\n"
		 "that it can work with.\n\n"
		 "The plug-in might also provide configuration options\n"
		 "that need to be set before completing the assignment operation.");
}

inline gchar *get_expand_volume_help_text(void)
{
	return _("This dialog window allows you to increase the\n"
		 "storage space consumed by a volume. If the volume contains a\n"
		 "file system with an associated File System Interface Module (FSIM),\n"
		 "the expansion of the file system will be automatically\n"
		 "handled by the FSIM plug-in.\n\n"
		 "Begin expanding the volume by selecting a volume that has one or\n"
		 "more of its child storage objects that can increase in size.\n\n"
		 "If the volume is composed of multiple storage objects, you\n"
		 "may be presented with additional objects to\n"
		 "select as an expansion point.\n\n"
		 "Expansion points are the storage objects offered to start the\n"
		 "expansion of a volume or topmost storage object.\n\n"
		 "For example, if you are expanding a volume composed of a\n"
		 "topmost drivelink feature object, the expansion points may\n"
		 "be the storage objects such as segments, regions, or other\n"
		 "feature objects that comprise the drivelink object.\n\n"
		 "Once you select an expansion point, the plug-in may present\n"
		 "additional objects to use for the expansion, such as adjacent\n"
		 "free space or another storage object to add to an aggregate.\n\n"
		 "The plug-in responsible for managing the expansion point\n"
		 "may also offer configuration options that need to be set\n"
		 "before the expansion operation can be completed.");
}

inline gchar *get_expand_object_help_text(void)
{
	return _("This dialog window allows you to increase the\n"
		 "storage space consumed by a topmost storage object.\n\n"
		 "Begin expanding the storage object by selecting a topmost\n"
		 "storage object that has one or more of its child storage\n"
		 "objects that can increase in size.\n\n"
		 "If the storage object is composed of multiple storage\n"
		 "objects, you may be presented with additional\n"
		 "objects to select as an expansion point.\n\n"
		 "Expansion points are the storage objects offered to start the\n"
		 "expansion of a volume or topmost storage object.\n\n"
		 "For example, if you are expanding a volume composed of a\n"
		 "topmost drivelink feature object, the expansion points may\n"
		 "be the storage objects such as segments, regions, or other\n"
		 "feature objects that comprise the drivelink object.\n\n"
		 "Once you select an expansion point, the plug-in may present\n"
		 "additional objects to use for the expansion, such as adjacent\n"
		 "free space or another storage object to add to an aggregate.\n\n"
		 "The plug-in responsible for managing the expansion point\n"
		 "may also offer configuration options that need to be set\n"
		 "before the expansion operation can be completed.");
}

inline gchar *get_expand_region_help_text(void)
{
	return _("This dialog window allows you to increase the size of a\n" "storage region.");
}

inline gchar *get_expand_container_help_text(void)
{
	return _("This dialog window allows you to increase the size of a\n"
		 "storage container.\n\n"
		 "Once a storage container is selected, the next window\n"
		 "will present the list of storage objects that the\n"
		 "storage container can consume to extend its total size.");
}

inline gchar *get_expand_segment_help_text(void)
{
	return _("This dialog window allows you to increase the size of a\n" "disk segment.");
}

inline gchar *get_shrink_volume_help_text(void)
{
	return _("This dialog window allows you to decrease the\n"
		 "storage space consumed by a volume. If the volume contains a\n"
		 "file system with an associated File System Interface Module (FSIM),\n"
		 "the reduction of the file system space will be automatically\n"
		 "handled by the FSIM plug-in.\n\n"
		 "Begin shrinking the volume by selecting a volume that has one or\n"
		 "more of its child storage objects that can decrease in size.\n\n"
		 "If the volume is composed of multiple storage objects, you\n"
		 "may be presented with additional objects to\n"
		 "select as an shrink point.\n\n"
		 "Shrink points are the storage objects offered to start the\n"
		 "shrinkage of a volume or topmost storage object.\n\n"
		 "For example, if you are shrinking a volume composed of a\n"
		 "topmost drivelink feature object, the shrink points may\n"
		 "be the storage objects such as segments, regions, or other\n"
		 "feature objects that comprise the drivelink object.\n\n"
		 "Once you select a shrink point, the plug-in may present\n"
		 "additional objects to select from such as segments to\n"
		 "remove from a drivelink object to reduce the aggregate size.\n\n"
		 "The plug-in responsible for managing the shrink point\n"
		 "may also offer configuration options that need to be set\n"
		 "before the shrink operation can be completed.");
}

inline gchar *get_shrink_object_help_text(void)
{
	return _("This dialog window allows you to decrease the\n"
		 "storage space consumed by a topmost storage object.\n\n"
		 "The user starts by selecting a topmost storage object which\n"
		 "has one or more of its child storage objects that can\n"
		 "decrease in size.\n\n"
		 "If the storage object is composed of multiple storage\n"
		 "objects, you may be presented with additional\n"
		 "objects to select as a shrink point.\n\n"
		 "Shrink points are the storage objects offered to start the\n"
		 "shrinkage of a volume or topmost storage object.\n\n"
		 "For example, if you are shrinking a volume composed of a\n"
		 "topmost drivelink feature object, the shrink points may\n"
		 "be the storage objects such as segments, regions, or other\n"
		 "feature objects that comprise the drivelink object.\n\n"
		 "Once you select a shrink point, the plug-in may present\n"
		 "additional objects to select from such as segments to\n"
		 "remove from a drivelink object to reduce the aggregate size.\n\n"
		 "The plug-in responsible for managing the shrink point\n"
		 "may also offer configuration options that need to be set\n"
		 "before the shrink operation can be completed.");
}

inline gchar *get_shrink_region_help_text(void)
{
	return _("This dialog window allows you to decrease the\n"
		 "storage space consumed by a storage region.");
}

inline gchar *get_shrink_segment_help_text(void)
{
	return _("This dialog window allows you to decrease the\n"
		 "storage space consumed by a disk segment.");
}

inline gchar *get_shrink_container_help_text(void)
{
	return _("This dialog window allows you to decrease the size of a\n"
		 "storage container.\n\n"
		 "Once a storage container is selected, the next window\n"
		 "will present the list of consumed storage objects that\n"
		 "can be removed from the storage container to decrease its\n" "total size.");
}

inline gchar *get_remove_region_from_container_help_text(void)
{
	return _("This dialog window allows you to remove or essentially\n"
		 "transfer a storage region being consumed by a storage\n"
		 "container.\n\n"
		 "The storage region will be displayed in the 'Available Objects'\n"
		 "view once the operation is completed.");
}

inline gchar *get_remove_segment_from_container_help_text(void)
{
	return _("This dialog window allows you to remove or essentially\n"
		 "transfer a disk segment being consumed by a storage\n"
		 "container.\n\n"
		 "The disk segment will be displayed in the 'Available Objects'\n"
		 "view once the operation is completed.");
}

inline gchar *get_remove_disk_from_container_help_text(void)
{
	return _("This dialog window allows you to remove or essentially\n"
		 "transfer a logical disk being consumed by a storage\n"
		 "container.\n\n"
		 "The logical disk will be displayed in the 'Available objects'\n"
		 "view once the operation is completed.");
}

inline gchar *get_remove_object_from_container_help_text(void)
{
	return _("This dialog window allows you to remove or essentially\n"
		 "transfer a storage object being consumed by a storage\n"
		 "container.\n\n"
		 "The storage object will be displayed in the 'Available Objects'\n"
		 "view once the operation is completed.");
}

inline gchar *get_modify_volume_properties_help_text(void)
{
	return _("This dialog window allows you to modify a volume's\n"
		 "properties such as the volume name.\n\n"
		 "Select a volume from the volume list, and\n"
		 "proceed to the next window where you can change\n" "the volume properties.");
}

inline gchar *get_modify_volume_properties_2_help_text(void)
{
	return _("This dialog window allows you to modify a volume's\n"
		 "properties such as the volume name.\n\n"
		 "Make your changes and select the 'Modify' button\n" "to complete the operation.");
}

inline gchar *get_modify_object_properties_help_text(void)
{
	return _("This dialog window allows you to modify a feature\n"
		 "object's properties.\n\n"
		 "Select a feature object from the list, and\n"
		 "proceed to the next window where you can change\n"
		 "the feature object properties.");
}

inline gchar *get_modify_region_properties_help_text(void)
{
	return _("This dialog window allows you to modify a storage\n"
		 "region's properties.\n\n"
		 "Select a storage region from the list, and\n"
		 "proceed to the next window where you can change\n"
		 "the storage region properties.");
}

inline gchar *get_modify_container_properties_help_text(void)
{
	return _("This dialog window allows you to modify a storage\n"
		 "container's properties.\n\n"
		 "Select a storage container from the list, and\n"
		 "proceed to the next window where you can change\n"
		 "the storage container properties.");
}

inline gchar *get_modify_segment_properties_help_text(void)
{
	return _("This dialog window allows you to modify a disk\n"
		 "segment's properties.\n\n"
		 "Select a disk segment from the list, and\n"
		 "proceed to the next window where you can change\n"
		 "the disk segment properties.");
}

inline gchar *get_modify_disk_properties_help_text(void)
{
	return _("This dialog window allows you to modify a logical\n"
		 "disk's properties.\n\n"
		 "Select a logical disk from the list, and\n"
		 "proceed to the next window where you can change\n"
		 "the logical disk properties.");
}

inline gchar *get_modify_storage_object_properties_help_text(void)
{
	return _("This dialog window allows you to modify a storage\n"
		 "object's properties.\n\n"
		 "Select a storage object from the list, and\n"
		 "proceed to the next window where you can change\n"
		 "the storage object properties.");
}

inline gchar *get_mkfs_help_text(void)
{
	return _("In order to make a file system on a volume, first\n"
		 "select a File System Interface Module (FSIM) that supports the file\n"
		 "system you intend to use. This action is very similar to using\n"
		 "the Linux mkfs command.\n\n"
		 "Once you select an FSIM and proceed to the volume selection window,\n"
		 "the FSIM plug-in will offer a list of volumes on which it can make a\n"
		 "file system.\n\n"
		 "If a volume you want to apply a certain file system to is not\n"
		 "shown, that volume already have a file system\n"
		 "applied. In this case, you must first use the 'Remove File System'\n"
		 "action before you can apply a new file system to the volume.\n\n"
		 "Once the volume has been selected, the FSIM may offer configuration\n"
		 "options that need to be set before completing the operation.\n\n"
		 "Note that the actual disk operations will occur when you\n"
		 "commit changes made in this application.");
}

inline gchar *get_fsck_help_text(void)
{
	return _("This dialog window allows you to check or repair the\n"
		 "integrity of the file system located on a volume. This action\n"
		 "is very similar to using the Linux fsck command.\n\n"
		 "To initiate a file system check/repair operation, select a\n"
		 "volume from the volume list and, if available, select the\n"
		 "'Check' button.\n\n"
		 "You may need to proceed to the next window if the FSIM\n"
		 "provides configuration options that must be set before a\n"
		 "'Check' button is made available to complete the operation.\n\n"
		 "Note that the actual disk operations will occur when you\n"
		 "commit changes made in this application.");
}

inline gchar *get_defrag_help_text(void)
{
	return _("This dialog window allows you to defragment\n"
		 "the file system located on a volume. Defragmentation\n"
		 "reorganizes files on the file system for optimal retrieval to\n"
		 "reduce file loading times.\n\n"
		 "To initiate defragmentation, select a volume from the\n"
		 "volume list and, if available, select the 'Defragment' button.\n\n"
		 "You may need to proceed to the next window if the FSIM\n"
		 "provides configuration options that must be set before a\n"
		 "'Defragment' button is made available to complete the operation.\n\n"
		 "Note that the actual disk operations will occur when you\n"
		 "commit changes made in this application.");
}

inline gchar *get_unmkfs_help_text(void)
{
	return _("This dialog window allows you to remove a file system and\n"
		 "its associated File System Interface Module (FSIM) from a volume.\n\n"
		 "This operation is typically initiated if you intend to apply\n"
		 "a new file system or start over with a empty file system using\n"
		 "the same FSIM. Another reason to remove a file system may be to\n"
		 "have the FSIM remove any of its meta-data that might allow it\n"
		 "to be recognized or mountable by a file system driver.\n\n"
		 "Note that the actual disk operations will occur when you\n"
		 "commit changes made in this application.");
}

inline gchar *get_acceptable_objects_help_text(void)
{
	return _("This dialog presents you with a list of storage objects\n"
		 "that the plug-in has determined are acceptable for use in\n"
		 "completing the operation successfully.\n\n"
		 "Depending on the plug-in, there may be a minimum number\n"
		 "of selections required before you can proceed\n"
		 "to the next window or be able to complete the operation\n"
		 "if no configuration options are available.");
}

inline gchar *get_expansion_points_help_text(void)
{
	return _("This dialog window displays expansion points. Expansion\n"
		 "points are the storage objects offered to start the\n"
		 "expansion of a volume or topmost storage object.\n\n"
		 "For example, if you are expanding a volume composed of a\n"
		 "topmost drivelink feature object, the expansion points may\n"
		 "be the storage objects such as segments, regions, or other\n"
		 "feature objects that comprise the drivelink object.\n\n"
		 "Once you select an expansion point, the plug-in may present\n"
		 "additional objects to use for the expansion, such as adjacent\n"
		 "free space or another storage object to add to an aggregate.\n\n"
		 "The plug-in responsible for managing the expansion point\n"
		 "may also offer configuration options that need to be set\n"
		 "before the expansion operation can be completed.");
}

inline gchar *get_shrink_points_help_text(void)
{
	return _("This dialog window displays shrink points. Shrink\n"
		 "points are the storage objects offered to start the\n"
		 "shrinkage of a volume or topmost storage object.\n\n"
		 "For example, if you are shrinking a volume composed of a\n"
		 "topmost drivelink feature object, the shrink points may\n"
		 "be the storage objects such as segments, regions, or other\n"
		 "feature objects that comprise the drivelink object.\n\n"
		 "Once you select a shrink point, the plug-in may present\n"
		 "additional objects to select from such as segments to\n"
		 "remove from a drivelink object to reduce the aggregate size.\n\n"
		 "The plug-in responsible for managing the shrink point\n"
		 "may also offer configuration options that need to be set\n"
		 "before the shrink operation can be completed.");
}

inline gchar *get_key_navigation_help_text(void)
{
	return _("\n\nNavigation and value selection using only the keyboard can\n"
		 "be accomplished by the following means:\n\n"
		 "<Tab> - this key allows moving between widgets/controls in\n"
		 "the window.\n\n"
		 "<Spacebar> - this key allows selection of items and activation\n"
		 "of buttons.\n\n"
		 "<Up Arrow>, <Down Arrow> - these keys allow up and down movement\n"
		 "in lists and in windows with scrollbars.\n\n"
		 "<Left Arrow>, <Right Arrow> - these keys allow movement between\n"
		 "buttons at the bottom of a dialog box.\n\n"
		 "<Enter> - this key allows immediate updates of a value if keyboard\n"
		 "focus is in an entry box. The <Enter> key is also used to activate\n"
		 "a button.\n\n"
		 "A special note for navigating tabbed notebook pages. Use the\n"
		 "<Tab> key to highlight the tab's label and then select the\n"
		 "page with the <Spacebar> key. This allows movement using <Tab>\n"
		 "within fields located on the notebook page.");
}
